/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.logging.Logger;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.MerlinOpImpl;
import merlin.actions.NewObject;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.animation.Animation;
import merlin.data.animation.AnimationDB;
import merlin.gui.AnimationNewDlg;
import merlin.gui.AnimationsPanel;
import merlin.gui.INewDlg;
import merlin.gui.ManagerDlg;
import merlin.gui.NewActionListener;
import merlin.gui.TagsField;
import merlin.unitsystem.UnitSystem;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.QuintFunction;

public class AnimationsDlg
extends ManagerDlg<Animation, ManagerDlg.IManager<Animation>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AnimationsDlg.class.getSimpleName());
    private final IEditor<Animation> d_editor;
    private ManagerDlg.IManager<Animation> d_mgr;
    private TagsField d_tagSearch = new TagsField();

    public AnimationsDlg(JFrame owner, UnitSystem uSys) {
        super(owner, Intl.intl("Animations"), Animation.class);
        this.getList().add((Component)this.d_tagSearch, "North");
        this.d_editor = new AnimationsPanel(owner);
        this.d_actions = new Action[]{this.newAction(new NewActionListener<Animation>(this.newObject(Intl.intl("New Animation"), (wowner, md, title, suggestedName, clazz) -> new AnimationNewDlg((Window)wowner, (MerlinData)md, (String)title, (String)suggestedName, (Animation)this.getList().getSelectedItem())))), new AnimationImportAction(), new AnimationRenameAction(), new ManagerDlg.DeleteAction(this)};
        this.updateActions();
    }

    private NewObject<Animation> newObject(String actionName, QuintFunction<Window, MerlinData, String, String, Class<Animation>, INewDlg<Animation>> createNewDlg) {
        return new NewObject<Animation>(Animation.class, md -> md.animations, md -> md.animNameGen, createNewDlg, (mgr, obj) -> {
            AnimationsDlg dlg = new AnimationsDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
            dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<Animation>)mgr, (Animation)obj);
            dlg.doModal();
        }, actionName, NamedMerlinObj.NAME, AnimationDB.class, md -> new Animation(), (md, base) -> {
            Animation clone = base.clone();
            clone.generateUuids();
            return clone;
        }, true, EnumSet.of(NewObject.Option.NO_UNDO));
    }

    @Override
    protected boolean validateEditor(IEditor<Animation> editor, boolean showWarn, boolean allowModify) {
        boolean modified = this.d_editor.isModified();
        if (!super.validateEditor(editor, showWarn, allowModify)) {
            return false;
        }
        if (modified) {
            int ix = this.d_edix;
            Animation anim = (Animation)this.getList().getItem(ix);
            if (anim != null && !this.validateAnimation(anim, showWarn, allowModify)) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateAnimation(Animation anim, boolean showWarn, boolean allowModify) {
        if (!showWarn) {
            return true;
        }
        return true;
    }

    public void init(MerlinData md, ManagerDlg.IManager<Animation> mgr, Animation init) {
        if (init == null && mgr.size() > 0) {
            init = mgr.getSorted().iterator().next();
        }
        this.d_mgr = mgr;
        super.init(md, this.d_mgr, this.d_editor, this.d_actions);
        this.d_editor.init(init);
        this.updateActions();
        if (init != null) {
            this.getList().select(init);
        }
        this.d_tagSearch.addValueListener(guiFormattedFld.VAL_CHANGE, evt -> {
            if (evt.getNewValue() != null) {
                mgr.filter(anim -> anim.getTags().containsAll((Collection)evt.getNewValue()));
            } else {
                mgr.filter(Predicates.alwaysTrue());
            }
            this.getList().updateModelView(mgr);
        });
    }

    @Override
    public void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[1].setEnabled(this.d_mgr != null);
        this.d_actions[2].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[3].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    protected class AnimationImportAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AnimationImportAction() {
            super(Intl.intl("Import..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AnimationsDlg.this.preSave()) {
                return;
            }
            guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, new FileChooser.ExtensionFilter(Intl.intl("Allowed Files"), "*.fbx", "*.md5anim"), FileFilters.EXT_FILTER_FBX, FileFilters.EXT_FILTER_MD5ANIM);
            File f = chooser.showOpenDialog();
            if (f == null) {
                return;
            }
            MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
            NewObject<Animation> newObject = AnimationsDlg.this.newObject(Intl.intl("Import Animation"), (wowner, md, title, suggestedName, clazz) -> new AnimationNewDlg((Window)wowner, (MerlinData)md, (String)title, FilenameManager.splitFilename(f.getName())[0], f, null));
            MerlinOpImpl op = new MerlinOpImpl((app, md) -> newObject.add((MerlinApp)app, (MerlinData)md, false));
            UIHook.run(UIHook.getComponent(e), "ImportAnimationAction", op, 0);
        }
    }

    protected class AnimationRenameAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AnimationRenameAction() {
            super(Intl.intl("Rename..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String oldName;
            if (!AnimationsDlg.this.preSave()) {
                return;
            }
            int selIx = AnimationsDlg.this.getList().getSelectedIx();
            Animation anim = (Animation)AnimationsDlg.this.getList().getItem(selIx);
            MerlinData md = AnimationsDlg.this.getMerlinData();
            try (MerlinData.ReadLock lock = md.lockRead();){
                oldName = anim.getSetName();
            }
            String objName = NewObject.promptForName(MerlinApp.getApp().getActiveFrame(), md, oldName, md.animations, Animation.class, Intl.intl("New Animation"), NamedMerlinObj.NAME, NewObject.FILENAME_FORMATTER);
            if (objName == null || objName.equals(oldName)) {
                return;
            }
            MerlinOpImpl op = new MerlinOpImpl((app, data) -> {
                try (MerlinData.WriteLock lock = data.lockWrite();){
                    Undo.insertEntry_breakChain(md);
                    Animation newAnim = anim.clone();
                    newAnim.setName(objName);
                    try {
                        md.animations.add(newAnim);
                        md.animations.remove(anim);
                    }
                    catch (Exception ioe) {
                        TeciLogging.log(LOGGER, String.format("Error renaming animation from \"%s\" to \"%s\"", oldName, objName), (Throwable)ioe);
                    }
                    data.uiLater(() -> {
                        AnimationsDlg.this.d_editor.init(newAnim);
                        AnimationsDlg.this.getList().updateModelView(AnimationsDlg.this.d_mgr);
                    });
                }
            });
            UIHook.run(AnimationsDlg.this, "AnimationRenameAction.actionPerformed", op, 0);
        }
    }
}

