/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.value;

import inferno.data2.value.ImpulseFunction1d;
import inferno.sim.occsource.AUCOccSourceFlowrate;
import inferno.sim.occsource.DistributedOccSourceFlowrate;
import inferno.sim.occsource.IOccSourceFlowrate;
import inferno.sim.occsource.RandomizedOccSourceFlowrate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import merlin.Intl;
import merlin.data.property.Function1dProp;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.IFunction1d;
import merlin.data.value.ImpulseFunction1d;
import merlin.data.value.PiecewiseFunction1d;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class RandomizedImpulseFunction1d
implements IFunction1d,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Distribution dist;
    public final List<Interval> intervals;

    public RandomizedImpulseFunction1d(Distribution dist, List<Interval> intervals) {
        this.dist = dist;
        this.intervals = intervals;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        RandomizedImpulseFunction1d f = (RandomizedImpulseFunction1d)obj;
        return this.dist.equals((Object)f.dist) && this.intervals.equals(f.intervals);
    }

    public int hashCode() {
        return 0xAF98328 ^ Objects.hash(new Object[]{this.dist, this.intervals});
    }

    @Override
    public PiecewiseFunction1d toPiecewise(Function1dProp prop) {
        return ImpulseFunction1d.impulseToPiecewiseFunction(prop, new ArrayList<Interval>(this.getNonZeroIntervals()), new UnitDouble(0.0, SIUS.unit(prop.y.unitType)), e -> e.x, e -> e.duration, e -> e.rate);
    }

    @Override
    public ConstFunction1d toConstant(Function1dProp prop) {
        if (this.intervals.isEmpty()) {
            return new ConstFunction1d(new UnitDouble(0.0, SIUS.unit(prop.y.unitType)));
        }
        if (this.intervals.get((int)0).x.getRawValue() == 0.0) {
            return new ConstFunction1d(this.intervals.get((int)0).rate);
        }
        return new ConstFunction1d(new UnitDouble(0.0, SIUS.unit(prop.y.unitType)));
    }

    @Override
    public ImpulseFunction1d toImpulse(Function1dProp prop) {
        Collection<Interval> intervals = this.getNonZeroIntervals();
        ArrayList<ImpulseFunction1d.Pulse> pulses = new ArrayList<ImpulseFunction1d.Pulse>(intervals.size());
        for (Interval interval : intervals) {
            pulses.add(new ImpulseFunction1d.Pulse(interval.x, interval.duration, interval.rate));
        }
        return new ImpulseFunction1d(new UnitDouble(0.0, SIUS.unit(prop.y.unitType)), pulses);
    }

    public Collection<Interval> getNonZeroIntervals() {
        return theUtil.filter(this.intervals, i -> i.rate.getRawValue() != 0.0);
    }

    @Override
    public RandomizedImpulseFunction1d toRandomizedImpulse(Function1dProp prop) {
        return this;
    }

    private List<ImpulseFunction1d.Pulse> toPulses(Unit xUnit, Unit yUnit) {
        ArrayList<ImpulseFunction1d.Pulse> pulses = new ArrayList<ImpulseFunction1d.Pulse>(this.intervals.size());
        for (Interval interval : this.getNonZeroIntervals()) {
            pulses.add(new ImpulseFunction1d.Pulse(interval.x.get(xUnit), interval.duration.get(xUnit), interval.rate.get(yUnit)));
        }
        return pulses;
    }

    @Override
    public inferno.data2.value.IFunction1d toInfernoFunction(Unit xUnit, Unit yUnit) {
        switch (this.dist) {
            case UNIFORM: {
                return new inferno.data2.value.ImpulseFunction1d(0.0, this.toPulses(xUnit, yUnit));
            }
            case RANDOM: {
                return null;
            }
            case POISSON: {
                return null;
            }
        }
        assert (false);
        throw new IllegalStateException();
    }

    @Override
    public IOccSourceFlowrate toInfernoOccSourceFlowrate(long occSourceSeed) {
        Supplier<inferno.data2.value.ImpulseFunction1d> getImpulseFunc = () -> new inferno.data2.value.ImpulseFunction1d(0.0, this.toPulses(SI.SECOND, Unit.ONE.divide(SI.SECOND)));
        switch (this.dist) {
            case UNIFORM: {
                return new AUCOccSourceFlowrate(this.toInfernoFunction(SI.SECOND, Unit.ONE.divide(SI.SECOND)));
            }
            case RANDOM: {
                return new RandomizedOccSourceFlowrate(getImpulseFunc.get(), occSourceSeed);
            }
            case POISSON: {
                return new DistributedOccSourceFlowrate(getImpulseFunc.get().optimize(), occSourceSeed, DistributedOccSourceFlowrate.Distribution.POISSON);
            }
        }
        assert (false);
        throw new IllegalStateException();
    }

    @Override
    public String format(UnaryOperator<Unit> getDisplayUnit) {
        return Intl.intl("Scheduled");
    }

    public static enum Distribution {
        UNIFORM(Intl.intl("Uniform"), Intl.intl("Occupants are distributed at uniformly-timed intervals during each insertion interval.\nThe total number of occupants is guaranteed as long as the flowrate is enforced and\na valid location can be found on the occupant source."), true),
        POISSON(Intl.intl("Poisson"), Intl.intl("Occupants are inserted at random times during each insertion interval using a Poisson distribution.\nThe total number of occupants is not guaranteed."), false),
        RANDOM(Intl.intl("Random"), Intl.intl("Occupants are inserted at random times during each insertion interval.\nLonger intervals produce more randomness, but the total number of occupants\nis guaranteed as long as the flowrate is enforced and a valid location\ncan be found on the occupant source."), true);

        public final String name;
        public final String occFlowrateDesc;
        public final boolean exact;

        private Distribution(String name, String desc, boolean exact) {
            this.name = name;
            this.occFlowrateDesc = desc;
            this.exact = exact;
        }
    }

    public static class Interval
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final UnitDouble x;
        public final UnitDouble duration;
        public final UnitDouble rate;

        public Interval(UnitDouble x, UnitDouble duration, UnitDouble rate) {
            this.x = x;
            this.duration = duration;
            this.rate = rate;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            Interval f = (Interval)obj;
            return this.x == f.x && this.duration == f.duration && this.rate == f.rate;
        }

        public int hashCode() {
            return 0xAF793 ^ Objects.hash(this.x, this.duration, this.rate);
        }

        public String toString() {
            return String.format("%s -> %s: %s", this.x, this.x.add(this.duration), this.rate);
        }
    }
}

