/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.material;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.NamedMerlinObj;
import merlin.data.material.HashMaterial;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.IAdvancedMaterial;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.MatUtil;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public class Material
extends NamedMerlinObj
implements IAdvancedMaterial,
ICompElement,
ISurrogate {
    private static final long serialVersionUID = 1L;
    private static final TypedProp<Integer> PROP_VERSION = new TypedProp<Integer>((Object)"version", 0);
    private static final TypedProp<String> PROP_MAT_NAME = new TypedProp<String>((Object)"name", String.class);
    private static final TypedProp<UnitDouble> PROP_WIDTH = new TypedProp<UnitDouble>((Object)"width", new UnitDouble(1.0, SI.METER));
    private static final TypedProp<UnitDouble> PROP_HEIGHT = new TypedProp<UnitDouble>((Object)"height", new UnitDouble(1.0, SI.METER));
    private static final TypedProp<String> PROP_UNITS = new TypedProp<String>((Object)"length_unit", SI.METER.toString());
    public static final Set<Object> ALL_PROPS = Sets.fromArrayLHS(NamedMerlinObj.NAME);
    private UnitDouble d_width;
    private UnitDouble d_height;
    private IMatAttrs d_material;

    public Material(String name, IMatAttrs mat) {
        this(name, mat, (UnitDouble)Material.PROP_WIDTH.defVal, (UnitDouble)Material.PROP_HEIGHT.defVal);
    }

    public Material(String name, IMatAttrs mat, UnitDouble width, UnitDouble height) {
        super(name);
        this.d_material = mat;
        this.d_width = width;
        this.d_height = height;
    }

    @Override
    public Material clone() {
        Material clone = (Material)super.clone();
        return clone;
    }

    public HashMaterial makeImagesHashable() {
        Material result = this.clone();
        result.d_material = MatUtil.makeImagesHashable(this.d_material);
        return new HashMaterial(result);
    }

    public List<IImage> getImages() {
        ArrayList<IImage> images = new ArrayList<IImage>();
        for (MatChannel chnl : MatChannel.values()) {
            Texture tex = this.d_material.getTexture(chnl);
            if (tex == null) continue;
            images.add(tex.image);
        }
        return images;
    }

    public void setImages(List<IImage> images) throws IOException {
        if (images.isEmpty() || !(this.d_material instanceof MatAttrs)) {
            return;
        }
        MatAttrs dmat = (MatAttrs)this.d_material;
        int ix = 0;
        for (MatChannel chnl : MatChannel.values()) {
            Texture tex = this.d_material.getTexture(chnl);
            if (tex == null) continue;
            IImage newImg = images.get(ix++);
            tex = new Texture(newImg, tex.mode, tex.wrapS, tex.wrapT, tex.borderColor, tex.uvSet);
            dmat = dmat.applyTexture(chnl, tex);
        }
        this.d_material = dmat;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setAttributes(IMatAttrs mat) {
        this.d_material = mat;
        this.changedEvt(new Object[0]);
    }

    @Override
    public IMatAttrs getAttributes() {
        return this.d_material;
    }

    @Override
    public UnitDouble getWidth() {
        return this.d_width;
    }

    protected void setWidth(UnitDouble width) {
        this.d_width = width;
        this.changedEvt(new Object[0]);
    }

    @Override
    public UnitDouble getHeight() {
        return this.d_height;
    }

    protected void setHeight(UnitDouble height) {
        this.d_height = height;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setSize(UnitDouble width, UnitDouble height) {
        if (this.d_width.equals(width) && this.d_height.equals(height)) {
            return;
        }
        this.d_width = width;
        this.d_height = height;
        this.changedEvt(new Object[0]);
    }

    public boolean isValid() {
        for (MatChannel chnl : MatChannel.values()) {
            Texture tex = this.d_material.getTexture(chnl);
            if (tex == null || tex.image.isValid()) continue;
            return false;
        }
        return true;
    }

    public static BufferedImage makeSafe(BufferedImage img) {
        if (img == null) {
            return null;
        }
        BufferedImage compat = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        Graphics2D g2d = compat.createGraphics();
        g2d.drawImage(img, null, 0, 0);
        g2d.dispose();
        return compat;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[[Texture]");
        sb.append("name=");
        sb.append(this.getName());
        sb.append(" ");
        for (MatChannel chnl : MatChannel.values()) {
            if (!MatUtil.isSupported(this.d_material, chnl)) continue;
            Color c = this.d_material.getColor(chnl);
            Texture tex = this.d_material.getTexture(chnl);
            sb.append(chnl.name());
            sb.append(": ");
            if (c != null) {
                sb.append("color=");
                sb.append(c.toString());
                sb.append(" ");
            }
            if (tex == null) continue;
            sb.append("tex=");
            sb.append(new File(tex.image.getFilename()).getName());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        boolean version = true;
        oos.writeInt(1);
        if (oos instanceof IPropertySet) {
            ((IPropertySet)((Object)oos)).set(Texture.PROP_CACHE_IN_STREAM, true);
        } else {
            System.err.println("Texture not saved with material: ObjectOutputStream was not an IPropertySet.");
        }
        oos.writeObject(this.d_material);
        oos.writeObject(this.d_width);
        oos.writeObject(this.d_height);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.readInt();
        this.d_material = (IMatAttrs)ois.readObject();
        this.d_width = (UnitDouble)ois.readObject();
        this.d_height = (UnitDouble)ois.readObject();
    }

    public void save(File dir, String filename) throws IOException {
        TeciProps tp = new TeciProps();
        tp.set(PROP_MAT_NAME, this.getName());
        tp.set(PROP_VERSION, Integer.valueOf(PropVersion.curr().ordinal()));
        tp.set(PROP_WIDTH, this.getWidth());
        tp.set(PROP_HEIGHT, this.getHeight());
        this.getAttributes().save(tp, (IImage img) -> {
            File file = new File(img.getFilename());
            return FilenameManager.getRelativeFilename(dir, file, false);
        });
        File f = new File(dir, filename);
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(f);
            tp.storeToXML(fos, null);
        }
    }

    public static Material load(File dir, String filename) throws IOException {
        File propsFile = new File(dir, filename);
        TeciProps tp = Material.loadProps(propsFile);
        String name = tp.getString(PROP_MAT_NAME);
        if (name == null) {
            name = FilenameManager.splitFilename(filename)[0];
        }
        UnitDouble width = tp.getUnitDouble(PROP_WIDTH);
        UnitDouble height = tp.getUnitDouble(PROP_HEIGHT);
        IMatAttrs matAttrs = IMatAttrs.load(tp, (String fn) -> {
            File file = FilenameManager.resolveFile(dir, fn, false);
            return ImageManager.getImage(file.getAbsolutePath(), 3, 0);
        });
        return new Material(name, matAttrs, width, height);
    }

    private static TeciProps loadProps(File infoFile) throws IOException {
        try (FileInputStream is = new FileInputStream(infoFile);){
            TeciProps tp = new TeciProps();
            tp.loadFromXML(is);
            int version = tp.getInt(PROP_VERSION);
            if (version < PropVersion.VERSION_0001.ordinal()) {
                String name = FilenameManager.splitFilename(infoFile.getName())[0];
                tp.set(PROP_MAT_NAME, name);
                Unit lenUnit = Material.getLenUnit(tp);
                double width = tp.getDouble((String)Material.PROP_WIDTH.key, ((UnitDouble)Material.PROP_WIDTH.defVal).getValue(lenUnit));
                double height = tp.getDouble((String)Material.PROP_HEIGHT.key, ((UnitDouble)Material.PROP_HEIGHT.defVal).getValue(lenUnit));
                tp.set(PROP_WIDTH, new UnitDouble(width, lenUnit));
                tp.set(PROP_HEIGHT, new UnitDouble(height, lenUnit));
                tp.remove(PROP_UNITS);
                tp.set(PROP_VERSION, Integer.valueOf(PropVersion.curr().ordinal()));
                String imgName = infoFile.getName();
                imgName = FilenameManager.splitFilename(imgName)[0];
                tp.set("diffuse.tex", imgName);
                IMatAttrs.DIFFUSE_COLOR.save(tp, i -> "", Color.WHITE);
            }
            if (version < PropVersion.VERSION_0002.ordinal()) {
                IMatAttrs.SPECULAR_COLOR.save(tp, i -> "", (Color)IMatAttrs.SPECULAR_COLOR.defVal);
            }
            TeciProps teciProps = tp;
            return teciProps;
        }
    }

    private static Unit getLenUnit(TeciProps props) {
        String prop = props.getString(PROP_UNITS);
        if (prop == null) {
            return SI.METER;
        }
        boolean UNIT_METERS = false;
        boolean UNIT_FEET = true;
        if (prop.equals(Integer.toString(0))) {
            return SI.METER;
        }
        if (prop.equals(Integer.toString(1))) {
            return NonSI.FOOT;
        }
        try {
            Unit u = Unit.valueOf(prop);
            if (UnitDouble.areCompatible(u, SI.METER)) {
                return u;
            }
            String msg = String.format(Intl.intl("Incompatible unit: %s"), prop);
            System.err.println(msg);
        }
        catch (IllegalArgumentException e) {
            String txt = String.format(Intl.intl("Unrecognized unit: %s"), prop);
            System.err.println(txt);
        }
        return SI.METER;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        }
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return ALL_PROPS;
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !comparable.getClass().equals(this.getClass())) {
            return false;
        }
        Material mat = (Material)comparable;
        return this.getName().equals(mat.getName()) && this.d_width.epsilonEquals(mat.d_width, 1.0E-12) && this.d_height.epsilonEquals(mat.d_height, 1.0E-12) && MatUtil.makeImagesHashable(this.d_material).equals(mat.d_material);
    }

    private static enum PropVersion {
        VERSION_0000,
        VERSION_0001,
        VERSION_0002;


        public static PropVersion curr() {
            return PropVersion.values()[PropVersion.values().length - 1];
        }
    }
}

