/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.queues;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.geom.GeomUtil;
import merlin.geom.IMerlinDispProps;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.theUtil;

public class QueueService
extends NamedMerlinObj
implements IQueueElement,
IEgressObj {
    static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<Point3d> PROP_LOC = new IPropertySet.Prop<Point3d>("QueueService.LOC", new Point3d());
    public static final IPropertySet.Prop<Vector3d> PROP_NORMAL = new IPropertySet.Prop<Vector3d>("QueueService.NORMAL", GeomConstants.VEC3D_ZPOS);
    public static final IPropertySet.Prop<IDistributedVal<UnitDouble>> PROP_TIME = new IPropertySet.Prop<Urn<UnitDouble>>("QueueService.TIME", new Urn<UnitDouble>((Collection<UnitDouble>)Collections.singleton(new UnitDouble(10.0, SI.SECOND))));
    public static final Set<Object> PROP_TYPES = new LinkedHashSet<Object>();
    private PropertySet d_props = new PropertySet();
    private boolean d_visible;
    @SkipDep
    private transient IEgressOccupiable d_room;

    public QueueService(String name, Point3d loc, IDistributedVal<UnitDouble> wait, IEgressOccupiable room, Vector3d normal) {
        super(name);
        this.d_props.set(PROP_LOC, loc);
        this.d_props.set(PROP_TIME, wait);
        this.d_props.set(PROP_NORMAL, normal);
        this.d_visible = true;
        this.d_room = room;
    }

    @Override
    public boolean surrogateEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        QueueService qs = (QueueService)obj;
        return Objects.equals(this.getName(), qs.getName()) && Objects.equals(this.getProperty(PROP_LOC), qs.getProperty(PROP_LOC)) && theUtil.equal(this.getProperty(PROP_TIME), qs.getProperty(PROP_TIME));
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.changedEvt(new Object[0]);
    }

    public Point3d getLocation() {
        return this.getProperty(PROP_LOC);
    }

    public void setLocation(Point3d loc) {
        this.setProperty(PROP_LOC, loc);
    }

    public Vector3d getNormal() {
        return this.getProperty(PROP_NORMAL);
    }

    public void setNormal(Vector3d normal) {
        this.setProperty(PROP_NORMAL, normal);
    }

    public void setLocation(IEgressOccupiable room, Vector3d normal, Point3d loc) {
        this.setLocation(loc);
        this.setNormal(normal);
        if (room != this.d_room) {
            if (this.getDomain() != null) {
                if (this.d_room != null) {
                    this.d_room.disconnectFrom(this);
                    this.disconnectFrom(this.d_room);
                }
                if (room != null) {
                    room.connectTo(this);
                }
            }
            this.d_room = room;
        }
    }

    public IDistributedVal getServiceTime() {
        return this.getProperty(PROP_TIME);
    }

    public void setServiceTime(IDistributedVal time) {
        this.setProperty(PROP_TIME, time);
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof QueueServiceGeom) {
            QueueServiceGeom sgeom = (QueueServiceGeom)geom;
            this.pauseUpdates();
            this.setLocation(sgeom.room, sgeom.normal, sgeom.location);
            this.resumeUpdates();
        } else if (geom instanceof Point) {
            this.setLocation(((Point)geom).loc);
        }
    }

    @Override
    public IGeomNode getGeom() {
        IGeom geom = this.getDomain() != null ? this.getSolidServiceGeom() : this.getHollowServiceGeom();
        return GeomNodeUtil.newNode(geom);
    }

    public IGeom getSolidServiceGeom() {
        return new QueueServiceGeom(this.getRoom(), this.getNormal(), this.getLocation(), true);
    }

    public IGeom getHollowServiceGeom() {
        return new QueueServiceGeom(this.getRoom(), this.getNormal(), this.getLocation(), false);
    }

    @Override
    public QueueService clone() {
        QueueService clone = (QueueService)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof QueueService)) {
            return;
        }
        QueueService qs = (QueueService)obj;
        this.pauseUpdates();
        this.d_props = qs.d_props;
        this.changedEvt(new Object[0]);
        this.setLocation(qs.getRoom(), qs.getNormal(), qs.getLocation());
        this.setVisible(qs.isVisible());
        this.resumeUpdates();
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.setProperty((IPropertySet.Prop)property, value);
        }
        if (property == NAME) {
            this.setName((String)value);
        }
        if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        }
    }

    public <T> void setProperty(IPropertySet.Prop<T> prop, T value) {
        this.d_props.set(prop, value);
        this.changedEvt(prop);
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NAME) {
            return this.getName();
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property instanceof IPropertySet.Prop) {
            return this.getProperty((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    public <T> T getProperty(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        if (!(props instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps globalProps = (IMerlinDispProps)props;
        IGeomNode geom = this.getGeom();
        PropsBuilder qsProps = new PropsBuilder();
        IPrimProps eprops = globalProps.getEdgeProps(this, IMerlinDispProps.EgressType.QUEUE_SERV, Color.BLACK, 1.0f);
        qsProps.add(eprops);
        if (this.getDomain() != null) {
            QueueObject parent = (QueueObject)((MerlinData)this.getDomain()).hierarchy.getParent(this);
            Color baseColor = parent.getColor();
            float opacity = parent.getOpacity();
            IPrimProps fprops = globalProps.getFaceProps(this, IMerlinDispProps.EgressType.QUEUE_SERV, null, baseColor, opacity);
            qsProps.add(fprops);
        }
        qsProps.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
        return new DisplayGeom(geom, qsProps);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room == null ? Collections.EMPTY_LIST : Arrays.asList(this.d_room);
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            this.d_room = null;
            this.setProperty(PROP_NORMAL, GeomConstants.VEC3D_ZPOS);
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public boolean updateTopo() {
        GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(this.getLocation().x, this.getLocation().y, this.getLocation().z + 1.0E-6), new Point3d(this.getLocation().x, this.getLocation().y, this.getLocation().z - 1.0E-6), 1);
        if (room != null) {
            this.setLocation(room.room, room.faceNormal, room.p);
            this.changedEvt(new Object[0]);
        }
        return true;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.getLocation();
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.getLocation();
    }

    static {
        PROP_TYPES.add(NAME);
        PROP_TYPES.add(MerlinData.VISIBILITY);
        PROP_TYPES.add(PROP_LOC);
        PROP_TYPES.add(PROP_NORMAL);
        PROP_TYPES.add(PROP_TIME);
    }

    private static class QueueServiceGeom
    extends GeomUtil.ACircleGeometry {
        private static final long serialVersionUID = 6888058928107634877L;
        private final boolean d_solid;

        public QueueServiceGeom(IEgressOccupiable room, Vector3d normal, Point3d location, boolean solid) {
            super(room, normal, location, 0.25, solid, new IGeom[0]);
            this.d_solid = solid;
        }

        @Override
        protected IGeom constructTransformedGeom(GeomUtil.FindResult find, Point3d newLoc, double radius) {
            if (find == null) {
                return new QueueServiceGeom(null, GeomConstants.VEC3D_ZPOS, newLoc, this.d_solid);
            }
            return new QueueServiceGeom(find.room, find.faceNormal, newLoc, this.d_solid);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new GeomUtil.LocationHandle(this, GeomUtil.LocationHandle.GEOM_TYPE.AREA));
        }

        @Override
        public GeomUtil.ACircleGeometry getConstructedTransform(IEgressOccupiable room, Vector3d normal, Point3d location, double radius) {
            return new QueueServiceGeom(room, normal, location, this.d_solid);
        }
    }
}

