/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.attractors;

import inferno.data2.ai.IEventTime;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.IWaitUntilSrc;
import merlin.gui.stat.CompactDistributedValPnl;
import merlin.gui.stat.VerboseDistributedValEditor;
import merlin.gui.value.MultiValEditor;
import merlin.mv.gui.behaviors.WaitUntilSrcPnl;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.gui.value.MappedValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;

public interface IAttractorTime
extends Serializable {
    public IEventTime toSim();

    public static IValEditor<IAttractorTime> newEditor(MerlinData md, boolean compact) {
        ArrayList entries = new ArrayList();
        for (Type type : Type.values()) {
            entries.add(new MultiValEditor.Entry<Object, Object>(type.name, type.desc, type.newEditor.apply(md, compact), v -> v != null, () -> true, v -> type.type.isInstance(v) ? v : type.getDefaultValue.apply(md)));
        }
        return new MultiValEditor(IAttractorTime.class, entries, !compact);
    }

    public static enum Type {
        AUTO(Auto.class, Intl.intl("Automatic"), "<html>" + Intl.intl("The <b>Decision Time</b> is chosen based on the occupant's current movement state:<br><b>Idling:</b> The occupant considers the trigger at a random time in the future<br>before their current idle period is over. <br><b>Seeking:</b> The occupant considers the trigger immediately."), (md, compact) -> new AutoEditor(), md -> Auto.INSTANCE),
        DELAY(Delay.class, Intl.intl("Delay"), Intl.intl("The occupant considers the trigger after a delay."), (md, compact) -> new DelayEditor((boolean)compact), md -> new Delay(new ConstantCurve(new UnitDouble(0.0, SI.SECOND)))),
        TIME(Time.class, Intl.intl("Specific Time"), Intl.intl("The occupant considers the trigger at a specific time."), (md, compact) -> new TimeEditor(), md -> new Time(new IWaitUntilSrc.SimpleWaitUntilSrc(new ConstantCurve(new UnitDouble(0.0, SI.SECOND)))));

        public final Class<? extends IAttractorTime> type;
        public final String name;
        public final String desc;
        public final BiFunction<MerlinData, Boolean, ? extends IValEditor<? extends IAttractorTime>> newEditor;
        public final Function<MerlinData, ? extends IAttractorTime> getDefaultValue;

        private <T extends IAttractorTime> Type(Class<T> type, String name, String desc, BiFunction<MerlinData, Boolean, IValEditor<T>> newEditor, Function<MerlinData, ? extends IAttractorTime> getDefaultValue) {
            this.type = type;
            this.name = name;
            this.desc = desc;
            this.newEditor = newEditor;
            this.getDefaultValue = getDefaultValue;
        }
    }

    public static class TimeEditor
    extends MappedValEditor<Time, IWaitUntilSrc> {
        public TimeEditor() {
            super(Time.class, new WaitUntilSrcPnl(Intl.intl("Time")), val -> new Time((IWaitUntilSrc)val), val -> val.value);
        }
    }

    public static class Time
    implements IAttractorTime {
        private static final long serialVersionUID = 1L;
        public final IWaitUntilSrc value;

        public Time(IWaitUntilSrc value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            Time v = (Time)obj;
            return v.value.equals(this.value);
        }

        public int hashCode() {
            return 0xAF7893 ^ this.value.hashCode();
        }

        public String toString() {
            return String.format("Time: %s", this.value.toString());
        }

        @Override
        public IEventTime toSim() {
            return this.value.toSim();
        }
    }

    public static class DelayEditor
    extends MappedValEditor<Delay, IDistributedVal<UnitDouble>> {
        public DelayEditor(boolean compact) {
            super(Delay.class, compact ? new CompactDistributedValPnl(Intl.intl("Delay"), 1, UnitDoubleVR.above(0.0, SI.SECOND, true)) : new VerboseDistributedValEditor(1, false), val -> new Delay((IDistributedVal<UnitDouble>)val), val -> val.value);
        }
    }

    public static class Delay
    implements IAttractorTime {
        private static final long serialVersionUID = 1L;
        public final IDistributedVal<UnitDouble> value;

        public Delay(IDistributedVal<UnitDouble> value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            Delay v = (Delay)obj;
            return v.value.equals(this.value);
        }

        public int hashCode() {
            return 0x7F89234 ^ this.value.hashCode();
        }

        public String toString() {
            return String.format("Delay: %s", this.value.toString());
        }

        @Override
        public IEventTime toSim() {
            return new IEventTime.Delay(this.value);
        }
    }

    public static class AutoEditor
    extends AValEditor<Auto> {
        private static final long serialVersionUID = 1L;

        public AutoEditor() {
            super(Auto.class);
        }

        @Override
        public void add(GridBagHelper gb) {
        }

        @Override
        protected void loadValue(Auto value) {
        }

        @Override
        protected Auto saveValue() {
            return Auto.INSTANCE;
        }
    }

    public static class Auto
    implements IAttractorTime {
        private static final long serialVersionUID = 1L;
        public static final Auto INSTANCE = new Auto();

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }

        public String toString() {
            return "Automatic";
        }

        @Override
        public IEventTime toSim() {
            return IEventTime.Auto.INSTANCE;
        }
    }
}

