/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import merlin.Intl;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.property.DetailedProp;
import merlin.data.property.INamedProp;
import merlin.gui.TagsEditor;
import merlin.util.ILabeledEnum;
import merlin.util.MerlinUtil;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;

public class LookAt
extends NamedMerlinObj
implements IBehaviorAction {
    static final long serialVersionUID = 1L;
    public static final DetailedProp<Set<String>> PROP_TAGS = new DetailedProp("LookAt.TAGS ", Intl.intl("Tags"), Intl.intl("Defines the tags used to find a target occupant."), Collections.emptySet(), (md, inline) -> new TagsEditor(true), v -> v, null);
    public static final DetailedProp<TagLogic> PROP_TAG_LOGIC = new DetailedProp<TagLogic>("LookAt.TAG_LOGIC ", Intl.intl("Tag Logic"), Intl.intl("Defines how the tags are combined in order to find a target occupant."), TagLogic.ALL, v -> v, logic -> logic.name);
    public static final DetailedProp<DistancePref> PROP_DIST_PREF = new DetailedProp<DistancePref>("LookAt.DIST_PREF", Intl.intl("Distance Preference"), Intl.intl("Defines the occupant's preference for a target occupant based on the distance\nto the occupant."), DistancePref.RANDOM, v -> v, v -> v.name);
    private static final Collection<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(LookAt.class);
    private static final Map<Object, IPropertySet.Prop<?>> ALL_PROPS_MAP = IPropertySet.getKeyToPropMap(ALL_PROPS);
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(new LinkedHashSet(ALL_PROPS), NamedMerlinObj.NAME);
    private PropertySet d_props = new PropertySet();

    public LookAt() {
        super(null);
    }

    @Override
    public LookAt clone() {
        LookAt clone = (LookAt)super.clone();
        clone.d_props = MerlinUtil.clone(this.d_props, ALL_PROPS_MAP::get, (prop, v) -> {
            if (prop instanceof INamedProp) {
                return ((INamedProp)((Object)prop)).cloneValue(v);
            }
            return v;
        });
        return clone;
    }

    @Override
    public LookAt getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof LookAt)) {
            return;
        }
        LookAt la = (LookAt)obj;
        this.pauseUpdates();
        this.d_props = la.d_props;
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        LookAt la = (LookAt)comparable;
        return this.getName().equals(la.getName()) && this.d_props.compare((IPropertySet)la.d_props, PROP_DIST_PREF, PROP_TAG_LOGIC, PROP_TAGS);
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(this.d_props.get(prop), value)) {
            this.d_props.setIfNotDefault(prop, value);
            this.changedEvt(prop);
        }
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public String getName() {
        return String.format(Intl.intl("Look at Occ %s"), this.get(LookAt.PROP_TAG_LOGIC).formatTags.apply(this.get(PROP_TAGS)));
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    public static enum TagLogic implements ILabeledEnum
    {
        ALL(Intl.intl("All"), Intl.intl("The target occupant must have all the specified tags."), tags -> MerlinUtil.formatTags(tags, Intl.intl(" and "), 25)),
        ANY(Intl.intl("Any"), Intl.intl("The target occupant must have any of the specified tags."), tags -> MerlinUtil.formatTags(tags, Intl.intl(" or "), 25));

        public final String name;
        public final String desc;
        public final Function<Set<String>, String> formatTags;

        private TagLogic(String name, String desc, Function<Set<String>, String> formatTags) {
            this.name = name;
            this.desc = desc;
            this.formatTags = formatTags;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum DistancePref implements ILabeledEnum
    {
        RANDOM(Intl.intl("None"), Intl.intl("The occupant has no distance preference. A target occupant is chosen at random from those available.")),
        NEAREST(Intl.intl("Nearest"), Intl.intl("The nearest available occupant is chosen."));

        public final String name;
        public final String desc;

        private DistancePref(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

