/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.Floor;
import merlin.data.egress.SimError;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class GotoElevators
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = -7706651152609813492L;
    private Collection<Elevator> d_elevators;
    private Floor d_targetDischarge;
    public static final Object PROP_ELEVATORS = "GotoElevators.ELEVATORS";
    public static final IPropertySet.Prop<Floor> PROP_FLOOR = new IPropertySet.Prop<Object>("GotoOccTarget.PROP_FLOOR", null);
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME, PROP_ELEVATORS, PROP_FLOOR);

    public GotoElevators(Set<Elevator> elevators) {
        this(elevators, null);
    }

    public GotoElevators(Set<Elevator> elevators, Floor targetDischarge) {
        super(null);
        this.d_elevators = elevators;
        this.d_targetDischarge = targetDischarge;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_elevators instanceof List || this.d_elevators instanceof IdentityHashSet) {
            this.d_elevators = new LinkedIdentityHashSet<Elevator>(this.d_elevators);
        }
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof GotoElevators)) {
            return;
        }
        GotoElevators ge = (GotoElevators)obj;
        this.pauseUpdates();
        this.setElevators((Set)ge.d_elevators);
        this.setName(ge.getSetName());
        this.resumeUpdates();
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public void setElevators(Set<Elevator> elevators) {
        this.d_elevators = elevators;
        this.changedEvt(new Object[0]);
    }

    public void setTargetDischarge(Floor floor) {
        this.d_targetDischarge = floor;
        this.changedEvt(new Object[0]);
    }

    public Set<Elevator> getElevators() {
        return Collections.unmodifiableSet((Set)this.d_elevators);
    }

    public Floor getTargetDischarge() {
        return this.d_targetDischarge;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            name = this.d_elevators.size() == 1 ? String.format(Intl.intl("Goto %s"), this.d_elevators.iterator().next().getName()) : (this.d_elevators.isEmpty() ? Intl.intl("Goto Any Elevator") : String.format(Intl.intl("Goto Elevators"), new Object[0]));
        }
        return name;
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == PROP_ELEVATORS) {
            return this.getElevators();
        }
        if (property == PROP_FLOOR) {
            return this.getTargetDischarge();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == PROP_ELEVATORS) {
            this.setElevators((Set)value);
        } else if (property == PROP_FLOOR) {
            this.setTargetDischarge((Floor)value);
        }
    }

    @Override
    public IDestination getDestination() {
        return new Destination();
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        LinkedIdentityHashSet<Elevator> newElevators = new LinkedIdentityHashSet<Elevator>(this.d_elevators);
        newElevators.remove(old);
        if (replacement != null && replacement instanceof Elevator) {
            newElevators.add((Elevator)replacement);
        }
        this.setElevators(newElevators);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.d_elevators);
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (Elevator elevator : this.getElevators()) {
            hash = 31 * hash + theUtil.hashCode(elevator);
        }
        return hash;
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        GotoElevators ge = (GotoElevators)comparable;
        Set<Elevator> comparableElevators = ge.getElevators();
        return Objects.equals(this.getSetName(), ge.getSetName()) && theUtil.surrogateSetsEqual(this.d_elevators, comparableElevators);
    }

    public class Destination
    implements IDestination {
        private final Set<IEgressConnector> d_connectors;
        private final Set<IEgressConnector> d_dischargeDoors;

        public Destination() {
            Collection<Elevator> elevators = GotoElevators.this.d_elevators.isEmpty() ? ((MerlinData)GotoElevators.this.getDomain()).elevators.getDeepMembers(Elevator.class) : GotoElevators.this.d_elevators;
            LinkedIdentityHashSet<IEgressConnector> connectors = new LinkedIdentityHashSet<IEgressConnector>();
            LinkedIdentityHashSet<IEgressConnector> dischargeDoors = new LinkedIdentityHashSet<IEgressConnector>();
            for (Elevator elevator : elevators) {
                for (ElevatorRoom er : elevator.getDeepMembers(ElevatorRoom.class)) {
                    if (er == elevator.getFloorLevelMap().get(GotoElevators.this.d_targetDischarge)) {
                        dischargeDoors.addAll(er.getDoors());
                        continue;
                    }
                    connectors.addAll(er.getDoors());
                }
            }
            this.d_connectors = connectors;
            this.d_dischargeDoors = dischargeDoors;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Destination && ((Destination)obj).getElevators().equals(GotoElevators.this.d_elevators);
        }

        @Override
        public int hashCode() {
            return 0xFAEE8F ^ GotoElevators.this.d_elevators.hashCode();
        }

        protected Set<Elevator> getElevators() {
            return (Set)GotoElevators.this.d_elevators;
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            if (MerlinUtil.isConnected(source, this.d_connectors)) {
                return null;
            }
            return new IUnreachable(this){

                @Override
                public SimError getError(IMerlinObj source) {
                    String name = MerlinUtil.getName(source);
                    return new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("\"%s\" cannot reach the next elevator."), name), String.format(Intl.intl("Move \"%s\" or change the next destination."), name), source);
                }
            };
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() {
            Collection<Elevator> elevators = GotoElevators.this.d_elevators.isEmpty() ? ((MerlinData)GotoElevators.this.getDomain()).elevators.getDeepMembers(Elevator.class) : GotoElevators.this.d_elevators;
            ArrayList<ElevatorRoom> exitComps = new ArrayList<ElevatorRoom>(elevators.size());
            for (Elevator elevator : elevators) {
                Object enabled = elevator.getProperty(MerlinData.ENABLED);
                if (enabled instanceof Boolean && !((Boolean)enabled).booleanValue()) continue;
                ElevatorRoom targetExit = elevator.getFloorLevelMap().get(elevator.getDischargeFloor());
                if (GotoElevators.this.d_targetDischarge != null) {
                    targetExit = elevator.getFloorLevelMap().get(GotoElevators.this.d_targetDischarge);
                }
                exitComps.add(targetExit);
            }
            return exitComps;
        }
    }
}

