/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.attractors.Attractor;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class DestroyAttractor
extends NamedMerlinObj
implements IBehaviorAction,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 7824814114567292619L;
    public static final IPropertySet.Prop<Set<Attractor>> PROP_ATTRACTORS = new IPropertySet.Prop("DestroyAttractor.ATTRACTORS", Collections.emptySet());
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME, PROP_ATTRACTORS);
    private Set<Attractor> d_attractors;

    public DestroyAttractor(Set<Attractor> attractors) {
        super(null);
        this.d_attractors = attractors;
    }

    @Override
    public DestroyAttractor getRestoreObj() {
        return (DestroyAttractor)this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof DestroyAttractor)) {
            return;
        }
        DestroyAttractor da = (DestroyAttractor)obj;
        this.pauseUpdates();
        this.setAttractors(da.d_attractors);
        this.setName(da.getSetName());
        this.resumeUpdates();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    public Set<Attractor> getAttractors() {
        return Collections.unmodifiableSet(this.d_attractors);
    }

    public void setAttractors(Set<Attractor> attractors) {
        this.d_attractors = attractors;
        this.changedEvt(new Object[0]);
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        if (this.d_attractors.size() == 1) {
            return String.format(Intl.intl("Destroy %s"), this.d_attractors.iterator().next().getName());
        }
        return Intl.intl("Destroy Triggers");
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == PROP_ATTRACTORS) {
            return this.getAttractors();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == PROP_ATTRACTORS) {
            this.setAttractors((Set)value);
        }
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        LinkedIdentityHashSet<Attractor> newAttractors = new LinkedIdentityHashSet<Attractor>((Collection<Attractor>)this.d_attractors);
        newAttractors.remove(old);
        if (replacement != null && replacement instanceof Attractor) {
            newAttractors.add((Attractor)replacement);
        }
        this.setProperty(PROP_ATTRACTORS, newAttractors);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.d_attractors);
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        DestroyAttractor comparableAction = (DestroyAttractor)comparable;
        if (!theUtil.equal(this.getSetName(), comparableAction.getSetName(), comparedSet)) {
            return false;
        }
        return theUtil.surrogateSetsEqual(this.getAttractors(), comparableAction.getAttractors(), comparedSet);
    }
}

