/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class CreateAttractor
extends NamedMerlinObj
implements IBehaviorAction,
IEgressObj,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 7824814114567292619L;
    public static final IPropertySet.Prop<Set<Attractor>> PROP_ATTRACTORS = new IPropertySet.Prop("CreateAttractor.ATTRACTORS", Collections.emptySet());
    public static final IPropertySet.Prop<LocationMode> PROP_LOCATION = new IPropertySet.Prop<LocationMode>("CreateAttractor.LOCATION", LocationMode.FOLLOW_OCC);
    public static final IPropertySet.Prop<Point3d> PROP_FIXED_LOCATION = new IPropertySet.Prop<Object>("CreateAttractor.FIXED_LOCATION", null);
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME, MerlinData.VISIBILITY, PROP_LOCATION, PROP_ATTRACTORS, PROP_FIXED_LOCATION);
    private Set<Attractor> d_attractors;
    private LocationMode d_location;
    private boolean d_visible;
    private Point3d d_fixedLocation;
    @SkipDep
    private transient IEgressOccupiable d_fixedRoom;
    private Vector3d d_fixedNormal;
    private static final Color BASE_COLOR = Color.ORANGE;

    public CreateAttractor(Set<Attractor> attractors, LocationMode location, Point3d fixedLocation, IEgressOccupiable fixedRoom, Vector3d fixedNormal) {
        super(null);
        this.d_attractors = attractors;
        this.d_location = location;
        this.d_visible = true;
        this.d_fixedLocation = fixedLocation;
        this.d_fixedRoom = fixedRoom;
        this.d_fixedNormal = fixedNormal;
    }

    @Override
    public CreateAttractor getRestoreObj() {
        return (CreateAttractor)this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof CreateAttractor)) {
            return;
        }
        CreateAttractor ca = (CreateAttractor)obj;
        this.pauseUpdates();
        super.setName(ca.getSetName());
        this.d_attractors = ca.d_attractors;
        this.d_location = ca.d_location;
        this.d_fixedLocation = ca.d_fixedLocation;
        this.d_fixedNormal = ca.d_fixedNormal;
        this.d_visible = ca.d_visible;
        this.changedEvt(MerlinData.TOPOLOGY);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    public Set<Attractor> getAttractors() {
        return Collections.unmodifiableSet(this.d_attractors);
    }

    public void setAttractors(Set<Attractor> attractors) {
        this.pauseUpdates();
        this.d_attractors = attractors;
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public LocationMode getLocation() {
        return this.d_location;
    }

    public void setLocation(LocationMode location) {
        if (this.d_location != location) {
            this.pauseUpdates();
            this.d_location = location;
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    public Point3d getFixedLocation() {
        return this.d_fixedLocation;
    }

    public IEgressOccupiable getFixedRoom() {
        return this.d_fixedRoom;
    }

    public void setFixedLocation(Point3d loc) {
        if (this.d_fixedLocation == null || !this.d_fixedLocation.equals(loc)) {
            this.pauseUpdates();
            this.d_fixedLocation = loc;
            this.changedEvt(MerlinData.TOPOLOGY);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    private void setFixedLocation(IEgressOccupiable room, Vector3d roomNorm, Point3d loc) {
        this.pauseUpdates();
        this.d_fixedLocation = loc;
        this.d_fixedNormal = roomNorm;
        if (room != this.d_fixedRoom) {
            if (this.getDomain() != null) {
                if (this.d_fixedRoom != null) {
                    this.d_fixedRoom.disconnectFrom(this);
                    this.disconnectFrom(this.d_fixedRoom);
                }
                if (room != null) {
                    room.connectTo(this);
                }
            }
            this.d_fixedRoom = room;
        }
        this.resumeUpdates();
        this.changedEvt(new Object[0]);
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        if (this.d_attractors.size() == 1) {
            switch (this.d_location) {
                case FOLLOW_OCC: {
                    return String.format(Intl.intl("Create %s Following Occupant"), this.d_attractors.iterator().next().getName());
                }
                case CURRENT_LOCATION: {
                    return String.format(Intl.intl("Create %s at Current Location"), this.d_attractors.iterator().next().getName());
                }
                case FIXED_LOCATION: {
                    return String.format(Intl.intl("Create %s at %s"), this.d_attractors.iterator().next().getName(), CreateAttractor.format(this.d_fixedLocation));
                }
            }
            return String.format(Intl.intl("Create %s"), this.d_attractors.iterator().next().getName());
        }
        switch (this.d_location) {
            case FOLLOW_OCC: {
                return String.format(Intl.intl("Create Triggers Following Occupant"), new Object[0]);
            }
            case CURRENT_LOCATION: {
                return String.format(Intl.intl("Create Triggers at Current Location"), new Object[0]);
            }
            case FIXED_LOCATION: {
                return String.format(Intl.intl("Create Triggers at %s"), CreateAttractor.format(this.d_fixedLocation));
            }
        }
        return String.format(Intl.intl("Create Triggers"), new Object[0]);
    }

    private static String format(Point3d p) {
        Unit su = Geometry.LENGTH_UNIT;
        Unit du = MerlinApp.getApp().getUnitSystem().getLength();
        return String.format("(%.1f, %.1f, %.1f) %s", UnitDouble.convert(p.x, su, du), UnitDouble.convert(p.y, su, du), UnitDouble.convert(p.z, su, du), du.toString());
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public IGeomNode getGeom() {
        if (this.d_location == LocationMode.FIXED_LOCATION) {
            return GeomNodeUtil.newNode(new CreateAttractorGeometry(this.d_fixedRoom, this.d_fixedNormal == null ? GeomConstants.VEC3D_ZPOS : this.d_fixedNormal, this.d_fixedLocation));
        }
        return GeomNodeUtil.newNode(EmptyGeom.INSTANCE);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof CreateAttractorGeometry) {
            CreateAttractorGeometry wgeom = (CreateAttractorGeometry)geom;
            this.setFixedLocation(wgeom.room, wgeom.normal, wgeom.location);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder gprops = new PropsBuilder();
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Face(BASE_COLOR, null, 0));
        gprops.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
        return new DisplayGeom(geom, gprops);
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.d_fixedLocation;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.d_fixedLocation;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_fixedRoom);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_fixedRoom = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public boolean updateTopo() {
        GeomUtil.FindResult room;
        if (this.d_location == LocationMode.FIXED_LOCATION && this.getDomain() != null && (room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(this.d_fixedLocation.x, this.d_fixedLocation.y, this.d_fixedLocation.z + 1.0E-6), new Point3d(this.d_fixedLocation.x, this.d_fixedLocation.y, this.d_fixedLocation.z - 1.0E-6), 1)) != null) {
            this.d_fixedRoom = room.room;
            this.d_fixedNormal = room.faceNormal;
            this.d_fixedLocation = room.p;
            this.changedEvt(new Object[0]);
        }
        return true;
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public void connectTo(IEgressObj conn) {
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_fixedRoom) {
            this.d_fixedRoom = null;
            this.d_fixedNormal = GeomConstants.VEC3D_ZPOS;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_fixedRoom == null ? Collections.emptyList() : Arrays.asList(this.d_fixedRoom);
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_fixedRoom == null;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == PROP_ATTRACTORS) {
            return this.getAttractors();
        }
        if (property == PROP_LOCATION) {
            return this.getLocation();
        }
        if (property == PROP_FIXED_LOCATION) {
            return this.getFixedLocation();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        }
        if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == PROP_ATTRACTORS) {
            this.setAttractors((Set)value);
        } else if (property == PROP_LOCATION) {
            this.setLocation((LocationMode)((Object)value));
        } else if (property == PROP_FIXED_LOCATION) {
            this.setFixedLocation((Point3d)value);
        }
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        LinkedIdentityHashSet<Attractor> newAttractors = new LinkedIdentityHashSet<Attractor>((Collection<Attractor>)this.d_attractors);
        newAttractors.remove(old);
        if (replacement != null && replacement instanceof Attractor) {
            newAttractors.add((Attractor)replacement);
        }
        this.setAttractors(newAttractors);
        this.updateTopo();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.d_attractors);
        deps.add(DLink.WEAK, this.d_fixedRoom);
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        CreateAttractor comparableAction = (CreateAttractor)comparable;
        if (!theUtil.equal(this.getSetName(), comparableAction.getSetName(), comparedSet)) {
            return false;
        }
        if (!theUtil.equal(this.getProperty(MerlinData.VISIBILITY), comparableAction.getProperty(MerlinData.VISIBILITY), comparedSet)) {
            return false;
        }
        if (!theUtil.surrogateSetsEqual(this.getAttractors(), comparableAction.getAttractors(), comparedSet)) {
            return false;
        }
        if (!theUtil.equal((Object)this.getLocation(), (Object)comparableAction.getLocation(), comparedSet)) {
            return false;
        }
        return theUtil.equal(this.getFixedLocation(), comparableAction.getFixedLocation(), comparedSet);
    }

    public static enum LocationMode {
        FOLLOW_OCC(Intl.intl("Follow Occupant"), Intl.intl("The created triggers will move with the occupant.")),
        CURRENT_LOCATION(Intl.intl("Current Location"), Intl.intl("The created triggers will be placed at the occupant's current location.")),
        FIXED_LOCATION(Intl.intl("Fixed Location"), Intl.intl("The created triggers will be placed at a predefined location."));

        public final String name;
        public final String desc;

        private LocationMode(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }

    private static class CreateAttractorGeometry
    extends GeomUtil.ACircleGeometry {
        private static final long serialVersionUID = -7258540461757674787L;

        public CreateAttractorGeometry(IEgressOccupiable room, Vector3d normal, Point3d location) {
            super(room, normal, location, 1.0, true, new IGeom[0]);
        }

        @Override
        protected IGeom constructTransformedGeom(GeomUtil.FindResult find, Point3d newLoc, double newRadius) {
            if (find == null) {
                return new CreateAttractorGeometry(null, GeomConstants.VEC3D_ZPOS, newLoc);
            }
            return new CreateAttractorGeometry(find.room, find.faceNormal, newLoc);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new GeomUtil.LocationHandle(this));
        }

        @Override
        public GeomUtil.ACircleGeometry getConstructedTransform(IEgressOccupiable room, Vector3d normal, Point3d location, double radius) {
            return new CreateAttractorGeometry(room, normal, location);
        }
    }
}

