/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.ChangeBehavior;
import merlin.data.egress.scripting.ChangeProfileProp;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.stat.DisabledCurve;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;

public class Behavior
extends GeomComposite<IBehaviorAction>
implements ICyclicSurrogate {
    private static final long serialVersionUID = 1L;
    public static final Object PROP_INI_DELAY = "Behavior.INI_DELAY";
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(GeomComposite.PROP_TYPES, PROP_INI_DELAY, MerlinData.COLOR);
    private static final long s_delaySeed = 275670542901161L;
    @SkipDep
    private IDistributedVal<UnitDouble> d_initialDelay;
    @SkipDep
    private Color d_color;
    private static final Predicate<ICompElement> s_filter = new TypeFilter<ICompElement>(IBehaviorAction.class);

    public Behavior(String name) {
        this(name, new ConstantCurve(new UnitDouble(0.0, SI.SECOND)));
    }

    public Behavior(String name, IDistributedVal<UnitDouble> initialDelay) {
        super(name);
        this.d_initialDelay = initialDelay;
        this.d_color = MerlinUtil.newRandomOccColor();
    }

    public Behavior(String name, IBehaviorAction action) {
        this(name);
        this.add(action);
    }

    public Behavior(String name, IDistributedVal<UnitDouble> initialDelay, IBehaviorAction action) {
        this(name, initialDelay);
        this.add(action);
    }

    public Behavior(String name, Behavior baseBehavior) {
        this(name, baseBehavior.d_initialDelay);
        for (ICompElement member : baseBehavior.getMembers()) {
            if (member instanceof IBehaviorAction) {
                member = (IBehaviorAction)((IBehaviorAction)member).clone();
            }
            this.add(member);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_color == null) {
            this.d_color = MerlinUtil.newRandomOccColor();
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0165)) {
            Object[] children = this.getChildren().toArray();
            for (int i = children.length - 1; i >= 0; --i) {
                ChangeProfileProp changeProp;
                if (!(children[i] instanceof ChangeProfileProp) || (changeProp = (ChangeProfileProp)children[i]).getProp() != OccProfile.PROP_SOCIAL_DIST) continue;
                if (changeProp.getValue() instanceof DisabledCurve) {
                    changeProp.set(ChangeProfileProp.VALUE, new ConstantCurve(new UnitDouble(0.0, SI.METER)));
                    this.insert(Collections.singletonList(new ChangeProfileProp(OccProfile.PROP_SOCIAL_DIST_FILTER, ObjsFilter.rejectAll())), i);
                    continue;
                }
                this.insert(Collections.singletonList(new ChangeProfileProp(OccProfile.PROP_SOCIAL_DIST_FILTER, ObjsFilter.acceptAll())), i);
            }
        }
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return null;
    }

    public void setColor(Color color) {
        if (this.d_color.equals(color)) {
            return;
        }
        if (color == null) {
            return;
        }
        this.d_color = color;
        this.changedEvt(MerlinData.COLOR);
    }

    public Color getColor() {
        return this.d_color;
    }

    public UnitDouble getDelayVal(Random rand, long baseSeed) {
        long seed = baseSeed ^ 0xFAB88CC8DFA9L;
        rand.setSeed(seed);
        return this.d_initialDelay.getValue(rand);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof Behavior)) {
            return;
        }
        Behavior behavior = (Behavior)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.d_initialDelay = behavior.d_initialDelay;
        this.d_color = behavior.d_color;
        this.resumeUpdates();
    }

    @Override
    public void add(ICompElement obj) {
        if (!(obj instanceof IBehaviorAction)) {
            return;
        }
        super.add(obj);
    }

    @Override
    public void addAll(Collection<? extends ICompElement> objs) {
        super.addAll(theUtil.filter(objs, IBehaviorAction.class));
    }

    public IDistributedVal<UnitDouble> getInitialDelay() {
        return this.d_initialDelay;
    }

    public void setInitialDelay(IDistributedVal<UnitDouble> iniDelay) {
        this.d_initialDelay = iniDelay;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == PROP_INI_DELAY) {
            return this.getInitialDelay();
        }
        if (property == MerlinData.COLOR) {
            return this.getColor();
        }
        return super.getProperty(property);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == PROP_INI_DELAY) {
            this.setInitialDelay((IDistributedVal)value);
        } else if (property == MerlinData.COLOR) {
            this.setColor((Color)value);
        } else {
            super.setProperty(property, value);
        }
    }

    public Optional<IBehaviorAction> getLastAction() {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return theUtil.getLast(this.getMembers(IBehaviorAction.class));
    }

    public void getReferencedBehaviors(Set<Behavior> allUsedBehaviors) {
        Collection<ChangeBehavior> changeBehaviorActions = this.flatten(ChangeBehavior.class);
        for (ChangeBehavior action : changeBehaviorActions) {
            for (Behavior b : action.getAllTargetBehaviors()) {
                if (allUsedBehaviors.contains(b)) continue;
                allUsedBehaviors.add(b);
                b.getReferencedBehaviors(allUsedBehaviors);
            }
        }
    }

    public <T> Collection<T> deepFlatten(Class<T> type) {
        LinkedIdentityHashSet result = new LinkedIdentityHashSet();
        this.deepFlatten(type, result);
        return result;
    }

    public <T> void deepFlatten(Class<T> type, Collection<T> result) {
        IdentityHashSet<Behavior> behaviors = new IdentityHashSet<Behavior>();
        behaviors.add(this);
        this.getReferencedBehaviors(behaviors);
        behaviors.forEach(b -> result.addAll(b.flatten(type)));
    }

    public <T> boolean allPathsContain(Class<T> type) {
        return Behavior.pathsContain(type, this, true);
    }

    public <T> boolean somePathsContain(Class<T> type) {
        return Behavior.pathsContain(type, this, false);
    }

    private static <T> boolean pathsContain(Class<T> type, Behavior rootBehavior, boolean allPaths) {
        ArrayDeque<Behavior> open = new ArrayDeque<Behavior>();
        HashSet<Behavior> closed = new HashSet<Behavior>();
        open.add(rootBehavior);
        while (!open.isEmpty()) {
            Behavior b = (Behavior)open.pop();
            if (closed.contains(b)) {
                if (!allPaths) continue;
                return false;
            }
            closed.add(b);
            Collection<T> localActions = b.flatten(type);
            if (!localActions.isEmpty()) {
                if (allPaths) continue;
                return true;
            }
            Collection<ChangeBehavior> changeBehaviorActions = b.flatten(ChangeBehavior.class);
            if (changeBehaviorActions.isEmpty()) {
                if (!allPaths) continue;
                return false;
            }
            for (ChangeBehavior changeBehavior : changeBehaviorActions) {
                changeBehavior.getAllTargetBehaviors().forEach(open::push);
            }
        }
        return allPaths;
    }

    public <T> T tracePath(Function<BehaviorNode, T> getResult) {
        Iterator<IBehaviorAction> actionIt = this.flatten(IBehaviorAction.class).iterator();
        if (!actionIt.hasNext()) {
            return null;
        }
        ArrayDeque<BehaviorNode> open = new ArrayDeque<BehaviorNode>();
        HashSet<Behavior> closed = new HashSet<Behavior>();
        open.push(new BehaviorNode(null, this, actionIt, actionIt.next()));
        closed.add(this);
        while (!open.isEmpty()) {
            BehaviorNode b = (BehaviorNode)open.pop();
            T result = getResult.apply(b);
            if (result != null) {
                return result;
            }
            if (b.actionIt.hasNext()) {
                open.push(new BehaviorNode(b.parent, b.behavior, b.actionIt, b.actionIt.next()));
            }
            if (!(b.action instanceof ChangeBehavior)) continue;
            ChangeBehavior cb = (ChangeBehavior)b.action;
            for (Behavior behavior : cb.getAllTargetBehaviors()) {
                Iterator<IBehaviorAction> nextActionIt;
                if (!closed.add(behavior) || !(nextActionIt = behavior.flatten(IBehaviorAction.class).iterator()).hasNext()) continue;
                open.push(new BehaviorNode(b, behavior, nextActionIt, nextActionIt.next()));
            }
        }
        return null;
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (Object prop : this.getPropTypes(0)) {
            hash = 31 * hash + theUtil.hashCode(this.getProperty(prop));
        }
        for (ICompElement member : this.getMembers()) {
            if (member instanceof ICyclicSurrogate) continue;
            hash = 31 * hash + theUtil.hashCode(member);
        }
        return hash;
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        Behavior comparableBehavior = (Behavior)comparable;
        for (Object prop : this.getPropTypes(0)) {
            if (theUtil.equal(this.getProperty(prop), comparableBehavior.getProperty(prop), comparedSet)) continue;
            return false;
        }
        return theUtil.surrogateListsEqual(this.getMembers(), comparableBehavior.getMembers(), comparedSet);
    }

    public static class BehaviorNode {
        public final BehaviorNode parent;
        public final Behavior behavior;
        public final IBehaviorAction action;
        public final Iterator<IBehaviorAction> actionIt;

        public BehaviorNode(BehaviorNode parent, Behavior behavior, Iterator<IBehaviorAction> actionIt, IBehaviorAction action) {
            this.parent = parent;
            this.behavior = behavior;
            this.action = action;
            this.actionIt = actionIt;
        }
    }
}

