/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import inferno.data2.SpeedModifier;
import java.io.Serializable;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.value.ConstVariant;
import merlin.data.value.IVariant;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Predicates;

public class SpeedModifier
implements Serializable {
    static final long serialVersionUID = 9023722890099195129L;
    public static final IPropertySet.Prop<Predicate<Type>> PROP_TYPE_FILTER = new IPropertySet.Prop("SpeedModifier.TYPE_FILTER", Predicates.alwaysTrue());
    public static final SpeedModifier IDENTITY;
    public static final SpeedModifier DEFAULT;
    public final Type type;
    public final IVariant<UnitDouble> value;

    public SpeedModifier(Type type, IVariant<UnitDouble> value) {
        this.value = value;
        this.type = type;
    }

    public boolean isBlocking(UnitDouble value) {
        return this.type.isBlocking.test(value);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SpeedModifier && ((SpeedModifier)obj).type == this.type && ((SpeedModifier)obj).value.equals(this.value);
    }

    public int hashCode() {
        return 0xF3EE432 ^ this.type.hashCode() + this.value.hashCode();
    }

    public boolean isMovingWalkway() {
        return this.type.isMovingWalkway();
    }

    public static IVariant<UnitDouble> newValForType(Type type) {
        switch (type) {
            case FACTOR: {
                return new ConstVariant<UnitDouble>(new UnitDouble(1.0, Unit.ONE));
            }
            case CONSTANT: {
                return new ConstVariant<UnitDouble>(SIUS.newud(1.0, 5));
            }
            case LIMIT: {
                return new ConstVariant<UnitDouble>(SIUS.newud(1.0, 5));
            }
        }
        assert (false);
        return null;
    }

    static {
        DEFAULT = IDENTITY = new SpeedModifier(Type.FACTOR, new ConstVariant<UnitDouble>(new UnitDouble(1.0, Unit.ONE)));
    }

    public static enum Type {
        FACTOR(Intl.intl("Speed Modifier"), Intl.intl("Multiplies the occupant's speed by a factor."), SpeedModifier.Type.FACTOR, 11, factor -> factor.getRawValue() == 0.0, new ValueAlias[0]),
        CONSTANT(Intl.intl("Speed Constant"), Intl.intl("Sets the occupant's speed to a constant value."), SpeedModifier.Type.CONSTANT, 5, Predicates.alwaysFalse(), new ValueAlias[0]),
        LIMIT(Intl.intl("Speed Limit"), Intl.intl("Sets a maximum speed for the occupant."), SpeedModifier.Type.LIMIT, 5, limit -> limit.getRawValue() == 0.0, new ValueAlias(new UnitDouble(Double.POSITIVE_INFINITY, SIUS.unit(5)), Type.disabled(), "<html>" + String.format(Intl.intl("NOTE: Enter a value of <b>%s</b> to disable the speed limit."), Type.disabled())));

        public final String name;
        public final String shortDesc;
        public final SpeedModifier.Type itype;
        public final int valueUnitType;
        public final ValueAlias[] valueAliases;
        public final Predicate<UnitDouble> isBlocking;

        private Type(String desc, String shortDesc, SpeedModifier.Type itype, int iValueUnitType, Predicate<UnitDouble> isBlocking, ValueAlias ... aliases) {
            this.name = desc;
            this.shortDesc = shortDesc;
            this.itype = itype;
            this.valueUnitType = iValueUnitType;
            this.isBlocking = isBlocking;
            this.valueAliases = aliases;
        }

        public boolean isMovingWalkway() {
            return this == CONSTANT;
        }

        private static String disabled() {
            return Intl.intl("disabled");
        }
    }

    public static final class ValueAlias {
        public final UnitDouble value;
        public final String alias;
        public final String description;

        public ValueAlias(UnitDouble value, String alias, String description) {
            this.value = value;
            this.alias = alias;
            this.description = description;
        }
    }
}

