/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import merlin.data.PredefTags;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressConnector;
import merlin.io.inferno.IInfernoComp;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public interface IEgressComp
extends IEgressObj,
IInfernoComp {
    public static final int MODELID_NON_BOUNDARY = 0;
    public static final int MODELID_BOUNDARY = 1;
    public static final int MODELID_CUSTOM_BEGIN = 100;
    public static final IPropertySet.Prop<Set<String>> OCC_TAGS = new IPropertySet.Prop("IEgressOccupiable.Tags", Collections.emptySet());
    public static final IPropertySet.Prop<Set<String>> CUSTOM_OCC_TAGS = new IPropertySet.Prop("IEgressOccupiable.Tags", Collections.emptySet());

    public Color getColor();

    public void setColor(Color var1);

    public float getOpacity();

    public void setOpacity(float var1);

    public void getConnectors(Collection<? super IEgressConnector> var1);

    public Collection<Pair<IEgressComp, ConflictType>> getConflicts();

    public boolean isEnabled();

    public Point3d astarGetTestPoint();

    public Set<String> getOccTags();

    public void setOccTags(Set<String> var1);

    default public Set<String> getCustomOccTags() {
        Set<String> tags = this.getOccTags();
        Predicate<String> filter = Filters.reject(PredefTags.NAMES);
        if (tags.stream().anyMatch(filter.negate())) {
            return tags.stream().filter(filter).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        }
        return tags;
    }

    default public void setCustomOccTags(Set<String> tags) {
        Set<String> currTags = this.getOccTags();
        IFilteredCollection<String> currPredefTags = theUtil.filter(currTags, Filters.accept(PredefTags.NAMES));
        if (!currPredefTags.isEmpty() && !tags.isEmpty()) {
            LinkedHashSet<String> newTags = new LinkedHashSet<String>(currPredefTags.size() + tags.size());
            newTags.addAll(currPredefTags);
            newTags.addAll(tags);
            this.setOccTags(newTags);
        } else if (!currPredefTags.isEmpty()) {
            if (currPredefTags.size() != currTags.size()) {
                this.setOccTags(new LinkedHashSet<String>(currPredefTags));
            }
        } else {
            this.setOccTags(tags);
        }
    }

    public static enum ConflictType {
        EDGE,
        NON_MANIFOLD;

    }
}

