/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.UUID;
import merlin.Intl;
import merlin.MerlinPrefs;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.gui.guiUtil;
import org.json.simple.JSONObject;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;

public class AvatarImportUtil {
    public static String importAvatarModel(Component parent, ResourceAvatar.Type type) {
        String importedModelName;
        guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.AVATAR_IMPORT_DIR_PREF), null, (Boolean)true, (Boolean)true, (Boolean)false, type.fileFilters);
        File srcFile = chooser.showOpenDialog();
        if (srcFile == null) {
            return null;
        }
        MerlinPrefs.set(MerlinPrefs.AVATAR_IMPORT_DIR_PREF, srcFile.getParent());
        try {
            String toCopyfileName;
            System.out.println("importing " + srcFile.getAbsolutePath());
            String fileNameWithExtension = srcFile.getName();
            importedModelName = toCopyfileName = FilenameManager.splitFilename(fileNameWithExtension)[0];
            File importDir = ResourceAvatar.getAvatarDirs(true, type).get(0);
            File newFileDir = new File(importDir, toCopyfileName);
            File targetFile = new File(newFileDir, fileNameWithExtension);
            AvatarImportUtil.copyAvatarFile(newFileDir, srcFile, targetFile);
            AvatarImportUtil.writeAvatarFile(fileNameWithExtension, newFileDir, toCopyfileName, type);
            AvatarImportUtil.addPreviewImage(type.defPreviewImg, newFileDir);
            String htmlFriendlyPath = "file:///" + newFileDir.getCanonicalPath();
            String htmlStr = String.format("<p>Files copied to local <a href=%s>directory.</a></p>", htmlFriendlyPath);
            guiUtil.showHTMLMessageDialog(parent, Intl.intl("Import Successful"), htmlStr);
        }
        catch (IOException e) {
            guiUtil.showError(parent, Intl.intl("An error occurred while importing the model."), thunderheadeng.Intl.intl("Import Error"), (Throwable)e);
            return null;
        }
        return importedModelName;
    }

    private static void copyAvatarFile(File newDir, File src, File target) throws IOException {
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        CopyFile.copy(src, target);
    }

    private static void writeAvatarFile(String avatarName, File targetDir, String targetName, ResourceAvatar.Type type) throws IOException {
        JSONObject jobj = AvatarImportUtil.toJson(avatarName, type);
        File newAvatarTarget = new File(targetDir, targetName + ".json");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newAvatarTarget), "utf-8"));){
            jobj.writeJSONString(writer);
        }
    }

    private static JSONObject toJson(String fileNameWithExt, ResourceAvatar.Type type) {
        JSONObject jroot = new JSONObject();
        JSONObject jmesh = new JSONObject();
        jmesh.put("path", fileNameWithExt);
        jmesh.put("uuid", UUID.randomUUID().toString());
        jroot.put("mesh", jmesh);
        return jroot;
    }

    private static void addPreviewImage(File defaultPreview, File targetDir) throws IOException {
        File targetFile = new File(targetDir, "preview.png");
        CopyFile.copy(defaultPreview, targetFile);
    }
}

