/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.camera;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.camera.ICameraObj;
import merlin.data.camera.IViewObj;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import org.jscience.physics.units.NonSI;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class Camera
extends NamedMerlinObj
implements IPropertySet,
ICameraObj,
IRestorable,
IMerlinGeomSrc,
IViewObj {
    static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<Type> PROP_TYPE = new IPropertySet.Prop<Type>(1, Type.PERSPECTIVE);
    public static final IPropertySet.Prop<Point3d> PROP_LOC = new IPropertySet.Prop<Point3d>(2, new Point3d(0.0, 0.0, 1.0));
    public static final IPropertySet.Prop<Point3d> PROP_REF = new IPropertySet.Prop<Point3d>(3, new Point3d(0.0, 0.0, 0.0));
    public static final IPropertySet.Prop<Vector3d> PROP_UP = new IPropertySet.Prop<Vector3d>(4, new Vector3d(0.0, 1.0, 0.0));
    public static final IPropertySet.Prop<double[]> PROP_CLIP = new IPropertySet.Prop<double[]>(5, new double[]{0.1, Double.POSITIVE_INFINITY});
    public static final IPropertySet.Prop<Double> PROP_ZOOM = new IPropertySet.Prop<Double>(6, 1.0);
    public static final IPropertySet.Prop<Point2d> PROP_ZOOM_LOC = new IPropertySet.Prop<Point2d>(7, new Point2d(0.0, 0.0));
    public static final IPropertySet.Prop<Double> PROP_FOV = new IPropertySet.Prop<Double>(8, UnitDouble.convert(65.0, NonSI.DEGREE_ANGLE, Geometry.ANGLE_UNIT));
    public static final IPropertySet.Prop<Boolean> PROP_SECURITY = new IPropertySet.Prop<Boolean>(9, Boolean.FALSE);
    public static final IPropertySet.Prop<PTZSpec> PROP_PAN_INFO = new IPropertySet.Prop<PTZSpec>(10, new PTZSpec(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.7853981633974483));
    public static final IPropertySet.Prop<PTZSpec> PROP_TILT_INFO = new IPropertySet.Prop<PTZSpec>(11, new PTZSpec(-1.5707963267948966, 0.0, 0.7853981633974483));
    public static final IPropertySet.Prop<PTZSpec> PROP_ZOOM_INFO = new IPropertySet.Prop<PTZSpec>(12, new PTZSpec(1.0, Double.POSITIVE_INFINITY, 2.0));
    public static final IPropertySet.Prop<Vector3d> PROP_PTZ_ORIENT = new IPropertySet.Prop<Vector3d>(13, GeomConstants.VEC3D_ZPOS);
    public static final IPropertySet.Prop<CameraRecord> PROP_CAMDATA = new IPropertySet.Prop<CameraRecord>(14, new CameraRecord(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 1.0, new Point2d(0.0, 0.0), 0.1, Double.POSITIVE_INFINITY, new PerspectiveCamera.FrustumRecord(Math.toRadians(65.0))));
    public static final Set<IPropertySet.Prop<? extends Serializable>> LOCAL_PROPS = Sets.fromArrayLHS(PROP_CAMDATA, PROP_SECURITY, PROP_PAN_INFO, PROP_TILT_INFO, PROP_ZOOM_INFO, PROP_PTZ_ORIENT);
    public static final Set<Object> ALL_PROPS = Sets.appendLHS(LOCAL_PROPS, NAME, MerlinData.VISIBILITY);
    private PropertySet d_props = new PropertySet();
    private boolean d_visible = true;

    public Camera(String name) {
        super(name);
        this.initDefaults();
    }

    private void initDefaults() {
        for (IPropertySet.Prop<? extends Serializable> prop : LOCAL_PROPS) {
            if (this.d_props.isDefined(prop)) continue;
            this.d_props.set(prop, prop.defVal);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        IPropertySet.Prop[] legProps;
        in.defaultReadObject();
        Map<Object, Object> map = this.d_props.getMap();
        for (IPropertySet.Prop prop : legProps = new IPropertySet.Prop[]{PROP_PAN_INFO, PROP_TILT_INFO, PROP_ZOOM_INFO}) {
            Object val = map.get(prop.key);
            if (!(val instanceof double[])) continue;
            double[] dval = (double[])val;
            PTZSpec spec = new PTZSpec(dval[0], dval[1], ((PTZSpec)prop.defVal).maxSpeed);
            map.put(prop.key, spec);
        }
        if (this.d_props.isDefined(PROP_LOC)) {
            IPropertySet.Prop[] legCamdataProps;
            CameraRecord.IFrustumRecord frustum = this.get(PROP_TYPE) == Type.PERSPECTIVE ? new PerspectiveCamera.FrustumRecord(this.get(PROP_FOV)) : new OrthoCamera.FrustumRecord(this.get(PROP_FOV));
            CameraRecord cr = new CameraRecord(this.get(PROP_LOC), this.get(PROP_REF), this.get(PROP_UP), this.get(PROP_ZOOM), this.get(PROP_ZOOM_LOC), this.get(PROP_CLIP)[0], this.get(PROP_CLIP)[1], frustum);
            this.set(PROP_CAMDATA, cr);
            for (IPropertySet.Prop legProp : legCamdataProps = new IPropertySet.Prop[]{PROP_LOC, PROP_REF, PROP_UP, PROP_CLIP, PROP_ZOOM, PROP_ZOOM_LOC, PROP_TYPE, PROP_FOV}) {
                this.d_props.remove(legProp);
            }
        }
        this.initDefaults();
    }

    @Override
    public Camera clone() {
        Camera clone = (Camera)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof Camera)) {
            return;
        }
        this.pauseUpdates();
        Camera c = (Camera)obj;
        this.setName(c.getName());
        this.d_props = c.d_props.clone();
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (!Objects.equals(val, this.get(prop))) {
            this.d_props.set(prop, val);
            this.changedEvt(prop);
        }
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        if (this.d_props.isDefined(prop)) {
            this.d_props.remove(prop);
            this.changedEvt(prop);
        }
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return this.d_props.isDefined(prop);
    }

    @Override
    public void setCameraState(CameraRecord cs) {
        this.set(PROP_CAMDATA, cs);
    }

    @Override
    public CameraRecord getCameraState() {
        return this.get(PROP_CAMDATA);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return ALL_PROPS;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (LOCAL_PROPS.contains(property)) {
            this.set((IPropertySet.Prop)property, value);
        } else if (property == NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (LOCAL_PROPS.contains(property)) {
            return this.get((IPropertySet.Prop)property);
        }
        if (property == NAME) {
            return this.getName();
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode p = this.getGeom();
        IPrimProps.Vertex pprops = new IPrimProps.Vertex(Color.PINK, 10.0);
        return new DisplayGeom(p, (IPrimProps)pprops);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(MerlinData.VISIBILITY);
    }

    public static class PTZSpec
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final double rangeMin;
        public final double rangeMax;
        public final double maxSpeed;

        public PTZSpec(double rangeMin, double rangeMax, double maxSpeed) {
            this.rangeMin = rangeMin;
            this.rangeMax = rangeMax;
            this.maxSpeed = maxSpeed;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof PTZSpec && ((PTZSpec)obj).rangeMin == this.rangeMin && ((PTZSpec)obj).rangeMax == this.rangeMax && ((PTZSpec)obj).maxSpeed == this.maxSpeed;
        }

        public int hashCode() {
            return 0xFE2323A9 ^ theUtil.hashCode(this.rangeMin) + theUtil.hashCode(this.rangeMax) + theUtil.hashCode(this.maxSpeed);
        }
    }

    public static enum Type {
        ORTHO,
        PERSPECTIVE;

    }
}

