/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.NamedMerlinObj;
import merlin.data.animation.AAnimationClip;
import merlin.data.animation.AnimType;
import merlin.data.animation.Animation;
import merlin.data.animation.JsonAnimationParser;
import merlin.data.animation.JsonAnimationWriter;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.io.CompareFiles;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theTimer;

public class AnimationDB
extends Composite<Animation> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AnimationDB.class.getName());
    public static final String ANIM_DIR_NAME = "models/anims";
    public static final String CLIP_DIR_NAME = "clips";
    public static final String MESH_DIR_NAME = "meshes";
    private static final String INFO_EXTN = "json";
    @SkipDep
    private final transient File d_dataDir;
    private static final Predicate<ICompElement> s_filter = new TypeFilter<ICompElement>(Animation.class);

    public AnimationDB(String name) {
        this(null, name);
    }

    public AnimationDB(File dataDir, String name) {
        super(name);
        this.d_dataDir = dataDir;
    }

    public Path getAnimDir() {
        Path animDir = this.d_dataDir.toPath().resolve(ANIM_DIR_NAME);
        try {
            if (!Files.isDirectory(animDir, new LinkOption[0])) {
                Files.deleteIfExists(animDir);
                Files.createDirectories(animDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            TeciLogging.log(LOGGER, String.format("Error creating anim dir: %s", animDir), (Throwable)e);
        }
        return animDir;
    }

    public Path getClipDir() {
        Path clipDir = this.getAnimDir().resolve(CLIP_DIR_NAME);
        try {
            if (!Files.isDirectory(clipDir, new LinkOption[0])) {
                Files.deleteIfExists(clipDir);
                Files.createDirectory(clipDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            TeciLogging.log(LOGGER, String.format("Error creating clip dir: %s", clipDir), (Throwable)e);
        }
        return clipDir;
    }

    public Path getMeshDir() {
        Path meshDir = this.getAnimDir().resolve(MESH_DIR_NAME);
        try {
            if (!Files.isDirectory(meshDir, new LinkOption[0])) {
                Files.deleteIfExists(meshDir);
                Files.createDirectory(meshDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            TeciLogging.log(LOGGER, String.format("Error creating mesh dir: %s", meshDir), (Throwable)e);
        }
        return meshDir;
    }

    private File getDBInfoFile(Animation anim) {
        return this.getAnimDir().resolve(anim.getName() + ".json").toFile();
    }

    public void scan() {
        LOGGER.log(Level.INFO, "Scanning animations...");
        theTimer timer = new theTimer();
        File[] animFiles = this.getAnimDir().toFile().listFiles(AnimationDB.getPropFilenameFilter());
        if (animFiles != null) {
            for (File animFile : animFiles) {
                try {
                    Animation anim = this.loadFromDB(animFile);
                    if (anim.getType() == AnimType.PIVOT) continue;
                    this.add(anim, false);
                }
                catch (Throwable e) {
                    TeciLogging.log(LOGGER, e);
                }
            }
        }
        LOGGER.log(Level.INFO, String.format("done (%g sec)%n", timer.curr()));
    }

    public static FilenameFilter getPropFilenameFilter() {
        ExampleFileFilter fileFilter = new ExampleFileFilter(INFO_EXTN);
        return (dir, name) -> {
            File file = new File(dir, name);
            return file.isFile() && fileFilter.accept(file);
        };
    }

    public Animation loadFromDB(File infoFile) throws IOException {
        if (!infoFile.exists() || !infoFile.isFile()) {
            return null;
        }
        Animation anim = JsonAnimationParser.parseAnimationFile(infoFile);
        Path animDir = this.getAnimDir();
        for (AAnimationClip clip : anim.getClips()) {
            clip.setPath(AnimationDB.getNormalizedPath(animDir, clip.getPath()).toString());
            clip.setRetargetSource(AnimationDB.getNormalizedPath(animDir, clip.getRetargetSource()).toString());
        }
        return anim;
    }

    public void saveToDB(Animation anim, boolean newName) throws IOException {
        if (newName) {
            anim.setName(this.getAvailableAnimationName(anim));
        }
        File infoFile = this.getDBInfoFile(anim);
        Path animDir = this.getAnimDir();
        try {
            if (infoFile.exists() && infoFile.isFile()) {
                Animation oldAnim = this.loadFromDB(infoFile);
                Set<Path> oldFiles = oldAnim.getClips().stream().flatMap(clip -> Stream.of(AnimationDB.getNormalizedPath(animDir, clip.getPath()), AnimationDB.getNormalizedPath(animDir, clip.getRetargetSource()))).collect(Collectors.toSet());
                this.deleteIfDereferenced(oldFiles, null);
            }
        }
        catch (Exception e) {
            TeciLogging.log(LOGGER, String.format("Error loading old anim file: %s", infoFile), (Throwable)e);
        }
        Set<Path> newClips = anim.getClips().stream().map(clip -> AnimationDB.getNormalizedPath(animDir, clip.getPath())).collect(Collectors.toSet());
        Set<Path> newMeshes = anim.getClips().stream().map(clip -> AnimationDB.getNormalizedPath(animDir, clip.getRetargetSource())).collect(Collectors.toSet());
        Map<Path, Path> clipPaths = AnimationDB.copyToDirectory(this.getClipDir(), animDir, newClips);
        Map<Path, Path> meshPaths = AnimationDB.copyToDirectory(this.getMeshDir(), animDir, newMeshes);
        for (AAnimationClip clip2 : anim.getClips()) {
            clip2.setPath(clipPaths.getOrDefault(AnimationDB.getNormalizedPath(animDir, clip2.getPath()), Paths.get("", new String[0])).toString());
            clip2.setRetargetSource(meshPaths.getOrDefault(AnimationDB.getNormalizedPath(animDir, clip2.getRetargetSource()), Paths.get("", new String[0])).toString());
        }
        JsonAnimationWriter.writeAnimationFile(anim, infoFile);
        for (AAnimationClip clip2 : anim.getClips()) {
            clip2.setPath(AnimationDB.getNormalizedPath(animDir, clip2.getPath()).toString());
            clip2.setRetargetSource(AnimationDB.getNormalizedPath(animDir, clip2.getRetargetSource()).toString());
        }
    }

    public void removeFromDB(Animation anim) throws IOException {
        Path animDir = this.getAnimDir();
        this.deleteIfDereferenced(anim.getClips().stream().flatMap(clip -> Stream.of(AnimationDB.getNormalizedPath(animDir, clip.getPath()), AnimationDB.getNormalizedPath(animDir, clip.getRetargetSource()))).collect(Collectors.toSet()), anim);
        File infoFile = this.getDBInfoFile(anim);
        if (!infoFile.delete()) {
            throw new IOException();
        }
    }

    private static Map<Path, Path> copyToDirectory(Path targetDir, Path relativeDir, Collection<Path> files) throws IOException {
        HashMap<Path, Path> relativePaths = new HashMap<Path, Path>();
        for (Path file : files) {
            if (file == null || file.toString().isEmpty()) continue;
            if (Files.isSameFile(file.getParent(), targetDir)) {
                relativePaths.put(file, relativeDir.relativize(file));
                continue;
            }
            Path targetDirFile = targetDir.resolve(file.getFileName());
            if (Files.exists(targetDirFile, new LinkOption[0]) && CompareFiles.equalsFiles(targetDirFile, file)) {
                relativePaths.put(file, targetDir.resolve(file.getFileName()));
                continue;
            }
            Path availablePath = targetDir.resolve(FilenameManager.getAvailableFilename(targetDir, file.getFileName().toString(), "untitled"));
            Files.copy(file, availablePath, new CopyOption[0]);
            relativePaths.put(file, relativeDir.relativize(availablePath));
        }
        return relativePaths;
    }

    private void deleteIfDereferenced(Collection<Path> removePaths, Animation ignore) throws IOException {
        Path animDir = this.getAnimDir();
        HashSet<Path> toRemove = new HashSet<Path>(removePaths);
        for (Animation anim : this.getMembers(Animation.class)) {
            if (Objects.equals(anim, ignore)) continue;
            for (AAnimationClip clip : anim.getClips()) {
                toRemove.remove(AnimationDB.getNormalizedPath(animDir, clip.getPath()));
                toRemove.remove(AnimationDB.getNormalizedPath(animDir, clip.getRetargetSource()));
            }
        }
        for (Path path : toRemove) {
            if (path == null || path.toString().isEmpty()) continue;
            Files.deleteIfExists(path);
        }
    }

    private static Path getNormalizedPath(Path relativeDir, String strPath) {
        if (strPath == null || strPath.isEmpty()) {
            return Paths.get("", new String[0]);
        }
        Path path = Paths.get(strPath, new String[0]);
        if (path.isAbsolute()) {
            return path.toAbsolutePath().normalize();
        }
        return relativeDir.resolve(path).toAbsolutePath().normalize();
    }

    private String getAvailableAnimationName(Animation anim) {
        Set usedNames = this.getMembers(Animation.class).stream().filter(a -> a != anim).map(NamedMerlinObj::getName).collect(Collectors.toSet());
        Path animDir = this.getAnimDir();
        Predicate<String> available = name -> !usedNames.contains(name) && Files.notExists(animDir.resolve(name + ".json"), new LinkOption[0]);
        String filename = FilenameManager.getAvailableFilename(anim.getName(), available, "untitled");
        return FilenameManager.splitFilename(filename)[0];
    }

    @Override
    protected boolean getSerializeMembersEnabled() {
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void loadFrom(AnimationDB db) {
        this.reset();
        this.setResultsId(db.getResultsId());
        this.addAll(db.getMembers(Animation.class));
    }

    @Override
    public void reset() {
        this.pauseUpdates();
        this.generateResultsIds();
        this.resumeUpdates();
    }

    @Override
    public void add(ICompElement anim) {
        if (!(anim instanceof Animation)) {
            return;
        }
        try {
            this.add((Animation)anim, true);
        }
        catch (IOException e) {
            TeciLogging.log(LOGGER, e);
        }
    }

    public void add(Animation anim, boolean createFiles) throws IOException {
        if (anim == null) {
            return;
        }
        super.add(anim);
        if (createFiles) {
            this.saveToDB(anim, true);
        }
    }

    @Override
    public boolean remove(ICompElement obj) {
        if (!(obj instanceof Animation)) {
            return false;
        }
        Animation anim = (Animation)obj;
        return this.remove(anim, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Animation anim, boolean deleteFiles) {
        this.pauseUpdates();
        try {
            if (!super.remove(anim)) {
                boolean bl = false;
                return bl;
            }
            if (deleteFiles) {
                this.removeFromDB(anim);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            TeciLogging.log(LOGGER, String.format("Error removing animation: %s", anim != null ? anim.getName() : "null"), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.resumeUpdates();
        }
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return null;
    }
}

