/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.animation;

import merlin.Intl;
import merlin.gui.guiUtil;

public enum AnimRetargetMode {
    NONE("none", Intl.intl("None"), Intl.intl("The animation will not be retargeted.\nIn this mode, the animation will only play on the exact avatar it was created for."), true, false),
    SAME("same", Intl.intl("Same"), Intl.intl("The animation will be retargeted only to avatars with identical skeletal structure\nto the avatar this animation was created for."), true, false),
    SELF("self", Intl.intl("Self"), Intl.intl("The animation can be retargeted to any avatar.\nThe original skeletal structure must be stored in the animation file."), false, false),
    OTHER("other", Intl.intl("Other"), guiUtil.encodeToHtmlLabel(Intl.intl("The animation can be retargeted to any avatar.\nThe original skeletal structure is stored in <b>Retarget Source</b>.")), false, true);

    public final String jsonName;
    public final String displayName;
    public final String description;
    public final boolean manuallyCreated;
    public final boolean requiresExternalBasePoseSource;

    private AnimRetargetMode(String jsonName, String displayName, String description, boolean manuallyCreated, boolean requiresExternalBasePoseSource) {
        this.jsonName = jsonName;
        this.displayName = displayName;
        this.description = description;
        this.manuallyCreated = manuallyCreated;
        this.requiresExternalBasePoseSource = requiresExternalBasePoseSource;
    }

    public String toString() {
        return this.displayName;
    }
}

