/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinPrefs;
import merlin.builders.ABehaviorActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.GotoElevators;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoOccTarget;
import merlin.data.egress.scripting.GotoQueue;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.queues.IGotoQueueDestination;
import merlin.geom.Geometry;
import merlin.gui.guiUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Predicates;

public class GotoActionBuilder
extends ABehaviorActionBuilder {
    public static final Object DEST_CHANGED = "GotoActionBuilder.DEST_CHANGED";
    public static final Object ARRIVE_RADIUS_CHANGED = "GotoActionBuilder.ARRIVE_RADIUS_CHANGED";
    private Type d_type;
    private IEgressOccupiable d_room;
    private Vector3d d_roomNormal;
    private UnitPoint3D d_loc;
    private UnitDouble d_arriveRad;
    private Set<Elevator> d_elevators;
    private Floor d_targetFloor;
    private Set<IEgressOccupiable> d_rooms;
    private final Predicate<? super IEgressOccupiable> d_roomsFilter;
    private Set<OccTarget> d_occTargets;
    private Set<EgressDoor> d_exits;
    private Set<IGotoQueueDestination> d_queues;

    public GotoActionBuilder(MerlinData md, Type initialType) {
        this(md, initialType, Predicates.alwaysTrue());
    }

    public GotoActionBuilder(MerlinData md, Type initialType, Predicate<? super IEgressOccupiable> roomsFilter) {
        super(md);
        this.d_type = initialType;
        this.d_room = null;
        this.d_roomNormal = GeomConstants.VEC3D_ZPOS;
        this.d_loc = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
        this.d_arriveRad = new UnitDouble(1.5, SI.METER);
        this.d_elevators = Collections.EMPTY_SET;
        this.d_targetFloor = null;
        this.d_rooms = Collections.EMPTY_SET;
        this.d_occTargets = Collections.emptySet();
        this.d_roomsFilter = roomsFilter;
        this.d_exits = Collections.EMPTY_SET;
        this.d_queues = Collections.EMPTY_SET;
    }

    public void setType(Type type) {
        if (type == this.d_type) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_type = type;
        this.pause();
        this.firePropChanged(DEST_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public void setElevatorDest(Set<Elevator> elevators) {
        if (this.d_type == Type.ELEVATORS && elevators.equals(this.d_elevators)) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_type = Type.ELEVATORS;
        this.d_elevators = elevators;
        this.pause();
        this.firePropChanged(DEST_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public void setFloorDest(Floor floor) {
        if (this.d_type == Type.ELEVATORS && this.d_targetFloor == floor) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_type = Type.ELEVATORS;
        this.d_targetFloor = floor;
        this.pause();
        this.firePropChanged(DEST_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public void setQueueDest(Set<IGotoQueueDestination> queues) {
        if (this.d_type == Type.QUEUES && queues.equals(this.d_queues)) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_type = Type.QUEUES;
        this.d_queues = queues;
        this.pause();
        this.firePropChanged(DEST_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public Predicate<? super IEgressOccupiable> getRoomsFilter() {
        return this.d_roomsFilter;
    }

    public void setRoomsDest(Set<IEgressOccupiable> rooms) {
        if (this.d_type == Type.ROOMS && rooms.equals(this.d_rooms)) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_type = Type.ROOMS;
        this.d_rooms = rooms;
        this.pause();
        this.firePropChanged(DEST_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public void setOccTargetsDest(Set<OccTarget> targets) {
        if (this.d_type == Type.OCC_TARGETS && targets.equals(this.d_occTargets)) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_type = Type.OCC_TARGETS;
        this.d_occTargets = targets;
        this.pause();
        this.firePropChanged(DEST_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public void setExitsDest(Set<EgressDoor> exits) {
        if (this.d_type == Type.EXITS && exits.equals(this.d_exits)) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_type = Type.EXITS;
        this.d_exits = exits;
        this.pause();
        this.firePropChanged(DEST_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public void setWaypointDest(IEgressOccupiable room, Vector3d roomNorm, UnitPoint3D loc) {
        if (this.d_type == Type.WAYPOINT && this.d_room == room && this.d_loc.equals(loc) && this.d_roomNormal.equals(roomNorm)) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        this.d_type = Type.WAYPOINT;
        this.d_room = room;
        this.d_loc = loc;
        this.d_roomNormal = roomNorm;
        this.pause();
        this.firePropChanged(DEST_CHANGED);
        this.firePropChanged(VALIDITY);
        this.resume();
        this.release();
    }

    public Type getType() {
        return this.d_type;
    }

    public Set<Elevator> getElevators() {
        return this.d_elevators;
    }

    public Floor getTargetFloor() {
        return this.d_targetFloor;
    }

    public Set<IEgressOccupiable> getRooms() {
        return this.d_rooms;
    }

    public Set<OccTarget> getOccTargets() {
        return this.d_occTargets;
    }

    public Set<EgressDoor> getExits() {
        return this.d_exits;
    }

    public UnitPoint3D getDestLoc() {
        return this.d_loc;
    }

    public Vector3d getRoomNormal() {
        return this.d_roomNormal;
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    public Set<IGotoQueueDestination> getQueues() {
        return this.d_queues;
    }

    public void setArriveRadius(UnitDouble rad) {
        if (!this.lock()) {
            return;
        }
        this.d_arriveRad = rad;
        this.firePropChanged(ARRIVE_RADIUS_CHANGED);
        this.release();
    }

    public UnitDouble getArriveRadius() {
        return this.d_arriveRad;
    }

    @Override
    public boolean isValid() {
        switch (this.d_type) {
            case ELEVATORS: {
                return true;
            }
            case QUEUES: {
                return !this.d_queues.isEmpty();
            }
            case ROOMS: {
                return GotoRooms.getAnyAllowed(this.d_roomsFilter) || !this.d_rooms.isEmpty();
            }
            case WAYPOINT: {
                return this.d_room != null;
            }
            case EXITS: {
                return true;
            }
            case OCC_TARGETS: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean validate(Component c) {
        switch (this.d_type) {
            case OCC_TARGETS: {
                if (MerlinPrefs.get(MerlinPrefs.SHOW_OCCTARGET_RESERVATION_MSG).booleanValue()) {
                    guiCheckBox doNotShowAgain = new guiCheckBox(Intl.intl("Do not show this message again"));
                    guiPanel msg = new guiPanel();
                    GridBagHelper gb = new GridBagHelper(msg);
                    gb.addRow("<html>" + Intl.intl("Occupants will hold a reservation for their chosen target until the next<br><b>Abandon Occ Targets</b> action."));
                    gb.addRow(doNotShowAgain, 0);
                    gb.finalizeRows();
                    JOptionPane.showMessageDialog(guiUtil.getWindow(c), msg, Intl.intl("Target Reservations"), 1);
                    if (doNotShowAgain.isSelected()) {
                        MerlinPrefs.set(MerlinPrefs.SHOW_OCCTARGET_RESERVATION_MSG, false);
                    }
                }
                return true;
            }
        }
        return true;
    }

    @Override
    protected IBehaviorAction create() {
        switch (this.d_type) {
            case WAYPOINT: {
                return new GotoWaypoint(null, this.d_loc.getPoint3dValue(Geometry.LENGTH_UNIT), this.d_room, this.d_roomNormal, this.d_arriveRad);
            }
            case ELEVATORS: {
                return new GotoElevators(this.d_elevators, this.d_targetFloor);
            }
            case QUEUES: {
                return new GotoQueue(this.d_queues);
            }
            case ROOMS: {
                return new GotoRooms(this.d_roomsFilter, this.d_rooms);
            }
            case EXITS: {
                return new GotoExits(this.d_exits);
            }
            case OCC_TARGETS: {
                GotoOccTarget gol = new GotoOccTarget(Predicates.alwaysTrue(), this.d_occTargets);
                gol.set(GotoOccTarget.PROP_DIST_PREF, this.get(GotoOccTarget.PROP_DIST_PREF));
                gol.set(GotoOccTarget.PROP_PRIORITY_PREF, this.get(GotoOccTarget.PROP_PRIORITY_PREF));
                return gol;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public void reset() {
        this.d_rooms = Collections.EMPTY_SET;
        this.d_occTargets = Collections.EMPTY_SET;
        this.d_elevators = Collections.EMPTY_SET;
        this.d_targetFloor = null;
        this.d_exits = Collections.EMPTY_SET;
        this.d_queues = Collections.EMPTY_SET;
    }

    public static enum Type {
        WAYPOINT,
        ELEVATORS,
        ROOMS,
        EXITS,
        QUEUES,
        OCC_TARGETS;

    }
}

