/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddOccupants;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccupancySpec;
import merlin.data.egress.scripting.Behavior;
import merlin.mv.tools.NewAgentRegionTool;
import merlin.util.MerlinProps;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class AgentRegionDropper
extends MerlinProps
implements IPropertySet,
IEventObserver {
    public static final Object COUNT_CHANGED = "AgentRectDropper.COUNT_CHANGED";
    public static final Object SPACING_CHANGED = "AgentRectDropper.SPACING_CHANGED";
    public static final Object PROFILE_CHANGED = "AgentRectDropper.PROFILE_CHANGED";
    public static final Object BEHAVIOR_CHANGED = "AgentRectDropper.BEHAVIOR_CHANGED";
    private final MerlinData d_data;
    private OccupancySpec d_occupancy;
    private UnitDouble d_searchTimeout = new UnitDouble(0.125, SI.SECOND);
    private int d_maxNumTries = 200;
    private IUrn<OccProfile> d_profileDist;
    private IUrn<Behavior> d_behaviorDist;
    private IOccCount d_occType;
    private final NameGenerator d_nameGenerator = new NameGenerator(Intl.intl("AddToRectTool") + "_");

    public AgentRegionDropper(MerlinData md, NewAgentRegionTool newAgentRectTool) {
        this.d_data = md;
        this.d_occupancy = md.getDefaultOccupancySpec();
        this.d_occupancy.setOccCount(new ConstOccCount(10));
        this.d_occupancy.setSpacing(1);
        this.d_occType = new ConstOccCount(10);
        OccProfile defProf = md.profiles.getMembers(OccProfile.class).iterator().next();
        this.d_profileDist = new Urn<OccProfile>(defProf);
        Behavior defBehavior = md.behaviors.getMembers(Behavior.class).iterator().next();
        this.d_behaviorDist = new Urn<Behavior>(defBehavior);
        this.d_data.getEvents().addObserver(this);
    }

    @Override
    public void update(Events events) {
        this.d_profileDist = AgentRegionDropper.updateDist(events, this.d_profileDist, OccProfile.class, this.d_data.profiles.getDeepMembers(OccProfile.class));
        this.d_behaviorDist = AgentRegionDropper.updateDist(events, this.d_behaviorDist, Behavior.class, this.d_data.behaviors.getDeepMembers(Behavior.class));
    }

    private static <T> IUrn<T> updateDist(Events events, IUrn<T> dval, Class<T> clazz, Collection<T> availObjs) {
        double total;
        Map<T, Double> dist = dval.getWeights();
        if (dist.keySet().removeAll(events.getEvents(clazz, new Class[0]).getRemovedObjs()) && theUtil.lt(total = AgentRegionDropper.sum(dist.values()), 1.0, 1.0E-6)) {
            assert (!availObjs.isEmpty());
            T firstObj = availObjs.iterator().next();
            double fracForFirst = dist.containsKey(firstObj) ? dist.get(firstObj) : 0.0;
            double remain = 1.0 - (total -= fracForFirst);
            dist.put(firstObj, remain);
        }
        return UrnUtil.newUrn(dist);
    }

    private static double sum(Collection<Double> values) {
        double total = 0.0;
        for (Double frac : values) {
            total += frac.doubleValue();
        }
        return total;
    }

    public IUrn<OccProfile> getProfileDist() {
        return this.d_profileDist;
    }

    public void setProfileDist(IUrn<OccProfile> oProf) {
        if (!this.lock()) {
            return;
        }
        this.d_profileDist = oProf;
        this.firePropChanged(PROFILE_CHANGED);
        this.release();
    }

    public IUrn<Behavior> getBehaviorDist() {
        return this.d_behaviorDist;
    }

    public void setBehaviorDist(IUrn<Behavior> behavior) {
        if (!this.lock()) {
            return;
        }
        this.d_behaviorDist = behavior;
        this.firePropChanged(BEHAVIOR_CHANGED);
        this.release();
    }

    public IOccCount getOccCount() {
        return this.d_occType;
    }

    public void setOccCount(IOccCount count) {
        if (!this.lock()) {
            return;
        }
        this.d_occType = count;
        this.firePropChanged(COUNT_CHANGED);
        this.release();
    }

    public int getSpacing() {
        return this.d_occupancy.getSpacing();
    }

    public void setSpacing(int spacing) {
        if (!this.lock()) {
            return;
        }
        this.d_occupancy.setSpacing(spacing);
        this.firePropChanged(SPACING_CHANGED);
        this.release();
    }

    private void fixOccSpec() {
        this.d_occupancy.setOccCount(this.d_occType);
    }

    public void create(Component c, final Collection<Model> pgeoms) {
        this.fixOccSpec();
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                String newGroupName = AgentRegionDropper.this.d_nameGenerator.generateName();
                AgentRegionDropper.this.d_nameGenerator.registerName(newGroupName);
                Random rgen = new Random();
                AddOccupants.addOccupants(app, md, rgen, AgentRegionDropper.this.d_searchTimeout, AgentRegionDropper.this.d_maxNumTries, pgeoms, AgentRegionDropper.this.d_occupancy, AgentRegionDropper.this.d_profileDist, AgentRegionDropper.this.d_behaviorDist, newGroupName);
            }
        };
        UIHook.run(c, "AgentRectDropper.createRect", op, 4);
    }
}

