/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.importgeom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.logging.Logger;
import javafx.stage.FileChooser;
import merlin.MerlinApp;
import merlin.actions.CancelledException;
import merlin.actions.importgeom.IImporter;
import merlin.actions.importgeom.PyroGeomConverter;
import merlin.actions.importgeom.PyroImporter;
import merlin.data.MerlinData;
import pyroloader.IPyroDataStore;
import pyroloader.PyroLoadOptions;
import pyroloader.PyroLoader;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.Events;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IPropertySet;

public class ImportPSM
implements IImporter {
    private static final Logger LOGGER = Logger.getLogger(ImportPSM.class.getName());
    private static final IPropertySet.Prop<String> PYRO_LOADER = new IPropertySet.Prop<String>("pyroloader", "pyrosim-lite/pyrosim.jar");

    @Override
    public FileChooser.ExtensionFilter[] getFileFilters() {
        return new FileChooser.ExtensionFilter[]{FileFilters.EXT_FILTER_FDS4, FileFilters.EXT_FILTER_FDS6, FileFilters.EXT_FILTER_PYROSIM};
    }

    @Override
    public void initDefaultOptions(MerlinData md, String ext, IPropertySet options) {
    }

    @Override
    public boolean getAllowNewFile(MerlinData md, String ext, IPropertySet options) {
        return true;
    }

    @Override
    public void update(MerlinData md, Events events, IPropertySet options) {
    }

    @Override
    public AWizardCard<IPropertySet> getCard(IPropertySet options) {
        return null;
    }

    @Override
    public void cleanup(IPropertySet options) {
    }

    @Override
    public IImporter.Result read(MerlinApp app, String fn, IPropertySet options) throws IOException, CancelledException {
        try {
            String ext = FilenameManager.getExtension(fn);
            if (ext.equalsIgnoreCase("data") || ext.equalsIgnoreCase("fds")) {
                return ImportPSM.importFDS(app, fn, options);
            }
            if (ext.equalsIgnoreCase("psm")) {
                return ImportPSM.importPSM(app, fn, options);
            }
            return IImporter.Result.EMPTY;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    private static IImporter.Result importPSM(MerlinApp app, String fn, IPropertySet ioptions) throws Throwable, CancelledException {
        System.out.println("importing PSM file: " + fn);
        try {
            PyroLoader loader = ImportPSM.getPyroLoader(app);
            IPyroDataStore data = loader.loadPyroSim(MerlinApp.getApp().getActiveFrame(), fn, ImportPSM.getPyroLoadOptions());
            return PyroImporter.importPyroData(app, fn, ioptions, data);
        }
        catch (CancellationException e) {
            throw CancelledException.INSTANCE;
        }
    }

    private static IImporter.Result importFDS(MerlinApp app, String fn, IPropertySet ioptions) throws Throwable, CancelledException {
        System.out.println("importing FDS file: " + fn);
        try {
            PyroLoader loader = ImportPSM.getPyroLoader(app);
            IPyroDataStore data = loader.loadFDS(MerlinApp.getApp().getActiveFrame(), fn, ImportPSM.getPyroLoadOptions());
            return PyroImporter.importPyroData(app, fn, ioptions, data);
        }
        catch (CancellationException e) {
            throw CancelledException.INSTANCE;
        }
    }

    private static PyroLoader getPyroLoader(MerlinApp app) {
        String loaderName = System.getProperty(ImportPSM.PYRO_LOADER.key.toString(), (String)ImportPSM.PYRO_LOADER.defVal);
        String pyroJar = app.getResourceFile(loaderName);
        PyroLoader loader = PyroLoader.get(pyroJar);
        if (loaderName.equals(ImportPSM.PYRO_LOADER.defVal)) {
            return loader;
        }
        try {
            if (!new File(pyroJar).exists()) {
                throw new FileNotFoundException(pyroJar);
            }
            loader.validate();
            return loader;
        }
        catch (Exception e) {
            TeciLogging.log(LOGGER, "Could not load debug PyroSim jar: " + pyroJar, (Throwable)e);
            return PyroLoader.get(app.getResourceFile((String)ImportPSM.PYRO_LOADER.defVal));
        }
    }

    private static PyroLoadOptions getPyroLoadOptions() {
        PyroLoadOptions loadOptions = new PyroLoadOptions();
        MerlinApp app = MerlinApp.getApp();
        loadOptions.setApplicationData(app.getAppName(), app.getInstallDir(), app.getActiveFrame());
        loadOptions.setCutHoles(true);
        loadOptions.setSupportedGeomTypes(PyroGeomConverter.getSupportedPyroGeomTypes());
        return loadOptions;
    }
}

