/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.importgeom;

import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.stage.FileChooser;
import javax.swing.Icon;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.CancelledException;
import merlin.actions.MerlinOp;
import merlin.actions.New;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.importgeom.IImporter;
import merlin.actions.importgeom.ImportCAD;
import merlin.actions.importgeom.ImportCSV;
import merlin.actions.importgeom.ImportOptions;
import merlin.actions.importgeom.ImportPSM;
import merlin.actions.importgeom.ImportTraj;
import merlin.actions.importgeom.ImportUtil;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.material.Material;
import merlin.gui.guiUtil;
import merlin.mv.ModelView;
import thunderheadeng.cad.in.CadImportUI;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.gui.wizard.WizardDlg;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class Import
extends AMerlinOp
implements IEventObserver {
    public static final boolean TRAJECTORY = Application.isDev() || theUtil.testSystemProp("import.trajectory");
    public static final Object MODEL_IMPORTED = "Import.MODEL_IMPORTED";
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Import16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Import(), Intl.intl("&Import...,-,Import File,Import File"), ICON);
    private static final List<IImporter> s_importers = new ArrayList<IImporter>();
    private static final Map<Pair<IImporter, String>, ImportOptions> s_cachedOptions = new HashMap<Pair<IImporter, String>, ImportOptions>();

    public static void registerImporter(IImporter importer) {
        s_importers.add(importer);
    }

    private Import() {
        MerlinData md = MerlinApp.getAppData();
        if (md != null) {
            md.getEvents().addObserver(this);
        }
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getAppData();
        if (md == null) {
            return;
        }
        for (Map.Entry<Pair<IImporter, String>, ImportOptions> entry : s_cachedOptions.entrySet()) {
            ((IImporter)entry.getKey().v1).update(md, events, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData mdd) {
        ArrayList<FileChooser.ExtensionFilter> filters = new ArrayList<FileChooser.ExtensionFilter>();
        for (IImporter importer : s_importers) {
            filters.addAll(Arrays.asList(importer.getFileFilters()));
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)true, (Boolean)true, (Boolean)false, filters);
        File f = chooser.showOpenDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        String ext = FilenameManager.getExtension(f.getAbsolutePath());
        if (ext.isEmpty()) {
            String msg = Intl.intl("Could not determine file type.");
            guiDialog.showInvalidEntryMessage(app.getActiveFrame(), msg);
            return;
        }
        IImporter importer = null;
        block8: for (IImporter imp : s_importers) {
            for (FileChooser.ExtensionFilter filt : imp.getFileFilters()) {
                if (!filt.getExtensions().contains("*." + ext)) continue;
                importer = imp;
                break block8;
            }
        }
        assert (importer != null);
        if (importer == null) {
            return;
        }
        ImportOptions options = null;
        app.beginWaitCursor();
        try {
            WhereCard firstImportCard;
            options = s_cachedOptions.get(new Pair<Object, String>(importer, ext));
            if (options == null) {
                options = new ImportOptions(mdd);
                importer.initDefaultOptions(mdd, ext, options);
                s_cachedOptions.put(new Pair<IImporter, String>(importer, ext), options);
            }
            try {
                options.reset(f);
            }
            catch (IOException e) {
                Import.showError(app, f.getAbsolutePath(), e);
                if (options != null) {
                    options.cleanup();
                }
                importer.cleanup(options);
                app.endWaitCursor();
                return;
            }
            options.set(CadImportUI.WARNINGS, new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0));
            WhereCard firstCard = firstImportCard = importer.getCard(options);
            if (importer.getAllowNewFile(mdd, ext, options)) {
                firstCard = new WhereCard(firstImportCard, f);
            } else {
                firstCard = firstImportCard;
                options.set(ImportOptions.NEW_MODEL, false);
            }
            if (firstCard != null) {
                WizardDlg<IPropertySet> wizard = new WizardDlg<IPropertySet>((Window)app.getActiveFrame(), Intl.intl("Import"), String.format(Intl.intl("Import %s"), f.getName()), firstCard);
                wizard.init(options);
                if (wizard.doModal() != 1) {
                    return;
                }
            }
            Import.open(app, mdd, f.getPath(), importer, options);
            WarningReport<Warning> warningReport = options.get(CadImportUI.WARNINGS);
            if (!warningReport.isEmpty()) {
                new WarningDlg<Warning>((Window)app.getActiveFrame(), Intl.intl("Import Warning"), Intl.intl("Problem importing model."), options.get(CadImportUI.WARNINGS)).doModal();
            }
        }
        finally {
            if (options != null) {
                options.cleanup();
            }
            importer.cleanup(options);
            app.endWaitCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean open(MerlinApp app, MerlinData mdd, String fn, IImporter importer, ImportOptions options) {
        app.beginWaitCursor();
        try {
            IImporter.Result result;
            if (options.get(ImportOptions.NEW_MODEL).booleanValue() && !app.promptSaveIfModified()) {
                boolean bl = false;
                return bl;
            }
            try (MerlinData.ReadLock lock = mdd.lockRead();){
                result = importer.read(app, fn, options);
            }
            result.root.prune();
            if (result.root.isEmpty() && result.additionalObjs.isEmpty()) {
                boolean lock = true;
                return lock;
            }
            IdentityHashSet<Material> usedMats = new IdentityHashSet<Material>();
            ImportUtil.getUsedMaterials(result.root.flatten(ImportedGeom.class), usedMats);
            LinkedIdentityHashSet<Material> newUsedMats = new LinkedIdentityHashSet<Material>((Collection<Material>)options.get(ImportOptions.MAT_CACHE).get().getAddedMaterials());
            newUsedMats.retainAll(usedMats);
            try (MerlinData.WriteLock lock = mdd.lockWrite();){
                Undo.begin(Intl.intl("Import"));
                if (options.get(ImportOptions.NEW_MODEL).booleanValue()) {
                    New.newModel(app, mdd);
                }
                if (!newUsedMats.isEmpty()) {
                    Undo.insertUndoEntry_delete(mdd, mdd.materials, newUsedMats);
                    mdd.materials.addAll(newUsedMats);
                }
                if (!result.root.isEmpty()) {
                    Undo.insertUndoEntry_delete(mdd, mdd.sceneGeom, result.root);
                    mdd.sceneGeom.add(result.root);
                }
                ArrayList<ICompElement> newSelection = new ArrayList<ICompElement>();
                for (Pair<Composite<?>, ICompElement> additionalObj : result.additionalObjs) {
                    Undo.insertUndoEntry_delete(mdd, (Composite)additionalObj.v1, additionalObj.v2);
                    ((Composite)additionalObj.v1).add((ICompElement)additionalObj.v2);
                    newSelection.add((ICompElement)additionalObj.v2);
                }
                if (!newSelection.isEmpty()) {
                    mdd.selection.set(newSelection);
                }
                mdd.getEvents().changed(mdd, MODEL_IMPORTED);
                mdd.getEvents().changed(mdd, ModelView.EVT_RESET_CAMERAS);
                Undo.end(mdd);
            }
        }
        catch (CancelledException result) {
        }
        catch (Exception e) {
            Import.showError(app, fn, e);
            boolean bl = false;
            return bl;
        }
        finally {
            app.endWaitCursor();
        }
        System.gc();
        return true;
    }

    private static void showError(MerlinApp app, String fn, Exception e) {
        String msg = String.format(Intl.intl("Error importing %s."), fn);
        guiUtil.showError(app, Intl.intl("Import Error"), msg, (Throwable)e);
    }

    static {
        Import.registerImporter(new ImportPSM());
        Import.registerImporter(new ImportCAD());
        Import.registerImporter(new ImportCSV());
        if (TRAJECTORY) {
            Import.registerImporter(new ImportTraj());
        }
    }

    private static class WhereCard
    extends AWizardCard<IPropertySet> {
        private static final long serialVersionUID = -7470489699676283058L;
        private final AWizardCard<IPropertySet> d_nextCard;
        private final guiRadioButton d_newModel;
        private final guiRadioButton d_currModel;

        public WhereCard(AWizardCard<IPropertySet> nextCard, File f) {
            super(Intl.intl("Import Location"));
            this.d_nextCard = nextCard;
            this.d_newModel = new guiRadioButton(Intl.intl("Into a new model"));
            this.d_currModel = new guiRadioButton(Intl.intl("Into the current model"));
            new guiButtonGroup(this.d_newModel, this.d_currModel);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(Intl.intl("Where should the data be imported?"));
            gb.addIdentRow(this.d_newModel);
            gb.addIdentRow(this.d_currModel);
            gb.finalizeRows();
        }

        @Override
        public Dimension getMaxCardSize() {
            return this.getMaxSizeThisOrNext();
        }

        @Override
        public boolean isActionEnabled(IPropertySet data, int action) {
            switch (action) {
                case 0: {
                    return true;
                }
                case 4: {
                    return this.d_nextCard == null;
                }
                case 1: {
                    return this.d_nextCard != null;
                }
            }
            return false;
        }

        @Override
        public void initFrom(IPropertySet data) {
            if (data.get(ImportOptions.NEW_MODEL).booleanValue()) {
                this.d_newModel.setSelected(true);
            } else {
                this.d_currModel.setSelected(true);
            }
        }

        @Override
        public void saveTo(IPropertySet data) {
            data.set(ImportOptions.NEW_MODEL, this.d_newModel.isSelected());
        }

        @Override
        public void cancel() {
        }

        @Override
        public AWizardCard<?> getNext() {
            return this.d_nextCard;
        }
    }
}

