/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import merlin.io.MerlinOIS;
import merlin.io.MerlinOOS;
import thunderheadeng.gui.IDomainObject;

public class PthCopyDataContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DataFlavor DATAFLAVOR_BINARY = new DataFlavor(PthCopyDataContainer.class, "Copied Pathfinder Data");
    public static final DataFlavor DATAFLAVOR_STRING = DataFlavor.stringFlavor;
    private final int d_version;
    private final byte[] d_data;

    public PthCopyDataContainer(int version, Map<IDomainObject, String> pasteObjMap) {
        this.d_version = version;
        this.d_data = this.serialize((Serializable)((Object)pasteObjMap));
    }

    public int getVersion() {
        return this.d_version;
    }

    public Map<IDomainObject, String> getObjs() {
        return (Map)((Object)this.deserialize(this.d_data));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] serialize(Serializable ser) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (MerlinOOS serializer = new MerlinOOS(baos);){
                byte[] data;
                serializer.writeObject(ser);
                byArray = data = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Serializable deserialize(byte[] bytes) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Serializable serializable;
            try (MerlinOIS reader = new MerlinOIS(bais, true, progress -> {});){
                Object obj = reader.readObject();
                serializable = (Serializable)obj;
            }
            return serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return (Serializable)((Object)Collections.EMPTY_MAP);
        }
    }

    public String toString() {
        return String.format("PthCopyDataContainer[d_version=%d,d_data=%s]", this.d_version, this.d_data);
    }
}

