/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import merlin.MerlinApp;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.mv.displays.GlobalDisplayMgr;
import merlin.util.MerlinUtil;
import thunderheadeng.util.LinkedIdentityHashSet;

public class Visibility {
    public static void setVisibility(MerlinData md, Collection<?> toShow, Collection<?> toHide, boolean hideFirst) {
        LinkedIdentityHashSet<ICompElement> showObjs = new LinkedIdentityHashSet<ICompElement>(toShow.size());
        LinkedIdentityHashSet<ICompElement> hideObjs = new LinkedIdentityHashSet<ICompElement>(toHide.size());
        for (Object obj : toShow) {
            Visibility.collectVisibilityHierarchy(md, showObjs, obj);
        }
        for (Object obj : toHide) {
            Visibility.collectVisibilityHierarchy(md, hideObjs, obj);
        }
        Visibility.removeGroups(showObjs);
        Visibility.removeGroups(hideObjs);
        if (Visibility.containsClipped(md, toShow)) {
            hideObjs.removeAll(md.floors.getMembers());
            showObjs.addAll(md.floors.getMembers());
        }
        if (hideFirst) {
            hideObjs.removeAll(showObjs);
            Undo.insertUndoEntry_propRestore(md, hideObjs, MerlinData.VISIBILITY);
            Undo.insertUndoEntry_propRestore(md, showObjs, MerlinData.VISIBILITY);
            Visibility.setVisibility(hideObjs, false);
            Visibility.setVisibility(showObjs, true);
        } else {
            showObjs.removeAll(hideObjs);
            Undo.insertUndoEntry_propRestore(md, showObjs, MerlinData.VISIBILITY);
            Undo.insertUndoEntry_propRestore(md, hideObjs, MerlinData.VISIBILITY);
            Visibility.setVisibility(showObjs, true);
            Visibility.setVisibility(hideObjs, false);
        }
    }

    private static boolean containsClipped(MerlinData md, Collection<?> objs) {
        MerlinApp app = MerlinApp.getApp();
        if (app == null) {
            return false;
        }
        GlobalDisplayMgr dispMgr = app.getModelView().getDisplayManager();
        for (Object o : MerlinUtil.flatten(objs)) {
            if (!dispMgr.isClippedByFloor(o)) continue;
            return true;
        }
        return false;
    }

    private static void collectVisibilityHierarchy(MerlinData md, Set<ICompElement> coll, Object obj) {
        if (!(obj instanceof ICompElement) || !coll.add((ICompElement)obj)) {
            return;
        }
        if (obj instanceof IEgressOccupiable) {
            IEgressOccupiable occu = (IEgressOccupiable)obj;
            for (EgressAgent agent : occu.getOccupants()) {
                Visibility.collectVisibilityHierarchy(md, coll, agent);
            }
            for (GotoWaypoint gw : occu.getWaypoints()) {
                Visibility.collectVisibilityHierarchy(md, coll, gw);
            }
        }
        for (Object child : md.hierarchy.getChildren(obj)) {
            Visibility.collectVisibilityHierarchy(md, coll, child);
        }
    }

    private static void removeGroups(Set<ICompElement> coll) {
        Iterator<ICompElement> it = coll.iterator();
        while (it.hasNext()) {
            ICompElement obj = it.next();
            if (!(obj instanceof Composite) || obj.getPropTypes(1).contains(MerlinData.VISIBILITY)) continue;
            it.remove();
        }
    }

    private static void setVisibility(Set<ICompElement> objs, boolean visibility) {
        Boolean val = visibility ? Boolean.TRUE : Boolean.FALSE;
        Composite.setProperty(MerlinData.VISIBILITY, val, objs);
    }
}

