/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.gui.ActionErrorDialog;
import merlin.gui.PropPanel;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.gui.WaitCursorMgr;
import thunderheadeng.gui.guiUtil;

public class UIHook
extends AbstractAction
implements PropertyChangeListener {
    private static final long serialVersionUID = 8217712023865840926L;
    public static final int EVENT_OP = 1;
    public static final int WAIT_FOR_OP = 2;
    public static final int RETAIN_MODELESS_OPS = 4;
    public static final int SKIP_NAME_PARSE = 8;
    public static final int SKIP_PROP_COMMIT = 16;
    public static final int SKIPPABLE = 32;
    public static final int BACKGROUND = 64;
    private static final Executor s_executor = new Executor();
    private static final Set<MerlinOp> s_preOps = Collections.synchronizedSet(new LinkedHashSet());
    private final int d_options;
    private final MerlinOp d_callback;
    private int mnemonicKey = -1;
    private final Collection<JComponent> d_uiElements = new HashSet<JComponent>();
    private static final int[] s_queuedCount = new int[]{0};

    public UIHook(MerlinOp callback, String name) {
        this(callback, name, null);
    }

    public UIHook(MerlinOp callback, String name, int options) {
        this(callback, name, null, options);
    }

    public UIHook(MerlinOp callback, String name, Icon ico) {
        this(callback, name, ico, 0);
    }

    public UIHook(MerlinOp callback, String name, Icon ico, int options) {
        super(name, ico);
        if (UIHook.test(options, 8)) {
            this.putValue("Name", name);
        } else {
            this.initFromName(this, name);
        }
        this.d_callback = callback;
        this.d_options = options;
        super.setEnabled(this.d_callback.isEnabled());
        this.d_callback.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ENABLED_CHANGED")) {
            super.setEnabled((Boolean)evt.getNewValue());
        }
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public void setShortDesc(String desc) {
        this.putValue("ShortDescription", desc);
    }

    public void setLongDesc(String desc) {
        this.putValue("LongDescription", desc);
    }

    @Override
    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        this.d_callback.setEnabled(newValue);
    }

    public JMenuItem getMenuItem() {
        JMenuItem jmi = new JMenuItem(this);
        this.registerUIComponent(jmi);
        return jmi;
    }

    public void registerUIComponent(JComponent comp) {
        if (comp instanceof JMenuItem && this.mnemonicKey != -1) {
            ((JMenuItem)comp).setMnemonic(this.mnemonicKey);
        }
        ArrayList<KeyStroke> accelerators = new ArrayList<KeyStroke>();
        KeyStroke ksRoot = (KeyStroke)this.getValue("AcceleratorKey");
        if (ksRoot != null) {
            KeyStroke ksIter;
            accelerators.add(ksRoot);
            int ix = 1;
            while ((ksIter = (KeyStroke)this.getValue("AcceleratorKey" + ix)) != null) {
                ++ix;
                accelerators.add(ksIter);
            }
            comp.getActionMap().put(this, this);
            InputMap im = comp.getInputMap(2);
            for (KeyStroke ks : accelerators) {
                im.put(ks, this);
            }
        }
        this.d_uiElements.add(comp);
    }

    public void setKeyStroke(KeyStroke newKS) {
        KeyStroke oldKS = (KeyStroke)this.getValue("AcceleratorKey");
        for (JComponent comp : this.d_uiElements) {
            if (oldKS != null) {
                comp.getInputMap(2).put(oldKS, "none");
            }
            if (newKS == null) continue;
            comp.getActionMap().put(this, this);
            comp.getInputMap(2).put(newKS, this);
        }
        this.putValue("AcceleratorKey", newKS);
    }

    public MerlinOp getMerOp() {
        return this.d_callback;
    }

    public static Icon loadIcon(String icoFile) {
        return guiUtil.loadIcon(icoFile);
    }

    public void initFromName(AbstractAction act, String name) {
        String[] toks = name.split(",");
        for (int i = 0; i < toks.length; ++i) {
            toks[i] = toks[i].trim();
        }
        String title = toks[0];
        int ixAmp = title.indexOf(38);
        if (ixAmp >= 0) {
            char mnemonicChar = title.charAt(ixAmp + 1);
            title = title.replaceFirst("&", "");
            this.mnemonicKey = Character.toUpperCase(mnemonicChar);
        }
        act.putValue("Name", title);
        if (toks.length >= 2 && !toks[1].equals("-")) {
            char keyCode = Character.toUpperCase(toks[1].charAt(0));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)keyCode, 2));
        }
        if (toks.length >= 3 && !toks[2].equals("-")) {
            this.putValue("ShortDescription", toks[2]);
            this.putValue("LongDescription", toks[2]);
        }
        if (toks.length >= 4 && !toks[2].equals("-")) {
            this.putValue("LongDescription", toks[3]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println(UIHook.formatForActionLog(this));
        FocusManager fm = FocusManager.getCurrentManager();
        if (guiUtil.keyboardShortcutWrapperNeeded((KeyStroke)this.getValue("AcceleratorKey")) && guiUtil.keyboardShortcutWrapperShouldBlock(fm)) {
            return;
        }
        this.run(UIHook.getComponent(e));
    }

    public static String formatForActionLog(Action action) {
        String[] preferredKeys;
        for (String key : preferredKeys = new String[]{"ShortDescription", "LongDescription", "Name"}) {
            String value = (String)action.getValue(key);
            if (value == null || value.isEmpty()) continue;
            return value;
        }
        return null;
    }

    public static Component getComponent(EventObject e) {
        return e.getSource() instanceof Component ? (Component)e.getSource() : null;
    }

    public void run(Component c) {
        UIHook.run(c, UIHook.formatForActionLog(this), this.d_callback, this.d_options);
    }

    private static List<WaitCursorMgr> getWaitMgrs(MerlinApp app, Component c) {
        List<WaitCursorMgr> waitMgrs = app.getWaitMgrs();
        WaitCursorMgr compWaitMgr = guiUtil.getWaitMgr(c);
        if (compWaitMgr != null && !waitMgrs.contains(compWaitMgr)) {
            waitMgrs.add(compWaitMgr);
        }
        return waitMgrs;
    }

    public static void addPreOp(MerlinOp op) {
        s_preOps.add(op);
    }

    public static boolean removePreOp(MerlinOp op) {
        return s_preOps.remove(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Component c, String actionName, MerlinOp op, int options) {
        boolean commitProps;
        MerlinApp app = MerlinApp.getApp();
        boolean bl = commitProps = !UIHook.test(options, 16) && app.getModelView() != null;
        assert (!(commitProps && UIHook.test(options, 2) && app.getData().isReadLockedByCurrentThread()));
        int[] nArray = s_queuedCount;
        synchronized (s_queuedCount) {
            if (UIHook.test(options, 32) && s_queuedCount[0] > 0) {
                System.err.printf("Rejected action: %s%n", actionName);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            s_queuedCount[0] = s_queuedCount[0] + 1;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (!s_executor.lock()) {
                return;
            }
            if (actionName != null && !actionName.isEmpty()) {
                CrashCatcher.logAction(actionName);
            }
            List<WaitCursorMgr> waitMgrs = UIHook.getWaitMgrs(app, c);
            waitMgrs.stream().forEach(mgr -> mgr.beginWaitCursor(true));
            if (commitProps) {
                AMerlinOp propCommitOp = new AMerlinOp(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run(MerlinApp app, MerlinData md) {
                        boolean valid = md.ui(() -> {
                            PropPanel propsPanel = app.getModelView().getToolPropsPanel();
                            return propsPanel.validateData(false, true);
                        });
                        if (valid) {
                            try (MerlinData.WriteLock lock = md.lockWrite();){
                                Undo.begin(Intl.intl("Commit Property"));
                                try {
                                    PropPanel propsPanel = app.getModelView().getToolPropsPanel();
                                    propsPanel.commit();
                                }
                                finally {
                                    Undo.end(md);
                                }
                            }
                        }
                    }
                };
                UIHook.invoke(app, propCommitOp, false);
            }
            if (!UIHook.test(options, 4) && !UIHook.test(options, 64)) {
                AMerlinOp cancelToolOp = new AMerlinOp(){

                    @Override
                    public void run(MerlinApp app, MerlinData md) {
                        app.getModelView().getTools().cancelCurrentTool();
                    }
                };
                UIHook.invoke(app, cancelToolOp, true);
            }
            if (!UIHook.test(options, 64)) {
                ArrayList<MerlinOp> preOps;
                Set<MerlinOp> set = s_preOps;
                synchronized (set) {
                    preOps = new ArrayList<MerlinOp>(s_preOps);
                    s_preOps.clear();
                }
                for (MerlinOp preOp : preOps) {
                    UIHook.invoke(app, preOp, false);
                }
            }
            UIHook.invoke(app, op, UIHook.test(options, 1));
            Runnable finalizeOp = () -> {
                waitMgrs.stream().forEach(mgr -> mgr.endWaitCursor());
                int[] nArray = s_queuedCount;
                synchronized (s_queuedCount) {
                    s_queuedCount[0] = s_queuedCount[0] - 1;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            };
            UIHook.invoke(app, finalizeOp, false);
            if (UIHook.test(options, 2)) {
                EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                SecondaryLoop waitLoop = eq.createSecondaryLoop();
                Runnable wakeupOp = () -> waitLoop.exit();
                UIHook.invoke(app, wakeupOp, false);
                s_executor.release();
                waitLoop.enter();
            } else {
                s_executor.release();
            }
            return;
        }
    }

    private static void invoke(MerlinApp app, MerlinOp op, boolean event) {
        UIHook.invoke(app, () -> op.run(app, app.getData()), event);
    }

    private static void invoke(MerlinApp app, Runnable r, boolean event) {
        if (event) {
            Runnable eworker = r;
            r = () -> {
                try {
                    SwingUtilities.invokeAndWait(eworker);
                }
                catch (Throwable t) {
                    SwingUtilities.invokeLater(() -> MerlinApp.crash(t));
                }
            };
        } else {
            Runnable worker = r;
            r = () -> {
                try {
                    worker.run();
                }
                catch (Throwable t) {
                    SwingUtilities.invokeLater(() -> MerlinApp.crash(t));
                }
            };
        }
        s_executor.push(r);
    }

    private static boolean test(int options, int option) {
        return (options & option) == option;
    }

    public static void showErrorMsg(JFrame frame, MerlinOp mop, Throwable t) {
        ActionErrorDialog dlg = new ActionErrorDialog(frame);
        StringBuffer msg = new StringBuffer();
        msg.append(mop.getClass().getName() + "\n");
        msg.append("\n");
        msg.append(t.getLocalizedMessage() + "\n");
        int tracedepth = 8;
        for (int i = 0; i < tracedepth && i < t.getStackTrace().length; ++i) {
            msg.append("     " + t.getStackTrace()[i].toString());
            if (i >= t.getStackTrace().length - 1) continue;
            msg.append("\n");
        }
        if (t.getStackTrace().length - tracedepth > 1) {
            msg.append("     ... (" + (t.getStackTrace().length - tracedepth) + " more elements)");
        } else if (t.getStackTrace().length - tracedepth == 1) {
            msg.append("     " + t.getStackTrace()[tracedepth].toString());
        }
        dlg.setMsg(msg.toString());
        dlg.doModal();
    }

    private static class Executor {
        private transient ExecutorService d_workerExecutor = null;
        private final Semaphore d_lock = new Semaphore(1);

        public Executor() {
            this.resetWorkerExecutor();
        }

        public boolean lock() {
            try {
                this.d_lock.acquire();
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }

        public void release() {
            this.d_lock.release();
        }

        private void resetWorkerExecutor() {
            ThreadFactory factory = new ThreadFactory(this){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setPriority(1);
                    return t;
                }
            };
            this.d_workerExecutor = Executors.newSingleThreadExecutor(factory);
        }

        private void checkWorkerExecutor() {
            if (this.d_workerExecutor.isShutdown()) {
                System.err.println("Worker executor was shutdown for some reason.  Restarting...");
                this.resetWorkerExecutor();
            }
        }

        public void push(Runnable worker) {
            this.checkWorkerExecutor();
            this.d_workerExecutor.submit(worker);
        }

        public void cancelWorkerOps() {
            System.out.println("cancelling...");
            this.d_workerExecutor.shutdownNow();
            System.out.println("cancelled");
            this.resetWorkerExecutor();
        }

        public void shutdownWorkers(boolean wait) {
            this.d_workerExecutor.shutdown();
            long waitTime = wait ? Integer.MAX_VALUE : 0L;
            try {
                this.d_workerExecutor.awaitTermination(waitTime, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

