/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Collection;
import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.FloorSortActions;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.egress.FloorSort;
import merlin.data.egress.geom.IEgressComp;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class SortByFloor
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SortByFloor(), Intl.intl("&Sort into Floors,-,Sort egress components into appropriate floors."));

    public SortByFloor() {
        SelectionObserver.add(this, IEgressComp.class, Composite.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        this.setEnabled(!SortByFloor.getSortableObjs(data).isEmpty());
    }

    private static Collection<IEgressComp> getSortableObjs(MerlinData md) {
        Set selObjs = md.selection.getDeepSelected(IEgressComp.class);
        return FloorSortActions.getSortableObjs(md, selObjs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginWrite();
        try {
            Collection<IEgressComp> comps = SortByFloor.getSortableObjs(md);
            Undo.begin(Intl.intl("Sort by Floor"));
            boolean oldAuto = md.floorSortOptions.get(FloorSort.AUTO_SELECT_FLOOR);
            md.floorSortOptions.set(FloorSort.AUTO_SELECT_FLOOR, true);
            FloorSortActions.updateComponentFloors(md, comps);
            md.floorSortOptions.set(FloorSort.AUTO_SELECT_FLOOR, oldAuto);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }
}

