/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.camera.IViewObj;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class ShowView
extends AMerlinOp
implements IEventObserver {
    public static final UIHook CONTEXT_HOOK = new UIHook((MerlinOp)new ShowView(), Intl.intl("Show in 3D View,-,Shows the 3D view from the view's perspective."), 1);

    public ShowView() {
        SelectionObserver.add(this, IViewObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(this.getEnabled());
    }

    private boolean getEnabled() {
        MerlinData md = MerlinApp.getApp().getData();
        if (!md.selection.isExclusive(IViewObj.class)) {
            return false;
        }
        Set sel = md.selection.getSelected(IViewObj.class);
        return sel.size() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginRead();
        try {
            Set selCameras = md.selection.getSelected(IViewObj.class);
            if (selCameras.isEmpty()) {
                return;
            }
            ShowView.showIn3DView(md, (IViewObj)selCameras.iterator().next());
        }
        finally {
            md.endRead();
        }
    }

    public static void showIn3DView(MerlinData md, IViewObj cam) {
        MerlinApp.getApp().getModelView().applyCamera(cam.getCameraState());
    }
}

