/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.util.Dependencies;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;

public class SelectReferencing
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectReferencing(), Intl.intl("Select Referencing Objects"));

    public SelectReferencing() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(!md.selection.isDeepEmpty(IMerlinObj.class));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        try (MerlinData.WriteLock lock = md.lockWrite();){
            LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
            Dependencies.getObjReferences(md, Predicates.alwaysTrue(), obj -> md.selection.isSelected(obj), (src, target) -> referencing.add(src));
            md.selection.set(referencing);
        }
    }
}

