/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import thunderheadeng.gui.OutputLog;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.FileFilters;

public class SaveOutputLogAction
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new SaveOutputLogAction(), Intl.intl("Save Output &Log..."), 64);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        Object filename;
        md.beginRead();
        try {
            filename = md.filename;
        }
        finally {
            md.endRead();
        }
        if (filename == null) {
            filename = "log.txt";
        } else {
            String[] fn = FilenameManager.splitFilename((String)filename);
            filename = fn[0] + "_log.txt";
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser((String)filename, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_TEXT);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return;
        }
        MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
        try {
            System.out.printf("Copying log file to: %s%n", f.getAbsolutePath());
            CopyFile.copy(OutputLog.logFile, f);
        }
        catch (IOException e) {
            e.printStackTrace();
            md.ui(() -> JOptionPane.showMessageDialog(app.getMainFrame(), e.getLocalizedMessage()));
        }
    }
}

