/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.geom.GeomUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;

public class RemoveImportedUVAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new RemoveImportedUVAction(), Intl.intl("Remove Imported Texture Coordinates,-,Removes the imported texture coordinates attached to the object and uses default texture coordinates instead."));

    public RemoveImportedUVAction() {
        SelectionObserver.add(this, ImportedGeom.class);
        this.update(null);
    }

    protected Collection<ImportedGeom> getObjs(MerlinData md) {
        return md.selection.getDeepSelected(ImportedGeom.class);
    }

    @Override
    public void update(Events events) {
        this.setEnabled(!this.getObjs(MerlinApp.getApp().getData()).isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        md.beginWrite();
        Undo.begin(Intl.intl("Remove Imported Texture Coordinates"));
        try {
            Collection<ImportedGeom> geoms = this.getObjs(md);
            LinkedIdentityHashMap<ImportedGeom, IGeomNode> changes = new LinkedIdentityHashMap<ImportedGeom, IGeomNode>();
            for (ImportedGeom importedGeom : geoms) {
                IGeomNode newGeom;
                IGeomNode geom = importedGeom.getGeom();
                if (geom == (newGeom = geom.initUVElements(GeomUtil.DEFUV))) continue;
                changes.put(importedGeom, newGeom);
            }
            if (!changes.isEmpty()) {
                Undo.insertUndoEntry_propRestore(md, new ArrayList(changes.keySet()), ImportedGeom.PROP_GEOM);
                for (Map.Entry entry : changes.entrySet()) {
                    ((ImportedGeom)entry.getKey()).setGeom((IGeomNode)entry.getValue());
                }
            }
        }
        finally {
            Undo.end(md);
            md.endWrite();
        }
    }
}

