/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Properties;
import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.Open;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.RecentFilesEntry;
import thunderheadeng.gui.MRUMenu;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.MRUFileList;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class RecentFilesAction
implements IEventObserver {
    private static final int DEF_SIZE = 10;
    private final MerlinData d_md;
    private final MRUFileList d_mru;
    private final MRUMenu d_topMenu;

    public RecentFilesAction(MerlinData md, Properties prefs) {
        this.d_md = md;
        this.d_mru = new MRUFileList("MRU.", "", 10);
        this.d_mru.load(prefs);
        this.d_topMenu = new MRUMenu(Intl.intl("Recent Files"), this.d_mru, (ix, name) -> {
            MRUEntry op = new MRUEntry(name);
            UIHook.run(MerlinApp.getApp().getActiveFrame(), "MRUEntry.run", op, 0);
            return true;
        });
        this.d_md.getEvents().addObserver(this);
    }

    @Override
    public void update(Events events) {
        Set<EventChannel<RecentFilesEntry>> channels = events.getAffectedChannels(RecentFilesEntry.class, new Class[0]);
        for (EventChannel<RecentFilesEntry> channel : channels) {
            Set<RecentFilesEntry> added = channel.getAddedObjs();
            for (RecentFilesEntry e : added) {
                this.handleAdd(e);
            }
            Set<RecentFilesEntry> rem = channel.getRemovedObjs();
            for (RecentFilesEntry e : rem) {
                this.handleRem(e);
            }
        }
    }

    private void handleAdd(RecentFilesEntry e) {
        String fn = e.fn;
        assert (fn != null);
        this.d_topMenu.usedFile(e.fn);
    }

    private void handleRem(RecentFilesEntry e) {
        String fn = e.fn;
        assert (fn != null);
        this.d_topMenu.removeFile(fn);
    }

    public void store(Properties p) {
        this.d_mru.store(p);
    }

    public MRUMenu getMenu() {
        return this.d_topMenu;
    }

    private static class MRUEntry
    extends AMerlinOp {
        private String d_fn;

        public MRUEntry(String fn) {
            this.d_fn = fn;
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            assert (FilenameManager.getExtension(this.d_fn).equalsIgnoreCase("pth"));
            if (!app.promptSaveIfModified()) {
                return;
            }
            if (Open.open(app, md, this.d_fn)) {
                MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, this.d_fn);
            } else {
                md.getEvents().removed((Object)new RecentFilesEntry(this.d_fn));
            }
        }
    }
}

