/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3f;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.EditObjects;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.AssistedEvacTeam;
import merlin.data.AssistedEvacTeamComp;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INameGenerator;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccProfileComp;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.agents.VehicleShapeComp;
import merlin.gui.AssistedEvacTeamsDlg;
import merlin.gui.INewDlg;
import merlin.gui.ManagerDlg;
import merlin.gui.NewDlg;
import merlin.gui.OccGroupTypesDlg;
import merlin.gui.ProfilesDlg;
import merlin.gui.VehicleShapesDlg;
import merlin.util.MerlinUtil;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Pair;
import thunderheadeng.util.QuintFunction;

public class NewObject<T extends ICompElement>
extends AMerlinOp
implements IEventObserver {
    public static final Function<String, String> FILENAME_FORMATTER = t -> t.replaceAll("[\\\\/:*?\"<>|]", "_");
    public static final NewObject<OccProfile> NEW_PROFILE_OP = new NewObject<OccProfile>(OccProfile.class, md -> md.profiles, md -> md.profNameGen, NewDlg::new, (mgr, obj) -> {
        ProfilesDlg dlg = new ProfilesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<OccProfile>)mgr, (OccProfile)obj);
        dlg.doModal();
    }, Intl.intl("New Profile"), OccProfile.PROP_NAME, OccProfileComp.class, md -> NewObject.newProfile(md), (md, base) -> base.clone(), true);
    public static final UIHook UI_HOOK_PROFILE = new UIHook(NEW_PROFILE_OP, Intl.intl("Add a Profile..."));
    public static final UIHook UI_HOOK_VEHICLE_SHAPE = new UIHook(new NewObject<VehicleShape>(VehicleShape.class, md -> md.vehicleShapes, md -> md.vehicleShapeNameGen, NewDlg::new, (mgr, obj) -> {
        VehicleShapesDlg dlg = new VehicleShapesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getData(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<VehicleShape>)mgr, (VehicleShape)obj);
        dlg.doModal();
    }, Intl.intl("New Vehicle Shape"), VehicleShape.PROP_NAME, VehicleShapeComp.class, md -> new VehicleShape(), (md, base) -> base.clone(), true), Intl.intl("Add a Vehicle Shape..."));
    public static final UIHook UI_HOOK_ASSISTED_EVAC_TEAM = new UIHook(new NewObject<AssistedEvacTeam>(AssistedEvacTeam.class, md -> md.assistedEvacTeams, md -> md.assistedEvacTeamNameGen, NewDlg::new, (mgr, obj) -> {
        AssistedEvacTeamsDlg dlg = new AssistedEvacTeamsDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (EditObjects.CompositeManager<?>)mgr, (AssistedEvacTeam)obj);
        dlg.doModal();
    }, Intl.intl("New Assisted Evacuation Team"), AssistedEvacTeam.PROP_NAME, AssistedEvacTeamComp.class, md -> new AssistedEvacTeam(), (md, base) -> base.clone(), true), Intl.intl("Add an Assisted Evacuation Team..."));
    public static final UIHook UI_HOOK_OCCGROUP_TYPE = new UIHook(new NewObject<OccGroupTypeObj>(OccGroupTypeObj.class, md -> md.occGroupTypes, md -> md.occGroupTypeNameGen, NewDlg::new, (mgr, obj) -> {
        OccGroupTypesDlg dlg = new OccGroupTypesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
        dlg.init(MerlinApp.getApp().getData(), (EditObjects.CompositeManager<?>)mgr, (OccGroupTypeObj)obj);
        dlg.doModal();
    }, Intl.intl("New Movement Group Template"), OccGroupTypeObj.PROP_NAME, OccGroupTypeObj.OccGroupTypeComp.class, md -> new OccGroupTypeObj(), (md, base) -> base.clone(), true), Intl.intl("Add a Movement Group Template..."));
    private final String d_newMsg;
    private final EnumSet<Option> d_options;
    private final Object d_propName;
    private final Class<T> d_clazz;
    private final Class<? extends Composite<? super T>> d_compClass;
    private final Function<MerlinData, Composite<? super T>> d_getRoot;
    private final Function<MerlinData, INameGenerator> d_getNameGenerator;
    private final BiConsumer<EditObjects.CompositeManager<T>, T> d_createEditDlg;
    private final QuintFunction<Window, MerlinData, String, String, Class<T>, INewDlg<T>> d_createNewDlg;
    private final Function<MerlinData, T> d_getNewObject;
    private final BiFunction<MerlinData, T, T> d_fromExistingObject;
    private final boolean d_requireSelection;

    public static OccProfile newProfile(MerlinData md) {
        OccProfile prof = new OccProfile();
        Color c = MerlinUtil.newRandomOccColor();
        float[] cc = new float[3];
        c.getColorComponents(cc);
        prof.setProperty(OccProfile.PROP_COLOR, new Point3f(cc));
        return prof;
    }

    public NewObject(Class<T> clazz, Function<MerlinData, Composite<? super T>> getRoot, Function<MerlinData, INameGenerator> getNameGenerator, QuintFunction<Window, MerlinData, String, String, Class<T>, INewDlg<T>> createNewDlg, BiConsumer<EditObjects.CompositeManager<T>, T> createEditDlg, String newMsg, Object propName, Class<? extends Composite<? super T>> compClass, Function<MerlinData, T> getNewObject, BiFunction<MerlinData, T, T> fromExistingObject, boolean requireSelection) {
        this(clazz, getRoot, getNameGenerator, createNewDlg, createEditDlg, newMsg, propName, compClass, getNewObject, fromExistingObject, requireSelection, EnumSet.noneOf(Option.class));
    }

    public NewObject(Class<T> clazz, Function<MerlinData, Composite<? super T>> getRoot, Function<MerlinData, INameGenerator> getNameGenerator, QuintFunction<Window, MerlinData, String, String, Class<T>, INewDlg<T>> createNewDlg, BiConsumer<EditObjects.CompositeManager<T>, T> createEditDlg, String newMsg, Object propName, Class<? extends Composite<? super T>> compClass, Function<MerlinData, T> getNewObject, BiFunction<MerlinData, T, T> fromExistingObject, boolean requireSelection, EnumSet<Option> options) {
        this.d_clazz = clazz;
        this.d_getRoot = getRoot;
        this.d_getNameGenerator = getNameGenerator;
        this.d_createNewDlg = createNewDlg;
        this.d_createEditDlg = createEditDlg;
        this.d_newMsg = newMsg;
        this.d_propName = propName;
        this.d_compClass = compClass;
        this.d_getNewObject = getNewObject;
        this.d_fromExistingObject = fromExistingObject;
        this.d_requireSelection = requireSelection;
        this.d_options = options;
        if (this.d_requireSelection) {
            SelectionObserver.add(this, IMerlinObj.class);
            this.update(null);
        }
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(md.selection.isSingleExclusive(this.d_compClass));
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        this.add(app, md, true);
    }

    public void add(MerlinApp app, MerlinData md, boolean editAfter) {
        ICompElement newObj;
        Pair<String, T> newObjInfo;
        try (MerlinData.ReadLock lock = md.lockRead();){
            newObjInfo = NewObject.promptForNewObject(app.getActiveFrame(), md, this.d_getNameGenerator.apply(md).getCurrentName(), this.d_getRoot.apply(md), this.d_clazz, this.d_newMsg, this.d_propName, this.d_createNewDlg);
            if (newObjInfo == null) {
                return;
            }
        }
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Composite parent;
            Composite composite = parent = editAfter && this.d_requireSelection ? (Composite)md.selection.getSelected(Composite.class).iterator().next() : this.d_getRoot.apply(md);
            assert (parent != null);
            newObj = NewObject.newObj(md, (ICompElement)newObjInfo.v2, (String)newObjInfo.v1, this.d_clazz, this.d_newMsg, parent, this.d_getNameGenerator, this.d_getNewObject, this.d_fromExistingObject, !this.d_options.contains((Object)Option.NO_UNDO));
        }
        if (editAfter) {
            EditObjects.editObject(app, md, newObj, this.d_propName, this.d_getRoot.apply(md), this.d_createEditDlg, this.d_clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ICompElement> T newObj(MerlinData md, T objBase, String name, Class<T> clazz, String newMsg, Composite<? super T> parent, Function<MerlinData, INameGenerator> getNameGenerator, Function<MerlinData, T> getNewObject, BiFunction<MerlinData, T, T> fromExisting, boolean undoSupported) {
        ICompElement objNew = null;
        Undo.begin(Intl.intl(newMsg));
        try {
            if (!undoSupported) {
                Undo.insertEntry_breakChain(md);
            }
            objNew = objBase != null ? (ICompElement)fromExisting.apply(md, (MerlinData)((Object)objBase)) : (ICompElement)getNewObject.apply(md);
            objNew.setName(name);
            INameGenerator nameGenerator = getNameGenerator.apply(md);
            if (name.equals(nameGenerator.getCurrentName())) {
                nameGenerator.nextName();
            }
            AddObject.add((MerlinData)md, parent, (int)parent.getMembers().size(), (ICompElement[])new ICompElement[]{objNew});
        }
        catch (Throwable e) {
            assert (false);
        }
        finally {
            Undo.end(md);
        }
        return (T)objNew;
    }

    public static <T extends ICompElement> String promptForName(Component owner, MerlinData md, String initName, Composite<? extends ICompElement> group, Class<T> clazz, String newMsg, Object propName) {
        return NewObject.promptForName(owner, md, initName, group, clazz, newMsg, propName, n -> n);
    }

    public static <T extends ICompElement> String promptForName(Component owner, MerlinData md, String initName, Composite<? extends ICompElement> group, Class<T> clazz, String newMsg, Object propName, Function<String, String> formatName) {
        Function<String, Pair> getName = name -> {
            String result = JOptionPane.showInputDialog(owner, Intl.intl("Name"), name);
            return result == null ? null : new Pair<String, Object>((String)formatName.apply(result), null);
        };
        Pair result = md.ui(() -> NewObject.promptForName(owner, initName, NewObject.getInUseNames(md, group, clazz, propName), getName));
        return result != null ? (String)result.v1 : null;
    }

    public static <T extends ICompElement> Pair<String, T> promptForNewObject(Component owner, MerlinData md, String initName, Composite<? extends ICompElement> group, Class<T> clazz, String newMsg, Object propName, QuintFunction<Window, MerlinData, String, String, Class<T>, INewDlg<T>> createNewDlg) {
        CachedValue cdlg = new CachedValue();
        Function<String, Pair> getName = name -> {
            INewDlg dlg = cdlg.get(() -> {
                Window wowner = owner instanceof Window ? (Window)owner : SwingUtilities.getWindowAncestor(owner);
                return (INewDlg)createNewDlg.apply(wowner, MerlinApp.getApp().getData(), newMsg, (String)name, clazz);
            });
            if (dlg.doModal() != 1) {
                return null;
            }
            return new Pair<String, ICompElement>(dlg.getName(), (ICompElement)dlg.getBaseObject());
        };
        return md.ui(() -> NewObject.promptForName(owner, initName, NewObject.getInUseNames(md, group, clazz, propName), getName));
    }

    private static <T extends IMerlinObj> Pair<String, T> promptForName(Component owner, String initName, Collection<String> inUse, Function<String, Pair<String, T>> getName) {
        String newName = null;
        IMerlinObj baseObject = null;
        boolean valid = false;
        boolean same = false;
        boolean contained = true;
        do {
            String msg;
            Pair<String, T> result;
            if ((result = getName.apply(newName != null ? newName : initName)) == null) {
                return null;
            }
            newName = (String)result.v1;
            baseObject = (IMerlinObj)result.v2;
            valid = newName.length() > 0;
            same = initName.equals(newName);
            contained = inUse.contains(newName);
            if (!valid) {
                msg = Intl.intl("Please provide a name.");
                JOptionPane.showMessageDialog(owner, msg, Intl.intl("Invalid Entry"), 0);
                continue;
            }
            if (same || !contained) continue;
            msg = String.format(Intl.intl("The name \"%s\" is already in use."), newName);
            JOptionPane.showMessageDialog(owner, msg, Intl.intl("Invalid Entry"), 0);
        } while (!valid || !same && contained);
        return new Pair<String, IMerlinObj>(newName, baseObject);
    }

    public static Set<String> getInUseNames(MerlinData md, Composite<? extends ICompElement> group, Class<? extends ICompElement> objType, Object nameProp) {
        LinkedHashSet<String> inUse = new LinkedHashSet<String>();
        for (ICompElement iCompElement : group.flatten(objType)) {
            inUse.add((String)iCompElement.getProperty(nameProp));
        }
        return inUse;
    }

    public static enum Option {
        NO_UNDO;

    }
}

