/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.JniTaskProgress;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;

public class NavMeshGen
extends ANativeObject {
    private static final long serialVersionUID = -66259366304775219L;

    public NavMeshGen() {
        Native.manager.flush();
    }

    @Override
    public Class<?> resolveNativeClass() {
        return NavMeshGen.class;
    }

    private native void setTaskProgress(int var1, ByteBuffer var2);

    private native Result getResult(int var1);

    public void addTri(TriType type, Point3d p1, Point3d p2, Point3d p3) {
        Native.manager.execMethod(NavMeshGen.class, (INativeObject)this, Methods.addTri.ordinal(), type.ordinal(), p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, p3.x, p3.y, p3.z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result buildNavMesh(TaskProgress progress, double headHeight) {
        JniTaskProgress jniProgress = new JniTaskProgress(progress);
        Native.invokeAndWait(() -> this.setTaskProgress(this.getKey(), jniProgress.getBuffer()));
        try {
            Native.manager.execMethod(NavMeshGen.class, (INativeObject)this, Methods.buildNavMesh.ordinal(), headHeight);
            Native.manager.flush();
            Result result = this.getResult(this.getKey());
            return result;
        }
        finally {
            jniProgress.finished();
        }
    }

    private static enum Methods {
        addTri,
        buildNavMesh;

    }

    public static enum TriType {
        FLOOR,
        OBSTRUCTION,
        BOTH;

    }

    public static class Result {
        public final List<Pair<IGeom, List<Boolean>>> result = new ArrayList<Pair<IGeom, List<Boolean>>>();
        private final Map<Point3d, Point3d> d_uniqueVerts = new HashMap<Point3d, Point3d>();
        private ArrayList<IPolygon> d_currPolyList;
        private ArrayList<Boolean> d_currBoundaryEdges;

        public void beginMesh(int polyCount) {
            this.d_currPolyList = new ArrayList(polyCount);
            this.d_currBoundaryEdges = new ArrayList(polyCount);
        }

        public void endMesh() {
            if (this.d_currPolyList.isEmpty()) {
                return;
            }
            this.d_currPolyList.trimToSize();
            this.d_currBoundaryEdges.trimToSize();
            this.result.add(new Pair<IGeom, ArrayList<Boolean>>(GeomUtil.group(this.d_currPolyList), this.d_currBoundaryEdges));
            this.d_currPolyList = null;
            this.d_currBoundaryEdges = null;
        }

        public void addPoly(double[] coords, int count, boolean[] boundaryEdges) {
            int m;
            Point3d[] points = new Point3d[count / 3];
            Point3d key = new Point3d();
            for (m = 0; m < points.length; ++m) {
                int offset = m * 3;
                key.set(coords[offset + 0], coords[offset + 1], coords[offset + 2]);
                Point3d p = this.d_uniqueVerts.get(key);
                if (p == null) {
                    p = new Point3d(key);
                    this.d_uniqueVerts.put(p, p);
                }
                points[m] = p;
            }
            for (m = 0; m < points.length; ++m) {
                this.d_currBoundaryEdges.add(boundaryEdges[m]);
            }
            this.d_currPolyList.add(PolyUtil.newPoly(points));
        }

        public Composite<ICompElement> getDebugObjects(MerlinData md) {
            String name = "NavMesh";
            IPrimProps.Face fprops = new IPrimProps.Face(Color.GREEN, null, 0);
            UniformProps oprops = new UniformProps(fprops);
            UniformProps lprops = new UniformProps(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
            Composite<ICompElement> group = md.sceneGeom.newGroup("NavMesh");
            for (Pair<IGeom, List<Boolean>> geom : this.result) {
                ArrayList<LineSeg> lineGeom = new ArrayList<LineSeg>();
                int boffset = 0;
                for (IPolygon poly : GeomUtil.explode((IGeom)geom.v1, IPolygon.class)) {
                    int nverts = poly.getNumVerts();
                    List polyCreaseList = ((List)geom.v2).subList(boffset, boffset + nverts);
                    for (int m = 0; m < nverts; ++m) {
                        if (!((Boolean)polyCreaseList.get(m)).booleanValue()) continue;
                        Point3d p1 = poly.getPoint(0, m);
                        Point3d p2 = poly.getPoint(0, (m + 1) % nverts);
                        lineGeom.add(new LineSeg(p1, p2));
                    }
                    boffset += nverts;
                }
                PropsBuilder propsBuilder = new PropsBuilder();
                ArrayList<IGeom> allGeoms = new ArrayList<IGeom>();
                allGeoms.add((IGeom)geom.v1);
                propsBuilder.add(oprops, ((IGeom)geom.v1).getNumPrims(7));
                allGeoms.addAll(lineGeom);
                propsBuilder.add(lprops, lineGeom.size());
                group.add(new ImportedGeom(name, GeomNodeUtil.newNode(GeomUtil.group(allGeoms)), propsBuilder.finalizeProps()));
            }
            return group;
        }
    }
}

