/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.Optional;
import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddBGImage;
import merlin.actions.EditObjects;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.AssistedEvacTeam;
import merlin.data.AssistedEvacTeamComp;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.NamedMerlinObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.animation.Animation;
import merlin.data.animation.AnimationDB;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccProfileComp;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.agents.VehicleShapeComp;
import merlin.data.image.BGImage;
import merlin.gui.AnimationsDlg;
import merlin.gui.AssistedEvacTeamsDlg;
import merlin.gui.EditOccGroupDlg;
import merlin.gui.ManagerDlg;
import merlin.gui.OccGroupTypesDlg;
import merlin.gui.ProfilesDlg;
import merlin.gui.VehicleShapesDlg;
import thunderheadeng.scene3d.IntermediateGraphicsXfer;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class EditProps
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new EditProps(), Intl.intl("Properties..."));

    private EditProps() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData md = app.getData();
        MerlinSelectionModel sel = md.selection;
        boolean enabled = sel.isExclusive(BGImage.class) && sel.getSelectionCount() == 1 || sel.isExclusive(OccProfile.class, OccProfileComp.class) || sel.isExclusive(VehicleShape.class, VehicleShapeComp.class) || sel.isExclusive(AssistedEvacTeam.class, AssistedEvacTeamComp.class) || sel.isExclusive(OccGroupTypeObj.class, OccGroupTypeObj.OccGroupTypeComp.class) || sel.isExclusive(EgressAgent.class, EgressAgentComp.class) || sel.isExclusive(Animation.class, AnimationDB.class);
        this.setEnabled(enabled);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        MerlinSelectionModel sel = md.selection;
        if (sel.isExclusive(BGImage.class)) {
            EditProps.editBGImage(app, md);
        } else if (sel.isExclusive(OccProfile.class, OccProfileComp.class)) {
            EditProps.editProfiles(app, md);
        } else if (sel.isExclusive(VehicleShape.class, VehicleShapeComp.class)) {
            EditProps.editVehicleShapes(app, md, Optional.empty());
        } else if (sel.isExclusive(AssistedEvacTeam.class, AssistedEvacTeamComp.class)) {
            EditProps.editAssistedEvacTeams(app, md);
        } else if (sel.isExclusive(OccGroupTypeObj.class, OccGroupTypeObj.OccGroupTypeComp.class)) {
            this.editOccupantGroupTypes(app, md);
        } else if (sel.isExclusive(Animation.class, Animation.class)) {
            EditProps.editAnimations(app, md);
        } else if (sel.isExclusive(EgressAgent.class, EgressAgentComp.class)) {
            EditProps.editSelectedOccs(app, md);
        }
    }

    private static void editProfiles(MerlinApp app, MerlinData md) {
        Set profs = md.selection.getSelected(OccProfile.class);
        OccProfile iniSel = !profs.isEmpty() ? (OccProfile)profs.iterator().next() : null;
        EditObjects.editObject(app, md, iniSel, OccProfile.PROP_NAME, md.profiles, (mgr, obj) -> {
            ProfilesDlg dlg = new ProfilesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
            dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<OccProfile>)mgr, (OccProfile)obj);
            dlg.doModal();
        }, OccProfile.class);
    }

    public static void editVehicleShapes(MerlinApp app, MerlinData md, Optional<VehicleShape> selectedObj) {
        Set vehicleShapes = md.selection.getSelected(VehicleShape.class);
        VehicleShape iniSel = selectedObj.orElse(!vehicleShapes.isEmpty() ? (VehicleShape)vehicleShapes.iterator().next() : null);
        EditObjects.editObject(app, md, iniSel, VehicleShape.PROP_NAME, md.vehicleShapes, (mgr, obj) -> {
            VehicleShapesDlg dlg = new VehicleShapesDlg(app.getMainFrame(), md, app.getUnitSystem());
            dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<VehicleShape>)mgr, (VehicleShape)obj);
            dlg.doModal();
        }, VehicleShape.class);
    }

    private static void editAssistedEvacTeams(MerlinApp app, MerlinData md) {
        Set assistedEvacTeams = md.selection.getSelected(AssistedEvacTeam.class);
        AssistedEvacTeam iniSel = !assistedEvacTeams.isEmpty() ? (AssistedEvacTeam)assistedEvacTeams.iterator().next() : null;
        EditObjects.editObject(app, md, iniSel, AssistedEvacTeam.PROP_NAME, md.assistedEvacTeams, (mgr, obj) -> {
            AssistedEvacTeamsDlg dlg = new AssistedEvacTeamsDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
            dlg.init(MerlinApp.getApp().getData(), (EditObjects.CompositeManager<?>)mgr, (AssistedEvacTeam)obj);
            dlg.doModal();
        }, AssistedEvacTeam.class);
    }

    private void editOccupantGroupTypes(MerlinApp app, MerlinData md) {
        Set occGroups = md.selection.getSelected(OccGroupTypeObj.class);
        OccGroupTypeObj iniSel = !occGroups.isEmpty() ? (OccGroupTypeObj)occGroups.iterator().next() : null;
        EditObjects.editObject(app, md, iniSel, OccGroupTypeObj.PROP_NAME, md.occGroupTypes, (mgr, obj) -> {
            OccGroupTypesDlg dlg = new OccGroupTypesDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
            dlg.init(MerlinApp.getApp().getData(), (EditObjects.CompositeManager<?>)mgr, (OccGroupTypeObj)obj);
            dlg.doModal();
        }, OccGroupTypeObj.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void editBGImage(MerlinApp app, MerlinData md) {
        Set images = md.selection.getSelected(BGImage.class);
        if (images.isEmpty()) {
            return;
        }
        BGImage i = (BGImage)images.iterator().next();
        IntermediateGraphicsXfer igx = new IntermediateGraphicsXfer();
        try {
            BGImageDlg.ImageInfo result;
            md.beginRead();
            try {
                result = md.ui(() -> AddBGImage.editBGImage(app.getActiveFrame(), i, igx));
            }
            finally {
                md.endRead();
            }
            if (result == null) {
                return;
            }
            md.beginWrite();
            try {
                Undo.begin(Intl.intl("Edit Image"));
                Undo.insertUndoEntry_restore(md, i);
                AddBGImage.applyBGInfo(i, result);
                Undo.end(md);
            }
            finally {
                md.endWrite();
            }
        }
        finally {
            igx.release();
        }
    }

    private static void editAnimations(MerlinApp app, MerlinData md) {
        Set profs = md.selection.getSelected(Animation.class);
        Animation iniSel = !profs.isEmpty() ? (Animation)profs.iterator().next() : null;
        EditObjects.editObject(app, md, iniSel, NamedMerlinObj.NAME, md.animations, (mgr, obj) -> {
            AnimationsDlg dlg = new AnimationsDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
            dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<Animation>)mgr, (Animation)obj);
            dlg.doModal();
        }, Animation.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void editSelectedOccs(MerlinApp app, MerlinData md) {
        Set agents = md.selection.getSelected(EgressAgent.class);
        Set groups = md.selection.getSelected(EgressAgentComp.class);
        for (EgressAgentComp group : groups) {
            agents.addAll(group.flatten(EgressAgent.class));
        }
        EditOccGroupDlg dlg = new EditOccGroupDlg((Window)app.getActiveFrame(), MerlinApp.getApp().getData());
        dlg.loadAgents(agents);
        if (dlg.doModal() == 1) {
            md.beginWrite();
            try {
                Undo.begin(Intl.intl("Edit Distribution"));
                dlg.save();
                Undo.end(md);
            }
            finally {
                md.endWrite();
            }
        }
    }
}

