/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.scripting.ScriptObj;
import merlin.gui.ManagerDlg;
import merlin.gui.scripting.ScriptDlg;
import thunderheadeng.util.Predicates;

public class EditCustomScripts
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new EditCustomScripts(), Intl.intl("Edit Custom Scripts..."));

    @Override
    public void run(MerlinApp app, MerlinData md) {
        EditCustomScripts.edit(app, md, null);
    }

    public static void edit(final MerlinApp app, final MerlinData md, final ScriptObj init) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                CompositeManager mgr = new CompositeManager(md, md.customScripts);
                ScriptDlg dlg = new ScriptDlg(app.getMainFrame(), app.getUnitSystem());
                dlg.init(md, mgr, init);
                dlg.doModal();
            }
        };
        md.uiLater(runner);
    }

    public static class CompositeManager
    implements ManagerDlg.IManager<ScriptObj> {
        private final MerlinData d_md;
        private Composite<? super ScriptObj> d_objs;
        private Predicate<ScriptObj> d_filter = Predicates.alwaysTrue();

        public CompositeManager(MerlinData md, Composite<? super ScriptObj> objs) {
            this.d_md = md;
            this.d_objs = objs;
        }

        @Override
        public String describe(ScriptObj oProf) {
            this.d_md.beginRead();
            String name = oProf.getName();
            this.d_md.endRead();
            return name;
        }

        @Override
        public Collection<ScriptObj> getSorted() {
            this.d_md.beginRead();
            List<ScriptObj> sorted = this.d_objs.getMembers().stream().map(obj -> (ScriptObj)obj).filter(this.d_filter).collect(Collectors.toList());
            this.d_md.endRead();
            return sorted;
        }

        @Override
        public int size() {
            this.d_md.beginRead();
            int size = (int)this.d_objs.getMembers().stream().map(obj -> (ScriptObj)obj).filter(this.d_filter).count();
            this.d_md.endRead();
            return size;
        }

        @Override
        public void filter(Predicate<ScriptObj> filter) {
            this.d_filter = filter;
        }
    }
}

