/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.Delete;
import merlin.actions.InfernoUtil;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.Proxy;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.gui.DistributionEditor;
import merlin.gui.guiUtil;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;

public class CreateGroupsAction
extends AMerlinOp
implements IEventObserver {
    private static final String actionName = Intl.intl("New Movement Group(s) from Template");
    public static final UIHook UI_HOOK = new UIHook(new CreateGroupsAction(), actionName + "...");
    private static CreateGroupsDlg s_createGroupsDlg;

    public CreateGroupsAction() {
        SelectionObserver.add(this, EgressAgent.class);
        this.update(null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Double> collectAllGeomRadii(Set<EgressAgent> agents) {
        LinkedHashSet<Double> allRadiiSet = new LinkedHashSet<Double>();
        for (EgressAgent a : agents) {
            allRadiiSet.add(0.5 * a.getGeomShoulderWidth(false).getValue(SI.METER));
        }
        return new ArrayList<Double>(allRadiiSet);
    }

    public static boolean verifyDeletingEmptyGroups(Set<EgressAgent> agents, MerlinApp app) {
        for (EgressAgent agt : agents) {
            if (agt.getMovementGroup() == null) continue;
            int response = JOptionPane.showConfirmDialog(app.getActiveFrame(), "<html>" + Intl.intl("Selected occupants are already assigned to a movement group.<br> Assigning a new movement group will remove occupants from their<br> current group and delete the old group if it is empty.<br> Do you want to continue?") + "</html>", Intl.intl("Movement Group Already Assigned"), 0);
            if (response == 0) break;
            return false;
        }
        return true;
    }

    public static boolean verifySingleBehavior(Collection<EgressAgent> agents, MerlinApp app) {
        Behavior b = null;
        for (EgressAgent a : agents) {
            if (b == null) {
                b = a.getBehavior();
                continue;
            }
            if (a.getBehavior() == b) continue;
            JOptionPane.showMessageDialog(app.getActiveFrame(), "<html>" + Intl.intl("All selected occupants have to share the same behavior.<br> Please change the behavior of selected occupants first.") + "</html>", Intl.intl("Inconsistent Behaviors"), 0);
            return false;
        }
        return true;
    }

    private Map<IEgressOccupiable, List<EgressAgent>> calcRoomMap(Set<EgressAgent> agents) {
        LinkedHashMap<IEgressOccupiable, List<EgressAgent>> roomMap = new LinkedHashMap<IEgressOccupiable, List<EgressAgent>>();
        for (EgressAgent a : agents) {
            roomMap.compute(a.getLocInfo().room, (k, v) -> {
                List list = v == null ? new ArrayList() : v;
                list.add(a);
                return list;
            });
        }
        return roomMap;
    }

    private void assignGroups(Collection<SizeConstrainedKMeans.ClusteringResult> clusteringResults, MerlinData md, boolean forceSelection, boolean deleteExtra, Set<EgressAgent> unclusteredAgents) {
        LinkedIdentityHashSet<OccGroupObj> oldGroups = new LinkedIdentityHashSet<OccGroupObj>();
        LinkedIdentityHashSet<EgressAgent> movedMembers = new LinkedIdentityHashSet<EgressAgent>();
        LinkedHashSet<OccGroupObj> newGroups = new LinkedHashSet<OccGroupObj>();
        Undo.begin("Create Group");
        for (SizeConstrainedKMeans.ClusteringResult result : clusteringResults) {
            for (SizeConstrainedKMeans.Cluster c : result.clusters) {
                if (c.groupTemplate == md.occGroupTypes.NO_GROUP_TYPE) continue;
                ArrayList<EgressAgent> members = new ArrayList<EgressAgent>(c.getMembers());
                Collections.sort(members, (a1, a2) -> a1.getName().compareTo(a2.getName()));
                CreateGroupsAction.assignProfiles(c, md);
                for (EgressAgent agt : members) {
                    if (agt.getMovementGroup() == null) continue;
                    oldGroups.add(agt.getMovementGroup());
                    movedMembers.add(agt);
                    CreateGroupsAction.removeAgentFromCurrentMovementGroup(agt, md);
                }
                OccGroupObj newGroup = OccGroupObj.newGroup(c.groupTemplate.createNewGroupName(), members, c.groupTemplate.getProperty(OccGroupObj.PROP_COLOR), null);
                newGroup.loadTemplate(c.groupTemplate, members);
                newGroups.add(newGroup);
            }
        }
        int ix = md.occGroups.getChildren().size();
        AddObject.add(md, md.occGroups, ix, newGroups);
        if (forceSelection) {
            md.selection.clear();
            md.selection.selectAll(unclusteredAgents);
        }
        if (deleteExtra) {
            Delete.deleteAll(md, unclusteredAgents);
        }
        CreateGroupsAction.resetOldGroupLeaders(oldGroups, movedMembers, md);
        CreateGroupsAction.deleteOldGroupsIfEmpty(oldGroups, md);
        Undo.end(md);
    }

    public static void deleteOldGroupsIfEmpty(Set<OccGroupObj> oldGroups, MerlinData md) {
        if (!oldGroups.isEmpty()) {
            LinkedIdentityHashSet deleteGroups = new LinkedIdentityHashSet();
            for (OccGroupObj group : oldGroups) {
                if (!group.getChildren().isEmpty()) continue;
                deleteGroups.add(group);
            }
            Delete.deleteAll(md, deleteGroups);
        }
    }

    public static void resetOldGroupLeaders(Collection<OccGroupObj> oldGroups, Collection<EgressAgent> agents, MerlinData md) {
        for (OccGroupObj group : oldGroups) {
            EgressAgent leader = group.getProperty(OccGroupObj.PROP_GROUP_LEADER);
            if (leader == null || !agents.contains(leader)) continue;
            Undo.insertUndoEntry_propRestore(md, Arrays.asList(group), OccGroupObj.PROP_GROUP_LEADER);
            Undo.insertUndoEntry_propRestore(md, Arrays.asList(group), OccGroupObj.PROP_REQUIRES_GROUP_LEADER);
            group.setProperty(OccGroupObj.PROP_GROUP_LEADER, null);
            group.setProperty(OccGroupObj.PROP_REQUIRES_GROUP_LEADER, Boolean.valueOf(false));
        }
    }

    public static void removeAgentFromCurrentMovementGroup(EgressAgent agt, MerlinData md) {
        for (Proxy<? extends ICompElement> proxy : md.proxies.getProxies(agt)) {
            Object parent = md.hierarchy.getParent(proxy);
            if (!(parent instanceof OccGroupObj)) continue;
            Undo.insertUndoEntry_insert(md, proxy);
            ((OccGroupObj)parent).remove(proxy);
        }
    }

    private static void assignProfiles(SizeConstrainedKMeans.Cluster c, MerlinData md) {
        if (c.groupTemplate.getProperty(OccGroupTypeObj.PROP_SPECIFY_PROFILES).booleanValue()) {
            int i;
            int count;
            assert (c.profilePrefCounts != null);
            Set<EgressAgent> members = c.getMembers();
            Iterator<EgressAgent> membersIt = members.iterator();
            Undo.insertUndoEntry_propRestore(md, members, OccProfile.PROP_PROF_PARENT);
            for (OccProfile prof : c.profileMinCounts.keySet()) {
                count = c.profileMinCounts.get(prof);
                for (i = 0; i < count; ++i) {
                    membersIt.next().setProfileParent(prof);
                }
            }
            for (OccProfile prof : c.profilePrefCounts.keySet()) {
                count = c.profilePrefCounts.get(prof) - c.profileMinCounts.get(prof);
                for (i = 0; i < count; ++i) {
                    if (!membersIt.hasNext()) {
                        return;
                    }
                    membersIt.next().setProfileParent(prof);
                }
            }
        }
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(EgressAgent.class));
    }

    private CreateGroupsDlg newCreateGroupsDlg(JFrame activeFrame, MerlinData md) {
        if (s_createGroupsDlg == null) {
            s_createGroupsDlg = new CreateGroupsDlg((Window)activeFrame, md);
        }
        return s_createGroupsDlg;
    }

    public static class CreateGroupsDlg
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private guiCheckBox d_cbRestrictRoom;
        private guiRadioButton d_rbExact;
        private guiRadioButton d_rbFast;
        private guiUnitDoubleField d_heightMultiplier;
        private DistributionEditor<OccGroupTypeObj> d_groupTemplateChooser;

        public CreateGroupsDlg(Window owner, MerlinData md) {
            super(owner, actionName, 9);
            this.d_groupTemplateChooser = new DistributionEditor<OccGroupTypeObj>(md, Intl.intl("Movement Group Templates"), md.occGroupTypes, OccGroupTypeObj.class, null);
            this.d_groupTemplateChooser.setExtraObjs(data -> Collections.singleton(data.occGroupTypes.NO_GROUP_TYPE));
            this.d_groupTemplateChooser.updateAvailable();
            guiLabel lDistCalc = new guiLabel(Intl.intl("Distance Calculation:"));
            lDistCalc.setToolTipText(Intl.intl("Method for distance calculation used in group creation."));
            this.d_cbRestrictRoom = new guiCheckBox(Intl.intl("Restrict Members to Same Room"));
            this.d_cbRestrictRoom.setToolTipText(Intl.intl("Specify whether the group members have to be in the same room at the time of group creation."));
            this.d_cbRestrictRoom.setSelected(true);
            this.d_rbExact = new guiRadioButton(Intl.intl("Travel Distance"));
            this.d_rbExact.setToolTipText(Intl.intl("Travel distance calculation uses length of occupant paths."));
            this.d_rbFast = new guiRadioButton(Intl.intl("Geometric Distance"));
            this.d_rbFast.setToolTipText(Intl.intl("Geometric distance calculation uses Euclidean distance."));
            guiUtil.group(new AbstractButton[]{this.d_rbExact, this.d_rbFast});
            this.d_rbExact.setSelected(true);
            guiLabel lHeightMult = new guiLabel(Intl.intl("Height Multiplier:"));
            lHeightMult.setToolTipText(Intl.intl("Multiplies distance in the vertical direction so that groups are not formed across floors."));
            this.d_heightMultiplier = new guiUnitDoubleField(Unit.ONE, UnitDoubleVR.above(1.0, Unit.ONE, true));
            LinkStatus.link2((AbstractButton)this.d_rbFast, this.d_heightMultiplier, lHeightMult);
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(Intl.intl("Movement Group Templates:"));
            gb.addIdentRow(this.d_groupTemplateChooser, 2);
            gb.addRow(this.d_cbRestrictRoom, 2);
            gb.addRow(lDistCalc);
            gb.indent();
            gb.addRow(this.d_rbExact);
            gb.addRow(this.d_rbFast, new double[]{1.0, 0.0}, GridBagHelper.REMAINING);
            gb.addIdentRow(lHeightMult, this.d_heightMultiplier, new double[]{1.0, 0.0}, GridBagHelper.REMAINING);
            gb.unindent();
        }

        public boolean isRestrictRooms() {
            return this.d_cbRestrictRoom.isSelected();
        }

        public double getHeightMultiplier() {
            return ((UnitDouble)this.d_heightMultiplier.getValue()).get(Unit.ONE);
        }

        public boolean isExactCalc() {
            return this.d_rbExact.isSelected();
        }

        public IUrn<OccGroupTypeObj> getGroupTemplates() {
            return (IUrn)this.d_groupTemplateChooser.getValue();
        }
    }

    public static class SizeConstrainedKMeans {
        private final Algorithm algorithm;
        private final DistanceMetric distanceMetric;
        private static final int ITERATION_LIMIT = 100;
        private static final int PARALLEL_ALL_OCCS_LIST_SIZE = 1000;
        private static final int PARALLEL_CLUSTER_COUNT = 300;
        private static final double ASTAR_MAX_DIST_LIMIT = Double.MAX_VALUE;
        private static final double ASTAR_MAX_DIST = Double.POSITIVE_INFINITY;
        private static final double MAX_NUM_RETRIES = 10.0;
        private static final int PRINT_SIZE_LIMIT = 100;
        private final boolean shouldPrint;
        private List<EgressAgent> agents;
        private List<EgressAgent> initCenters;
        private Random rnd;
        private List<Cluster> clusters;
        private List<DataPoint> dataPoints;
        private IUrn<OccGroupTypeObj> groupTemplates;
        private MerlinData md;
        private InfernoUtil.InfernoGetter infernoGetter;
        private Set<EgressAgent> unclusteredOccupants = new LinkedHashSet<EgressAgent>();
        private Map<SearchPair, Double> distanceCache = new HashMap<SearchPair, Double>();
        private final double heightMultiplier;
        private TaskProgress progress;
        public IEgressOccupiable room;
        private final Function<DataPoint, Double> distFn = dataPoint -> {
            double minDist = Double.MAX_VALUE;
            double maxDist = -1.7976931348623157E308;
            for (Cluster c : this.clusters) {
                double dist;
                if (!c.canJoin((DataPoint)dataPoint) || (dist = this.distance((DataPoint)dataPoint, c.center)) == Double.POSITIVE_INFINITY) continue;
                if (dist < minDist) {
                    minDist = dist;
                }
                if (!(dist > maxDist)) continue;
                maxDist = dist;
            }
            return minDist - maxDist;
        };
        private final Function<DataPoint, Double> currDeltaFn = dataPoint -> {
            double bestAlternateDist = Double.MAX_VALUE;
            Cluster current = dataPoint.currentCluster.cluster;
            double currentDist = dataPoint.currentCluster.distance;
            for (Cluster c : this.clusters) {
                double dist;
                if (c == current || (dist = this.distance((DataPoint)dataPoint, c.center)) == Double.POSITIVE_INFINITY || !(dist < bestAlternateDist)) continue;
                bestAlternateDist = dist;
            }
            return bestAlternateDist - currentDist;
        };
        private final BiFunction<SearchPair<Point3d>, Double, Double> getPathDistance = (searchPair, radius) -> {
            Optional<Double> dist = this.infernoGetter.getPathLength((Point3d)searchPair.v1, (Point3d)searchPair.v2, (double)radius, Double.MAX_VALUE, this.md);
            return dist.orElse(Double.POSITIVE_INFINITY);
        };
        private final Comparator<DataPoint> initComparator = (dp1, dp2) -> (int)Math.signum(this.distFn.apply((DataPoint)dp1) - this.distFn.apply((DataPoint)dp2));
        private final Comparator<DataPoint> currDeltaComparator = (dp1, dp2) -> (int)Math.signum(this.currDeltaFn.apply((DataPoint)dp1) - this.currDeltaFn.apply((DataPoint)dp2));
        private ClusteringResult currentBestSolution;

        public SizeConstrainedKMeans(List<EgressAgent> agents, boolean useExactCalc, double heightMultiplier, Random rnd, IUrn<OccGroupTypeObj> groupTemplates, InfernoUtil.InfernoGetter infernoGetter, TaskProgress progress) {
            this.heightMultiplier = heightMultiplier;
            this.agents = agents;
            this.groupTemplates = groupTemplates;
            this.infernoGetter = infernoGetter;
            this.progress = progress;
            this.initCenters = new ArrayList<EgressAgent>(agents);
            this.rnd = rnd;
            boolean bl = this.shouldPrint = System.getProperty("debug-grouping") != null;
            if (useExactCalc) {
                this.algorithm = Algorithm.K_MEDOIDS;
                this.distanceMetric = DistanceMetric.ASTAR;
            } else {
                this.algorithm = Algorithm.K_MEANS;
                this.distanceMetric = heightMultiplier != 0.0 ? DistanceMetric.EUCLIDEAN_PENALIZED_HEIGHT : DistanceMetric.EUCLIDEAN;
            }
        }

        public ClusteringResult cluster() throws CancellationException {
            if (this.agents.size() > 100) {
                System.out.println("Clustering " + this.agents.size() + " occupants...");
            }
            boolean initialized = this.initialize();
            if (this.shouldPrint) {
                System.out.println("Initialization output:");
            }
            this.printState(0);
            if (initialized) {
                this.progress.check();
                boolean change = true;
                int i = 0;
                while (change && i++ < 100) {
                    this.progress.setMessage(this.room != null ? String.format(Intl.intl("%s: Improving movement groups, iteration %d"), this.room.getName(), i) : String.format(Intl.intl("Improving movement groups, iteration %d"), i));
                    change = this.iteration();
                    if (this.shouldPrint) {
                        System.out.println("Iteration " + i + " finished");
                    }
                    if (!change) continue;
                    this.progress.check();
                }
                if (this.shouldPrint) {
                    System.out.println("Verifying clusters...");
                }
                this.progress.setMessage(this.room != null ? String.format(Intl.intl("%s: Verifying created movement groups"), this.room.getName()) : Intl.intl("Verifying created movement groups"));
                this.verifyClusters();
                if (this.shouldPrint) {
                    System.out.println("Clustering output:");
                }
                this.printState(i);
            }
            ClusteringResult result = new ClusteringResult(this.clusters, this.unclusteredOccupants);
            this.currentBestSolution = null;
            return result;
        }

        private boolean iteration() {
            LinkedHashSet<Cluster> invalidClusters = null;
            for (Cluster c : this.clusters) {
                this.progress.check();
                c.updateCenter();
                if (c.center != null) continue;
                if (invalidClusters == null) {
                    invalidClusters = new LinkedHashSet<Cluster>();
                }
                invalidClusters.add(c);
            }
            if (invalidClusters != null) {
                this.clusters.removeAll(invalidClusters);
            }
            if (this.dataPoints.size() > 1000 && this.distanceMetric.equals((Object)DistanceMetric.ASTAR)) {
                this.updateDistancesParallel();
            } else {
                for (DataPoint d : this.dataPoints) {
                    d.updateDistances();
                }
            }
            this.dataPoints.sort(this.currDeltaComparator);
            boolean change = false;
            block2: for (DataPoint dataPoint : this.dataPoints) {
                this.progress.check();
                for (ClusterView cv : dataPoint.clusterViews) {
                    if (cv == dataPoint.currentCluster || cv.distance == Double.POSITIVE_INFINITY) continue;
                    double gain = dataPoint.gain(cv, false);
                    double gainForSwap = dataPoint.gain(cv, true);
                    for (DataPoint other : cv.cluster.willLeave) {
                        double otherGain = other.gain(other.getClusterView(dataPoint.currentCluster.cluster), true);
                        if (!(gainForSwap + otherGain > 0.0)) continue;
                        this.swap(dataPoint, other);
                        if (this.shouldPrint) {
                            System.out.println("SWAP: " + String.valueOf(dataPoint) + "<->" + String.valueOf(other));
                        }
                        change = true;
                        continue block2;
                    }
                    if (gain > 0.0 && cv.cluster.canJoin(dataPoint) && dataPoint.currentCluster.cluster.canLeave(dataPoint)) {
                        dataPoint.currentCluster.cluster.removeDataPoint(dataPoint);
                        dataPoint.currentCluster = dataPoint.getClusterView(cv.cluster);
                        cv.cluster.addDataPoint(dataPoint);
                        change = true;
                        if (!this.shouldPrint) continue block2;
                        System.out.println("TRANSFER: " + String.valueOf(dataPoint) + " TO: " + String.valueOf(cv.cluster.center));
                        continue block2;
                    }
                    if (dataPoint.currentCluster.cluster == dataPoint.clusterViews.get((int)0).cluster || dataPoint.currentCluster.cluster.willLeave.contains(dataPoint)) continue;
                    dataPoint.currentCluster.cluster.willLeave.add(dataPoint);
                    dataPoint.clusterViews.get((int)0).cluster.reservations.add(dataPoint);
                    dataPoint.reservation = dataPoint.clusterViews.get((int)0).cluster;
                    change = true;
                    if (!this.shouldPrint) continue;
                    System.out.println("RESERVATION: " + String.valueOf(dataPoint) + " AT: " + String.valueOf(dataPoint.clusterViews.get((int)0).cluster.center));
                }
            }
            this.saveCurrentBestSolution();
            return change;
        }

        private void saveCurrentBestSolution() {
            ArrayList<Cluster> clustersSnapshot = new ArrayList<Cluster>();
            for (Cluster c : this.clusters) {
                clustersSnapshot.add(c.clone());
            }
            LinkedHashSet<EgressAgent> unclusteredOccupantsSnapshot = new LinkedHashSet<EgressAgent>(this.unclusteredOccupants);
            this.currentBestSolution = new ClusteringResult(clustersSnapshot, unclusteredOccupantsSnapshot);
        }

        public ClusteringResult getCurrentBestSolution() {
            return this.currentBestSolution;
        }

        private void swap(DataPoint dp1, DataPoint dp2) {
            ClusterView cv1 = dp1.currentCluster;
            ClusterView cv2 = dp2.currentCluster;
            dp1.currentCluster = dp1.getClusterView(cv2.cluster);
            dp2.currentCluster = dp2.getClusterView(cv1.cluster);
            cv1.cluster.removeDataPoint(dp1);
            cv2.cluster.removeDataPoint(dp2);
            cv1.cluster.addDataPoint(dp2, true);
            cv2.cluster.addDataPoint(dp1, true);
            cv1.cluster.willLeave.remove(dp1);
            cv2.cluster.willLeave.remove(dp2);
            cv1.cluster.reservations.remove(dp2);
            cv2.cluster.reservations.remove(dp1);
            Consumer<DataPoint> removeReservation = dataPoint -> {
                if (dataPoint.reservation != null) {
                    dataPoint.reservation.reservations.remove(dataPoint);
                    dataPoint.reservation = null;
                }
            };
            removeReservation.accept(dp1);
            removeReservation.accept(dp2);
        }

        private boolean initialize() {
            int numAgents;
            this.progress.setMessage(this.room != null ? String.format(Intl.intl("%s: Initializing movement groups"), this.room.getName()) : Intl.intl("Initializing movement groups"));
            int remaining = numAgents = this.agents.size();
            this.clusters = new ArrayList<Cluster>();
            HashMap<EgressAgent, Cluster> agentToClusterMap = new HashMap<EgressAgent, Cluster>();
            int numRetries = 0;
            while (remaining > 0 && (double)numRetries < 10.0) {
                this.progress.check();
                OccGroupTypeObj groupTemplate = this.groupTemplates.getValue(this.rnd);
                OccGroupTypeObj.GroupCreationDataObj groupCreationData = groupTemplate.getGroupCreationData(this.rnd);
                ICurve prefNumberOfMembers = groupCreationData.prefNumberOfMembers;
                boolean allowSmallerGroups = groupCreationData.allowSmallerGroups;
                ICurve minNumberOfMembers = groupCreationData.minNumberOfMembers;
                int prefSize = Math.max((int)Math.round(prefNumberOfMembers.getValue(this.rnd).get(Unit.ONE)), 1);
                int minSize = Math.max(allowSmallerGroups ? Math.min((int)Math.round(minNumberOfMembers.getValue(this.rnd).get(Unit.ONE)), prefSize) : prefSize, 1);
                if (remaining < minSize) {
                    ++numRetries;
                    continue;
                }
                Cluster c = new Cluster(groupTemplate, minSize, prefSize, groupCreationData.profilePrefCounts, groupCreationData.profileMinCounts, this, true);
                this.clusters.add(c);
                agentToClusterMap.put(c.center.initCentroid, c);
                remaining -= prefSize;
            }
            if (this.clusters.isEmpty()) {
                this.unclusteredOccupants.addAll(this.agents);
                return false;
            }
            this.dataPoints = new ArrayList<DataPoint>();
            for (EgressAgent agent : this.agents) {
                this.progress.check();
                DataPoint d = new DataPoint(agent, this);
                this.dataPoints.add(d);
                if (!agentToClusterMap.containsKey(agent)) continue;
                ((Cluster)agentToClusterMap.get((Object)agent)).center.dataPoint = d;
            }
            if (this.dataPoints.size() > 1000 && this.distanceMetric.equals((Object)DistanceMetric.ASTAR)) {
                this.precomputeCache();
            }
            ArrayList<DataPoint> remainingData = new ArrayList<DataPoint>(this.dataPoints);
            while (!remainingData.isEmpty()) {
                this.progress.check();
                remainingData.sort(this.initComparator);
                ArrayList<DataPoint> toRemove = new ArrayList<DataPoint>();
                for (DataPoint dataPoint : remainingData) {
                    this.progress.check();
                    Cluster c = this.getNearestCluster(dataPoint);
                    boolean forceAdd = false;
                    if (c == null) {
                        c = this.clusters.get(this.rnd.nextInt(this.clusters.size()));
                        forceAdd = true;
                    }
                    if (!c.addDataPoint(dataPoint, forceAdd)) continue;
                    dataPoint.currentCluster = dataPoint.getClusterView(c);
                    toRemove.add(dataPoint);
                }
                remainingData.removeAll(toRemove);
            }
            this.saveCurrentBestSolution();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void precomputeCache() {
            HashSet<SearchPair<EgressAgent>> searchPairs = new HashSet<SearchPair<EgressAgent>>();
            for (DataPoint d : this.dataPoints) {
                for (Cluster cluster : this.clusters) {
                    searchPairs.add(new SearchPair<EgressAgent>(d.agent, cluster.center.dataPoint.agent));
                }
            }
            ExecutorService executor = null;
            try {
                executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                HashMap<SearchPair<Point3d>, Future<Double>> futures = new HashMap<SearchPair<Point3d>, Future<Double>>();
                for (SearchPair searchPair : searchPairs) {
                    this.progress.check();
                    SearchPair<Point3d> pathPair = new SearchPair<Point3d>(((EgressAgent)searchPair.v1).getLocation(), ((EgressAgent)searchPair.v2).getLocation());
                    Future<Double> future = executor.submit(() -> {
                        double rad = 0.5 * Math.max(((EgressAgent)sp.v1).getGeomShoulderWidth(false).getValue(SI.METER), ((EgressAgent)sp.v2).getGeomShoulderWidth(false).getValue(SI.METER));
                        double d = this.getPathDistance.apply(pathPair, rad);
                        return d;
                    });
                    futures.put(pathPair, future);
                }
                for (Map.Entry entry : futures.entrySet()) {
                    this.progress.check();
                    try {
                        this.distanceCache.put((SearchPair)entry.getKey(), (Double)((Future)entry.getValue()).get());
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            finally {
                if (executor != null) {
                    executor.shutdownNow();
                }
            }
        }

        private void updateDistancesParallel() {
            this.infernoGetter.updateClusteringDistancesParallel(this.dataPoints);
        }

        private void verifyClusters() {
            Function<Cluster, Boolean> verifyCluster = c -> {
                if (c.center.dataPoint == null) {
                    c.center.dataPoint = c.members.iterator().next();
                }
                ClusterCenter medoid = c.center;
                assert (medoid.dataPoint != null);
                ArrayList<DataPoint> toRemove = null;
                for (DataPoint d : c.members) {
                    double dist;
                    if (d == medoid.dataPoint || (dist = this.distance(d, c.center, DistanceMetric.ASTAR)) != Double.POSITIVE_INFINITY) continue;
                    if (toRemove == null) {
                        toRemove = new ArrayList<DataPoint>();
                    }
                    toRemove.add(d);
                    this.unclusteredOccupants.add(d.agent);
                }
                if (toRemove != null) {
                    c.members.removeAll(toRemove);
                }
                if (c.members.size() < c.minSize) {
                    for (DataPoint d : c.members) {
                        this.unclusteredOccupants.add(d.agent);
                    }
                    return false;
                }
                if (c.members.size() > c.prefSize) {
                    ArrayList<DataPoint> membersList = new ArrayList<DataPoint>(c.members);
                    membersList.sort((dp1, dp2) -> (int)Math.signum(dp2.currentCluster.distance - dp1.currentCluster.distance));
                    for (int i = 0; i < membersList.size() - c.prefSize; ++i) {
                        DataPoint extra = (DataPoint)membersList.get(i);
                        this.unclusteredOccupants.add(extra.agent);
                        c.members.remove(extra);
                    }
                }
                return true;
            };
            HashSet<Cluster> toRemove = new HashSet<Cluster>();
            if (this.clusters.size() < 300) {
                for (Cluster c2 : this.clusters) {
                    if (verifyCluster.apply(c2).booleanValue()) continue;
                    toRemove.add(c2);
                }
            } else {
                this.infernoGetter.verifyClusters(this.clusters, verifyCluster, toRemove);
            }
            this.clusters.removeAll(toRemove);
        }

        private Cluster getNearestCluster(DataPoint dataPoint) {
            double minDist = Double.MAX_VALUE;
            Cluster closest = null;
            for (Cluster c : this.clusters) {
                double dist;
                if (!c.canJoin(dataPoint) || (dist = this.distance(dataPoint, c.center)) == Double.POSITIVE_INFINITY || !(dist < minDist)) continue;
                minDist = dist;
                closest = c;
            }
            return closest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double distance(DataPoint point, ClusterCenter center, DistanceMetric distanceMetric) {
            switch (distanceMetric) {
                case EUCLIDEAN_PENALIZED_HEIGHT: {
                    Point3d b2 = new Point3d(center.position);
                    double deltaZ = center.position.z - point.agent.getLocation().z;
                    b2.z += (this.heightMultiplier - 1.0) * deltaZ;
                    return point.agent.getLocation().distance(b2);
                }
                case ASTAR: {
                    SearchPair<Point3d> pair = new SearchPair<Point3d>(point.agent.getLocation(), center.dataPoint.agent.getLocation());
                    Map<SearchPair, Double> deltaZ = this.distanceCache;
                    synchronized (deltaZ) {
                        if (!this.distanceCache.containsKey(pair)) {
                            double rad = 0.5 * Math.max(point.agent.getGeomShoulderWidth(false).getValue(SI.METER), center.dataPoint.agent.getGeomShoulderWidth(false).getValue(SI.METER));
                            double d = this.getPathDistance.apply(pair, rad);
                            this.distanceCache.put(pair, d);
                        }
                    }
                    double dist = this.distanceCache.get(pair);
                    return dist;
                }
            }
            return point.agent.getLocation().distance(center.position);
        }

        private double distance(DataPoint dataPoint, ClusterCenter center) {
            return this.distance(dataPoint, center, this.distanceMetric);
        }

        private void printState(int iteration) {
            if (!this.shouldPrint) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(iteration).append(": ");
            for (Cluster c : this.clusters) {
                sb.append("[");
                boolean first = true;
                for (DataPoint d : c.members) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(d.toString());
                }
                sb.append("] ");
            }
            sb.append("\n Unclustered occupants:\n");
            for (EgressAgent a : this.unclusteredOccupants) {
                sb.append(a.getName() + ", ");
            }
            System.out.println(sb.toString());
        }

        private static ICurve discretizeCurve(ICurve curve) {
            if (curve == null) {
                return null;
            }
            if (curve instanceof ConstantCurve) {
                return curve;
            }
            Unit unit = curve.getAvg().getUnit();
            double min = curve.getMin().get(unit);
            double max = curve.getMax().get(unit);
            min = min == Math.floor(min) ? min - 0.5 : Math.floor(min) + 0.5;
            max = Math.floor(max) + 0.5;
            UnitDouble minUD = new UnitDouble(min, unit);
            UnitDouble maxUD = new UnitDouble(max, unit);
            if (curve instanceof UniformCurve) {
                return new UniformCurve(minUD, maxUD);
            }
            if (curve instanceof StdNormCurve) {
                return new StdNormCurve(minUD, maxUD, curve.getAvg(), ((StdNormCurve)curve).getStdDev());
            }
            if (curve instanceof LogNormCurve) {
                return new LogNormCurve(minUD, maxUD, curve.getAvg(), ((LogNormCurve)curve).getStdDev());
            }
            assert (false);
            return null;
        }

        private static enum Algorithm {
            K_MEANS,
            K_MEDOIDS;

        }

        private static enum DistanceMetric {
            EUCLIDEAN,
            EUCLIDEAN_PENALIZED_HEIGHT,
            ASTAR;

        }

        public static class ClusteringResult {
            public final List<Cluster> clusters;
            public final Set<EgressAgent> unClusteredOccs;

            public ClusteringResult(List<Cluster> clusters, Set<EgressAgent> unClusteredOccs) {
                this.clusters = clusters;
                this.unClusteredOccs = unClusteredOccs;
            }
        }

        public static class Cluster {
            private int minSize;
            private int prefSize;
            private SizeConstrainedKMeans kmeans;
            private Set<DataPoint> members;
            private Set<DataPoint> willLeave;
            private Set<DataPoint> reservations;
            ClusterCenter center;
            public final OccGroupTypeObj groupTemplate;
            public final Map<OccProfile, Integer> profilePrefCounts;
            private Map<OccProfile, Integer> profileMinCounts;

            public Cluster(OccGroupTypeObj groupTemplate, int minSize, int prefSize, Map<OccProfile, Integer> profilePrefCounts, Map<OccProfile, Integer> profileMinCounts, SizeConstrainedKMeans kMeans, boolean initCenter) {
                this.groupTemplate = groupTemplate;
                this.minSize = minSize;
                this.prefSize = prefSize;
                this.profilePrefCounts = profilePrefCounts;
                this.profileMinCounts = profileMinCounts;
                this.kmeans = kMeans;
                this.members = new LinkedHashSet<DataPoint>();
                this.willLeave = new LinkedHashSet<DataPoint>();
                this.reservations = new LinkedHashSet<DataPoint>();
                if (initCenter) {
                    this.initCenter();
                }
            }

            public int getSize() {
                return this.members.size();
            }

            public void updateCenter() {
                switch (this.kmeans.algorithm) {
                    case K_MEANS: {
                        this.center = this.updateCenterMean();
                        break;
                    }
                    case K_MEDOIDS: {
                        this.center = this.updateCenterMedoid();
                    }
                }
            }

            private ClusterCenter updateCenterMean() {
                Point3d center = new Point3d();
                for (DataPoint d : this.members) {
                    center.add(d.agent.getLocation());
                }
                center.scale(1.0 / (double)this.members.size());
                return new ClusterCenter(center);
            }

            private ClusterCenter updateCenterMedoid() {
                double minDist = Double.MAX_VALUE;
                ClusterCenter newCenter = null;
                ArrayList<DataPoint> reservationsList = new ArrayList<DataPoint>(this.reservations);
                Collections.sort(reservationsList, (dp1, dp2) -> (int)Math.signum(dp2.getClusterView((Cluster)this).distance - dp1.getClusterView((Cluster)this).distance));
                for (DataPoint d : this.members) {
                    ClusterCenter c = new ClusterCenter(d);
                    double totalDist = this.getInClusterDistance(c, reservationsList);
                    if (!(totalDist < minDist)) continue;
                    minDist = totalDist;
                    newCenter = c;
                }
                if (newCenter == null) {
                    if (this.members.isEmpty()) {
                        return null;
                    }
                    return new ClusterCenter(this.members.iterator().next());
                }
                return newCenter;
            }

            private double getInClusterDistance(ClusterCenter medoid, List<DataPoint> reservationsList) {
                double totalDist = 0.0;
                for (DataPoint d : this.members) {
                    if (d == medoid.dataPoint) continue;
                    totalDist += this.kmeans.distance(d, medoid);
                }
                if (!reservationsList.isEmpty()) {
                    double baseDist = reservationsList.get((int)0).getClusterView((Cluster)this).distance;
                    for (DataPoint d : reservationsList) {
                        double weight = d.getClusterView((Cluster)this).distance / baseDist;
                        totalDist += weight * this.kmeans.distance(d, medoid);
                    }
                }
                return totalDist;
            }

            public boolean canJoin(DataPoint datapoint) {
                return this.members.size() < this.prefSize;
            }

            public boolean canLeave(DataPoint datapoint) {
                return this.members.size() > this.minSize;
            }

            public boolean canSwap(DataPoint currentMeber, DataPoint newMember) {
                return true;
            }

            public boolean addDataPoint(DataPoint dataPoint) {
                return this.addDataPoint(dataPoint, false);
            }

            public boolean addDataPoint(DataPoint dataPoint, boolean forceAdd) {
                if (!forceAdd && !this.canJoin(dataPoint)) {
                    return false;
                }
                this.members.add(dataPoint);
                this.reservations.remove(dataPoint);
                return true;
            }

            public void removeDataPoint(DataPoint dataPoint) {
                this.members.remove(dataPoint);
                this.willLeave.remove(dataPoint);
            }

            private void initCenter() {
                EgressAgent centroid = this.kmeans.initCenters.remove(this.kmeans.rnd.nextInt(this.kmeans.initCenters.size()));
                this.center = new ClusterCenter(centroid);
            }

            public Set<EgressAgent> getMembers() {
                LinkedIdentityHashSet<EgressAgent> ret = new LinkedIdentityHashSet<EgressAgent>();
                for (DataPoint d : this.members) {
                    if (d.agent == null) continue;
                    ret.add(d.agent);
                }
                return ret;
            }

            public int getMinSize() {
                return this.minSize;
            }

            public int getPrefSize() {
                return this.prefSize;
            }

            public Cluster clone() {
                Cluster clone = new Cluster(this.groupTemplate, this.minSize, this.prefSize, this.profilePrefCounts, this.profileMinCounts, this.kmeans, false);
                clone.members = new LinkedHashSet<DataPoint>(this.members);
                return clone;
            }
        }

        static class ClusterCenter {
            public Point3d position;
            public DataPoint dataPoint;
            private EgressAgent initCentroid;

            public ClusterCenter(DataPoint d) {
                this.position = d.agent.getLocation();
                this.dataPoint = d;
            }

            public ClusterCenter(Point3d position) {
                this.position = position;
            }

            public ClusterCenter(EgressAgent centroid) {
                this.initCentroid = centroid;
                this.position = centroid.getLocation();
            }

            public String toString() {
                return this.dataPoint != null ? this.dataPoint.toString() : this.position.toString();
            }
        }

        public static class DataPoint {
            public Cluster reservation;
            final EgressAgent agent;
            private final SizeConstrainedKMeans kmeans;
            private final List<ClusterView> clusterViews;
            private final Map<Cluster, ClusterView> clusterMap;
            private ClusterView currentCluster;

            public DataPoint(EgressAgent agent, SizeConstrainedKMeans kmeans) {
                assert (agent != null);
                this.agent = agent;
                this.kmeans = kmeans;
                this.clusterViews = new ArrayList<ClusterView>();
                HashMap<Cluster, ClusterView> clusterMap = new HashMap<Cluster, ClusterView>();
                for (Cluster c : kmeans.clusters) {
                    ClusterView cv = new ClusterView(c);
                    this.clusterViews.add(cv);
                    clusterMap.put(c, cv);
                }
                this.clusterMap = Collections.unmodifiableMap(clusterMap);
            }

            public ClusterView getClusterView(Cluster cluster) {
                return this.clusterMap.get(cluster);
            }

            public double gain(ClusterView cv, boolean forSwap) {
                double curDist = this.currentCluster.distance;
                double alternateDist = cv.distance;
                if (forSwap && cv.cluster.members.size() == 1) {
                    alternateDist = 0.0;
                }
                return curDist - alternateDist;
            }

            public void updateDistances() {
                for (ClusterView cv : this.clusterViews) {
                    this.kmeans.progress.check();
                    cv.distance = cv.cluster.center != null ? this.kmeans.distance(this, cv.cluster.center) : Double.MAX_VALUE;
                }
                this.clusterViews.sort((c1, c2) -> Double.compare(c1.distance, c2.distance));
            }

            public String toString() {
                return this.agent.getName();
            }
        }

        private static class ClusterView {
            public double distance;
            private final Cluster cluster;

            public ClusterView(Cluster c) {
                this.cluster = c;
            }
        }

        public static class SearchPair<T> {
            private final T v1;
            private final T v2;

            public SearchPair(T v1, T v2) {
                this.v1 = v1;
                this.v2 = v2;
            }

            public int hashCode() {
                return this.v1.hashCode() + this.v2.hashCode();
            }

            public boolean equals(Object other) {
                if (!(other instanceof SearchPair)) {
                    return false;
                }
                SearchPair otherPair = (SearchPair)other;
                return this.v1.equals(otherPair.v1) && this.v2.equals(otherPair.v2) || this.v1.equals(otherPair.v2) && this.v2.equals(otherPair.v1);
            }
        }
    }
}

