/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CancelledException;
import merlin.actions.Delete;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.geomops.SeparateGeom;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressModelGeom;
import merlin.data.egress.geom.EgressRoom;
import merlin.geom.Geometry;
import merlin.geom.ModelConstrictor;
import merlin.gui.MerlinUDF;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class CloseGapsAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new CloseGapsAction(), Intl.intl("Close Gaps...,-,Close small gaps in the room by adding boundary edges."));
    private UnitDouble d_gapTol = new UnitDouble(6.0, NonSI.INCH);
    private UnitDouble d_minRoomArea = CloseGapsAction.mulArea(this.d_gapTol, this.d_gapTol);

    public CloseGapsAction() {
        SelectionObserver.add(this, EgressRoom.class);
        this.update(null);
    }

    protected Set<EgressRoom> getValidRooms(MerlinData md) {
        return theUtil.filter(md.selection.getDeepSelected(EgressRoom.class), new Predicate<EgressRoom>(this){

            @Override
            public boolean test(EgressRoom o) {
                return o.getModificationsAllowed();
            }
        });
    }

    @Override
    public void update(Events events) {
        this.setEnabled(MerlinApp.getApp().getData().selection.isExclusive(EgressRoom.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        MerlinUDF tolFld = new MerlinUDF(6);
        tolFld.setValueRange(UnitDoubleVR.above(0.0, SI.METER, false));
        tolFld.setValue(this.d_gapTol);
        guiCheckBox keepLargeRoomsCB = new guiCheckBox(Intl.intl("Delete small, split-off rooms"), this.d_minRoomArea != null);
        MerlinUDF minRoomAreaFld = new MerlinUDF(4);
        minRoomAreaFld.setValueRange(UnitDoubleVR.above(0.0, SIUS.unit(4), false));
        minRoomAreaFld.setValue(this.d_minRoomArea == null ? CloseGapsAction.mulArea(this.d_gapTol, this.d_gapTol) : this.d_minRoomArea);
        LinkStatus.link((AbstractButton)keepLargeRoomsCB, minRoomAreaFld);
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Close Gaps"), 9);
        GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
        gb.addRow(Intl.intl("Close gaps smaller than:"), tolFld);
        gb.addRow(keepLargeRoomsCB, 0);
        gb.addIdentRow(Intl.intl("Minimum room area:"), minRoomAreaFld);
        gb.finalizeRows();
        if (dlg.doModal() != 1) {
            return;
        }
        this.d_gapTol = (UnitDouble)tolFld.getValue();
        this.d_minRoomArea = !keepLargeRoomsCB.isSelected() ? null : (UnitDouble)minRoomAreaFld.getValue();
        TaskProgress progress = new TaskProgress();
        guiProgressMonitor pm = new guiProgressMonitor(app.getMainFrame(), Intl.intl("Closing Gaps"), true, progress);
        pm.begin();
        try {
            EgressRoom room;
            LinkedIdentityHashMap<EgressRoom, Model> newRoomGeom = new LinkedIdentityHashMap<EgressRoom, Model>();
            md.beginRead();
            try {
                Set<EgressRoom> rooms = this.getValidRooms(md);
                Iterator<EgressRoom> iterator = rooms.iterator();
                while (iterator.hasNext()) {
                    room = iterator.next();
                    this.checkCancelled(progress);
                    Model model = room.getModel();
                    Model newModel = CloseGapsAction.closeGaps(model, this.d_gapTol.getValue(Geometry.LENGTH_UNIT));
                    if (newModel == model) continue;
                    newRoomGeom.put(room, newModel);
                }
            }
            finally {
                md.endRead();
            }
            this.checkCancelled(progress);
            md.beginWrite();
            try {
                Undo.begin(Intl.intl("Close Gaps"));
                for (Map.Entry entry : newRoomGeom.entrySet()) {
                    room = (EgressRoom)entry.getKey();
                    Model newModel = (Model)entry.getValue();
                    Undo.insertUndoEntry_restore(md, room);
                    room.setGeom(new EgressModelGeom(newModel));
                }
                LinkedIdentityHashSet toClean = new LinkedIdentityHashSet();
                Map<EgressRoom, List<EgressRoom>> map = SeparateGeom.separate(md, newRoomGeom.keySet(), toClean::add);
                if (this.d_minRoomArea != null) {
                    LinkedIdentityHashSet toDelete = new LinkedIdentityHashSet();
                    for (Map.Entry<EgressRoom, List<EgressRoom>> entry : map.entrySet()) {
                        if (entry.getValue().size() <= 1) continue;
                        for (EgressRoom room2 : entry.getValue()) {
                            UnitDouble area = room2.getArea();
                            if (area.compareTo(this.d_minRoomArea) > 0) continue;
                            toDelete.add(room2);
                        }
                    }
                    if (!toDelete.isEmpty()) {
                        toClean.removeAll(toDelete);
                        Delete.deleteAll(md, toDelete);
                    }
                }
                EgressRoom.cleanup(md, toClean);
                Undo.end(md);
            }
            finally {
                md.endWrite();
            }
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            pm.end();
        }
    }

    private static UnitDouble mulArea(UnitDouble a1, UnitDouble a2) {
        double d1 = a1.getValueNoUnit();
        double d2 = a2.getValue(a1.getUnit());
        double result = d1 * d2;
        return new UnitDouble(result, a1.getUnit().multiply(a1.getUnit()));
    }

    public static Model closeGaps(Model model, double gapSize) {
        return CloseGapsAction.closeGaps(model, gapSize, new ModelConstrictor.IEdgeClassifier(){

            @Override
            public boolean isBoundary(Edge edge) {
                return edge.partOfGroup(1);
            }

            @Override
            public boolean isInternal(Edge edge) {
                return !edge.partOfGroup(1);
            }

            @Override
            public boolean canSplit(Edge edge) {
                return true;
            }

            @Override
            public boolean isSplitTarget(Edge edge) {
                return this.isBoundary(edge);
            }
        });
    }

    public static Model closeGaps(Model model, double gapSize, ModelConstrictor.IEdgeClassifier ecfr) {
        if (gapSize <= 0.0) {
            return model;
        }
        Model result = model;
        try {
            List<List<Point3d>> constEdges = ModelConstrictor.findConstrictionEdges(model, ecfr, gapSize);
            for (List<Point3d> constEdge : constEdges) {
                for (int m = 0; m < constEdge.size() - 1; ++m) {
                    Point3d p1 = constEdge.get(m);
                    Point3d p2 = constEdge.get(m + 1);
                    if (result == model) {
                        result = model.clone();
                    }
                    result.addEdge(1, new LineSeg3D(p1, p2));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return model;
        }
        return result;
    }
}

