/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.SimpleOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.blockages.EgressBlockageComp;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.ModelView;
import merlin.mv.tools.IPointPickListener;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.AbstractDlgListener;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapInfo;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.MutableInt;
import thunderheadeng.util.Pair;

public class AlignBlockageNormalAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new AlignBlockageNormalAction(), Intl.intl("Align Obstacle with Plane...,-,Aligns the selected obstacles with a plane."));
    private Vector3d d_lastNormal = null;

    public AlignBlockageNormalAction() {
        SelectionObserver.add(this, EgressBlockage.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(md.selection.isExclusive(EgressBlockage.class, EgressBlockageComp.class) && !md.selection.flatten(EgressBlockage.class, blkg -> blkg.isSearchGeomSettable()).isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        ArrayList<EgressBlockage> blockages;
        final ModelView mv = app.getModelView();
        md.beginRead();
        try {
            blockages = new ArrayList<EgressBlockage>(md.selection.flatten(EgressBlockage.class, blkg -> blkg.isSearchGeomSettable()));
            if (this.d_lastNormal == null) {
                for (EgressBlockage blkg2 : blockages) {
                    IGeomNode node = blkg2.getSearchGeom();
                    if (!node.getChildren().isEmpty() || !(node.getLocalGeom() instanceof ExtrudedPoly)) continue;
                    ExtrudedPoly epoly = (ExtrudedPoly)node.getLocalGeom();
                    this.d_lastNormal = epoly.poly.getPlane(true).getNormal();
                    break;
                }
                if (this.d_lastNormal == null) {
                    this.d_lastNormal = new Vector3d(0.0, 0.0, 1.0);
                }
            }
        }
        finally {
            md.endRead();
        }
        final SetNormalDialog dlg = new SetNormalDialog(app.getMainFrame());
        IPointPickListener pickListener = new IPointPickListener(){

            @Override
            public Pair<SnapMode, IIsectFilter> getSnapInfo(CursorTool tool) {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(GeomType.FACE));
            }

            @Override
            public void pointSnapped(SnapInfo snap) {
                for (IsectInfo ii : snap.snaps) {
                    if (ii.getFaceNormal == null) continue;
                    dlg.load(ii.getFaceNormal.get());
                    return;
                }
            }

            @Override
            public void pointPicked(IMerlinGeomSrc source, UnitPoint3D p) {
            }

            @Override
            public void stopPicking() {
            }
        };
        dlg.load(this.d_lastNormal);
        dlg.addDlgListener(new AbstractDlgListener(){

            @Override
            public void okPressed() {
                SimpleOp op = new SimpleOp((app, md) -> {
                    md.beginWrite();
                    try {
                        Vector3d normal;
                        Undo.begin(Intl.intl("Align Obstacle Plane"));
                        AlignBlockageNormalAction.this.d_lastNormal = normal = dlg.save();
                        int unflattened = AlignBlockageNormalAction.alignNormal(app, md, blockages, normal);
                        Undo.end(md);
                        if (unflattened != 0) {
                            md.uiLater(() -> JOptionPane.showMessageDialog(app.getMainFrame(), String.format(Intl.intl("%d obstacles could not be aligned."), unflattened), Intl.intl("Unaligned Obstacles"), 2));
                        }
                    }
                    finally {
                        md.endWrite();
                    }
                });
                UIHook.run(null, "AlignBlockageNormalAction", op, 0);
                mv.stopChoosingPoints();
            }

            @Override
            public void cancelPressed() {
                mv.stopChoosingPoints();
            }

            @Override
            public void closePressed() {
                mv.stopChoosingPoints();
            }
        });
        dlg.doModeless();
        md.ui(() -> mv.startChoosingPoints(pickListener));
    }

    private static int alignNormal(MerlinApp app, MerlinData md, Collection<? extends EgressBlockage> selObjs, Vector3d normal) {
        MutableInt unaligned = new MutableInt(0);
        for (EgressBlockage egressBlockage : selObjs) {
            IGeomNode node = egressBlockage.getSearchGeom();
            BiConsumer<Point3d, Vector3d> transform = (centroid, pNormal) -> {
                ITransform.ITransformer transformer = node.getLocalTransform().getTransformer();
                pNormal = transformer.transformNew((Vector3d)pNormal);
                Vector3d axis = Util3D.cross(pNormal, normal);
                if (Util3D.safeNormalize(axis, 1.0E-6) == 0.0) {
                    return;
                }
                double angle = Util3D.angle(pNormal, normal, axis);
                if (angle == 0.0) {
                    return;
                }
                centroid = transformer.transformNew((Point3d)centroid);
                ITransform xform = TransformUtil.translate(centroid);
                xform = xform.concatenate(TransformUtil.rotate(axis.x, axis.y, axis.z, angle));
                IGeomNode xformNode = node.transform((xform = xform.concatenate(TransformUtil.translate(-centroid.x, -centroid.y, -centroid.z))).getInfo());
                if (xformNode != node) {
                    Undo.insertUndoEntry_restore(md, blkg);
                    blkg.setSearchGeom(xformNode);
                }
            };
            if (node.isLeaf() && node.getLocalGeom() instanceof ExtrudedPoly) {
                ExtrudedPoly epoly = (ExtrudedPoly)node.getLocalGeom();
                Vector3d pNormal2 = epoly.poly.getNormalIfValid(true);
                if (pNormal2 == null) continue;
                Point3d centroid2 = epoly.poly.getCentroid();
                centroid2 = Util3D.add(centroid2, (Tuple3d)Util3D.scale(epoly.extrusion, 0.5));
                transform.accept(centroid2, pNormal2);
                continue;
            }
            if (node.isLeaf() && node.getLocalGeom() instanceof AABoxGeom) {
                AABoxGeom box = (AABoxGeom)node.getLocalGeom();
                Vector3d pNormal2 = GeomConstants.VEC3D_ZPOS;
                Point3d centroid2 = Util3D.scale(Util3D.add(box.min, (Tuple3d)box.max), 0.5);
                transform.accept(centroid2, pNormal2);
                continue;
            }
            ++unaligned.val;
        }
        return unaligned.val;
    }

    public class SetNormalDialog
    extends guiDialog {
        private static final long serialVersionUID = -1067617725256271244L;
        private final ValueField<Double> d_x;
        private final ValueField<Double> d_y;
        private final ValueField<Double> d_z;

        public SetNormalDialog(Window owner) {
            super(owner, Intl.intl("Set Normal"), 9);
            this.d_x = ValueFields.doubleFld();
            this.d_y = ValueFields.doubleFld();
            this.d_z = ValueFields.doubleFld();
            guiLabel planeLbl = guiUtil.lbl(Intl.intl("Plane Normal:"), Intl.intl("The normal of the plane with which to align the selected obstacles."));
            MultiLineLabel pickFromSceneLbl = new MultiLineLabel(Intl.intl("NOTE: You can also pick the plane by clicking in the 2D/3D View."));
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(planeLbl, Intl.intl("X:"), this.d_x, Intl.intl("Y:"), this.d_y, Intl.intl("Z:"), this.d_z);
            gb.addFilledRow(pickFromSceneLbl);
            gb.finalizeRows();
        }

        public void load(Vector3d normal) {
            this.d_x.setValue(normal.x);
            this.d_y.setValue(normal.y);
            this.d_z.setValue(normal.z);
        }

        public Vector3d save() {
            Vector3d normal = new Vector3d((Double)this.d_x.getValue(), (Double)this.d_y.getValue(), (Double)this.d_z.getValue());
            Util3D.safeNormalize(normal, 0.0);
            return normal;
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            Vector3d normal = this.save();
            if (normal.lengthSquared() == 0.0) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, Intl.intl("The normal vector must have a length greater than 0."), Intl.intl("Invalid Normal"), 2);
                }
                return false;
            }
            return true;
        }
    }
}

