/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import inferno.data2.ANode;
import inferno.data2.AttractorSim;
import inferno.data2.CylinderShape;
import inferno.data2.Mesh;
import inferno.data2.OccTarget;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.ElevatorModel;
import inferno.geom.Inter;
import inferno.geom.Util;
import inferno.geom.VorDensityField;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.occsource.OccSource;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathFilters;
import inferno.vis.DisplayFilter;
import inferno.vis.rend.IRenderer;
import inferno.vis.rend.RendAttractor;
import inferno.vis.rend.RendMeshTri;
import inferno.vis.rend.RendNode;
import inferno.vis.rend.RendOccAgent;
import inferno.vis.rend.RendOccSource;
import inferno.vis.rend.RendOccTarget;
import inferno.vis.rend.RendVertex;
import inferno.vis.rend.RendVorDensityField;
import inferno.vis.rend.RendWingedEdge;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.Sphere;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.colorscheme.ColorMgr;
import thunderheadeng.gui.colorscheme.ColorScheme;
import thunderheadeng.gui.guiStatusMessage;
import thunderheadeng.gui.tool.DefaultDeviceMgr;
import thunderheadeng.gui.tool.IDeviceManager;
import thunderheadeng.gui.tool.SwingKeyboard;
import thunderheadeng.gui.tool.SwingMouse;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.scene3d.SceneColors;
import thunderheadeng.scene3d.nativebuffered.ARenderCounter;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.OverlayLayout;
import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.Scene;
import thunderheadeng.scene3d.nativebuffered.SceneRenderer;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.nativebuffered.Viewport;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CompositeFunc;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.DragFunc;
import thunderheadeng.scene3d.navtools.ISelectionLogic;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.NavtoolUtil;
import thunderheadeng.scene3d.navtools.OrbitFunc;
import thunderheadeng.scene3d.navtools.SelectionFunc;
import thunderheadeng.scene3d.navtools.ZoomFunc;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickConfig;
import thunderheadeng.scene3d.picking.IPickRoot;
import thunderheadeng.scene3d.picking.IPickSession;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypedProp;

public class GLView
extends AWTGLCanvas
implements MouseMotionListener,
MouseListener,
IRenderSurface {
    private static final long serialVersionUID = 1L;
    public final Map<Class<?>, IRenderer<?>> REND_MAP;
    private final Set<IRenderer<?>> d_miscRenderers;
    private final Engine d_engine;
    private final DisplayFilter d_filterMgr;
    private List<?> d_objs;
    private AABox d_bounds;
    private Rectangle d_resize;
    private RenderPanel d_rootPanel = new RenderPanel();
    private final Camera d_camera;
    private final View d_view;
    private final ToolManager d_toolMgr;
    private final CursorTool[] d_tools;
    private final ARenderCounter d_renderCounter = new ARenderCounter(){

        @Override
        protected void forceRender(Viewport vp) {
            GLView.this.repaint(vp.x(), vp.y(), vp.w(), vp.h());
        }

        @Override
        protected Viewport getFullVP() {
            return new Viewport(0, 0, GLView.this.getWidth(), GLView.this.getHeight());
        }
    };
    private PathDebug d_pathDebug = new PathDebug();
    private Set<ANode> d_elevatorNodes;
    boolean once = false;
    private static final Predicate<PathChange> s_pathFilter = PathFilters.filterEdges(Predicates.and(EdgeFilters.rejectAllExits(), EdgeFilters.rejectAllClosedDoors()));

    public GLView(GraphicsDevice gd, PixelFormat pfmt, Engine engine) throws LWJGLException {
        super(gd, pfmt);
        this.REND_MAP = new Hashtable();
        this.REND_MAP.put(Vertex.class, new RendVertex());
        this.REND_MAP.put(WingedEdge.class, new RendWingedEdge());
        this.REND_MAP.put(OccSource.class, new RendOccSource());
        this.REND_MAP.put(Tri.class, new RendMeshTri());
        this.REND_MAP.put(OccAgent.class, new RendOccAgent());
        this.REND_MAP.put(OccTarget.class, new RendOccTarget());
        this.REND_MAP.put(AttractorSim.class, new RendAttractor());
        this.REND_MAP.put(VorDensityField.class, new RendVorDensityField());
        this.REND_MAP.put(ANode.class, new RendNode());
        this.d_filterMgr = new DisplayFilter();
        this.d_toolMgr = new ToolManager(this);
        final ColorMgr d_tempColors = new ColorMgr();
        ColorScheme cs = new ColorScheme("colors");
        cs.setColor(SceneColors.TOOL_COLOR, Color.GREEN);
        cs.setColor(SceneColors.SNAP_POINT_COLOR, Color.GREEN);
        cs.setColor(SceneColors.TOOL_GUIDES_COLOR, Color.GREEN);
        d_tempColors.setCurrentColorScheme(cs);
        IToolController toolController = new IToolController(){
            private final IDeviceManager d_devices = new DefaultDeviceMgr(new SwingKeyboard(), new SwingMouse());

            @Override
            public ModelScene[] getToolScenes() {
                return new ModelScene[2];
            }

            @Override
            public <T> T getPreference(TypedProp<T> pref) {
                return (T)pref.defVal;
            }

            @Override
            public GeomPicker getSnapper() {
                return null;
            }

            @Override
            public ColorMgr getColors() {
                return d_tempColors;
            }

            @Override
            public Component getRenderComp() {
                return GLView.this;
            }

            @Override
            public guiStatusMessage getStatusMessage() {
                return null;
            }

            @Override
            public Unit[] getLengthUnits() {
                return new Unit[]{SI.METER, SI.METER};
            }

            @Override
            public IAnimSession getAnimSession() {
                return null;
            }

            @Override
            public IDeviceManager getDevices() {
                return this.d_devices;
            }

            @Override
            public boolean endTool(Tool tool, boolean cancelled) {
                return GLView.this.d_toolMgr.endTool(tool, cancelled);
            }

            @Override
            public void backgroundTaskStarted(Runnable cancel) {
            }

            @Override
            public void backgroundTaskEnded(Runnable cancelOp) {
            }
        };
        this.d_camera = new OrthoCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.1, 10000.0, 10.0);
        Scene fakeScene = new Scene();
        fakeScene.setCamera(this.d_camera);
        OverlayLayout layout = new OverlayLayout();
        layout.add(new SceneRenderer(fakeScene));
        this.d_rootPanel.setLayoutManager(layout);
        this.d_view = new View((IRenderSurface)this, fakeScene);
        PickRoot pickRoot = new PickRoot(this);
        SelectionLogic selLogic = new SelectionLogic(this);
        SelectionFunc sf = new SelectionFunc(new GeomPicker(pickRoot, this.d_view), selLogic);
        DragFunc df = new DragFunc();
        ZoomFunc zf = new ZoomFunc();
        OrbitFunc of = new OrbitFunc();
        CompositeFunc cf = NavtoolUtil.newCompositeNav3DTool(of, zf, df, sf);
        CursorTool viewCompositeTool = new CursorTool(toolController, cf);
        this.d_toolMgr.addTool(viewCompositeTool, "Rotate", "Rotate Model", null);
        CursorTool traceToDestTool = new CursorTool(toolController, new TraceToDestFunc(this));
        this.d_toolMgr.addTool(traceToDestTool, "Trace to Dest", "Trace to Dest", null);
        CursorTool traceCrossingsTool = new CursorTool(toolController, new CrossingsFunc(this));
        this.d_toolMgr.addTool(traceCrossingsTool, "Trace Crossings", "Trace Crossings", null);
        CursorTool traceObstTool = new CursorTool(toolController, new ObstructedFunc(this));
        this.d_toolMgr.addTool(traceObstTool, "Trace Obstructed", "Trace Obstructed", null);
        for (CursorTool tool : this.d_tools = new CursorTool[]{viewCompositeTool, traceToDestTool, traceCrossingsTool, traceObstTool}) {
            tool.setView(this.d_view);
        }
        this.d_toolMgr.setCurrentTool(viewCompositeTool);
        this.d_engine = engine;
        this.setSize(800, 600);
        this.addComponentListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.d_objs = null;
        this.d_resize = null;
        this.d_miscRenderers = new IdentityHashSet();
    }

    public PathDebug getPathDebug() {
        return this.d_pathDebug;
    }

    @Override
    public IRenderSurface.OpenGLInfo getOpenGLInfo() {
        return new IRenderSurface.OpenGLInfo();
    }

    @Override
    public IRenderSurface.Adapter getAdapter() {
        return IRenderSurface.Adapter.UNKNOWN;
    }

    @Override
    public IRenderSurface.SurfPrefs testRenderPrefs() {
        return new IRenderSurface.SurfPrefs();
    }

    public boolean testFilter(Class<?> filterClass) {
        return !this.getFilters().isFilteringAllOf(filterClass);
    }

    public Set<ANode> getElevatorNodes(ElevatorModel elevatorModel) {
        if (this.d_elevatorNodes == null) {
            this.d_elevatorNodes = new IdentityHashSet<ANode>();
            for (Elevator elevator : elevatorModel.getElevators()) {
                for (ElevatorLevel el : elevator.getLevels()) {
                    this.d_elevatorNodes.add(el.pickupNode);
                }
            }
        }
        return this.d_elevatorNodes;
    }

    public ToolManager getToolMgr() {
        return this.d_toolMgr;
    }

    public CursorTool[] getTools() {
        return this.d_tools;
    }

    public DisplayFilter getFilters() {
        return this.d_filterMgr;
    }

    @Override
    public Integer getKey() {
        return null;
    }

    public void setKey(Integer key) {
    }

    @Override
    public RenderPanel getRootPanel() {
        return null;
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
    }

    @Override
    public void setRootPanel(RenderPanel layout) {
        this.d_rootPanel = layout;
    }

    @Override
    public void updateLayout() {
        this.d_rootPanel.setViewport(0, 0, this.getWidth(), this.getHeight());
    }

    public void show(List<?> objs) {
        this.d_objs = objs != null && !objs.isEmpty() ? objs : null;
        if (!this.once) {
            this.updateBounds();
            this.once = true;
        }
        this.repaint();
    }

    private <T> void updateBounds() {
        if (this.d_objs == null || this.d_objs.isEmpty()) {
            this.d_bounds = new AABox(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0));
        } else {
            this.d_bounds = new AABox();
            for (Object o : this.d_objs) {
                IRenderer<?> rend = this.REND_MAP.get(o.getClass());
                if (rend == null) continue;
                this.d_bounds.add(rend.getBounds(o));
            }
        }
        this.d_camera.reset(this.d_bounds, this.getWidth(), this.getHeight());
        if (this.d_camera instanceof OrthoCamera) {
            this.d_camera.setClip(-10000.0, 10000.0);
        }
    }

    private DoubleBuffer toBuffer(Matrix4d mat) {
        DoubleBuffer db = ByteBuffer.allocateDirect(128).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        double[] row = new double[4];
        for (int m = 0; m < 4; ++m) {
            mat.getRow(m, row);
            db.put(row);
        }
        db.position(0);
        return db;
    }

    private void updateProj() {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        this.d_rootPanel.layoutComponents();
        Matrix4d mat = new Matrix4d(this.d_camera.getTransform(4, 1));
        mat.transpose();
        GL11.glMultMatrix(this.toBuffer(mat));
        GL11.glMatrixMode(5888);
    }

    @Override
    protected void initGL() {
        GL11.glEnable(2929);
        GL11.glEnable(32823);
        GL11.glPolygonOffset(1.0f, 1.0f);
        GL11.glClearColor(0.85f, 0.85f, 0.99f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintGL() {
        Iterator<IRenderer<?>> iterator = this;
        synchronized (iterator) {
            if (this.d_resize != null) {
                GL11.glViewport(this.d_resize.x, this.d_resize.y, this.d_resize.width, this.d_resize.height);
                this.d_resize = null;
            }
        }
        this.updateProj();
        GL11.glClear(16640);
        GL11.glDepthFunc(515);
        if (this.d_bounds == null) {
            this.updateBounds();
        }
        if (this.d_objs != null) {
            IRenderer<?> rend;
            for (Object o : this.d_objs) {
                rend = this.REND_MAP.get(o.getClass());
                if (rend == null) continue;
                try {
                    rend.renderOpaque(this, this.d_engine.getKB(), o);
                }
                catch (Exception e) {
                    System.err.println("[rendering1]");
                    e.printStackTrace();
                }
            }
            for (IRenderer<?> rend2 : this.d_miscRenderers) {
                try {
                    rend2.renderOpaque(this, this.d_engine.getKB(), null);
                }
                catch (Exception e) {
                    System.err.println("[rendering2] " + e.getLocalizedMessage());
                }
            }
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            for (Object o : this.d_objs) {
                rend = this.REND_MAP.get(o.getClass());
                if (rend == null) continue;
                try {
                    rend.renderTranslucent(this, this.d_engine.getKB(), o);
                }
                catch (Exception e) {
                    System.err.println("[rendering3]");
                    e.printStackTrace();
                }
            }
            for (IRenderer<?> rend2 : this.d_miscRenderers) {
                try {
                    rend2.renderTranslucent(this, this.d_engine.getKB(), null);
                }
                catch (Exception e) {
                    System.err.println("[rendering4] " + e.getLocalizedMessage());
                }
            }
            GL11.glDisable(3042);
        }
        GL11.glFlush();
        try {
            this.swapBuffers();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void componentResized(ComponentEvent evt) {
        super.componentResized(evt);
        GLView gLView = this;
        synchronized (gLView) {
            this.d_resize = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point3d p = this.screenToWorld(e.getX(), e.getY(), 0.0f);
        if (this.d_engine.getGLView() != null) {
            this.d_engine.getGLView().updateCoordinates(p);
        }
    }

    private static double[][] toMatrix(DoubleBuffer buffer) {
        assert (buffer.limit() >= 16);
        double[][] mat = new double[4][4];
        int bufix = 0;
        for (int m = 0; m < 4; ++m) {
            for (int n = 0; n < 4; ++n) {
                mat[m][n] = buffer.get(bufix++);
            }
        }
        return mat;
    }

    private static float[][] toMatrix(FloatBuffer buffer) {
        assert (buffer.limit() >= 16);
        float[][] mat = new float[4][4];
        int bufix = 0;
        for (int m = 0; m < 4; ++m) {
            for (int n = 0; n < 4; ++n) {
                mat[m][n] = buffer.get(bufix++);
            }
        }
        return mat;
    }

    private static int[] toArray(IntBuffer buffer) {
        int[] buf = new int[buffer.limit()];
        for (int m = 0; m < buffer.limit(); ++m) {
            buf[m] = buffer.get(m);
        }
        return buf;
    }

    private static FloatBuffer newFloatBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    private static IntBuffer newIntBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    private Point3d screenToWorld(int x, int y, float z) {
        return this.d_view.screenToWorld(new Point3d(x, this.getHeight() - y, z));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        final Point3d p1 = this.screenToWorld(e.getX(), e.getY(), 0.0f);
        Point3d p2 = this.screenToWorld(e.getX(), e.getY(), 1.0f);
        final Vector3d lineDirN = Inter.normalize(Inter.vector(p1, p2));
        final double[] closestDist = new double[]{Double.MAX_VALUE};
        final OccAgent[] closestAgent = new OccAgent[]{null};
        try {
            this.d_engine.getKB().findOccs(new ITest<AABox>(){

                @Override
                public Containment test(AABox bb) {
                    return Inter.lineAABB(p1, lineDirN, bb.getMin(), bb.getMax()) ? Containment.INTERSECTS : Containment.OUTSIDE;
                }
            }, true, new IResult<OccAgent>(){

                @Override
                public void mark(OccAgent obj, Containment ctmt) {
                    if (ctmt == Containment.INSIDE) {
                        throw new CancellationException();
                    }
                    double dist = p1.distance(obj.getPos());
                    if (dist > closestDist[0]) {
                        return;
                    }
                    Point3d isect = new Point3d();
                    if (Inter3D.lineZPlaneIntersection(isect, p1, lineDirN, obj.getPos().z, 1.0E-6) && isect.distance(obj.getPos()) <= obj.getOccupantRadius()) {
                        closestDist[0] = dist;
                        closestAgent[0] = obj;
                    }
                }
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        try {
            for (OccAgent agent : this.d_engine.getKB().getActiveAgents()) {
                agent.setSelected(false);
            }
            this.repaintAll(closestAgent[0]);
            if (closestAgent[0] != null) {
                closestAgent[0].setSelected(true);
                System.out.println("selected " + String.valueOf(closestAgent[0]));
            }
        }
        catch (ConcurrentModificationException exc) {
            exc.printStackTrace();
        }
    }

    private void repaintAll(OccAgent closestAgent) {
        this.d_engine.getGLView().updateTables(closestAgent);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void pauseRender() {
        this.d_renderCounter.pauseRender();
    }

    @Override
    public void render() {
        this.d_renderCounter.render();
    }

    @Override
    public void render(Viewport clippingVP) {
        this.d_renderCounter.render(clippingVP);
    }

    @Override
    public void resumeRender() {
        this.d_renderCounter.resumeRender();
    }

    @Override
    public void resumeRender(boolean render) {
        this.d_renderCounter.resumeRender(render);
    }

    public void resetView() {
        this.d_camera.reset(this.d_bounds, this.getWidth(), this.getHeight());
        if (this.d_camera instanceof OrthoCamera) {
            this.d_camera.setClip(-10000.0, 10000.0);
        }
        this.repaint();
    }

    @Override
    public <T> void setProp(IPropertySet.Prop<T> prop, T value) {
    }

    @Override
    public boolean getMaterialShadersEnabled() {
        return false;
    }

    @Override
    public void setMaterialShadersEnabled(boolean enabled, boolean clearCacheOnDisable) {
    }

    @Override
    public AffineTransform getUiScaleTransform() {
        return new AffineTransform();
    }

    public static class PathDebug {
        public int nodeIx = 0;
    }

    private class PickRoot
    implements IPickRoot {
        private PickRoot(GLView gLView) {
        }

        @Override
        public IPickSession beginPicking() {
            return new Session(this);
        }

        private class Session
        implements IPickSession {
            private Session(PickRoot pickRoot) {
            }

            @Override
            public boolean isActive() {
                return true;
            }

            @Override
            public void begin() {
            }

            @Override
            public void end() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                return 0;
            }

            @Override
            public IPickConfig[] getPickConfigs() {
                return new IPickConfig[]{new IPickConfig(this){

                    @Override
                    public ConvexHull getClippingRegion() {
                        return new ConvexHull(new Plane3d[0]);
                    }

                    @Override
                    public void find(ITest<AABox> test, IResult<IPickable> result, boolean quick) {
                    }
                }};
            }

            @Override
            public boolean isVisible(IPickConfig config, Object o) {
                return true;
            }

            @Override
            public boolean isWireframe(IPickConfig config, Object o) {
                return false;
            }

            @Override
            public boolean isOcclusionTarget(Object o, boolean occludeGuides) {
                return true;
            }

            @Override
            public boolean isOcclusionSource(Object o) {
                return true;
            }

            @Override
            public void pickPoints(IPickable obj, IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
                obj.pickPoints(isects, filter, rayBegin, rayDirN, maxDist, tester);
            }

            @Override
            public void pickBox(IPickable obj, IBoxCollector result, IIsectFilter filter, ConvexHull region) {
                obj.pickBox(result, filter, region);
            }
        }
    }

    private class SelectionLogic
    implements ISelectionLogic {
        private SelectionLogic(GLView gLView) {
        }

        @Override
        public void selectMultiple(CursorTool tool, MouseEvent e, Point2d viewPoint1, Point2d viewPoint2, GeomPicker picker) {
        }

        @Override
        public void selectSingle(CursorTool tool, MouseEvent e, Point2d viewPoint, GeomPicker picker) {
        }
    }

    private class TraceToDestFunc
    extends ATraceFunc {
        private TraceToDestFunc(GLView gLView) {
        }

        @Override
        protected IRenderer<?> performTrace(final Mesh geomMesh, final TriPoint source, final Vector3d dir, TriPoint dest) {
            return new IRenderer<Object>(){

                @Override
                public AABox getBounds(Object obj) {
                    return new AABox();
                }

                @Override
                public void renderTranslucent(GLView view, KB kb, Object obj) {
                }

                @Override
                public void renderOpaque(GLView view, KB kb, Object obj) {
                    Mesh.ShapeTrace trace = geomMesh.traceMovingShape(source, dir, s_pathFilter, Double.MAX_VALUE, new CylinderShape(source.p, 0.2286, 0.2286, 0.0, dir, -1));
                    GL11.glColor3f(0.0f, 0.0f, 1.0f);
                    GL11.glBegin(1);
                    GL11.glVertex3d(source.p.x, source.p.y, source.p.z);
                    GL11.glVertex3d(source.p.x + dir.x, source.p.y + dir.y, source.p.z + dir.z);
                    GL11.glEnd();
                    if (trace != null && trace.boundary != null) {
                        TriPoint tp = trace.loc;
                        GL11.glTranslated(tp.p.x, tp.p.y, tp.p.z);
                        Sphere sphere = new Sphere();
                        sphere.draw(0.2286f, 32, 32);
                        GL11.glTranslated(-tp.p.x, -tp.p.y, -tp.p.z);
                    }
                }
            };
        }
    }

    private class CrossingsFunc
    extends ATraceFunc {
        private CrossingsFunc(GLView gLView) {
        }

        @Override
        protected IRenderer<?> performTrace(final Mesh geomMesh, final TriPoint source, final Vector3d dir, final TriPoint dest) {
            return new IRenderer<Object>(){

                @Override
                public AABox getBounds(Object obj) {
                    return new AABox();
                }

                @Override
                public void renderTranslucent(GLView view, KB kb, Object obj) {
                }

                @Override
                public void renderOpaque(GLView view, KB kb, Object obj) {
                    List<Mesh.EdgeCrossing> crossings;
                    Mesh.ShapeTrace trace = geomMesh.traceMovingShape(source, dir, s_pathFilter, Double.MAX_VALUE, new CylinderShape(source.p, 0.2286, 0.2286, 0.0, dir, -1));
                    if (trace != null && trace.boundary != null) {
                        Mesh.EdgeCrossing crossing = null;
                        try {
                            crossing = geomMesh.getCrossedEdges(source.tri, source.p, dir, s_pathFilter, trace.t);
                        }
                        catch (Mesh.CrossedEdgesException crossedEdgesException) {
                            // empty catch block
                        }
                        crossings = crossing == null ? Collections.EMPTY_LIST : crossing.flatten();
                    } else {
                        crossings = Collections.EMPTY_LIST;
                    }
                    try {
                        GL11.glColor3f(1.0f, 1.0f, 0.0f);
                        GL11.glBegin(1);
                        GL11.glVertex3d(source.p.x, source.p.y, source.p.z);
                        GL11.glVertex3d(dest.p.x, dest.p.y, dest.p.z);
                        GL11.glEnd();
                        Sphere sphere = new Sphere();
                        for (Mesh.EdgeCrossing crossing : crossings) {
                            WingedEdge edge = crossing.edge;
                            GL11.glColor3f(1.0f, 0.0f, 1.0f);
                            GL11.glBegin(1);
                            GL11.glVertex3d(edge.base.n1.p.x, edge.base.n1.p.y, edge.base.n1.p.z + 0.1);
                            GL11.glVertex3d(edge.base.n2.p.x, edge.base.n2.p.y, edge.base.n2.p.z + 0.1);
                            GL11.glEnd();
                            GL11.glColor3f(0.0f, 1.0f, 0.0f);
                            GL11.glTranslated(crossing.enterLoc.p.x, crossing.enterLoc.p.y, crossing.enterLoc.p.z);
                            sphere.draw(0.1143f, 32, 32);
                            GL11.glTranslated(-crossing.enterLoc.p.x, -crossing.enterLoc.p.y, -crossing.enterLoc.p.z);
                        }
                        if (trace != null) {
                            Point3d p = trace.loc.p;
                            GL11.glColor3f(1.0f, 0.0f, 0.0f);
                            GL11.glTranslated(p.x, p.y, p.z);
                            sphere.draw(0.2286f, 32, 32);
                            GL11.glTranslated(-p.x, -p.y, -p.z);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
        }
    }

    private class ObstructedFunc
    extends ATraceFunc {
        private ObstructedFunc(GLView gLView) {
        }

        @Override
        protected IRenderer<?> performTrace(final Mesh geomMesh, final TriPoint source, Vector3d dir, final TriPoint dest) {
            return new IRenderer<Object>(){

                @Override
                public AABox getBounds(Object obj) {
                    return new AABox();
                }

                @Override
                public void renderTranslucent(GLView view, KB kb, Object obj) {
                }

                @Override
                public void renderOpaque(GLView view, KB kb, Object obj) {
                    boolean obst = geomMesh.isPathObstructed(source, dest, 0.2286, EdgeFilters.acceptAll());
                    if (obst) {
                        GL11.glColor3f(1.0f, 0.0f, 0.0f);
                    } else {
                        GL11.glColor3f(0.0f, 0.0f, 1.0f);
                    }
                    GL11.glBegin(1);
                    GL11.glVertex3d(source.p.x, source.p.y, source.p.z);
                    GL11.glVertex3d(dest.p.x, dest.p.y, dest.p.z);
                    GL11.glEnd();
                }
            };
        }
    }

    private abstract class ATraceFunc
    extends AToolFunction<CursorTool> {
        private TriPoint d_lastPoint = null;
        private int d_buttonDown = 0;

        private ATraceFunc() {
        }

        @Override
        public Cursor getCursor(CursorTool tool) {
            return null;
        }

        @Override
        public void mouseMoved(CursorTool tool, MouseEvent e) {
        }

        @Override
        public void mouseReleased(CursorTool tool, MouseEvent e) {
        }

        @Override
        public void mousePressed(CursorTool tool, MouseEvent e) {
            this.d_buttonDown = e.getButton();
            if (this.d_buttonDown == 1) {
                Point3d isect;
                Point3d p1 = GLView.this.screenToWorld(e.getX(), e.getY(), 0.0f);
                Point3d p2 = GLView.this.screenToWorld(e.getX(), e.getY(), 1.0f);
                Mesh geomMesh = GLView.this.d_engine.getKB().getMesh();
                Tri tri = geomMesh.getTri(isect = new Point3d(), p1, p2);
                if (tri != null) {
                    this.d_lastPoint = new TriPoint(tri, isect);
                    System.out.println(this.d_lastPoint.p);
                } else {
                    this.d_lastPoint = null;
                }
                GLView.this.repaint();
            }
        }

        @Override
        public void mouseDragged(CursorTool tool, MouseEvent e) {
            if (this.d_buttonDown == 1) {
                GLView.this.d_miscRenderers.clear();
                if (this.d_lastPoint != null) {
                    TriPoint dest;
                    Point3d isect;
                    Point3d p1 = GLView.this.screenToWorld(e.getX(), e.getY(), 0.0f);
                    Point3d p2 = GLView.this.screenToWorld(e.getX(), e.getY(), 1.0f);
                    Mesh geomMesh = GLView.this.d_engine.getKB().getMesh();
                    Tri tri = geomMesh.getTri(isect = new Point3d(), p1, p2);
                    if (tri != null) {
                        dest = new TriPoint(tri, isect);
                    } else {
                        isect = Inter.linePlane(p1, Inter.normalize(Inter.vector(p1, p2)), this.d_lastPoint.tri.plane, 1.0E-6);
                        dest = new TriPoint(null, isect);
                    }
                    Vector3d dir = Inter.normalizeEq(Inter.vector(this.d_lastPoint.p, dest.p));
                    Util.projectAlongZEq(this.d_lastPoint.tri.plane, dir);
                    IRenderer<?> renderer = this.performTrace(geomMesh, this.d_lastPoint, dir, dest);
                    if (renderer != null) {
                        GLView.this.d_miscRenderers.add(renderer);
                    }
                }
                GLView.this.repaint();
            }
        }

        protected abstract IRenderer<?> performTrace(Mesh var1, TriPoint var2, Vector3d var3, TriPoint var4);
    }

    public static final class ANIMATION_FILTER {
    }
}

