/*
 * Decompiled with CFR 0.152.
 */
package inferno.test;

import inferno.sim.KB;
import merlin.data.MerlinData;

public class Tweaks {
    public static ITweak SFPE_MODE = new SfpeMode();
    public static ITweak STEERING_MODE = new SteeringMode();
    public static ITweak STEERING_PLUS_MODE = new SteeringPlusMode();
    public static final ITweak NOCHANGE_SFPE = new Unchanged(VariantId.SFPE);
    public static final ITweak NOCHANGE_STEERING = new Unchanged(VariantId.STEERING);
    public static final ITweak NOCHANGE_STEERING_FLOWLIMIT = new Unchanged(VariantId.STEERING_FLOWLIMIT);

    private static class SfpeMode
    implements ITweak {
        private SfpeMode() {
        }

        @Override
        public void tweak(KB kb) {
            kb.getParams().inertia = false;
            kb.getParams().vel_from_density = true;
            kb.getParams().reactive_steering = false;
            kb.getParams().handle_collisions = false;
            kb.getParams().door_flow_from_density = true;
            kb.getParams().specific_flowrate_max = 1.32;
            kb.getParams().dt_snapshot = 0.0;
        }

        @Override
        public void tweak(MerlinData md) {
            md.simParams.useDoorQueues = true;
        }

        public String toString() {
            return VariantId.SFPE.value;
        }
    }

    public static interface ITweak {
        public void tweak(MerlinData var1);

        public void tweak(KB var1);
    }

    private static class SteeringMode
    implements ITweak {
        private SteeringMode() {
        }

        @Override
        public void tweak(KB kb) {
            kb.getParams().inertia = true;
            kb.getParams().vel_from_density = false;
            kb.getParams().reactive_steering = true;
            kb.getParams().handle_collisions = true;
            kb.getParams().door_flow_from_density = false;
            kb.getParams().specific_flowrate_max = Double.POSITIVE_INFINITY;
            kb.getParams().dt_snapshot = 0.0;
        }

        @Override
        public void tweak(MerlinData md) {
            md.simParams.useDoorQueues = false;
        }

        public String toString() {
            return VariantId.STEERING.value;
        }
    }

    private static class SteeringPlusMode
    extends SteeringMode {
        private SteeringPlusMode() {
        }

        @Override
        public void tweak(KB kb) {
            super.tweak(kb);
            kb.getParams().specific_flowrate_max = 1.32;
        }

        @Override
        public void tweak(MerlinData md) {
            md.simParams.useDoorQueues = true;
        }

        @Override
        public String toString() {
            return VariantId.STEERING_FLOWLIMIT.value;
        }
    }

    public static class Unchanged
    implements ITweak {
        private final VariantId d_variantId;

        public Unchanged(VariantId variantId) {
            this.d_variantId = variantId;
        }

        @Override
        public void tweak(MerlinData md) {
        }

        @Override
        public void tweak(KB kb) {
        }

        public String toString() {
            return this.d_variantId.value;
        }
    }

    public static enum VariantId {
        SFPE("SFPE"),
        STEERING("STEERING"),
        STEERING_FLOWLIMIT("STEERING-FSMAX");

        private final String value;

        private VariantId(String value) {
            this.value = value;
        }
    }
}

