/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.simple;

import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.LookAtUtil;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import java.io.Serializable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;

public class MaintainVel
implements ISteeringBehavior,
Serializable {
    static final long serialVersionUID = 1L;

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public void done(KB kb, OccAgent occ, boolean interrupted) {
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
    }

    public double getDistanceToGoal(KB kb, OccAgent agent) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return null;
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) {
        Vector3d dir = new Vector3d(agent.getVel());
        double speed = Util3D.safeNormalize(dir, 0.0);
        LineSeg3D curve = new LineSeg3D(agent.getPos(), Util3D.add(agent.getPos(), (Tuple3d)dir));
        return Util.generateSeekCurve(kb, agent, curve, speed > 0.0, EdgeFilters.acceptAll());
    }

    @Override
    public Steer steer(KB world, OccAgent agent, SeekCurve seek) {
        Vector3d dvel = agent.getVel();
        Vector3d dorient = LookAtUtil.orientToTargetIfVisible(world, agent.getOcc().lookAtSource, agent, () -> dvel.lengthSquared() == 0.0 ? agent.getDirFacing() : Util3D.normalize(dvel));
        return new Steer(null, dvel, dorient, agent.getOcc().priority, 1.0, Filters.acceptAll(), false, true, new OccAgent[0]);
    }
}

