/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.simple;

import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.SimulationMode;
import inferno.sim.path.EdgeFilters;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.LookAtUtil;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import java.io.Serializable;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;

public class Arrive
implements ISteeringBehavior,
Serializable {
    static final long serialVersionUID = 1L;
    private final double d_slowingDist;
    private ITpSource d_ptSrc;
    private final Vector3d d_arriveOrient;

    public Arrive(ITpSource ptSrc, Vector3d arriveOrient) {
        this(ptSrc, 1.0, arriveOrient);
    }

    public Arrive(ITpSource ptSrc, double slowingDist, Vector3d arriveOrient) {
        this.d_ptSrc = ptSrc;
        this.d_slowingDist = slowingDist;
        this.d_arriveOrient = arriveOrient;
    }

    @Override
    public void done(KB kb, OccAgent occ, boolean interrupted) {
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
    }

    public double getDistanceToGoal(KB kb, OccAgent agent) {
        return agent.getPos().distance(this.d_ptSrc.getTriPoint().p);
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return null;
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) {
        LineSeg3D curve = new LineSeg3D(agent.getPos(), this.d_ptSrc.getTriPoint().p);
        return Util.generateSeekCurve(kb, agent, curve, true, EdgeFilters.acceptAll());
    }

    @Override
    public Steer steer(KB world, OccAgent agent, SeekCurve seek) {
        double tol;
        Vector3d offset = Util3D.vector(agent.getPos(), this.d_ptSrc.getTriPoint().p);
        double d = tol = world.getSimMode() == SimulationMode.STEERING ? 0.1 : OccAgent.getMaxVel(world, agent.getOcc(), 0.0, null) * world.getDt();
        if (offset.lengthSquared() <= tol * tol) {
            Vector3d orient = LookAtUtil.orientToTargetIfVisible(world, agent.getOcc().lookAtSource, agent, () -> this.d_arriveOrient != null ? this.d_arriveOrient : agent.getDirFacing());
            return new Steer(null, Util3D.VEC_ZERO, orient, agent.getOcc().priority, 1.0, Filters.acceptAll(), false, true, new OccAgent[0]);
        }
        double maxVel = OccAgent.getMaxVel(world, agent.getOcc(), 0.0, offset);
        double distance = offset.length();
        double rampedSpeed = maxVel * (distance / this.d_slowingDist);
        double clippedSpeed = Math.min(rampedSpeed, maxVel);
        Vector3d desired = new Vector3d(offset);
        desired.scale(clippedSpeed / distance);
        Util.projectAlongZEq(agent.getLoc().tri.plane, desired);
        assert (Util.isValid(desired));
        Vector3d orient = LookAtUtil.orientToTargetIfVisible(world, agent.getOcc().lookAtSource, agent, () -> desired);
        return new Steer(null, desired, orient, agent.getOcc().priority, 1.0, Filters.acceptAll(), false, true, new OccAgent[0]);
    }
}

