/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.locallyquickest;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.OccPriority;
import inferno.data2.Occupant;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.DoorQueueEstimate;
import inferno.sim.path.Estimate;
import inferno.sim.steering.locallyquickest.ILocalTarget;
import inferno.sim.steering.locallyquickest.LocalDoorTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.DoubleSupplier;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public abstract class LocalTimeEstimate
implements Serializable {
    private static final long serialVersionUID = -7639555888009837113L;

    public abstract double getTravelTime(KB var1, OccAgent var2, double var3);

    public abstract double getCrossTime(KB var1, OccAgent var2, ANode var3, DoorDir var4, double var5, double var7, double var9, double var11, DoubleSupplier var13);

    public abstract double getEmptyTime(KB var1, ANode var2, DoorDir var3);

    public abstract void clearMemory(ANode var1, DoorDir var2);

    public abstract void clearAllMemory();

    public abstract void updateEstimates(KB var1, Collection<? extends ILocalTarget> var2);

    public static class QueueSizes
    extends LocalTimeEstimate {
        private static final long serialVersionUID = 2393774088912982239L;
        private Map<Pair<ANode, DoorDir>, Pair<Double, Integer>> d_flowrateMem = new HashMap<Pair<ANode, DoorDir>, Pair<Double, Integer>>();
        private static final double CACHE_UPDATE_INTERVAL = 5.0;
        private double d_flowrateMemLastUpdate = 0.0;

        @Override
        public void clearAllMemory() {
            this.d_flowrateMem = new HashMap<Pair<ANode, DoorDir>, Pair<Double, Integer>>();
        }

        @Override
        public void clearMemory(ANode localDoor, DoorDir dir) {
            this.d_flowrateMem.remove(new Pair<ANode, DoorDir>(localDoor, dir));
        }

        @Override
        public double getTravelTime(KB kb, OccAgent agent, double localDist) {
            if (kb.getParams().reactive_steering) {
                return localDist / (double)agent.getOcc().maxVel;
            }
            Occupant occ = agent.getOcc();
            ANode thisRoom = occ.curNode;
            double roomDensity = (double)thisRoom.getCorrespondingNumOccupants() / thisRoom.getArea();
            double localVel = OccAgent.getMaxVel(kb, occ, roomDensity, null);
            return localDist / localVel;
        }

        @Override
        public double getEmptyTime(KB kb, ANode localDoor, DoorDir dir) {
            int waitFor = kb.getPathEstimates().getQueue(localDoor).getQueue(dir).size();
            return this.getQueueTime(kb, null, localDoor, dir, 0.0, waitFor, Double.POSITIVE_INFINITY);
        }

        @Override
        public double getCrossTime(KB kb, OccAgent agent, ANode localDoor, DoorDir dir, double localDist, double maxTime, double tCurrQueueChosen, double tFlowrateMemory, DoubleSupplier getTransportDepartTimeRem) {
            double closedTime;
            int waitFor = kb.getPathEstimates().getQueue(localDoor).getQueue(dir).getQueuePosition(agent, localDist);
            if (waitFor < 0) {
                waitFor = -waitFor - 1;
            }
            if (Double.isInfinite(closedTime = QueueSizes.getClosedTime(kb, localDoor, dir, agent, localDist, waitFor, getTransportDepartTimeRem))) {
                return closedTime;
            }
            if (!agent.getOcc().curNode.isAdjacent(localDoor)) {
                return closedTime;
            }
            return this.getQueueTime(kb, agent, localDoor, dir, closedTime, waitFor, tCurrQueueChosen);
        }

        private double getQueueTime(KB kb, OccAgent agent, ANode localDoor, DoorDir dir, double closedTime, int waitFor, double tCurrQueueChosen) {
            if (kb.getParams().reactive_steering) {
                return this.getLocalPathTimeSteering(kb, agent, localDoor, dir, closedTime, waitFor, tCurrQueueChosen);
            }
            return this.getLocalPathTimeSFPE(kb, localDoor, dir, closedTime, waitFor);
        }

        public double getLocalPathTimeSteering(KB kb, OccAgent agent, ANode localDoor, DoorDir dir, double closedTime, int waitFor, double tCurrQueueChosen) {
            boolean waiting;
            double tInQueue = 0.0;
            DoorQueueEstimate dq = kb.getPathEstimates().getQueue(localDoor);
            DoorQueueEstimate.OccQueue queue = dq.getQueue(dir);
            boolean inQueue = !Double.isInfinite(tCurrQueueChosen);
            int queueBegin = queue.getQueueBegin();
            boolean bl = waiting = agent != null && DoorQueueEstimate.OccQueue.isQueuing(kb, agent, localDoor);
            if (inQueue && waiting && (queueBegin == -1 || waitFor < queueBegin)) {
                queueBegin = waitFor;
            }
            FlowrateEval eval = QueueSizes.evalFlowrate(kb, localDoor, dir, agent, inQueue, queueBegin, waitFor);
            double flowrate = 0.0;
            if (queueBegin == -1 || waitFor < queueBegin) {
                if (eval.maxFlowrate == 0.0) {
                    tInQueue = Double.POSITIVE_INFINITY;
                } else {
                    Pair<Double, Integer> mem;
                    flowrate = eval.maxFlowrate;
                    if (!inQueue && (mem = this.d_flowrateMem.get(new Pair<ANode, DoorDir>(localDoor, dir))) != null) {
                        flowrate = (Double)mem.v1;
                    }
                    numQueued = waitFor;
                    if (eval.includeSelf) {
                        ++numQueued;
                    }
                    tInQueue = flowrate == 0.0 ? Double.POSITIVE_INFINITY : (double)numQueued / flowrate;
                }
            } else {
                flowrate = closedTime == 0.0 ? QueueSizes.getFlowratePotential(kb, localDoor, queue, eval.minFlowrate, eval.maxFlowrate) : eval.maxFlowrate;
                numQueued = waitFor;
                if (eval.includeSelf) {
                    ++numQueued;
                }
                double d = tInQueue = flowrate == 0.0 ? Double.POSITIVE_INFINITY : (double)numQueued / flowrate;
            }
            if (agent != null && !localDoor.isClosed(kb, agent)) {
                this.d_flowrateMem.put(new Pair<ANode, DoorDir>(localDoor, dir), new Pair<Double, Integer>(flowrate, waitFor));
                DoorQueueEstimate.OccQueue oppositeQueue = dq.getQueue(dir.opposite());
                if (oppositeQueue.size() > 0) {
                    this.d_flowrateMem.put(new Pair<ANode, DoorDir>(localDoor, dir.opposite()), new Pair<Object, Integer>(null, oppositeQueue.size()));
                }
            }
            return closedTime + tInQueue;
        }

        private static double getClosedTime(KB kb, ANode localDoor, DoorDir dir, OccAgent agent, double localDist, int waitFor, DoubleSupplier getTransportDepartTimeRem) {
            int transportBatch = QueueSizes.getTransportBatch(kb, localDoor, dir, agent, localDist, waitFor);
            if (transportBatch > 0) {
                if (transportBatch == Integer.MAX_VALUE) {
                    return Double.POSITIVE_INFINITY;
                }
                double ret = Math.max(0.0, localDoor.getNextOpenTime(kb, agent, getTransportDepartTimeRem) - kb.getCurrentSimTime());
                return QueueSizes.getWaitOnTransportTime(kb, agent, localDoor, dir, transportBatch) + ret;
            }
            if (localDoor.isClosed(kb, agent)) {
                return Math.max(0.0, localDoor.getNextOpenTime(kb, agent, getTransportDepartTimeRem) - kb.getCurrentSimTime());
            }
            return 0.0;
        }

        private static int getTransportBatch(KB kb, ANode localDoor, DoorDir dir, OccAgent agent, double localDist, int waitFor) {
            DoorQueue dq = localDoor.doorQueue;
            if (!dq.isElevatorDoor()) {
                return -1;
            }
            ANode adjNode = dq.getDestination(dir);
            if (adjNode.getElevatorLevel() == null) {
                return -1;
            }
            ANode elevatorNode = adjNode;
            if (!elevatorNode.hasOccLimit() || elevatorNode.getEnteringAgents().contains(agent)) {
                return 0;
            }
            int nominalLoad = elevatorNode.getElevatorLevel().getElevator().getNominalLoad();
            int formationSize = agent.getFormationCorrespondingOccCount();
            if (formationSize > nominalLoad) {
                return Integer.MAX_VALUE;
            }
            int occsAlreadyIn = localDoor.isPhysicallyClosed() ? 0 : elevatorNode.getCorrespondingNumOccupants();
            DoorQueueEstimate.OccQueue queue = kb.getPathEstimates().getQueue(localDoor).getQueue(dir);
            int batch = 0;
            int toFill = nominalLoad - occsAlreadyIn;
            int m = 0;
            while (m < waitFor) {
                DoorQueueEstimate.OccDist od = queue.get(m);
                int corrCount = od.occ.getFormationCorrespondingOccCount();
                if (corrCount > nominalLoad) {
                    ++m;
                    continue;
                }
                if (corrCount <= toFill) {
                    toFill -= corrCount;
                    ++m;
                    continue;
                }
                ++batch;
                toFill = nominalLoad;
            }
            if (formationSize <= toFill) {
                return batch;
            }
            return batch + 1;
        }

        private static double getWaitOnTransportTime(KB kb, OccAgent agent, ANode localDoor, DoorDir dir, int transportBatch) {
            ANode elevatorNode = localDoor.doorQueue.getDestination(dir);
            if (elevatorNode.getElevatorLevel() == null) {
                return 0.0;
            }
            Elevator elevator = elevatorNode.getElevatorLevel().getElevator();
            ElevatorLevel source = elevatorNode.getElevatorLevel();
            ElevatorLevel target = elevator.getMaxTravelTimeTarget(source);
            assert (target != null);
            double roundTripCost = source.getTravelTimeTot(target) + elevator.getDischargeTimeEstimate(kb) + target.getTravelTimeTot(source);
            return roundTripCost * (double)transportBatch;
        }

        @Override
        public void updateEstimates(KB kb, Collection<? extends ILocalTarget> allTargets) {
            if (this.d_flowrateMem.isEmpty()) {
                return;
            }
            if (kb.getCurrentSimTime() <= this.d_flowrateMemLastUpdate + 5.0) {
                return;
            }
            int nTargetsWithQueues = 0;
            IFilteredCollection<LocalDoorTarget> doorTargets = theUtil.filter(allTargets, LocalDoorTarget.class);
            BiPredicate<ANode, DoorDir> hasQueue = (door, dir) -> {
                Pair<Double, Integer> mem = this.d_flowrateMem.get(new Pair<ANode, DoorDir>((ANode)door, (DoorDir)((Object)((Object)dir))));
                return mem != null && (Integer)mem.v2 > 0;
            };
            for (LocalDoorTarget doorTarget : doorTargets) {
                if (!hasQueue.test(doorTarget.door, DoorDir.POSITIVE) && !hasQueue.test(doorTarget.door, DoorDir.NEGATIVE)) continue;
                ++nTargetsWithQueues;
            }
            if (nTargetsWithQueues < allTargets.size()) {
                return;
            }
            TriPredicate<DoorQueueEstimate, DoorDir, Pair> didQueueClear = (dqueue, dir, mem) -> {
                if (mem == null || (Integer)mem.v2 <= 0) {
                    return false;
                }
                DoorQueueEstimate.OccQueue queue = dqueue.getQueue((DoorDir)((Object)((Object)dir)));
                return queue.size() == 0;
            };
            ArrayList<Pair<ANode, DoorDir>> toClear = new ArrayList<Pair<ANode, DoorDir>>();
            Estimate estimates = kb.getPathEstimates();
            for (Map.Entry<Pair<ANode, DoorDir>, Pair<Double, Integer>> entry : this.d_flowrateMem.entrySet()) {
                Pair<ANode, DoorDir> key = entry.getKey();
                DoorQueueEstimate dqueue2 = estimates.getQueue((ANode)key.v1);
                if (!didQueueClear.test(dqueue2, (DoorDir)((Object)key.v2), entry.getValue()) && !didQueueClear.test(dqueue2, ((DoorDir)((Object)key.v2)).opposite(), this.d_flowrateMem.get(new Pair<ANode, DoorDir>((ANode)key.v1, ((DoorDir)((Object)key.v2)).opposite())))) continue;
                toClear.add(key);
            }
            for (Pair pair : toClear) {
                this.clearMemory((ANode)pair.v1, (DoorDir)((Object)pair.v2));
                this.clearMemory((ANode)pair.v1, ((DoorDir)((Object)pair.v2)).opposite());
            }
            if (!toClear.isEmpty()) {
                this.d_flowrateMemLastUpdate = kb.getCurrentSimTime();
            }
        }

        private static double getFlowratePotential(KB kb, ANode door, DoorQueueEstimate.OccQueue queue, double minFlowrate, double maxFlowrate) {
            double flowrate = queue.getFlowrate().getOptimistic();
            if (flowrate > maxFlowrate) {
                flowrate = maxFlowrate;
            } else if (flowrate < minFlowrate) {
                flowrate = minFlowrate;
            }
            if (flowrate < 0.01 * queue.getFlowrate().getNominal()) {
                flowrate = 0.0;
            }
            return flowrate;
        }

        private static FlowrateEval evalFlowrate(KB kb, ANode door, DoorDir dir, OccAgent agent, boolean inQueue, int queueBegin, int waitFor) {
            double minFlowrate;
            double nominal;
            DoorQueueEstimate dqueue = kb.getPathEstimates().getQueue(door);
            DoorQueueEstimate.OccQueue queue = dqueue.getQueue(dir);
            double maxFlowrate = nominal = queue.getFlowrate().getNominal();
            double actual = queue.getFlowrate().getActual();
            if (actual > maxFlowrate) {
                return new FlowrateEval(actual, actual, false);
            }
            double minFlowrateFactor = kb.getParams().min_flowrate_factor;
            boolean includeSelf = true;
            DoorQueueEstimate.OccQueue oppQueue = dqueue.getQueue(dir.opposite());
            int oppQueueFront = oppQueue.getQueueBegin();
            double oppFlowrate = oppQueue.getFlowrate().getActual();
            OccAgent cfAgent = agent;
            if (cfAgent == null) {
                if (queueBegin >= 0) {
                    cfAgent = queue.get((int)queueBegin).occ;
                } else if (queue.size() > 0) {
                    cfAgent = queue.get((int)0).occ;
                }
            }
            if (cfAgent != null) {
                if (QueueSizes.isSignificantCounterflow(kb, cfAgent, oppQueue, oppFlowrate, oppQueueFront, 0.001)) {
                    maxFlowrate = 0.0;
                    minFlowrateFactor = 0.001;
                    includeSelf = true;
                } else {
                    maxFlowrate = nominal - oppFlowrate;
                    int n = oppQueueFront = oppQueue.size() > 0 ? 0 : -1;
                    if (QueueSizes.isSignificantCounterflow(kb, cfAgent, oppQueue, oppFlowrate, oppQueueFront, minFlowrateFactor * nominal)) {
                        includeSelf = true;
                        minFlowrateFactor = 0.001;
                    }
                }
            }
            if (maxFlowrate < (minFlowrate = Math.max(actual, minFlowrateFactor * nominal))) {
                maxFlowrate = minFlowrate;
            }
            return new FlowrateEval(minFlowrate, maxFlowrate, includeSelf && agent != null);
        }

        private static boolean isSignificantCounterflow(KB kb, OccAgent agent, DoorQueueEstimate.OccQueue oppQueue, double oppFlowrate, int oppQueueFront, double minSigFlowrate) {
            double closeDist = 2.5;
            return oppQueueFront != -1 && oppQueue.get((int)oppQueueFront).dist <= 2.5 && oppFlowrate >= minSigFlowrate && OccPriority.compareLevels(agent.getPriority(kb), oppQueue.get((int)oppQueueFront).occ.getPriority(kb)) >= 0 && !oppQueue.door.isClosed(kb, oppQueue.get((int)oppQueueFront).occ);
        }

        public double getLocalPathTimeSFPE(KB kb, ANode localDoor, DoorDir dir, double closedTime, int waitFor) {
            double timeInQueue = 0.0;
            double flowRate = localDoor.doorQueue.getNominalFlowrate(kb, dir);
            timeInQueue = (double)waitFor / flowRate;
            return closedTime + timeInQueue;
        }

        private static class FlowrateEval {
            public final double minFlowrate;
            public final double maxFlowrate;
            public final boolean includeSelf;

            public FlowrateEval(double minFlowrate, double maxFlowrate, boolean includeSelf) {
                this.minFlowrate = minFlowrate;
                this.maxFlowrate = maxFlowrate;
                this.includeSelf = includeSelf;
            }
        }

        private static interface TriPredicate<K1, K2, K3> {
            public boolean test(K1 var1, K2 var2, K3 var3);
        }
    }
}

