/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.IAgentBodyShape;
import inferno.data2.Mesh;
import inferno.data2.OccLocator;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.geom.Inter;
import inferno.geom.Util;
import inferno.geom.WallSlider;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathFilters;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class Senses
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(Senses.class.getSimpleName());
    public static final double CROSSFLOW_ANGLE = theUtil.getSystemDouble("Senses.CROSSFLOW_ANGLE", 60.0);
    private static final boolean CROSSFLOW_ALTERNATE = theUtil.testSystemProp("Senses.CROSSFLOW_ANGLE");
    public static final double VISIBLE_MEMORY = theUtil.getSystemDouble("Senses.VISIBLE_MEMORY", 4.0);
    public static final double HIDDEN_MEMORY = theUtil.getSystemDouble("Senses.HIDDEN_MEMORY", 0.5);
    private final Memory d_memory;
    private final Map<Pair<Vector3d, Double>, WallHit> d_wallHits = new HashMap<Pair<Vector3d, Double>, WallHit>();
    private final Map<Tri, Double> d_speedInTriCache = new IdentityHashMap<Tri, Double>();
    private final Map<Integer, NearOccs> d_nearOccs;
    private final WallSlider d_wallSlider;
    private final double d_hazardSenseRadius;
    private final double d_wallSenseRadius;
    private transient SensedGeom d_geom;
    private Map<OccAgent, Flow> d_flow = Collections.emptyMap();
    private static final Comparator<Pair<OccAgent, Double>> s_occHitComp = new Comparator<Pair<OccAgent, Double>>(){

        @Override
        public int compare(Pair<OccAgent, Double> o1, Pair<OccAgent, Double> o2) {
            return Double.compare((Double)o1.v2, (Double)o2.v2);
        }
    };
    public static final String PROX_FRUS_KEY = "prox_frustum";
    private static final double CROSS_EPS = Senses.toDotTol(CROSSFLOW_ANGLE);

    public Senses(KB kb, Memory memory, OccAgent agent, IParametric3D seekCurve, WallSlider wallSlider, double hazardSenseRadius, double wallSenseRadius, Collection<AgentFilter> filters) {
        this.d_memory = memory;
        this.d_nearOccs = Senses.senseNearOccs(kb, memory, agent, seekCurve, filters);
        this.d_wallSlider = wallSlider != null ? wallSlider.tweak(EdgeFilters.rejectAllClosedDoors()) : null;
        this.d_wallSenseRadius = wallSenseRadius;
        this.d_hazardSenseRadius = hazardSenseRadius;
    }

    public Memory getMemory() {
        return this.d_memory;
    }

    public List<WingedEdge> getNearWalls(KB kb, OccInfo oi) {
        return this.senseGeom((KB)kb, (OccInfo)oi).walls;
    }

    private SensedGeom senseGeom(KB kb, OccInfo oi) {
        if (this.d_geom != null) {
            return this.d_geom;
        }
        Occupant occ = oi.oa.getOcc();
        boolean[] hasImpedingTris = new boolean[]{occ.tri.isImpeding()};
        Predicate<PathChange> wallFilter = Mesh.acceptBoundaries(this.d_wallSlider.getEdgeFilter().and(PathFilters.filterEdges(EdgeFilters.rejectAllClosedDoors())));
        ArrayList closeBoundaries = new ArrayList();
        boolean hasHazards = kb.hasImpedingTris();
        double hazardDist = hasHazards ? this.d_hazardSenseRadius : 0.0;
        double searchDist = Math.max(hazardDist, this.d_wallSenseRadius);
        double wallDistSq = this.d_wallSenseRadius * this.d_wallSenseRadius;
        double hazardDistSq = hazardDist * hazardDist;
        PathChange pc = new PathChange();
        kb.getMesh().getCloseEdges(occ.tri, occ.loc, occ.curNode, searchDist, searchDist, Predicates.alwaysTrue(), ed -> {
            if (ed.distSq <= wallDistSq && wallFilter.test(pc.set(ed.destTri, ed.edge))) {
                closeBoundaries.add(ed);
            }
            hasImpedingTris[0] = hasImpedingTris[0] || !ed.edge.isBoundary() && ed.distSq <= hazardDistSq && ed.destTri != null && ed.destTri.isImpeding(oi.cache.maxVel);
        });
        Collections.sort(closeBoundaries);
        this.d_geom = new SensedGeom(closeBoundaries.isEmpty() ? Collections.emptyList() : closeBoundaries.stream().map(b -> b.edge).collect(Collectors.toList()), hasImpedingTris[0]);
        return this.d_geom;
    }

    public WallSlider getWallSlider() {
        return this.d_wallSlider;
    }

    public boolean hasNearbyHazards(KB kb, OccInfo oi) {
        return this.senseGeom((KB)kb, (OccInfo)oi).hasHazards;
    }

    public WallHit senseNearestWallHit(KB kb, TriPoint occLoc, Vector3d dir, double maxDist, Predicate<PathChange> pathFilter, IAgentBodyShape bodyShape, IAgentBodyShape bodyShapeDefault) {
        Pair<Vector3d, Double> key = new Pair<Vector3d, Double>(dir, bodyShapeDefault.getEnclosingRadius());
        if (this.d_wallHits.containsKey(key)) {
            return this.d_wallHits.get(key);
        }
        WallHit wh = this.senseNearestWallHitUncached(kb, occLoc, dir, maxDist, pathFilter, bodyShape);
        this.d_wallHits.put(key, wh);
        return wh;
    }

    public WallHit senseNearestWallHitUncached(KB kb, TriPoint occLoc, Vector3d dir, double maxDist, Predicate<PathChange> pathFilter, IAgentBodyShape bodyShape) {
        Mesh geomMesh;
        Mesh.ShapeTrace trace;
        if (dir == null) {
            if (bodyShape instanceof PolygonShape) {
                dir = new Vector3d(0.0, 0.0, 0.0);
            } else {
                return null;
            }
        }
        if ((trace = (geomMesh = kb.getMesh()).traceMovingShape(occLoc, dir, pathFilter, maxDist, bodyShape)) == null) {
            return new WallHit(null, 0.0, occLoc);
        }
        if (trace.boundary == null) {
            return null;
        }
        double hitTime = trace.t;
        double hitDist = hitTime * dir.length();
        return new WallHit(trace.boundary, hitDist, trace.loc);
    }

    public double senseMaxSpeedInTri(KB kb, OccInfo oi, Tri tri) {
        return this.d_speedInTriCache.computeIfAbsent(tri, t -> OccAgent.getMaxVel(kb, oi.oa.getOcc(), t, 0.0, true, null, OccAgent.ALL_TRANSIENT_LIMITERS));
    }

    public double senseGeomTravelTime(KB kb, OccInfo oi, Vector3d dir, double maxDist, Predicate<PathChange> pathFilter) {
        IGetTime getTime = (tri, dist) -> {
            double speed = this.senseMaxSpeedInTri(kb, oi, tri);
            return dist / speed;
        };
        TriPoint occLoc = oi.oa.getLoc();
        DoubleSupplier getTimeInCurrTri = () -> getTime.apply(occLoc.tri, maxDist);
        if (dir == null) {
            return getTimeInCurrTri.getAsDouble();
        }
        try {
            Mesh geomMesh = kb.getMesh();
            Mesh.EdgeCrossing crossings = geomMesh.getCrossedEdges(occLoc.tri, occLoc.p, dir, pathFilter, maxDist);
            if (crossings == null) {
                return getTimeInCurrTri.getAsDouble();
            }
            double time = 0.0;
            double nextt = crossings.t;
            double finalDistInTri = crossings.enterLoc.p.distance(crossings.destPt);
            time += getTime.apply(crossings.enterLoc.tri, finalDistInTri);
            Mesh.EdgeCrossing cross = crossings;
            while (cross != null) {
                Mesh.EdgeCrossing parent = cross.parent;
                if (parent != null) {
                    if (theUtil.gt(nextt, parent.t, 1.0E-9)) {
                        distInTri = parent.enterLoc.p.distance(cross.enterLoc.p);
                        time += getTime.apply(parent.enterLoc.tri, distInTri);
                    }
                    nextt = parent.t;
                } else {
                    distInTri = occLoc.p.distance(cross.enterLoc.p);
                    time += getTime.apply(occLoc.tri, distInTri);
                }
                cross = parent;
            }
            return time;
        }
        catch (Mesh.CrossedEdgesException e) {
            TeciLogging.log(LOGGER, e);
            return getTimeInCurrTri.getAsDouble();
        }
    }

    public void senseNearestOccHits(KB kb, int filterId, OccInfo oi, Vector3d dir, List<Pair<OccAgent, Double>> transientOccHits, List<Pair<OccAgent, Double>> stationaryOccHits) {
        this.senseNearestOccHits(kb, filterId, oi, dir, transientOccHits, stationaryOccHits, 0.0, 1.0);
    }

    public void senseNearestOccHits(KB kb, int filterId, OccInfo oi, Vector3d dir, List<Pair<OccAgent, Double>> transientOccHits, List<Pair<OccAgent, Double>> stationaryOccHits, double distOffset, double sizeMultiplier) {
        this.senseNearestOccHits(kb, this.getNearOccs(filterId, oi), oi, dir, transientOccHits, stationaryOccHits, distOffset, sizeMultiplier);
    }

    public void senseNearestOccHits(KB kb, Collection<OccAgent> nearOccs, OccInfo oi, Vector3d dir, List<Pair<OccAgent, Double>> transientOccHits, List<Pair<OccAgent, Double>> stationaryOccHits, double distOffset, double sizeMultiplier) {
        Vector3d dirVel;
        IAgentBodyShape shape1 = oi.shapeAgents;
        if (dir == null) {
            velMag = 0.0;
            dirVel = new Vector3d(0.0, 0.0, 0.0);
        } else {
            velMag = oi.cache.maxVel;
            dirVel = Inter.scale(dir, velMag);
            shape1 = shape1.orientTo(dir);
        }
        Vector3d occDir = new Vector3d();
        boolean isVehicle = oi.oa.hasVehicle();
        for (OccAgent otherOcc : nearOccs) {
            double tcollt;
            double tcollt2;
            occDir.sub(otherOcc.getPos(), oi.oa.getPos());
            boolean polAndCirAgents = isVehicle ^ otherOcc.hasVehicle();
            if (dir != null && Util.dot2d(dir, occDir) < 0.0 && !polAndCirAgents && distOffset == 0.0) continue;
            IAgentBodyShape shape2 = otherOcc.getCollisionShape();
            if (distOffset != 0.0) {
                Vector3d moveDir = otherOcc.getLastSteer() != null ? otherOcc.getLastSteer().vel : otherOcc.getDirFacing();
                shape2 = shape2.moveInDirBy(moveDir, distOffset);
                shape2 = shape2.adjust(sizeMultiplier);
            }
            if (transientOccHits != null && !Double.isInfinite(tcollt2 = Inter.getOccCollision(shape1, dirVel, shape2, InvSteerUtil.getCollisionVel(otherOcc), 1.0E-6))) {
                transientOccHits.add(new Pair<OccAgent, Double>(otherOcc, tcollt2));
            }
            if (stationaryOccHits == null || Double.isInfinite(tcollt = Inter.getOccCollision(shape1, dirVel, shape2, GeomConstants.VEC3D_ZERO, 1.0E-6))) continue;
            stationaryOccHits.add(new Pair<OccAgent, Double>(otherOcc, tcollt));
        }
        if (stationaryOccHits != null) {
            Collections.sort(stationaryOccHits, s_occHitComp);
        }
        if (transientOccHits != null) {
            Collections.sort(transientOccHits, s_occHitComp);
        }
    }

    public Collection<OccAgent> getNearOccs(int filterId, OccInfo oi) {
        NearOccs noccs = this.d_nearOccs.get(filterId);
        if (noccs == null || noccs.occs.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return theUtil.filter(noccs.occs, oi.collisionFilter);
    }

    public static Vector3d getSeekDir(OccAgent agent) {
        Vector3d dir;
        double len;
        IParametric3D seekCurve = agent.getSeekCurve();
        if (seekCurve != null && (len = Util3D.safeNormalize(dir = seekCurve.getTangent(0.0), 0.0)) != 0.0) {
            return dir;
        }
        return null;
    }

    public Flow getFlow(KB kb, OccAgent agent1, SeekInfo seekInfo1, OccAgent agent2, Vector3d dir2) {
        if (dir2 == null || dir2.lengthSquared() == 0.0) {
            return Flow.OBSTRUCT;
        }
        if (this.d_flow == Collections.EMPTY_MAP) {
            this.d_flow = new IdentityHashMap<OccAgent, Flow>();
        }
        return this.d_flow.computeIfAbsent(agent2, a -> Senses.getCounterflowStatusImpl(kb, agent1, seekInfo1.seekDir, agent2, dir2));
    }

    public static Flow getCounterflowStatusImpl(KB kb, OccAgent agent1, Vector3d seekDir1, OccAgent agent2, Vector3d dir2) {
        assert (seekDir1 != null);
        Pair<ANode, DoorDir> door1 = agent1.getTargetDoor(true);
        Pair<ANode, DoorDir> door2 = agent2.getTargetDoor(false);
        if (door1 != null && door2 != null) {
            if (door1.equals(door2)) {
                return Flow.MERGE;
            }
            if (door1.v1 == door2.v1 && door1.v2 != door2.v2) {
                return Flow.COUNTER;
            }
        }
        if (agent1.getOcc().curNode != agent2.getOcc().curNode && agent2.getAvoidOcc() != agent1) {
            return Flow.MERGE;
        }
        Optional<Flow> counterflowPath = Senses.getCounterflowStatusPath(kb, agent1, seekDir1, agent2, dir2);
        if (counterflowPath.isPresent()) {
            return counterflowPath.get();
        }
        seekDir1 = Senses.projectNormalizedVecToZ(seekDir1);
        dir2 = Senses.projectNormalizedVecToZ(dir2);
        double dot = seekDir1.dot(dir2);
        return Senses.getFlow(dot);
    }

    private static Vector3d projectNormalizedVecToZ(Vector3d v) {
        if (v.z == 0.0) {
            return v;
        }
        v = new Vector3d(v.x, v.y, 0.0);
        Util3D.safeNormalize(v, 0.0);
        return v;
    }

    public static double toDotTol(double angleDeg) {
        return Math.cos(Math.toRadians(angleDeg));
    }

    private static Flow getFlow(double dot) {
        if (CROSSFLOW_ALTERNATE) {
            if (Math.abs(dot) <= CROSS_EPS) {
                return Flow.CROSS;
            }
            if (dot < 0.0) {
                return Flow.COUNTER;
            }
            return Flow.MERGE;
        }
        if (dot < 0.0) {
            return Flow.COUNTER;
        }
        if (dot <= CROSS_EPS) {
            return Flow.CROSS;
        }
        return Flow.MERGE;
    }

    private static Optional<Flow> getCounterflowStatusPath(KB kb, OccAgent agent1, Vector3d dir1, OccAgent agent2, Vector3d dir2) {
        PathFollow pfollow = agent1.getPathFollow();
        if (pfollow == null) {
            return Optional.empty();
        }
        ArrayList<Point3d> seekPoints = new ArrayList<Point3d>();
        pfollow.getSeekPoints(kb, agent1.getPos(), agent1.getPos().distance(agent2.getPos()) * 2.0, false, true, seekPoints);
        if (seekPoints.isEmpty()) {
            return Optional.empty();
        }
        Point3d agent2Loc = agent2.getPos();
        ArrayList<Point3d[]> closestSegs = new ArrayList<Point3d[]>(2);
        double closestDistSq = Double.POSITIVE_INFINITY;
        Point3d prevPt = agent1.getPos();
        for (int m = 0; m < seekPoints.size(); ++m) {
            Point3d currPt = (Point3d)seekPoints.get(m);
            if (theUtil.eq0(Util.distSq2d(prevPt, currPt), 1.0E-12)) continue;
            double distSq = Inter3D.distSqToNearestPtOnLineSeg(prevPt, currPt, agent2Loc);
            int comp = theUtil.compare(distSq, closestDistSq, 1.0E-12);
            if (comp <= 0) {
                if (comp < 0) {
                    closestDistSq = distSq;
                    closestSegs.clear();
                }
                closestSegs.add(new Point3d[]{prevPt, currPt});
            }
            prevPt = currPt;
        }
        if (closestSegs.isEmpty()) {
            return Optional.empty();
        }
        double dot = 0.0;
        if (closestSegs.size() == 1) {
            Point3d[] seg = (Point3d[])closestSegs.get(0);
            Vector3d dir = Util3D.vector(seg[0], seg[1]);
            dir.normalize();
            dot = dir.dot(dir2);
        } else {
            double maxAdot = Double.NEGATIVE_INFINITY;
            Vector3d tdir = new Vector3d();
            for (int m = 0; m < closestSegs.size(); ++m) {
                Point3d[] seg = (Point3d[])closestSegs.get(m);
                tdir.sub(seg[1], seg[0]);
                tdir.normalize();
                double tdot = tdir.dot(dir2);
                double adot = Math.abs(tdot);
                if (!(adot > maxAdot)) continue;
                maxAdot = adot;
                dot = tdot;
            }
            if (Double.isInfinite(maxAdot)) {
                return Optional.empty();
            }
        }
        return Optional.of(Senses.getFlow(dot));
    }

    private static double distsq2d(Point3d p1, Point3d p2) {
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        return dx * dx + dy * dy;
    }

    private static double dist2d(Point3d p1, Point3d p2) {
        return Math.sqrt(Senses.distsq2d(p1, p2));
    }

    private static Map<Integer, NearOccs> senseNearOccs(KB kb, Memory memory, OccAgent oa, IParametric3D seekCurve, Collection<AgentFilter> filters) {
        if (filters.stream().allMatch(f -> Predicates.alwaysFalse(f.filter))) {
            return Collections.emptyMap();
        }
        TriPoint occLoc = oa.getLoc();
        Plane3d[] additionalPlanes = new Plane3d[]{};
        HashMap<Integer, NearOccs> map = new HashMap<Integer, NearOccs>();
        double tCurr = kb.getCurrentSimTime();
        Function<Integer, NearOccs> nearOccsMapper = f -> new NearOccs();
        BiFunction<OccAgent, OccVis, OccVis> occVisFunction = (occ, existing) -> {
            if (existing != null) {
                if (!existing.isExpired(tCurr)) {
                    return existing;
                }
                existing.update(tCurr, oa.isVisible(kb, (OccAgent)occ));
                return existing;
            }
            return new OccVis(tCurr, oa.isVisible(kb, (OccAgent)occ));
        };
        IResult<OccAgent> result = (occ, ctmt) -> {
            if (occ == oa) {
                return;
            }
            OccVis ovis = null;
            for (AgentFilter filter : filters) {
                double rad = occ.getCollisionShape().getEnclosingRadius();
                double dist = Senses.dist2d(occLoc.p, occ.getPos()) - rad;
                if (dist > filter.radius || !filter.filter.test((OccAgent)occ)) continue;
                if (ovis == null) {
                    ovis = memory.occVis.compute((OccAgent)occ, occVisFunction);
                }
                if (!ovis.visible) {
                    return;
                }
                ((NearOccs)map.computeIfAbsent(Integer.valueOf((int)filter.id), nearOccsMapper)).occs.add((OccAgent)occ);
            }
        };
        double searchRadius = 0.0;
        for (AgentFilter filter : filters) {
            if (!(filter.radius > searchRadius)) continue;
            searchRadius = filter.radius;
        }
        kb.findOccs(OccLocator.testCyl(occLoc.p, searchRadius * searchRadius, occLoc.p.z, occLoc.p.z + oa.getHeight(), additionalPlanes), false, result);
        memory.expire(kb);
        if (oa.isSelected()) {
            kb.getProps().setDbgFunc(oa.getOcc(), "nearoccs", () -> {
                IdentityHashSet<OccAgent> agents = new IdentityHashSet<OccAgent>();
                for (Map.Entry entry : map.entrySet()) {
                    agents.addAll((Collection<OccAgent>)((NearOccs)entry.getValue()).occs);
                }
                return agents;
            });
        } else {
            kb.getProps().setDbg(oa.getOcc(), "nearoccs", null);
        }
        return map;
    }

    public static class Memory
    implements Serializable {
        private static final long serialVersionUID = -8158856231000145852L;
        public final Map<OccAgent, OccVis> occVis = new IdentityHashMap<OccAgent, OccVis>();

        public void expire(KB kb) {
            double tCurr = kb.getCurrentSimTime();
            Iterator<Map.Entry<OccAgent, OccVis>> entryIt = this.occVis.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry<OccAgent, OccVis> entry = entryIt.next();
                if (!entry.getValue().isExpired(tCurr) && !entry.getKey().isDone()) continue;
                entryIt.remove();
            }
        }

        public boolean isEmpty() {
            return this.occVis.isEmpty();
        }

        public double getTimeVisible(KB kb, OccAgent occ) {
            OccVis ov = this.occVis.get(occ);
            if (ov == null) {
                return Double.NaN;
            }
            return ov.visible ? kb.getCurrentSimTime() - ov.tDiscovered : Double.NaN;
        }
    }

    private static class SensedGeom
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final List<WingedEdge> walls;
        public final boolean hasHazards;

        public SensedGeom(List<WingedEdge> walls, boolean hasImpedingTris) {
            this.walls = walls;
            this.hasHazards = hasImpedingTris;
        }
    }

    public static class WallHit
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final double dist;
        public final TriPoint loc;
        public final WingedEdge wall;

        public WallHit(WingedEdge wall, double hitDist, TriPoint hitLoc) {
            this.wall = wall;
            this.dist = hitDist;
            this.loc = hitLoc;
        }
    }

    private static interface IGetTime {
        public double apply(Tri var1, double var2);
    }

    public static class NearOccs
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final List<OccAgent> occs;

        public NearOccs() {
            this(new ArrayList<OccAgent>());
        }

        public NearOccs(List<OccAgent> occs) {
            this.occs = occs;
        }
    }

    public static enum Flow {
        MERGE,
        COUNTER,
        CROSS,
        OBSTRUCT;

    }

    public static class AgentFilter {
        public final int id;
        public final Predicate<OccAgent> filter;
        public final double radius;
        public final double fov;

        public AgentFilter(int id, Predicate<OccAgent> agentFilter, double radius, double fov) {
            this.id = id;
            this.filter = agentFilter;
            this.radius = radius;
            this.fov = fov;
        }
    }

    private static class OccVis
    implements Serializable {
        private static final long serialVersionUID = -2598493284528279304L;
        public double tDiscovered;
        public boolean visible;
        public double tExpire;

        public OccVis(double tCurr, boolean visible) {
            this(visible, OccVis.calcTExpire(tCurr, visible), tCurr);
        }

        public OccVis(boolean visible, double tExpire, double tDiscovered) {
            this.visible = visible;
            this.tExpire = tExpire;
            this.tDiscovered = tDiscovered;
        }

        private static double calcTExpire(double tCurr, boolean vis) {
            return vis ? tCurr + VISIBLE_MEMORY : tCurr + HIDDEN_MEMORY;
        }

        public boolean isExpired(double tCurr) {
            return tCurr >= this.tExpire;
        }

        public void update(double tCurr, boolean visible) {
            if (visible != this.visible) {
                this.tDiscovered = tCurr;
            }
            this.visible = visible;
            this.tExpire = OccVis.calcTExpire(tCurr, visible);
        }
    }
}

