/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.profiling;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;

public class TimeAccum
implements Serializable {
    static final long serialVersionUID = 1L;
    private Map<String, ThreadAccum> d_accums = new Hashtable<String, ThreadAccum>();

    public synchronized void begin(String tid) {
        ThreadAccum accum = this.d_accums.get(tid);
        if (accum == null) {
            accum = new ThreadAccum();
            this.d_accums.put(tid, accum);
        }
        accum.begin();
    }

    public synchronized void end(String tid) {
        ThreadAccum accum = this.d_accums.get(tid);
        if (accum == null) {
            return;
        }
        accum.end();
    }

    public synchronized long getCount(String tid) {
        ThreadAccum accum = this.d_accums.get(tid);
        if (accum == null) {
            return 0L;
        }
        return accum.count;
    }

    public synchronized double getTime(String tid) {
        ThreadAccum accum = this.d_accums.get(tid);
        if (accum == null) {
            return 0.0;
        }
        return accum.getTime();
    }

    public synchronized void clear(String ... tids) {
        for (String tid : tids) {
            this.d_accums.remove(tid);
        }
    }

    public synchronized void printSummary(PrintStream out, String ref, String ... parts) {
        if (parts.length == 0) {
            ArrayList<String> names = new ArrayList<String>(this.d_accums.size() - 1);
            for (String name : this.d_accums.keySet()) {
                if (name.equals(ref)) continue;
                names.add(name);
            }
            parts = names.toArray(new String[names.size()]);
        }
        double tAll = this.getTime(ref);
        long cAll = this.getCount(ref);
        int longestNameLen = 0;
        for (String part : parts) {
            int len = part.length();
            if (len <= longestNameLen) continue;
            longestNameLen = len;
        }
        if (ref.length() > longestNameLen) {
            longestNameLen = ref.length();
        }
        longestNameLen = Math.max(longestNameLen, "FUNCTION".length());
        String col1Format = "%-" + longestNameLen + "s";
        Object dashes = "";
        for (int m = 0; m < longestNameLen; ++m) {
            dashes = (String)dashes + "-";
        }
        out.printf(col1Format + "  RUN TIME      PERCENT     COUNT     %n", "FUNCTION");
        out.printf((String)dashes + "  ------------  ----------  ----------%n", new Object[0]);
        Arrays.sort(parts, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                double t1 = TimeAccum.this.getTime(o1);
                double t2 = TimeAccum.this.getTime(o2);
                return Double.compare(t2, t1);
            }
        });
        for (String part : parts) {
            double tPart = this.getTime(part);
            long cPart = this.getCount(part);
            out.printf(col1Format + "  %10.3f s  (%6.2f %%)  %10d%n", part, tPart, tPart / tAll * 100.0, cPart);
        }
        out.printf((String)dashes + "  ------------  ----------  ----------%n", new Object[0]);
        out.printf(col1Format + "  %10.3f s  (%6.2f %%)  %10d%n", ref, tAll, tAll / tAll * 100.0, cAll);
    }

    private static class ThreadAccum
    implements Serializable {
        static final long serialVersionUID = 1L;
        private transient long beginTicks = -1L;
        private long entrance = 0L;
        private long totalTicks = 0L;
        private long count = 0L;

        private ThreadAccum() {
        }

        public void begin() {
            if (this.entrance++ == 0L) {
                assert (this.beginTicks == -1L);
                this.beginTicks = System.nanoTime();
            }
            ++this.count;
        }

        public void end() {
            if (--this.entrance == 0L) {
                long end = System.nanoTime();
                this.totalTicks += end - this.beginTicks;
                this.beginTicks = -1L;
            }
        }

        public boolean isRunning() {
            return this.entrance > 0L;
        }

        public double getTime() {
            long count = this.totalTicks;
            if (this.isRunning()) {
                count += System.nanoTime() - this.beginTicks;
            }
            return (double)count * 1.0E-9;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            if (this.isRunning()) {
                long end = System.nanoTime();
                this.totalTicks += end - this.beginTicks;
                this.beginTicks = end;
            }
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.beginTicks = this.isRunning() ? System.nanoTime() : -1L;
        }
    }
}

