/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import inferno.data2.Occupant;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.Param;
import inferno.sim.output.json.AJsonInfoWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class OccParamsWriterJson
extends AJsonInfoWriter {
    public static final OccProfileSim.IOccProp<?>[] SKIP_PROPS = new OccProfileSim.IOccProp[]{OccProfileSim.PROP_MAXVEL, OccProfileSim.PROP_SHAPE};
    public static final List<OccProfileSim.IOccProp<?>> OUTPUT_PROPS;

    public static boolean isWriterEnabled(KB kb) {
        return kb.getParams().write_occ_params_file;
    }

    public OccParamsWriterJson(KB kb) {
        super(kb, true);
    }

    public void init(double t) {
        Collection<OccAgent> agents = this.getKb().getActiveAgents();
        for (OccAgent agent : agents) {
            this.writeFrame(t, agent);
        }
    }

    public void addOccs(double t, Collection<OccAgent> agents) {
        for (OccAgent agent : agents) {
            this.writeFrame(t, agent);
        }
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_occ_params_json));
    }

    @Override
    public void writeFrame(double t) {
    }

    private void writeFrame(double t, OccAgent agent) {
        LinkedHashMap<String, Object> frame = new LinkedHashMap<String, Object>();
        Occupant occ = agent.getOcc();
        for (Keys k : Keys.values()) {
            Object val = k.formatter.apply(this.getKb(), occ);
            frame.put(k.toString(), val);
        }
        LinkedHashMap<String, ListMap<String, Object>> profileProps = new LinkedHashMap<String, ListMap<String, Object>>();
        for (OccProfileSim.IOccProp<?> prop : OUTPUT_PROPS) {
            ListMap<String, Object> val = prop.getValue(this.getKb(), occ);
            if (prop == OccProfileSim.PROP_OCCMODEL && val instanceof String) {
                val = FilenameManager.splitFilename(new File((String)((Object)val)).getName())[0];
            } else if (val instanceof UnitDouble && prop.getDisplayUnit() != null) {
                UnitDouble dbl = (UnitDouble)((Object)val);
                val = OccParamsWriterJson.convertToMapWithUnits(prop.getDisplayUnit(), OccParamsWriterJson.formatDouble(dbl.getValueNoUnit(), 3));
            }
            profileProps.put(theUtil.toCamelCase(prop.getName().replace("OccProfile.", "")), val);
        }
        frame.put("profileProps", profileProps);
        this.getWriter().add(frame);
    }

    @Override
    public void consolidate() {
        ArrayList<Map<String, Object>> tempData = this.getWriter().readTempJsonData();
        LinkedHashMap<String, Map<String, Object>> finalData = new LinkedHashMap<String, Map<String, Object>>();
        for (Map<String, Object> occ : tempData) {
            String id = (String)occ.get(Keys.id.toString());
            finalData.put(id, occ);
        }
        this.getWriter().add(finalData);
    }

    static {
        Predicate<OccProfileSim.IOccProp<?>> filter = Predicates.and(p -> !p.testOption(OccProfileSim.PropOption.SKIP_PARAM), Filters.reject(SKIP_PROPS));
        OUTPUT_PROPS = new ArrayList(theUtil.filter(OccProfileSim.ALL_OCC_PROPS, filter));
    }

    private static enum Keys {
        id("id", null, (kb, occ) -> String.valueOf(occ.id)),
        name("name", null, (kb, occ) -> occ.name),
        startTime("startTime", SI.SECOND, (kb, occ) -> AJsonInfoWriter.formatDouble(kb.getCurrentSimTime(), 2)),
        profile("profile", null, (kb, occ) -> occ.parentProfile.getName()),
        behavior("behavior", null, (kb, occ) -> occ.behavior.name),
        maxVel("maxVelocity", OccProfileSim.SPEED_UNIT, (kb, occ) -> AJsonInfoWriter.convertToMapWithUnits(OccProfileSim.SPEED_UNIT, Float.valueOf(occ.maxVel))),
        shapeType("shape", null, (kb, occ) -> occ.bodyShape),
        occupantRadius("occupantRadius", SI.METER, (kb, occ) -> AJsonInfoWriter.convertToMapWithUnits(SI.METER, AJsonInfoWriter.formatDouble(occ.bodyShape.getOccRadius(), 2))),
        geometryRadius("geometryRadius", SI.METER, (kb, occ) -> AJsonInfoWriter.convertToMapWithUnits(SI.METER, AJsonInfoWriter.formatDouble(occ.bodyShape.getGeomRadius(), 2))),
        height("height", SI.METER, (kb, occ) -> AJsonInfoWriter.convertToMapWithUnits(SI.METER, AJsonInfoWriter.formatDouble(occ.bodyShape.getHeight(), 2))),
        room("room", null, (kb, occ) -> occ.curNode.annotatedName),
        position("position", null, (kb, occ) -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("unit", SI.METER.toString());
            map.put("x", AJsonInfoWriter.formatDouble(occ.loc.x, 2));
            map.put("y", AJsonInfoWriter.formatDouble(occ.loc.y, 2));
            map.put("z", AJsonInfoWriter.formatDouble(occ.loc.z, 2));
            return map;
        });

        public final String val;
        public final Unit unit;
        public final BiFunction<KB, Occupant, Object> formatter;

        private Keys(String val, Unit unit, BiFunction<KB, Occupant, Object> formatter) {
            this.val = val;
            this.unit = unit;
            this.formatter = formatter;
        }

        public String toString() {
            return this.val;
        }
    }
}

