/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import inferno.sim.KB;
import inferno.sim.Param;
import inferno.sim.output.json.AJsonInfoWriter;
import inferno.sim.output.json.AOccDataWriterJson;
import inferno.sim.output.json.OccDataWriterMultipleJson;
import inferno.sim.output.json.OccParamsWriterJson;
import inferno.sim.output.json.SocialDistanceAccumulatedWriterJson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.theUtil;

public class CombinedOutputWriterJson
extends AJsonInfoWriter {
    private static final Logger LOGGER = Logger.getLogger(CombinedOutputWriterJson.class.getName());

    public static boolean isWriterEnabled(KB kb) {
        return true;
    }

    public CombinedOutputWriterJson(KB kb) {
        super(kb, false);
    }

    @Override
    public void open(double t, Param params) throws IOException {
        this.getWriter().open(t, new File(params.out_combined_json));
    }

    @Override
    public void writeFrame(double t) {
    }

    @Override
    public void consolidate() {
        LinkedHashMap<String, Object> finalData = new LinkedHashMap<String, Object>();
        for (Keys k : Keys.values()) {
            finalData.put(k.toString(), k.apply(this.getKb()));
        }
        this.getWriter().add(finalData);
    }

    private static Map<String, Object> getJsonFromFile(String jsonFilePath) {
        Map map;
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeSpecialFloatingPointValues().create();
        FileReader reader = new FileReader(jsonFilePath);
        try {
            map = gson.fromJson((Reader)reader, LinkedHashMap.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return new LinkedHashMap<String, Object>();
            }
            catch (Exception e) {
                TeciLogging.log(LOGGER, e);
                return new LinkedHashMap<String, Object>();
            }
        }
        reader.close();
        return map;
    }

    private static enum Keys {
        TRIGGERS("triggers", kb -> CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_attractors_json)),
        DOORS("doors", kb -> CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_doors_json)),
        GROUPS("groups", kb -> CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_groups_json)),
        MEASUREMENT_REGIONS("measurementRegions", kb -> CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_measurement_regions_json)),
        OCCUPANTS("occupants", kb -> {
            Map<String, Object> occGeneralData = CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_occ_cummulative_json);
            if (occGeneralData != null) {
                Object occId;
                if (OccParamsWriterJson.isWriterEnabled(kb)) {
                    Map<String, Object> occParamData = CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_occ_params_json);
                    for (Map.Entry<String, Object> entry : occParamData.entrySet()) {
                        occId = entry.getKey();
                        theUtil.mapPutSubObject(occGeneralData, (String)occId, "initialParams", entry.getValue());
                    }
                }
                if (AOccDataWriterJson.isWriterEnabled(kb)) {
                    if (kb.getParams().occ_csv_file_as_one) {
                        Map<String, Object> occDetailedData = CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_occ_detailed_json);
                        for (Map.Entry<String, Object> entry : occDetailedData.entrySet()) {
                            occId = entry.getKey();
                            theUtil.mapPutSubObject(occGeneralData, (String)occId, "detailed", entry.getValue());
                        }
                    } else {
                        for (String fn : OccDataWriterMultipleJson.getAllFileNames(kb)) {
                            Map<String, Object> map = CombinedOutputWriterJson.getJsonFromFile(fn);
                            for (Map.Entry entry : map.entrySet()) {
                                String occId2 = (String)entry.getKey();
                                theUtil.mapPutSubObject(occGeneralData, occId2, "detailed", entry.getValue());
                            }
                        }
                    }
                }
                if (SocialDistanceAccumulatedWriterJson.isWriterEnabled(kb)) {
                    Map<String, Object> sdAccum = CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_sd_accumulated_json);
                    Map<String, Object> sdTrans = CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_sd_transient_json);
                    for (Map.Entry<String, Object> entry : sdTrans.entrySet()) {
                        String string = entry.getKey();
                        theUtil.mapPutSubObject(sdAccum, string, "transient", entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : sdAccum.entrySet()) {
                        String string = entry.getKey();
                        theUtil.mapPutSubObject(occGeneralData, string, "socialDistancing", entry.getValue());
                    }
                }
                return occGeneralData;
            }
            return new LinkedHashMap();
        }),
        TARGETS("targets", kb -> CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_occtargets_json)),
        ROOMS("rooms", kb -> CombinedOutputWriterJson.getJsonFromFile(kb.getParams().out_rooms_json));

        private final String key;
        private final Function<KB, Map<String, Object>> formatter;

        private Keys(String key, Function<KB, Map<String, Object>> formatter) {
            this.key = key;
            this.formatter = formatter;
        }

        public Object apply(KB kb) {
            return this.formatter.apply(kb);
        }

        public String toString() {
            return this.key;
        }
    }
}

