/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.OccTarget;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OccTargetsWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private KB d_kb;
    private final CSVWriter d_out;
    private final SerializedOutputStream d_stream;

    public static boolean isEnabled(KB kb) {
        return !kb.getOccTargets().getAll().isEmpty();
    }

    public OccTargetsWriter(KB kb) {
        this.d_kb = kb;
        this.d_out = new CSVWriter();
        this.d_stream = new SerializedOutputStream(kb.getParams().out_occtargets_info);
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_stream));
    }

    @Override
    public void close() throws IOException {
        this.d_out.close();
    }

    public void writeHeader(KB kb) {
        this.d_out.add(Header.TIME.get());
        List perLocHeaders = Stream.of(Header.values()).filter(h -> h.perLoc).collect(Collectors.toList());
        for (OccTarget target : this.d_kb.getOccTargets().getAll()) {
            for (Header header : perLocHeaders) {
                this.d_out.add(String.format("%s %s", target.name, header.val.fileStr));
            }
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public void writeFrame(KB kb, double t) {
        this.d_out.add(t);
        OccAgent[] reservations = new OccAgent[kb.getOccTargets().getAll().size()];
        boolean[] using = new boolean[kb.getOccTargets().getAll().size()];
        for (OccAgent agent : kb.getActiveAgents()) {
            for (OccTarget target : kb.getOccTargets().getReservations(agent)) {
                reservations[target.id] = agent;
            }
            agent.getAiCore().getOccTargetInUse(kb, agent).ifPresent(loc -> {
                using[loc.id] = true;
            });
        }
        for (OccTarget target : this.d_kb.getOccTargets().getAll()) {
            OccAgent ragent = reservations[target.id];
            this.d_out.add(ragent != null ? ragent.getName() : "");
            this.d_out.add(ragent != null ? Integer.valueOf(ragent.getId()) : "");
            this.d_out.add(using[target.id]);
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public static enum Header implements Supplier<WriterIntl.ColHeaderString>
    {
        TIME(WriterIntl.intl("Time (s)"), false),
        RESERVED_BY_NAME(WriterIntl.intl("reserved_by"), true),
        RESERVED_BY_ID(WriterIntl.intl("reserved_by_id"), true),
        IN_USE(WriterIntl.intl("in_use"), true);

        public final WriterIntl.ColHeaderString val;
        public final boolean perLoc;

        private Header(WriterIntl.ColHeaderString val, boolean perLoc) {
            this.val = val;
            this.perLoc = perLoc;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeaderString get() {
            return this.val;
        }
    }
}

