/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.MeasurementRegion;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MeasurementRegionWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private SerializedOutputStream d_stream;
    private final CSVWriter d_out;
    private boolean d_seekSpeed;

    public MeasurementRegionWriter(Param p) {
        String fn = String.format("%s_measurement-regions.csv", p.out_snapshot_base);
        this.d_stream = new SerializedOutputStream(fn);
        this.d_out = new CSVWriter();
        this.d_seekSpeed = p.measurement_region_seekspeed;
    }

    public void open() throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_stream));
    }

    @Override
    public void close() throws IOException {
        this.d_out.close();
    }

    public void writeHeader(KB kb) {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(Header.TIME));
        kb.getDensityRegions().forEach(region -> {
            for (Header h : Header.values()) {
                if (h == Header.SEEKVEL && !this.d_seekSpeed || h.desc != null) continue;
                columns.add(new Column(region.name, h));
            }
        });
        for (Column c : columns) {
            this.d_out.add(c.name);
        }
        this.d_out.nextRow();
        for (Column c : columns) {
            this.d_out.add(c.header.quantity.fileStr);
        }
        this.d_out.nextRow();
        for (Column c : columns) {
            this.d_out.add(c.header.unit.fileStr);
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public void writeFrame(KB kb, double t) {
        this.d_out.add(t, 2);
        List dataHeaders = Stream.of(Header.values()).filter(h -> h.desc == null && (this.d_seekSpeed || h != Header.SEEKVEL)).collect(Collectors.toList());
        for (MeasurementRegion region : kb.getDensityRegions()) {
            dataHeaders.stream().mapToDouble(h -> h.getData.applyAsDouble(region.data)).forEach(d -> this.d_out.add(d, 2));
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    private static class Column {
        public final String name;
        public final Header header;

        public Column(String name, Header header) {
            this.name = name;
            this.header = header;
        }

        public Column(Header header) {
            this(header.desc.fileStr, header);
        }
    }

    public static enum Header implements WriterIntl.IColHeader
    {
        TIME(WriterIntl.intl("Time"), WriterIntl.intl("Time"), WriterIntl.intl("s"), d -> d.time),
        DENSITY(null, WriterIntl.intl("Density"), WriterIntl.intl("pers/m2"), d -> d.density),
        VELOCITY(null, WriterIntl.intl("Velocity"), WriterIntl.intl("m/s"), d -> d.velocity),
        SEEKVEL(null, WriterIntl.intl("SeekVelocity"), WriterIntl.intl("m/s"), d -> d.seekVelocity),
        COUNT(null, WriterIntl.intl("Count"), WriterIntl.intl("pers"), d -> d.count);

        public final WriterIntl.ColHeaderString desc;
        public final WriterIntl.ColHeaderString quantity;
        public final WriterIntl.ColHeaderString unit;
        public final ToDoubleFunction<MeasurementRegion.Data> getData;

        private Header(WriterIntl.ColHeaderString desc, WriterIntl.ColHeaderString quantity, WriterIntl.ColHeaderString unit, ToDoubleFunction<MeasurementRegion.Data> getData) {
            this.desc = desc;
            this.quantity = quantity;
            this.unit = unit;
            this.getData = getData;
        }

        public String toString() {
            return this.desc.toString();
        }

        @Override
        public final WriterIntl.ColHeaderString desc() {
            return this.desc != null ? this.desc : new WriterIntl.ColHeaderString();
        }

        @Override
        public WriterIntl.ColHeaderString quantity() {
            return this.quantity;
        }

        @Override
        public WriterIntl.ColHeaderString unit() {
            return this.unit;
        }
    }
}

