/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.AttractorSim;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.output.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Supplier;

public class AttractorWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private KB d_kb;
    private final CSVWriter d_out;
    private final SerializedOutputStream d_stream;

    public static boolean isEnabled(KB kb) {
        return !kb.getRootAttractors().isEmpty();
    }

    public AttractorWriter(KB kb) {
        this.d_kb = kb;
        this.d_out = new CSVWriter();
        this.d_stream = new SerializedOutputStream(kb.getParams().out_attractor_info);
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_stream));
    }

    @Override
    public void close() throws IOException {
        this.d_out.close();
    }

    public void writeHeader(KB kb) {
        this.d_out.add(Header.TIME.get());
        for (AttractorSim attr : this.d_kb.getRootAttractors()) {
            this.d_out.add(String.format("%s %s", attr.name, Header.USAGE.val.fileStr));
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public void writeFrame(KB kb, double t) {
        this.d_out.add(t);
        int[] counts = new int[kb.getRootAttractors().size()];
        for (OccAgent agent : kb.getActiveAgents()) {
            agent.getAiCore().getAttractorInUse(kb, agent).ifPresent(core -> {
                int n = core.getRootId();
                counts[n] = counts[n] + 1;
            });
        }
        for (AttractorSim attr : this.d_kb.getRootAttractors()) {
            this.d_out.add(counts[attr.getRootId()]);
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public static enum Header implements Supplier<WriterIntl.ColHeaderString>
    {
        TIME(WriterIntl.intl("Time (s)")),
        USAGE(WriterIntl.intl("Usage (occs)"));

        public final WriterIntl.ColHeaderString val;

        private Header(WriterIntl.ColHeaderString val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeaderString get() {
            return this.val;
        }
    }
}

