/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import common.Flags;
import common.PathfinderLM;
import common.io.pfr.PFRWriter;
import inferno.InfernoPrefs;
import inferno.data2.ANode;
import inferno.data2.MeasurementRegion;
import inferno.data2.NullProps;
import inferno.data2.Occupant;
import inferno.data2.Props;
import inferno.data2.ai.IProgressNote;
import inferno.geom.IDensityField;
import inferno.io.CSVWriter;
import inferno.io.SnapshotWriter;
import inferno.sim.CameraAgent;
import inferno.sim.CycleBreaker;
import inferno.sim.EngineOp;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.occsource.OccSource;
import inferno.sim.output.AttractorWriter;
import inferno.sim.output.DoorUsageWriter;
import inferno.sim.output.DtWriter;
import inferno.sim.output.GeomVisWriter;
import inferno.sim.output.GroupInfoWriter;
import inferno.sim.output.IOccDataWriter;
import inferno.sim.output.MeasurementRegionWriter;
import inferno.sim.output.OccDataCumulativeWriter;
import inferno.sim.output.OccDataWriterMultiple;
import inferno.sim.output.OccDataWriterSingle;
import inferno.sim.output.OccParamsWriter;
import inferno.sim.output.OccTargetsWriter;
import inferno.sim.output.OccVisWriter;
import inferno.sim.output.RoomUsageWriter;
import inferno.sim.output.SocialDistanceAccumulatedWriter;
import inferno.sim.output.SocialDistanceTransientWriter;
import inferno.sim.output.StuckWriter;
import inferno.sim.output.SummaryWriter;
import inferno.sim.output.json.AOccDataWriterJson;
import inferno.sim.output.json.AttractorWriterJson;
import inferno.sim.output.json.CombinedOutputWriterJson;
import inferno.sim.output.json.DoorUsageWriterJson;
import inferno.sim.output.json.GroupInfoWriterJson;
import inferno.sim.output.json.MeasurementRegionWriterJson;
import inferno.sim.output.json.OccDataCumulativeWriterJson;
import inferno.sim.output.json.OccDataWriterMultipleJson;
import inferno.sim.output.json.OccDataWriterSingleJson;
import inferno.sim.output.json.OccParamsWriterJson;
import inferno.sim.output.json.OccTargetsWriterJson;
import inferno.sim.output.json.RoomUsageWriterJson;
import inferno.sim.output.json.SocialDistanceAccumulatedWriterJson;
import inferno.sim.output.json.SocialDistanceTransientWriterJson;
import inferno.sim.profiling.TimeAccum;
import inferno.sim.scripting.ScriptHandler;
import inferno.vis.GLWindow;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.SystemProps;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.mtproc.MTProcessor;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class Engine
extends Observable
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(Engine.class.getName());
    public static final String THREAD_NAME = "Engine";
    public static final IPropertySet.Prop<Long> META_TIME_TS = new IPropertySet.Prop<Long>("ts", 0L);
    public static final IPropertySet.Prop<Double> META_TIME_SIM = new IPropertySet.Prop<Double>("simulation_time", 0.0);
    public static final IPropertySet.Prop<Double> META_TIME_WALL = new IPropertySet.Prop<Double>("wall_clock_time", 0.0);
    public static final IPropertySet.Prop<Double> META_TIME_DT = new IPropertySet.Prop<Double>("dt", 0.0);
    public static final IPropertySet.Prop<Integer> META_OCCS_REM = new IPropertySet.Prop<Integer>("occupants_remaining", 0);
    public static final IPropertySet.Prop<Integer> META_OCCS_TOTAL = new IPropertySet.Prop<Integer>("occupants_total", 0);
    public static final IPropertySet.Prop<Double> META_DTG_MAX = new IPropertySet.Prop<Double>("distance_to_goal_max", 0.0);
    public static final IPropertySet.Prop<Double> META_DTG_AVG = new IPropertySet.Prop<Double>("distance_to_goal_avg", 0.0);
    public static final IPropertySet.Prop<Double> META_DTG_MIN = new IPropertySet.Prop<Double>("distance_to_goal_min", 0.0);
    public static final IPropertySet.Prop<Boolean> META_STUCK_STATUS = new IPropertySet.Prop<Boolean>("stuck_status", false);
    public static final IPropertySet.Prop<State> META_STATE = new IPropertySet.Prop<State>("state", State.RUNNING);
    private static final boolean isDev = System.getProperty("dev") != null;
    private final KB d_kb;
    private final List<OccAgent> d_occAgents;
    private final List<CameraAgent> d_camAgents;
    private final Param d_param;
    private final TimeAccum d_ticks;
    private long d_ts;
    private BigDecimal d_dt;
    private double d_wallDt;
    private BigDecimal d_simTime;
    private OccVisWriter d_occHistWriter;
    private GeomVisWriter d_geomHistWriter;
    private RoomUsageWriter d_roomUsageWriter;
    private RoomUsageWriterJson d_roomUsageWriterJson;
    private DoorUsageWriter d_doorUsageWriter;
    private DoorUsageWriterJson d_doorUsageWriterJson;
    private IOccDataWriter d_occDataWriters;
    private AOccDataWriterJson d_occDataWriterJson;
    private OccDataCumulativeWriterJson d_occDataCumulativeWriterJson;
    private OccParamsWriter d_occParamsWriter;
    private OccParamsWriterJson d_occParamsWriterJson;
    private AttractorWriter d_attrWriter;
    private AttractorWriterJson d_attrWriterJson;
    private OccTargetsWriter d_occTargetsWriter;
    private OccTargetsWriterJson d_occTargetsWriterJson;
    private DtWriter d_dtWriter;
    private transient List<OccAgent> d_addedAgents;
    private MeasurementRegionWriter d_densityWriter;
    private MeasurementRegionWriterJson d_densityWriterJson;
    private SnapshotWriter d_snapshotWriter;
    private SocialDistanceTransientWriter d_sdTransWriter;
    private SocialDistanceTransientWriterJson d_sdTransWriterJson;
    private SocialDistanceAccumulatedWriter d_sdAccumWriter;
    private SocialDistanceAccumulatedWriterJson d_sdAccumWriterJson;
    private GroupInfoWriter d_groupInfoWriter;
    private GroupInfoWriterJson d_groupInfoWriterJson;
    private CombinedOutputWriterJson d_combinedOutputWriterJson;
    private AtomicBoolean d_stuckWritten;
    private transient PathfinderLM d_license;
    private transient GLWindow d_glView;
    private transient int d_paused;
    private transient boolean d_enginePaused;
    private transient AtomicBoolean d_cancel;
    private transient AtomicBoolean d_writeSnapshot;
    private transient AtomicBoolean d_finished;
    private Throwable[] d_caughtException = new Throwable[]{null};
    public static TimeAccum TIME_ACCUM;
    private transient Runnable d_timedCallback;
    private transient double d_timedCallbackInterval;
    private transient double d_timedCallbackLastInvoked;
    private transient AtomicBoolean d_notifyCallback;
    private List<EngineOp> d_opQueue;
    private double d_nextPlotTime;
    private double d_nextCSVPlotTime;
    private double d_nextSnapshotTime;
    private double d_nextCbTime;
    private double d_cbUpdateInterval;
    private transient ScriptHandler d_scripting;

    public static boolean isDev() {
        return isDev;
    }

    public Engine(KB kb, Param p, TimeAccum ticks) throws FileNotFoundException {
        this.d_license = new PathfinderLM();
        this.d_kb = kb;
        this.d_param = p;
        TIME_ACCUM = this.d_ticks = ticks != null ? ticks : new TimeAccum();
        this.d_ticks.begin("STARTUP");
        this.d_occAgents = this.d_kb.getAgents();
        this.d_camAgents = this.d_kb.getCameraAgents();
        this.d_simTime = BigDecimal.ZERO;
        this.d_dt = BigDecimal.valueOf(this.d_param.dt_init);
        this.d_paused = 0;
        this.d_enginePaused = false;
        this.d_cancel = new AtomicBoolean(false);
        this.d_writeSnapshot = new AtomicBoolean(false);
        this.d_finished = new AtomicBoolean(false);
        this.d_occHistWriter = new OccVisWriter(this.d_param.out_occ_time_history, kb);
        this.d_geomHistWriter = new GeomVisWriter(this.d_param.out_geom_time_history);
        this.d_roomUsageWriter = new RoomUsageWriter(kb);
        this.d_doorUsageWriter = new DoorUsageWriter(kb);
        this.d_groupInfoWriter = new GroupInfoWriter(kb);
        this.d_stuckWritten = new AtomicBoolean(false);
        if (kb.getParams().social_distance_csv_output) {
            double sd = kb.getParams().social_distance_value;
            this.d_kb.getMesh().shrinkInternalEdgesFromBoundary(Arrays.asList(0.1));
            this.d_sdTransWriter = new SocialDistanceTransientWriter(kb, 3.0);
            this.d_sdAccumWriter = new SocialDistanceAccumulatedWriter(kb, sd);
        }
        try {
            this.d_snapshotWriter = new SnapshotWriter(this.d_param.out_snapshot_base + ".snapshot");
        }
        catch (SnapshotWriter.SnapshotWriterInitException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e.getCause());
            this.d_snapshotWriter = null;
        }
        this.d_occDataWriters = kb.getParams().occ_csv_file_as_one ? new OccDataWriterSingle(kb) : new OccDataWriterMultiple(kb);
        this.d_occParamsWriter = kb.getParams().write_occ_params_file ? new OccParamsWriter(kb) : null;
        this.d_attrWriter = AttractorWriter.isEnabled(kb) ? new AttractorWriter(kb) : null;
        this.d_occTargetsWriter = OccTargetsWriter.isEnabled(kb) ? new OccTargetsWriter(kb) : null;
        this.d_dtWriter = new DtWriter(kb);
        MeasurementRegionWriter measurementRegionWriter = this.d_densityWriter = !this.d_kb.getDensityRegions().isEmpty() ? new MeasurementRegionWriter(this.d_param) : null;
        if (this.d_param.enable_json_output) {
            this.d_attrWriterJson = AttractorWriterJson.isWriterEnabled(kb) ? new AttractorWriterJson(kb) : null;
            this.d_doorUsageWriterJson = DoorUsageWriterJson.isWriterEnabled(kb) ? new DoorUsageWriterJson(kb) : null;
            this.d_groupInfoWriterJson = GroupInfoWriterJson.isWriterEnabled(kb) ? new GroupInfoWriterJson(kb) : null;
            this.d_densityWriterJson = MeasurementRegionWriterJson.isWriterEnabled(kb) ? new MeasurementRegionWriterJson(kb) : null;
            this.d_roomUsageWriterJson = RoomUsageWriterJson.isWriterEnabled(kb) ? new RoomUsageWriterJson(kb) : null;
            this.d_occTargetsWriterJson = OccTargetsWriterJson.isWriterEnabled(kb) ? new OccTargetsWriterJson(kb) : null;
            OccDataCumulativeWriterJson occDataCumulativeWriterJson = this.d_occDataCumulativeWriterJson = OccDataCumulativeWriterJson.isWriterEnabled(kb) ? new OccDataCumulativeWriterJson(kb) : null;
            if (AOccDataWriterJson.isWriterEnabled(kb)) {
                this.d_occDataWriterJson = this.d_param.occ_csv_file_as_one ? new OccDataWriterSingleJson(kb, true) : new OccDataWriterMultipleJson(kb);
            }
            this.d_occParamsWriterJson = OccParamsWriterJson.isWriterEnabled(kb) ? new OccParamsWriterJson(kb) : null;
            this.d_sdAccumWriterJson = SocialDistanceAccumulatedWriterJson.isWriterEnabled(kb) ? new SocialDistanceAccumulatedWriterJson(kb, this.d_param.social_distance_value) : null;
            this.d_sdTransWriterJson = SocialDistanceTransientWriterJson.isWriterEnabled(kb) ? new SocialDistanceTransientWriterJson(kb) : null;
            this.d_combinedOutputWriterJson = CombinedOutputWriterJson.isWriterEnabled(kb) ? new CombinedOutputWriterJson(kb) : null;
        }
        this.d_addedAgents = new ArrayList<OccAgent>();
        this.d_nextPlotTime = this.d_param.dt_vis > 0.0 ? this.d_param.dt_vis : Double.POSITIVE_INFINITY;
        this.d_nextCSVPlotTime = this.d_param.dt_csv_data > 0.0 ? this.d_param.dt_csv_data : Double.POSITIVE_INFINITY;
        this.d_nextSnapshotTime = this.d_param.dt_snapshot > 0.0 ? this.d_param.dt_snapshot : Double.POSITIVE_INFINITY;
        this.d_cbUpdateInterval = CycleBreaker.getUpdateInterval(this.d_occAgents, this.d_kb.getOccSources());
        double d = this.d_nextCbTime = this.d_cbUpdateInterval > 0.0 ? this.d_cbUpdateInterval : Double.POSITIVE_INFINITY;
        if (p.show_vis) {
            this.createVis();
            this.pause();
        }
        this.setTimedCallback(Double.POSITIVE_INFINITY, null);
        this.d_notifyCallback = new AtomicBoolean(false);
        this.d_opQueue = Collections.synchronizedList(new ArrayList());
        this.d_ts = 0L;
        this.d_scripting = !this.d_kb.getScripts().isEmpty() ? new ScriptHandler(this, this.d_kb) : ScriptHandler.createNullHandler();
    }

    private void writeResultsFile() {
        try {
            Param p = this.d_kb.getParams();
            PFRWriter.createResultsFiles(p.dir, p.input, p.out_results, p.out_occ_time_history, p.out_geom_time_history, p.imported_geom, p.views);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_license = new PathfinderLM();
        this.d_paused = 0;
        this.d_enginePaused = false;
        this.d_cancel = new AtomicBoolean(false);
        this.d_writeSnapshot = new AtomicBoolean(false);
        this.d_finished = new AtomicBoolean(false);
        if (this.d_param.show_vis) {
            this.createVis();
        }
        this.d_notifyCallback = new AtomicBoolean(false);
        this.d_addedAgents = new ArrayList<OccAgent>();
        this.d_scripting = new ScriptHandler(this, this.d_kb);
        TIME_ACCUM = this.d_ticks;
    }

    public void agentAdded(OccAgent oa) {
        if (0 < oa.getOcc().outputTimeHistory || this.d_occParamsWriter != null) {
            this.d_addedAgents.add(oa);
        }
    }

    public boolean hasDensityFields() {
        return System.getProperty("smooth_voronoi") != null || this.d_densityWriter != null || this.d_densityWriterJson != null;
    }

    public void setTimedCallback(double dt, Runnable callback) {
        this.d_timedCallback = callback;
        this.d_timedCallbackInterval = dt;
        this.d_timedCallbackLastInvoked = this.t();
    }

    private void checkTimedCallback() {
        if (this.t() >= this.d_timedCallbackLastInvoked + this.d_timedCallbackInterval) {
            this.d_notifyCallback.set(true);
            this.notifyTimedCallback();
        }
    }

    private void notifyTimedCallback() {
        if (this.d_timedCallback != null && this.d_notifyCallback.get()) {
            this.d_timedCallback.run();
            this.d_timedCallbackLastInvoked = this.t();
            this.d_notifyCallback.set(false);
        }
    }

    private void forceCallback() {
        this.d_notifyCallback.set(true);
        this.notifyTimedCallback();
    }

    public void scheduleSnapshot() {
        this.d_writeSnapshot.set(true);
    }

    public GLWindow getGLView() {
        return this.d_glView;
    }

    private void createVis() {
        this.d_kb.setProps(new Props());
        this.d_glView = new GLWindow("Debug", this);
        this.d_glView.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent e) {
                Engine engine = Engine.this;
                synchronized (engine) {
                    Engine.this.d_glView = null;
                    Engine.this.d_param.show_vis = false;
                }
                Engine.this.pushOp(new EngineOp(){
                    private static final long serialVersionUID = 1061188394302413939L;

                    @Override
                    public void run(Engine e) {
                        Engine.this.d_kb.setProps(new NullProps());
                    }
                });
            }
        });
        this.d_param.show_vis = true;
        this.updateVis();
    }

    public synchronized void showVis() {
        if (this.d_param.show_vis) {
            return;
        }
        this.createVis();
        this.d_glView.setVisible(true);
    }

    public Param getParam() {
        return this.d_param;
    }

    public int getAgentCount() {
        return this.d_kb.getOccs().size();
    }

    public void cancel() {
        this.d_cancel.set(true);
        this.resume();
    }

    public void checkCancel() throws CanceledException {
        if (this.d_cancel.get()) {
            this.checkSnapshot();
            throw new CanceledException();
        }
    }

    public void pause() {
        this.pause(false);
    }

    public synchronized void pause(boolean wait) {
        ++this.d_paused;
        if (wait && this.d_paused > 0 && !this.d_enginePaused) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void resume() {
        --this.d_paused;
    }

    public synchronized boolean isPaused() {
        return this.d_paused > 0;
    }

    public void scheduleCallbackNotification() {
        this.d_notifyCallback.set(true);
    }

    private synchronized void checkPause(Runnable onPause, Runnable onResume) {
        if (this.d_paused > 0) {
            LOGGER.info("paused");
            this.d_ticks.end("SIMULATION");
            this.d_enginePaused = true;
            onPause.run();
            this.notifyAll();
            while (this.d_paused > 0) {
                this.processOpQueue();
                this.notifyTimedCallback();
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            this.d_enginePaused = false;
            this.d_ticks.begin("SIMULATION");
            LOGGER.info("resume");
            onResume.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOpQueue() {
        this.getKB().getPathEstimates().pauseWorkers();
        List<EngineOp> list = this.d_opQueue;
        synchronized (list) {
            for (EngineOp op : this.d_opQueue) {
                op.run(this);
                EngineOp engineOp = op;
                synchronized (engineOp) {
                    op.notifyAll();
                }
            }
            this.d_opQueue.clear();
        }
        this.getKB().getPathEstimates().resumeWorkers();
    }

    public void pushOp(EngineOp op) {
        this.pushOp(op, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushOp(EngineOp op, boolean waitForOp) {
        if (!waitForOp) {
            this.d_opQueue.add(op);
        } else {
            List<EngineOp> list = this.d_opQueue;
            synchronized (list) {
                this.d_opQueue.add(op);
                EngineOp engineOp = op;
                synchronized (engineOp) {
                    try {
                        op.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void processTimeBasedEvents() {
        NavigableMap<Double, EngineOp> events = this.d_kb.getEvents();
        NavigableMap<Double, EngineOp> passedEvts = events.headMap(this.t(), true);
        this.d_opQueue.addAll(passedEvts.values());
        passedEvts.clear();
    }

    public boolean hasFutureTimeBasedEvents() {
        return !this.d_kb.getEvents().isEmpty();
    }

    private boolean startLicenseServerWithRetry(TeciProps prefs, int attempts) {
        for (int i = 0; i < attempts; ++i) {
            if (PathfinderLM.startFromPrefs(this.d_license, prefs)) {
                return true;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(150 - new Random().nextInt(100));
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void run(final TeciProps prefs) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Throwable[] throwableArray = Engine.this.d_caughtException;
                synchronized (Engine.this.d_caughtException) {
                    Engine.this.d_caughtException[0] = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    MetaUpdator metaUpdator = new MetaUpdator();
                    try {
                        boolean started = Engine.this.startLicenseServerWithRetry(prefs, 3);
                        LOGGER.config(Engine.this.d_license.getDescription());
                        if (!started) {
                            LOGGER.log(Level.WARNING, Engine.this.d_license.getLastError());
                            throw new RuntimeException("Unable to start license manager.");
                        }
                        if (!Engine.this.d_license.isAuthorized()) {
                            throw new RuntimeException("Unable to authorize license manager.");
                        }
                        Engine.this.runSingleThread(metaUpdator);
                    }
                    catch (CanceledException e) {
                        LOGGER.log(Level.SEVERE, "canceled");
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                    catch (ExecutionException e) {
                        Throwable[] throwableArray2 = Engine.this.d_caughtException;
                        synchronized (Engine.this.d_caughtException) {
                            Engine.this.d_caughtException[0] = e.getCause();
                            // ** MonitorExit[var3_11] (shouldn't be in output)
                            return;
                        }
                    }
                    catch (RuntimeException e) {
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                    catch (Throwable e) {
                        Throwable[] t = Engine.this.d_caughtException;
                        synchronized (Engine.this.d_caughtException) {
                            Engine.this.d_caughtException[0] = e;
                            // ** MonitorExit[t] (shouldn't be in output)
                            return;
                        }
                    }
                    finally {
                        Engine.this.d_finished.set(true);
                        try {
                            Engine.this.forceCallback();
                            metaUpdator.post(Engine.this);
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.SEVERE, t.toString(), t);
                        }
                        Engine.this.d_license.closeLM();
                    }
                    return;
                }
            }
        }, THREAD_NAME).start();
    }

    public KB getKB() {
        return this.d_kb;
    }

    public boolean isFinished() {
        return this.d_finished.get();
    }

    public void waitUntilFinished(long pollFreq) throws ExecutionException, FileNotFoundException {
        while (!this.isFinished()) {
            try {
                Thread.sleep(pollFreq);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.throwCaughtExceptionIfPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwCaughtExceptionIfPresent() throws ExecutionException, FileNotFoundException {
        Throwable[] throwableArray = this.d_caughtException;
        synchronized (this.d_caughtException) {
            Throwable t = this.d_caughtException[0];
            if (t instanceof FileNotFoundException) {
                throw (FileNotFoundException)this.d_caughtException[0];
            }
            if (t instanceof ExecutionException) {
                throw (ExecutionException)t;
            }
            if (t != null) {
                throw new ExecutionException(t);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void postMessage(IPropertySet engineMeta) {
        this.setChanged();
        this.notifyObservers(engineMeta);
    }

    public synchronized double t() {
        return this.d_simTime.doubleValue();
    }

    private synchronized void updateTime(BigDecimal dt) {
        this.d_simTime = this.d_simTime.add(dt);
        this.d_kb.setCurrentSimTime(this.d_simTime.doubleValue());
    }

    public long getCurrentTimeStep() {
        return this.d_ts;
    }

    public double getCurrentDt() {
        return this.d_kb.getDt();
    }

    public double getPreviousWallDt() {
        return this.d_wallDt;
    }

    public static int getNumProcThreads() {
        Integer nThreadsPref = Flags.NTHREADS.getValue();
        if (nThreadsPref != null && nThreadsPref != 0) {
            return nThreadsPref;
        }
        return Runtime.getRuntime().availableProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void runSingleThread(MetaUpdator metaUpdator) throws CanceledException, ExecutionException, IOException {
        if (!this.d_license.isAuthorized()) {
            throw new RuntimeException("no license");
        }
        assert (this.d_kb.isValid());
        this.d_dt = BigDecimal.valueOf(this.d_param.dt_init);
        this.d_kb.setDt(this.d_dt.doubleValue());
        double initWallTime = 0.0;
        double beginTime = this.t();
        double realtimeError = 0.0;
        double nextDoorQueueUpdate = Double.NEGATIVE_INFINITY;
        double nextWallUpdate = this.d_param.dt_wall_meta;
        double endTime = this.d_param.max_time == 0.0 ? Double.POSITIVE_INFINITY : this.d_param.max_time;
        ArrayList<Closeable> ioToCleanUp = new ArrayList<Closeable>();
        try {
            ioToCleanUp.add(this.d_occHistWriter);
            ioToCleanUp.add(this.d_geomHistWriter);
            this.d_roomUsageWriter.open(this.d_param);
            ioToCleanUp.add(this.d_roomUsageWriter);
            this.d_doorUsageWriter.open(this.d_param);
            ioToCleanUp.add(this.d_doorUsageWriter);
            this.d_occDataWriters.open(this.d_param);
            ioToCleanUp.add(this.d_occDataWriters);
            this.d_groupInfoWriter.open(this.d_param);
            ioToCleanUp.add(this.d_groupInfoWriter);
            if (this.d_sdTransWriter != null) {
                this.d_sdTransWriter.open(this.d_param);
                ioToCleanUp.add(this.d_sdTransWriter);
            }
            if (this.d_sdAccumWriter != null) {
                this.d_sdAccumWriter.open(this.d_param);
                ioToCleanUp.add(this.d_sdAccumWriter);
            }
            if (this.d_occParamsWriter != null) {
                this.d_occParamsWriter.open(this.d_param);
                ioToCleanUp.add(this.d_occParamsWriter);
            }
            if (this.d_attrWriter != null) {
                this.d_attrWriter.open(this.d_param);
                ioToCleanUp.add(this.d_attrWriter);
            }
            if (this.d_occTargetsWriter != null) {
                this.d_occTargetsWriter.open(this.d_param);
                ioToCleanUp.add(this.d_occTargetsWriter);
            }
            this.d_dtWriter.open(this.d_param);
            ioToCleanUp.add(this.d_dtWriter);
            if (this.d_densityWriter != null) {
                this.d_densityWriter.open();
                ioToCleanUp.add(this.d_densityWriter);
            }
            if (this.d_param.enable_json_output) {
                if (this.d_attrWriterJson != null) {
                    this.d_attrWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_attrWriterJson);
                }
                if (this.d_doorUsageWriterJson != null) {
                    this.d_doorUsageWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_doorUsageWriterJson);
                }
                if (this.d_groupInfoWriterJson != null) {
                    this.d_groupInfoWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_groupInfoWriterJson);
                }
                if (this.d_densityWriterJson != null) {
                    this.d_densityWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_densityWriterJson);
                }
                if (this.d_roomUsageWriterJson != null) {
                    this.d_roomUsageWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_roomUsageWriterJson);
                }
                if (this.d_occTargetsWriterJson != null) {
                    this.d_occTargetsWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_occTargetsWriterJson);
                }
                if (this.d_occDataCumulativeWriterJson != null) {
                    this.d_occDataCumulativeWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_occDataCumulativeWriterJson);
                }
                if (this.d_occDataWriterJson != null) {
                    this.d_occDataWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_occDataWriterJson);
                }
                if (this.d_occParamsWriterJson != null) {
                    this.d_occParamsWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_occParamsWriterJson);
                }
                if (this.d_sdAccumWriterJson != null) {
                    this.d_sdAccumWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_sdAccumWriterJson);
                }
                if (this.d_sdTransWriterJson != null) {
                    this.d_sdTransWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_sdTransWriterJson);
                }
                if (this.d_combinedOutputWriterJson != null) {
                    this.d_combinedOutputWriterJson.open(this.t(), this.d_param);
                    ioToCleanUp.add(this.d_combinedOutputWriterJson);
                }
            }
        }
        catch (IOException e) {
            for (Closeable stream : ioToCleanUp) {
                Output.close(stream);
            }
            throw e;
        }
        StuckWriter.deleteStuck(this.d_kb);
        MTProcessor mtproc = new MTProcessor(Engine.getNumProcThreads(), MTProcessor.Schedule.GUIDED, this.d_kb.getThreadPool());
        LOGGER.info(String.format("using %s threads", Engine.getNumProcThreads()));
        Predicate<OccAgent> NOT_ISDONE = agent -> !agent.isDone();
        ArrayList dwriterNodes = new ArrayList();
        boolean doAssistedPremove = this.d_kb.getAssistedEvacTeams() != null && !this.d_kb.getAssistedEvacTeams().isEmpty();
        boolean updateAllDensityFields = System.getProperty("smooth_voronoi") != null;
        theTimer wallTimer = new theTimer();
        try {
            boolean finished;
            ThrowingRunnable updateDensityFields = () -> {
                this.d_ticks.begin("UPDATE DENSITY FIELD");
                if (updateAllDensityFields) {
                    mtproc.process(MTProcessor.Schedule.DYNAMIC, this.d_kb.getNodes(), node -> node.updateDensityField(this.d_kb));
                } else {
                    mtproc.process(MTProcessor.Schedule.DYNAMIC, dwriterNodes, node -> node.updateDensityField(this.d_kb));
                }
                this.d_ticks.end("UPDATE DENSITY FIELD");
            };
            ThrowingRunnable updateDensityRegions = () -> {
                this.d_ticks.begin("UPDATE DENSITY REGIONS");
                mtproc.process(MTProcessor.Schedule.DYNAMIC, this.d_kb.getDensityRegions(), r -> r.update(this.d_kb));
                this.d_ticks.end("UPDATE DENSITY REGIONS");
            };
            this.d_ticks.end("STARTUP");
            this.d_ticks.begin("SIMULATION");
            if (this.d_ts == 0L) {
                wallTimer.reset();
                boolean abort = false;
                if (this.d_kb.hasQueueingDoors()) {
                    Iterator<Object> invalidNodes = new ArrayList();
                    for (ANode node2 : this.d_kb.getQueuingDoors()) {
                        if (!(node2.getArea() > 0.0)) continue;
                        invalidNodes.add(node2);
                        abort = true;
                    }
                    if (!invalidNodes.isEmpty()) {
                        LOGGER.log(Level.WARNING, "Fatal Error - Thick Doors");
                        Iterator iterator = invalidNodes.iterator();
                        while (iterator.hasNext()) {
                            ANode node2 = (ANode)iterator.next();
                            LOGGER.log(Level.FINER, node2.name);
                        }
                        abort = true;
                    }
                }
                if (abort) {
                    LOGGER.log(Level.WARNING, "Simulation Aborted");
                    return;
                }
                this.d_ticks.begin("SHRINK INTERNAL EDGES");
                this.d_kb.trimMeshes(this.d_param.max_trim_error);
                this.d_ticks.end("SHRINK INTERNAL EDGES");
                this.d_ticks.begin("SCRIPT");
                this.processTimeBasedEvents();
                this.processOpQueue();
                for (String string : this.d_kb.getScripts()) {
                    this.d_scripting.init(string);
                }
                this.d_ticks.end("SCRIPT");
                this.d_ticks.begin("UPDATE TRIMMED EDGES");
                this.d_kb.updateTrimmedMeshes();
                this.d_ticks.end("UPDATE TRIMMED EDGES");
                this.d_ticks.begin("INIT");
                this.d_kb.getPathEstimates().init();
                for (OccGroup occGroup : this.d_kb.getOccupantGroups()) {
                    occGroup.update(this.d_kb);
                }
                this.d_kb.getPathEstimates().pauseWorkers();
                Set<OccAgent> failed = Collections.synchronizedSet(new LinkedHashSet());
                mtproc.process(MTProcessor.Schedule.DYNAMIC, this.d_kb.getAgents(), NOT_ISDONE, agent -> {
                    boolean result = agent.init(this.d_kb, this.d_kb.getParams());
                    if (!result) {
                        failed.add((OccAgent)agent);
                    }
                });
                this.d_kb.getPathEstimates().resumeWorkers();
                this.d_kb.invalidateAgents(failed);
                for (CameraAgent camAgent : this.d_camAgents) {
                    camAgent.init(this.d_kb, this.d_param);
                }
                if (this.d_param.handle_collisions && this.d_param.reactive_steering) {
                    List<Occupant> list = this.d_kb.getInvalidOccs(this.d_kb.getOccs(), true, false);
                    if (list.size() > 0) {
                        LOGGER.warning(String.format("%d Occupants overlap boundaries%n", list.size()));
                        ArrayList<String> names = new ArrayList<String>();
                        for (Occupant occupant : list) {
                            names.add(occupant.name);
                            if (7 >= names.size()) continue;
                            LOGGER.log(Level.FINER, ((Object)names).toString());
                            names.clear();
                        }
                        LOGGER.log(Level.FINER, ((Object)names).toString());
                    }
                    List<Occupant> overlappingOccs = this.d_kb.getInvalidOccs(this.d_kb.getOccs(), false, true);
                    overlappingOccs.removeAll(list);
                    if (overlappingOccs.size() > 0) {
                        LOGGER.warning(String.format("%d Overlapping Occupants%n", overlappingOccs.size()));
                        ArrayList<String> names = new ArrayList<String>();
                        Iterator iterator = overlappingOccs.iterator();
                        while (iterator.hasNext()) {
                            Occupant occ2 = (Occupant)iterator.next();
                            names.add(occ2.name);
                            if (7 >= names.size()) continue;
                            LOGGER.log(Level.FINER, ((Object)names).toString());
                            names.clear();
                        }
                        LOGGER.log(Level.FINER, ((Object)names).toString());
                    }
                }
                this.d_ticks.end("INIT");
                this.d_ticks.begin("UPDATE NODES");
                mtproc.process(this.d_kb.getNodes(), n -> n.updateOccupantCounts(this.d_kb));
                this.d_ticks.end("UPDATE NODES");
                this.d_nextPlotTime = 0.0;
                this.writeResultsFile();
                if (this.d_densityWriter != null) {
                    LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
                    for (MeasurementRegion dwriter : this.d_kb.getDensityRegions()) {
                        dwriter.getNodes(this.d_kb, linkedIdentityHashSet::add);
                    }
                    dwriterNodes.addAll(linkedIdentityHashSet);
                }
                updateDensityFields.run();
                updateDensityRegions.run();
                this.d_ticks.begin("WRITE OUTPUT");
                this.d_occHistWriter.writeHeader(this.d_kb);
                this.d_geomHistWriter.writeHeader(this.d_kb);
                this.d_roomUsageWriter.writeHeader();
                this.d_doorUsageWriter.writeHeader();
                this.d_occDataWriters.writeHeader();
                this.d_groupInfoWriter.writeHeader();
                if (this.d_sdTransWriter != null) {
                    this.d_sdTransWriter.writeHeader();
                }
                if (this.d_sdAccumWriter != null) {
                    this.d_sdAccumWriter.writeHeader();
                }
                if (this.d_occParamsWriter != null) {
                    this.d_occParamsWriter.writeHeader();
                }
                if (this.d_attrWriter != null) {
                    this.d_attrWriter.writeHeader(this.d_kb);
                }
                if (this.d_occTargetsWriter != null) {
                    this.d_occTargetsWriter.writeHeader(this.d_kb);
                }
                this.d_dtWriter.writeHeader(this.d_kb);
                if (this.d_densityWriter != null) {
                    this.d_densityWriter.writeHeader(this.d_kb);
                }
                this.d_occHistWriter.writeFrame(this.d_kb, this.t(), this.d_occAgents);
                this.d_geomHistWriter.writeFrame(this.d_kb, this.t());
                this.d_roomUsageWriter.writeFrame(this.t());
                if (this.d_sdTransWriter != null) {
                    this.d_sdTransWriter.writeFrame(this.t());
                }
                this.d_doorUsageWriter.writeFrame(this.t());
                this.d_occDataWriters.writeFrame(this.t(), false);
                this.d_groupInfoWriter.writeFrame(this.t());
                if (this.d_occParamsWriter != null) {
                    this.d_occParamsWriter.init(this.t());
                }
                if (this.d_densityWriter != null) {
                    this.d_densityWriter.writeFrame(this.d_kb, this.t());
                }
                this.d_kb.getOccEnvData().update(this.d_kb, this.t());
                if (this.d_param.enable_json_output) {
                    if (this.d_attrWriterJson != null) {
                        this.d_attrWriterJson.writeFrame(this.t());
                    }
                    if (this.d_doorUsageWriterJson != null) {
                        this.d_doorUsageWriterJson.writeFrame(this.t());
                    }
                    if (this.d_groupInfoWriterJson != null) {
                        this.d_groupInfoWriterJson.writeFrame(this.t());
                    }
                    if (this.d_densityWriterJson != null) {
                        this.d_densityWriterJson.writeFrame(this.t());
                    }
                    if (this.d_roomUsageWriterJson != null) {
                        this.d_roomUsageWriterJson.writeFrame(this.t());
                    }
                    if (this.d_occDataWriterJson != null) {
                        this.d_occDataWriterJson.writeFrame(this.t(), false);
                    }
                    if (this.d_occParamsWriterJson != null) {
                        this.d_occParamsWriterJson.init(this.t());
                    }
                    if (this.d_sdTransWriterJson != null) {
                        this.d_sdTransWriterJson.writeFrame(this.t());
                    }
                }
                this.d_ticks.end("WRITE OUTPUT");
                initWallTime = wallTimer.curr();
                metaUpdator.addWallTime(initWallTime);
            }
            this.d_kb.setCurrentSimTime(this.t());
            if (this.d_param.show_vis) {
                this.d_glView.setVisible(true);
            }
            this.updateVis();
            String printMsg = this.d_ts == 0L ? "SIMULATION BEGIN" : String.format("SIMULATION RESUME from t=%g", this.t());
            LOGGER.log(Level.FINE, printMsg);
            this.d_ticks.begin("CALLBACK");
            this.checkTimedCallback();
            this.d_ticks.end("CALLBACK");
            Runnable onPauseResume = () -> {
                this.forceCallback();
                metaUpdator.post(this);
                if (!this.d_cancel.get()) {
                    StuckWriter.deleteStuck(this.d_kb);
                    this.d_stuckWritten.set(false);
                }
            };
            Runnable runnable = () -> {
                this.forceCallback();
                metaUpdator.post(this);
            };
            if (System.getProperty("ex_print_occupant_params") != null) {
                this.pushOp(new EngineOp.DumpAgentsTsv());
            }
            boolean bl = finished = this.d_occAgents.isEmpty() && this.d_kb.checkOccSourcesFinished() || this.t() > endTime;
            while (!finished) {
                double totWallTime;
                ++this.d_ts;
                this.checkPause(runnable, onPauseResume);
                this.checkCancel();
                if (this.d_param.slower > 0) {
                    try {
                        Thread.sleep(this.d_param.slower);
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.SEVERE, t.toString(), t);
                    }
                }
                wallTimer.reset();
                this.d_kb.clearPerTimeStepCaches();
                double dt = this.d_kb.getDt();
                this.d_ticks.begin("UPDATE OCC SOURCES");
                for (OccSource occSource : this.d_kb.getOccSources()) {
                    occSource.update(this, dt);
                }
                this.d_ticks.end("UPDATE OCC SOURCES");
                this.d_ticks.begin("UPDATE OCC GROUPS");
                for (OccGroupType occGroupType : this.d_kb.getOccupantGroupTypes()) {
                    occGroupType.update(this.d_kb);
                }
                for (OccGroup occGroup : this.d_kb.getOccupantGroups()) {
                    occGroup.update(this.d_kb);
                }
                this.d_ticks.end("UPDATE OCC GROUPS");
                this.d_ticks.begin("SCRIPT");
                this.processTimeBasedEvents();
                this.processOpQueue();
                this.d_scripting.invokeCallbacks("onUpdate");
                this.d_ticks.end("SCRIPT");
                this.d_ticks.begin("UPDATE TRIMMED EDGES");
                this.d_kb.updateTrimmedMeshes();
                this.d_ticks.end("UPDATE TRIMMED EDGES");
                this.d_ticks.begin("UPDATE AE TEAMS");
                mtproc.process(MTProcessor.Schedule.DYNAMIC, this.d_kb.getAssistedEvacTeams(), team -> team.update(this.d_kb));
                this.d_ticks.end("UPDATE AE TEAMS");
                this.d_ticks.begin("UPDATE OCCTARGET RESERVATIONS");
                this.d_kb.getOccTargets().resolveReservations(this.d_kb);
                this.d_ticks.end("UPDATE OCCTARGET RESERVATIONS");
                if (this.d_param.handle_collisions) {
                    this.d_ticks.begin("UPDATE OCC FINDER");
                    this.d_kb.updateOccFinder(dt);
                    this.d_ticks.end("UPDATE OCC FINDER");
                }
                if (theUtil.le(nextDoorQueueUpdate, this.t(), 1.0E-6)) {
                    this.d_kb.getPathEstimates().updateDoorQueues();
                    nextDoorQueueUpdate = this.t() + this.d_param.door_queue_update_interval;
                }
                int addedAgentsCount1 = this.d_addedAgents.size();
                if (!this.d_addedAgents.isEmpty() && this.d_occParamsWriter != null) {
                    this.d_ticks.begin("WRITE OUTPUT");
                    this.d_occParamsWriter.addOccs(this.t(), this.d_addedAgents);
                    if (this.d_param.enable_json_output && this.d_occParamsWriterJson != null) {
                        this.d_occParamsWriterJson.addOccs(this.t(), this.d_addedAgents);
                    }
                    this.d_ticks.end("WRITE OUTPUT");
                }
                this.d_ticks.begin("STEERING CALC");
                this.d_kb.getPathEstimates().pauseWorkers();
                mtproc.process(MTProcessor.Schedule.DYNAMIC, this.d_kb.getAgents(), NOT_ISDONE, agent -> agent.preMove(this.d_kb, this.d_kb.getParams(), this.d_kb.getDt()));
                if (doAssistedPremove) {
                    mtproc.process(MTProcessor.Schedule.DYNAMIC, this.d_kb.getAgents(), NOT_ISDONE, agent -> agent.getAssistedEvacClientModule().ifPresent(m -> m.preMoveAssistedEvacClients(this.d_kb)));
                }
                this.d_kb.getPathEstimates().resumeWorkers();
                for (CameraAgent camAgent : this.d_camAgents) {
                    camAgent.preMove(this.d_kb, this.d_param, dt);
                }
                this.d_ticks.end("STEERING CALC");
                this.d_ticks.begin("UPDATE LOCATION");
                mtproc.process(this.d_kb.getAgents(), NOT_ISDONE, agent -> agent.update(this.d_kb, this.d_kb.getParams(), this.d_kb.getDt()));
                for (CameraAgent camAgent : this.d_camAgents) {
                    camAgent.update(this.d_kb, this.d_param, dt);
                }
                this.d_ticks.end("UPDATE LOCATION");
                this.d_ticks.begin("UPDATE NODES");
                mtproc.process(this.d_kb.getNodes(), node -> node.updateOccupantCounts(this.d_kb));
                this.d_ticks.end("UPDATE NODES");
                this.d_ticks.begin("UPDATE DOORS");
                this.d_kb.updateDoors(dt);
                this.d_ticks.end("UPDATE DOORS");
                this.d_ticks.begin("UPDATE ELEVATORS");
                this.d_kb.getElevatorModel().update(this.d_kb);
                this.d_ticks.end("UPDATE ELEVATORS");
                this.d_ticks.begin("UPDATE SUBUNITS");
                this.d_kb.updateBaseQueues(dt);
                this.d_ticks.end("UPDATE SUBUNITS");
                if (this.d_nextCbTime <= this.t()) {
                    this.d_ticks.begin("CYCLE BREAKER");
                    this.d_kb.getCycleBreaker().update(this.d_kb, dt, this.d_occAgents);
                    this.d_ticks.end("CYCLE BREAKER");
                    this.d_nextCbTime += this.d_cbUpdateInterval;
                }
                this.d_ticks.begin("UPDATE AI");
                mtproc.process(this.d_kb.getAgents(), NOT_ISDONE, agent -> agent.getAiCore().update(this, this.d_kb, (OccAgent)agent));
                this.d_ticks.end("UPDATE AI");
                this.d_ticks.begin("UPDATE ATTRACTORS");
                this.d_kb.updateDynamicAttractors();
                this.d_ticks.end("UPDATE ATTRACTORS");
                this.updateTime(this.d_dt);
                finished |= this.d_param.shutdown_empty && this.d_occAgents.isEmpty() && this.d_kb.checkOccSourcesFinished();
                finished |= endTime < this.t();
                this.d_ticks.begin("CALLBACK");
                this.checkTimedCallback();
                this.d_ticks.end("CALLBACK");
                this.d_kb.getOccEnvData().update(this.d_kb, this.t());
                if (this.d_param.handle_collisions) {
                    this.d_ticks.begin("UPDATE OCC FINDER");
                    for (OccAgent agent2 : this.d_occAgents) {
                        if (!agent2.isDone()) continue;
                        this.d_kb.getOccFinder().remove(agent2);
                    }
                    this.d_ticks.end("UPDATE OCC FINDER");
                }
                if (updateAllDensityFields || this.t() >= this.d_nextCSVPlotTime) {
                    updateDensityFields.run();
                }
                if (this.t() >= this.d_nextCSVPlotTime) {
                    updateDensityRegions.run();
                }
                this.updateVis();
                this.d_ticks.begin("WRITE OUTPUT");
                if (this.d_sdAccumWriter != null) {
                    this.d_sdAccumWriter.update(false);
                }
                if (this.d_sdAccumWriterJson != null && this.d_param.enable_json_output) {
                    this.d_sdAccumWriterJson.update(false);
                }
                if (this.t() >= this.d_nextPlotTime || finished) {
                    this.d_occHistWriter.writeFrame(this.d_kb, this.t(), this.d_occAgents);
                    this.d_nextPlotTime += this.d_param.dt_vis;
                    this.d_kb.pruneFinishedAgents();
                    this.d_geomHistWriter.writeFrame(this.d_kb, this.t());
                }
                if (this.t() >= this.d_nextCSVPlotTime) {
                    this.d_roomUsageWriter.writeFrame(this.t());
                    this.d_doorUsageWriter.writeFrame(this.t());
                    if (this.d_sdTransWriter != null) {
                        this.d_sdTransWriter.writeFrame(this.t());
                    }
                    this.d_occDataWriters.writeFrame(this.t(), true);
                    this.d_groupInfoWriter.writeFrame(this.t());
                    if (this.d_densityWriter != null) {
                        this.d_densityWriter.writeFrame(this.d_kb, this.t());
                    }
                    if (this.d_attrWriter != null) {
                        this.d_attrWriter.writeFrame(this.d_kb, this.t());
                    }
                    if (this.d_occTargetsWriter != null) {
                        this.d_occTargetsWriter.writeFrame(this.d_kb, this.t());
                    }
                    this.d_dtWriter.writeFrame(this.d_kb, this.t());
                    this.d_nextCSVPlotTime += this.d_param.dt_csv_data;
                    if (this.d_param.enable_json_output) {
                        if (this.d_attrWriterJson != null) {
                            this.d_attrWriterJson.writeFrame(this.t());
                        }
                        if (this.d_doorUsageWriterJson != null) {
                            this.d_doorUsageWriterJson.writeFrame(this.t());
                        }
                        if (this.d_groupInfoWriterJson != null) {
                            this.d_groupInfoWriterJson.writeFrame(this.t());
                        }
                        if (this.d_densityWriterJson != null) {
                            this.d_densityWriterJson.writeFrame(this.t());
                        }
                        if (this.d_roomUsageWriterJson != null) {
                            this.d_roomUsageWriterJson.writeFrame(this.t());
                        }
                        if (this.d_occTargetsWriterJson != null) {
                            this.d_occTargetsWriterJson.writeFrame(this.t());
                        }
                        if (this.d_occDataWriterJson != null) {
                            this.d_occDataWriterJson.writeFrame(this.t(), true);
                        }
                        if (this.d_sdTransWriterJson != null) {
                            this.d_sdTransWriterJson.writeFrame(this.t());
                        }
                    }
                }
                if (this.d_param.enable_json_output && this.d_occDataWriterJson != null) {
                    this.d_occDataWriterJson.addAgents(this.t(), this.d_addedAgents);
                }
                this.d_occDataWriters.addAgents(this.t(), this.d_addedAgents);
                int n2 = this.d_addedAgents.size();
                assert (n2 == addedAgentsCount1);
                if (n2 != addedAgentsCount1) {
                    LOGGER.log(Level.WARNING, () -> String.format("%d agents were added after recording parameters and will be missing from params file.", addedAgentsCount2 - addedAgentsCount1));
                }
                this.d_addedAgents.clear();
                this.d_ticks.end("WRITE OUTPUT");
                if (SystemProps.get(InfernoPrefs.INCLUDE_SNAPSHOT).booleanValue()) {
                    this.d_ticks.begin("WRITE SNAPSHOT");
                    if (this.t() >= this.d_nextSnapshotTime) {
                        this.d_writeSnapshot.set(true);
                        do {
                            this.d_nextSnapshotTime += this.d_param.dt_snapshot;
                        } while (this.d_nextSnapshotTime < this.t());
                    }
                    this.checkSnapshot();
                    this.d_ticks.end("WRITE SNAPSHOT");
                }
                if ((totWallTime = metaUpdator.totTime[0] + wallTimer.curr()) >= nextWallUpdate || finished) {
                    IPropertySet metaMap = metaUpdator.mkMetaMap(this, wallTimer.curr());
                    if (metaMap.get(META_STUCK_STATUS).booleanValue() && !this.d_stuckWritten.getAndSet(true)) {
                        this.d_ticks.begin("WRITE STUCK");
                        StuckWriter.printStuck(this.d_kb);
                        this.d_ticks.end("WRITE STUCK");
                    }
                    this.postMessage(metaMap);
                    nextWallUpdate = totWallTime + this.d_param.dt_wall_meta;
                }
                if (this.d_param.realtime) {
                    double wallDT;
                    double thisRunSimTime = this.t() - beginTime + realtimeError;
                    this.d_wallDt = wallDT = wallTimer.curr();
                    double thisRunWallTime = metaUpdator.totTime[0] - initWallTime + wallDT;
                    int comp = theUtil.compare(thisRunWallTime, thisRunSimTime, 1.0E-6);
                    if (comp < 0) {
                        double waitTimeSec = thisRunSimTime - thisRunWallTime;
                        WaitTime waitTime = this.split(waitTimeSec);
                        this.d_ticks.begin("REALTIME CORRECTION");
                        Engine engine = this;
                        synchronized (engine) {
                            try {
                                this.wait(waitTime.millis, waitTime.nanos);
                            }
                            catch (InterruptedException e) {
                                LOGGER.log(Level.SEVERE, e.toString(), e);
                            }
                        }
                        this.d_ticks.end("REALTIME CORRECTION");
                        double newdt = Math.max(this.d_param.dt_init, wallDT);
                        this.d_dt = BigDecimal.valueOf(newdt);
                    } else if (comp > 0) {
                        double newdt = Math.min(0.2, wallDT);
                        if (wallDT > this.d_dt.doubleValue()) {
                            realtimeError += wallDT - this.d_dt.doubleValue();
                        }
                        this.d_dt = BigDecimal.valueOf(newdt);
                    }
                    this.d_kb.setDt(this.d_dt.doubleValue());
                }
                metaUpdator.addWallTime(wallTimer.curr());
            }
            LOGGER.fine("SIMULATION END");
            this.d_ticks.begin("SCRIPT");
            this.d_scripting.invokeCallbacks("onExit");
            this.d_ticks.end("SCRIPT");
            updateDensityRegions.run();
            this.d_ticks.begin("WRITE OUTPUT");
            this.d_roomUsageWriter.writeFrame(this.t());
            this.d_doorUsageWriter.writeFrame(this.t());
            this.d_groupInfoWriter.writeFrame(this.t());
            if (this.d_sdTransWriter != null) {
                this.d_sdTransWriter.writeFrame(this.t());
            }
            if (this.d_sdAccumWriter != null) {
                this.d_sdAccumWriter.update(true);
                this.d_sdAccumWriter.writeOuptut();
            }
            if (this.d_attrWriter != null) {
                this.d_attrWriter.writeFrame(this.d_kb, this.t());
            }
            if (this.d_occTargetsWriter != null) {
                this.d_occTargetsWriter.writeFrame(this.d_kb, this.t());
            }
            this.d_dtWriter.writeFrame(this.d_kb, this.t());
            this.d_occDataWriters.writeFrame(this.t(), false);
            if (this.d_densityWriter != null) {
                this.d_densityWriter.writeFrame(this.d_kb, this.t());
            }
            ArrayList<FileNotFoundException> fileWriteErrors = new ArrayList<FileNotFoundException>();
            if (this.d_param.enable_json_output) {
                if (this.d_attrWriterJson != null) {
                    this.d_attrWriterJson.writeFrame(this.t());
                }
                if (this.d_attrWriterJson != null && !this.d_cancel.get()) {
                    this.d_attrWriterJson.consolidate();
                }
                if (this.d_doorUsageWriterJson != null) {
                    this.d_doorUsageWriterJson.writeFrame(this.t());
                }
                if (this.d_doorUsageWriterJson != null && !this.d_cancel.get()) {
                    this.d_doorUsageWriterJson.consolidate();
                }
                if (this.d_groupInfoWriterJson != null) {
                    this.d_groupInfoWriterJson.writeFrame(this.t());
                }
                if (this.d_groupInfoWriterJson != null && !this.d_cancel.get()) {
                    this.d_groupInfoWriterJson.consolidate();
                }
                if (this.d_densityWriterJson != null) {
                    this.d_densityWriterJson.writeFrame(this.t());
                }
                if (this.d_densityWriterJson != null && !this.d_cancel.get()) {
                    this.d_densityWriterJson.consolidate();
                }
                if (this.d_roomUsageWriterJson != null) {
                    this.d_roomUsageWriterJson.writeFrame(this.t());
                }
                if (this.d_roomUsageWriterJson != null && !this.d_cancel.get()) {
                    this.d_roomUsageWriterJson.consolidate();
                }
                if (this.d_occTargetsWriterJson != null) {
                    this.d_occTargetsWriterJson.writeFrame(this.t());
                }
                if (this.d_occTargetsWriterJson != null && !this.d_cancel.get()) {
                    this.d_occTargetsWriterJson.consolidate();
                }
                if (this.d_occDataCumulativeWriterJson != null) {
                    this.d_occDataCumulativeWriterJson.writeFrame(this.t());
                }
                if (this.d_occDataWriterJson != null) {
                    this.d_occDataWriterJson.writeFrame(this.t(), false);
                }
                if (this.d_occDataWriterJson != null && !this.d_cancel.get()) {
                    this.d_occDataWriterJson.consolidate();
                }
                if (this.d_occParamsWriterJson != null && !this.d_cancel.get()) {
                    this.d_occParamsWriterJson.consolidate();
                }
                if (this.d_sdAccumWriterJson != null) {
                    this.d_sdAccumWriterJson.update(true);
                    this.d_sdAccumWriterJson.writeFrame(this.t());
                }
                if (this.d_sdTransWriterJson != null) {
                    this.d_sdTransWriterJson.writeFrame(this.t());
                }
                if (this.d_sdTransWriterJson != null && !this.d_cancel.get()) {
                    this.d_sdTransWriterJson.consolidate();
                }
                if (this.d_combinedOutputWriterJson != null) {
                    this.d_combinedOutputWriterJson.consolidate();
                }
            }
            try {
                SummaryWriter.printSummary(this.d_kb, this.d_ticks);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileWriteErrors.add(fileNotFoundException);
            }
            try {
                SummaryWriter.logSummary(LOGGER, this.d_kb, this.d_ticks);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileWriteErrors.add(fileNotFoundException);
            }
            try {
                SummaryWriter.printSummaryJson(this.d_kb, this.d_ticks);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileWriteErrors.add(fileNotFoundException);
            }
            try (CSVWriter cSVWriter = OccDataCumulativeWriter.open(this.d_param);){
                OccDataCumulativeWriter.write(cSVWriter, this.d_kb, this.d_kb.getOccStats());
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileWriteErrors.add(fileNotFoundException);
            }
            this.d_ticks.end("WRITE OUTPUT");
            this.d_ticks.end("SIMULATION");
            if (SystemProps.get(InfernoPrefs.INCLUDE_POUT).booleanValue()) {
                try (PrintStream printStream = Output.openTxtStream(this.d_param.out_performance);){
                    this.printPerformance(printStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileWriteErrors.add(fileNotFoundException);
                }
            }
            if (!metaUpdator.stuckChecker.isStuck(this)) {
                StuckWriter.deleteStuck(this.d_kb);
            }
            if (!fileWriteErrors.isEmpty()) {
                void var28_62;
                this.d_param.out.flush();
                boolean bl2 = false;
                while (var28_62 < fileWriteErrors.size() - 1) {
                    Exception e = (Exception)fileWriteErrors.get((int)var28_62);
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                    ++var28_62;
                }
                throw (FileNotFoundException)fileWriteErrors.get(fileWriteErrors.size() - 1);
            }
        }
        catch (CanceledException e) {
            throw e;
        }
        catch (IOException e1) {
            LOGGER.log(Level.SEVERE, e1.toString(), e1);
        }
        finally {
            for (Closeable stream : ioToCleanUp) {
                Output.close(stream);
            }
            ioToCleanUp.clear();
            this.d_kb.getThreadPool().stopAndClearThreads();
        }
    }

    private WaitTime split(double time) {
        long nanos = (long)(time * 1.0E9);
        if (nanos > 999999L) {
            long millis = nanos / 1000000L;
            return new WaitTime(millis, (int)(nanos -= millis * 1000000L));
        }
        return new WaitTime(0L, (int)nanos);
    }

    private void printPerformance(PrintStream stream) {
        this.d_ticks.printSummary(stream, "SIMULATION", new String[0]);
    }

    private void checkSnapshot() {
        if (!this.d_writeSnapshot.getAndSet(false)) {
            return;
        }
        if (this.d_snapshotWriter == null) {
            return;
        }
        KB kb = this.d_kb;
        Param param = kb.getParams();
        String filename = this.d_snapshotWriter.getFilename();
        param.out.printf("Writing snapshot, %s...%n", new File(filename).getName());
        try {
            this.d_snapshotWriter.write(this);
            param.out.println("Snapshot written.");
        }
        catch (IOException e) {
            param.err.println(String.format("Error writing snapshot: %s->%s%n", e, e.getLocalizedMessage()));
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    @Override
    public synchronized void addObserver(Observer o) {
        super.addObserver(o);
    }

    private void updateVis() {
        this.d_ticks.begin("RENDERER");
        if (this.d_param.show_vis) {
            ArrayList<Serializable> allRender = new ArrayList<Serializable>();
            allRender.addAll(Arrays.asList(this.d_kb.getMesh().getVerts()));
            allRender.addAll(Arrays.asList(this.d_kb.getMesh().getEdges()));
            allRender.addAll(Arrays.asList(this.d_kb.getMesh().getTris()));
            allRender.addAll(this.d_kb.getAllAttractors(attr -> attr.type.isPlaced));
            allRender.addAll(this.d_kb.getAllOccTargets());
            allRender.addAll(this.d_kb.getNodes());
            allRender.addAll(this.d_kb.getOccSources());
            allRender.addAll(this.d_occAgents);
            for (ANode node : this.d_kb.getNodes()) {
                IDensityField df = node.getDensityField();
                allRender.add(df);
            }
            try {
                final Consumer<GLWindow> render = glView -> {
                    Engine engine = this;
                    synchronized (engine) {
                        if (this.d_glView != null) {
                            this.d_glView.render(allRender);
                        }
                    }
                };
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            render.accept(Engine.this.d_glView);
                        }
                    });
                } else {
                    render.accept(this.d_glView);
                }
            }
            catch (InvocationTargetException e1) {
                LOGGER.log(Level.SEVERE, e1.toString(), e1);
            }
            catch (InterruptedException e2) {
                LOGGER.log(Level.SEVERE, e2.toString(), e2);
            }
        }
        this.d_ticks.end("RENDERER");
    }

    private class CanceledException
    extends Exception {
        private static final long serialVersionUID = -7950819412021714212L;

        private CanceledException() {
        }
    }

    private static interface ThrowingRunnable<T extends Exception> {
        public void run() throws T;
    }

    private static class MetaUpdator {
        private final double[] totTime = new double[]{0.0};
        private final StuckChecker stuckChecker = new StuckChecker();

        private MetaUpdator() {
        }

        public void post(Engine engine) {
            this.post(engine, 0.0);
        }

        public void post(Engine engine, double partialWallTime) {
            engine.postMessage(this.mkMetaMap(engine, partialWallTime));
        }

        public IPropertySet mkMetaMap(Engine engine, double partialWallTime) {
            PropertySet meta = new PropertySet();
            MetaUpdator.safeSet(meta, META_STATE, () -> {
                if (engine.isFinished()) {
                    return State.FINISHED;
                }
                if (engine.isPaused()) {
                    return State.PAUSED;
                }
                return State.RUNNING;
            });
            meta.set(META_TIME_TS, engine.d_ts);
            MetaUpdator.safeSet(meta, META_TIME_SIM, () -> engine.t());
            meta.set(META_TIME_WALL, this.totTime[0] + partialWallTime);
            MetaUpdator.safeSet(meta, META_TIME_DT, () -> engine.d_dt.doubleValue());
            MetaUpdator.safeSet(meta, META_OCCS_REM, () -> engine.d_kb.getActiveAgents().size());
            MetaUpdator.safeSet(meta, META_OCCS_TOTAL, () -> engine.d_kb.getAllAgentsEver().size());
            try {
                double[] DTGs = MetaUpdator.getAllDTGs(engine.d_occAgents);
                meta.set(META_DTG_MIN, DTGs[0]);
                meta.set(META_DTG_MAX, DTGs[1]);
                meta.set(META_DTG_AVG, DTGs[2]);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.toString(), t);
            }
            MetaUpdator.safeSet(meta, META_STUCK_STATUS, () -> this.stuckChecker.isStuck(engine));
            return meta;
        }

        private static <T> void safeSet(IPropertySet meta, IPropertySet.Prop<T> prop, Supplier<T> getter) {
            try {
                meta.set(prop, getter.get());
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.toString(), t);
            }
        }

        public void addWallTime(double time) {
            this.totTime[0] = this.totTime[0] + time;
        }

        private static double[] getAllDTGs(List<OccAgent> oas) {
            if (oas.isEmpty()) {
                return new double[]{0.0, 0.0, 0.0};
            }
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            double avg = 0.0;
            int count = 0;
            for (OccAgent oa : oas) {
                if (oa.getPathFollow() == null) continue;
                ++count;
                double d = oa.getRemainingDistance();
                if (!Double.isFinite(d)) continue;
                min = Math.min(d, min);
                max = Math.max(d, max);
                avg += d;
            }
            if (count == 0) {
                return new double[]{0.0, 0.0, 0.0};
            }
            return new double[]{min, max, avg /= (double)count};
        }
    }

    private static class WaitTime {
        public final long millis;
        public final int nanos;

        public WaitTime(long millis, int nanos) {
            this.millis = millis;
            this.nanos = nanos;
        }
    }

    private static class StuckChecker {
        private static final double T_STUCK_CHECK = 10.0;
        private Map<Object, IProgressNote> d_progress = null;
        private double d_lastCheckTime = Double.NaN;
        private boolean d_stuck = false;

        private StuckChecker() {
        }

        private void update(Engine engine) {
            if (this.d_progress == null) {
                this.d_progress = this.getCurrentProgress(engine.getKB());
            }
            double simTime = engine.t();
            if (Double.isNaN(this.d_lastCheckTime)) {
                this.d_lastCheckTime = simTime;
            }
            if (simTime - this.d_lastCheckTime > 10.0) {
                Map<Object, IProgressNote> currProgress = this.getCurrentProgress(engine.getKB());
                this.d_stuck = this.checkStuck(engine, simTime, currProgress);
                this.d_lastCheckTime = simTime;
                this.d_progress = currProgress;
            }
        }

        private Map<Object, IProgressNote> getCurrentProgress(KB kb) {
            IdentityHashMap<Object, IProgressNote> currProgress = new IdentityHashMap<Object, IProgressNote>();
            for (OccAgent occ : kb.getActiveAgents()) {
                currProgress.put(occ, occ.getProgress(kb));
            }
            for (OccSource source : kb.getActiveOccSources()) {
                currProgress.put(source, source.getProgress(kb));
            }
            return currProgress;
        }

        private boolean checkStuck(Engine engine, double simTime, Map<Object, IProgressNote> currProgress) {
            if (currProgress.size() == 0 || this.d_progress.size() != currProgress.size()) {
                return false;
            }
            boolean makingProgress = true;
            HashSet<Object> allSources = new HashSet<Object>(currProgress.keySet());
            allSources.addAll(this.d_progress.keySet());
            for (Object e : allSources) {
                IProgressNote oldProgress = this.d_progress.get(e);
                IProgressNote newProgress = currProgress.get(e);
                if (oldProgress == null) {
                    return false;
                }
                if (newProgress == null) continue;
                if (newProgress.isMakingProgress(engine.getKB(), e, oldProgress)) {
                    return false;
                }
                makingProgress = false;
            }
            return !makingProgress;
        }

        public boolean isStuck(Engine engine) {
            this.update(engine);
            return this.d_stuck;
        }
    }

    public static enum State {
        RUNNING,
        PAUSED,
        FINISHED;

    }
}

