/*
 * Decompiled with CFR 0.152.
 */
package inferno.parse2;

import common.data.EscalatorPreference;
import common.data.SpeedInSmoke;
import common.data.WaitMode;
import inferno.data2.ANode;
import inferno.data2.AnimatedGeom;
import inferno.data2.AttractorSim;
import inferno.data2.Blockage;
import inferno.data2.Camera;
import inferno.data2.CommonAnimTags;
import inferno.data2.Counter;
import inferno.data2.CylinderShape;
import inferno.data2.DoorDir;
import inferno.data2.IOccFilter;
import inferno.data2.Material;
import inferno.data2.MeasurementRegion;
import inferno.data2.Mesh;
import inferno.data2.MeshBuilder;
import inferno.data2.OccPriority;
import inferno.data2.OccTarget;
import inferno.data2.Occupant;
import inferno.data2.PredefTag;
import inferno.data2.QBaseQueue;
import inferno.data2.QMetaQueue;
import inferno.data2.QPath;
import inferno.data2.QServicePoint;
import inferno.data2.SlopeSpeed;
import inferno.data2.SpeedInSmokeSim;
import inferno.data2.SpeedModifier;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.ai.AbandonOccTargetsGoal;
import inferno.data2.ai.AssistOccupantsGoal;
import inferno.data2.ai.AssistedEvacTeam;
import inferno.data2.ai.ChangeBehaviorGoal;
import inferno.data2.ai.ChangeCounterGoal;
import inferno.data2.ai.ChangeProfileGoal;
import inferno.data2.ai.ChangeTagGoal;
import inferno.data2.ai.CreateAttractorGoal;
import inferno.data2.ai.DestroyAttractorGoal;
import inferno.data2.ai.DetachGoal;
import inferno.data2.ai.DynamicTargetGoal;
import inferno.data2.ai.ExitGoal;
import inferno.data2.ai.FillRoomGoal;
import inferno.data2.ai.IEventTime;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.ITargetPtSupplier;
import inferno.data2.ai.JoinOccGroupGoal;
import inferno.data2.ai.LookAheadGoal;
import inferno.data2.ai.LookAtGoal;
import inferno.data2.ai.OccTargetGoal;
import inferno.data2.ai.PointGoal;
import inferno.data2.ai.QueueGoal;
import inferno.data2.ai.RemoveSelfGoal;
import inferno.data2.ai.RoomGoal;
import inferno.data2.ai.SetOccPropGoal;
import inferno.data2.ai.SetOccPropToProfileGoal;
import inferno.data2.ai.SetTagGoal;
import inferno.data2.ai.WaitForAssistanceGoal;
import inferno.data2.ai.WaitForCounterGoal;
import inferno.data2.ai.WaitGoal;
import inferno.data2.ai.WaitIntervalGoal;
import inferno.data2.ai.WaitUntilEndGoal;
import inferno.data2.ai.WaitUntilGoal;
import inferno.data2.ai.WaitUntilInsideGoal;
import inferno.data2.ai.WaitUntilTaggedGoal;
import inferno.data2.value.ConstFunction1d;
import inferno.data2.value.IFunction1d;
import inferno.data2.value.ImpulseFunction1d;
import inferno.data2.value.PiecewiseFunction1d;
import inferno.elevator.ElevatorParserTxt;
import inferno.elevator.ITimeEstimate;
import inferno.geom.Inter;
import inferno.io.fdsout.DataFinder;
import inferno.io.fdsout.DataFinderSmvPlot3d;
import inferno.io.fdsout.DataInquisitor;
import inferno.io.fdsout.KbLink;
import inferno.sim.BehaviorSim;
import inferno.sim.EngineOp;
import inferno.sim.IDoorFlowrate;
import inferno.sim.IOccGroup;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAdder;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.OccProfileSim;
import inferno.sim.Param;
import inferno.sim.VehicleBody;
import inferno.sim.occsource.AUCOccSourceFlowrate;
import inferno.sim.occsource.DistributedOccSourceFlowrate;
import inferno.sim.occsource.IOccSourceFlowrate;
import inferno.sim.occsource.OccSource;
import inferno.sim.occsource.RandomizedOccSourceFlowrate;
import inferno.util.BigDecimalOp;
import inferno.util.ComparePredicate;
import inferno.util.Util;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Color3b;
import javax.vecmath.Color4f;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.stat.AutoCurve;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.JsonUtil;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CSVLineParser;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class SimpleParser {
    private static final Logger LOGGER = Logger.getLogger(SimpleParser.class.getName());
    private static final String CMD_ADD_BLOCKAGE = "add_blockage";
    private static final String CMD_REMOVE_BLOCKAGE = "remove_blockage";
    private static final String CMD_SET_BLOCKAGE_SPEED_MOD = "set_blockage_speed_mod";
    private static final String CMD_OPEN_DOOR = "open_door";
    private static final String CMD_CLOSE_DOOR = "close_door";
    private static final String CMD_CHANGE_DOOR_DIR = "change_door_dir";
    private static final String CMD_SET_SPEED_MOD = "set_speed_mod";
    private static final String CMD_SET_ATTRACTOR_INFLUENCE = "set_attractor_influence";
    public static final Unit LENGTH_UNIT = SI.METER;
    public static final Unit VEL_UNIT = SI.METER.divide(SI.SECOND);
    public static final Unit TIME_UNIT = SI.SECOND;
    public static final String INLINE_PROP_DIAMETER = "OccProfile.DIAMETER";
    public static final String INLINE_PROP_GEOM_DIAMETER = "OccProfile.GEOM_DIAMETER";
    public static final String INLINE_PROP_HEIGHT = "OccProfile.HEIGHT";
    private final InputStream d_is;
    private final String d_absolutePath;
    private final KB d_kb;
    private final Param d_param;
    private long d_lastLineN = 0L;
    private String d_lastLine;
    private int d_version = 1;
    private final Random d_occSourceSeedGen;
    private final Map<Integer, MeshBuilder.MTri> d_triFileOrder = new HashMap<Integer, MeshBuilder.MTri>();
    private final Map<Color3b, Color3b> d_colorPool = new HashMap<Color3b, Color3b>();
    private final Map<SlopeSpeed, SlopeSpeed> d_slopeSpeedPool = new HashMap<SlopeSpeed, SlopeSpeed>();
    private final Map<Set<?>, Set<?>> d_setPool = new HashMap();
    private static final Color4f DEFAULT_BLKG_COLOR = new Color4f(1.0f, 1.0f, 1.0f, 0.3f);

    public SimpleParser(InputStream is, File dir, String fileName) {
        this.d_is = is;
        this.d_absolutePath = dir.getAbsolutePath();
        this.d_param = new Param(fileName, dir.getAbsolutePath());
        this.d_kb = new KB(this.d_param);
        this.d_occSourceSeedGen = new Random(fileName.hashCode());
        this.d_slopeSpeedPool.put(KnownFuncs.SFPE_STAIR_SPEED, KnownFuncs.SFPE_STAIR_SPEED);
        this.d_slopeSpeedPool.put(KnownFuncs.SFPE_RAMP_SPEED, KnownFuncs.SFPE_RAMP_SPEED);
    }

    public KB getKB() {
        return this.d_kb;
    }

    public Param getParam() {
        return this.d_param;
    }

    public long getLastLineN() {
        return this.d_lastLineN;
    }

    public String getLastLine() {
        return this.d_lastLine;
    }

    public void run() throws Exception {
        State state = State.UNKNOWN;
        Scanner scan = new Scanner(this.d_is, "UTF-8");
        ParseData pdata = new ParseData(this.d_kb);
        while (scan.hasNext()) {
            String line = scan.nextLine().trim();
            ++this.d_lastLineN;
            this.d_lastLine = line;
            if (line.length() == 0 || line.startsWith("#")) continue;
            if (line.startsWith("[")) {
                state = State.UNKNOWN;
                String sectTitle = line.substring(1, line.length() - 1);
                for (State s : State.values()) {
                    if (!s.token.equalsIgnoreCase(sectTitle)) continue;
                    state = s;
                    break;
                }
                String stateChange = state != State.UNKNOWN ? "reading " + state.token : "Unrecognized section: " + line;
                System.out.println(stateChange);
                continue;
            }
            if (state == State.NAVMESH && pdata.navmb == null) {
                pdata.navmb = new MeshBuilder(pdata.pList);
            } else if (state == State.GEOMMESH && pdata.geommb == null) {
                pdata.geommb = new MeshBuilder(pdata.pList);
            }
            switch (state) {
                case VERSION: {
                    this.d_version = this.parseVersion(line);
                    break;
                }
                case MATERIALS: {
                    pdata.mats.add(this.parseMat(line));
                    break;
                }
                case DISTRIBUTIONS: {
                    pdata.distributions.add(this.parseDistribution(pdata.tags, line, true));
                    break;
                }
                case FUNCTIONS: {
                    pdata.functions.add(this.parseFunction(line));
                    break;
                }
                case NODES: {
                    pdata.nodeLines.add(line);
                    break;
                }
                case DOORS: {
                    pdata.doorLines.add(line);
                    break;
                }
                case OCCS: {
                    pdata.occLines.add(line);
                    break;
                }
                case VERTS: {
                    Point3d vert = this.parseVert(line);
                    pdata.pList.add(vert);
                    break;
                }
                case NAVMESH: {
                    pdata.navTriLines.add(line);
                    break;
                }
                case GEOMMESH: {
                    pdata.geomTriLines.add(line);
                    break;
                }
                case PARAM: {
                    this.parseParam(line);
                    break;
                }
                case PROFILES: {
                    pdata.profLines.add(line);
                    break;
                }
                case BEHAVIORS: {
                    pdata.behaviorLines.add(line);
                    break;
                }
                case TAGS: {
                    pdata.tagLines.add(line);
                    break;
                }
                case EDGES: {
                    pdata.edgeLines.add(line);
                    break;
                }
                case STAIRS: {
                    pdata.stairLines.add(line);
                    break;
                }
                case ELEVATORS: {
                    pdata.elevatorLines.add(line);
                    break;
                }
                case ELEVATOR_DISCHARGE: {
                    pdata.elevatorDischargeLines.add(line);
                    break;
                }
                case ELEVATOR_LEVEL_DATA: {
                    pdata.elevatorLevelDataLines.add(line);
                    break;
                }
                case ELEVATOR_LINKS: {
                    pdata.elevatorLinkLines.add(line);
                    break;
                }
                case ELEVATOR_PRIORITY: {
                    pdata.elevatorPriorityLines.add(line);
                    break;
                }
                case ELEVATOR_TIMING_MODELS: {
                    pdata.elevatorTimingModels.add(line);
                    break;
                }
                case QUEUE_BASE: {
                    pdata.baseQueuesLines.add(line);
                    break;
                }
                case QUEUE_META: {
                    pdata.metaQueues.add(line);
                    break;
                }
                case BLOCKAGES: {
                    pdata.blockagesLines.add(line);
                    break;
                }
                case CAMERAS: {
                    this.parseCamera(line);
                    break;
                }
                case EVENTS: {
                    pdata.evtLines.add(line);
                    break;
                }
                case JSON: {
                    this.parseJSON(line);
                    break;
                }
                case META: {
                    this.parseMeta(line);
                    break;
                }
                case ASSISTED_EVAC_TEAMS: {
                    pdata.aeGoalsLines.add(line);
                    break;
                }
                case OCCSHAPES: {
                    pdata.occShapeLines.add(line);
                    break;
                }
                case OCC_SOURCES: {
                    pdata.occSourcesLines.add(line);
                    break;
                }
                case COUNTERS: {
                    pdata.counters.add(this.parseCounter(line));
                    break;
                }
                case GROUPS: {
                    pdata.occGroupLines.add(line);
                    break;
                }
                case GROUP_TEMPLATES: {
                    pdata.occGroupTypeLines.add(line);
                    break;
                }
                case COMPONENT_RESTRICTIONS: {
                    pdata.compRestrictionsLines.add(line);
                    break;
                }
                case ATTRACTORS: {
                    pdata.attractorLines.add(line);
                    break;
                }
                case ATTRACTOR_RESTRICTIONS: {
                    pdata.attrRestrictionLines.add(line);
                    break;
                }
                case OCCTARGETS: {
                    pdata.occTargetLines.add(line);
                    break;
                }
                case ANIMATEDGEOMS: {
                    pdata.animatedGeomLines.add(line);
                    break;
                }
                case FLOORS: 
                case UNKNOWN: {
                    System.out.println("Ignoring Line: " + line);
                }
            }
        }
        if (pdata.geommb != null) {
            System.err.println("WARNING: Section geommesh is deprecated and will be ignored.");
        }
        this.finishParsing(pdata);
    }

    public void finishParsing(ParseData pdata) throws IOException {
        TagGenerator tags = pdata.tags;
        for (String string : pdata.tagLines) {
            tags.add(this.parseTag(string));
        }
        for (String string : pdata.nodeLines) {
            this.parseNode(string, tags);
        }
        pdata.stairLines.forEach(line -> this.parseStair((String)line));
        pdata.navTriLines.forEach(line -> this.parseMeshTri(pdata.navmb, (String)line));
        pdata.geomTriLines.forEach(line -> this.parseMeshTri(pdata.geommb, (String)line));
        MeshBuilder mb = pdata.navmb;
        for (String doorLine : pdata.doorLines) {
            this.parseDoor(doorLine, pdata.distributions);
        }
        for (Blockage blkg : this.d_kb.getBlockages()) {
            int[] indices = blkg.tris;
            for (int i = 0; i < indices.length; ++i) {
                int indexInMemory;
                int indexInFile = indices[i];
                MeshBuilder.MTri mtri = this.d_triFileOrder.get(indexInFile);
                indices[i] = indexInMemory = mb.indexOf(mtri);
            }
        }
        for (String edgeLine : pdata.edgeLines) {
            this.parseEdge(mb, edgeLine);
        }
        ArrayList<MeshBuilder.Error> arrayList = new ArrayList<MeshBuilder.Error>();
        ConstantUnitSrc lenUnit = new ConstantUnitSrc(SI.METER);
        Mesh mesh = mb.finish(this.d_param, arrayList, lenUnit);
        this.d_param.out.println("mesh has " + mesh.getTris().length + " triangles");
        this.d_kb.setMesh(mesh);
        for (String blockageLine : pdata.blockagesLines) {
            this.parseBlockage(blockageLine, pdata.mats);
        }
        for (String line4 : pdata.animatedGeomLines) {
            this.parseAnimatedGeom(line4);
        }
        ElevatorParserTxt.parse(this.d_kb.getParams(), this.d_kb.getElevatorModel(), this.d_kb.getNodes(), pdata.elevatorLines, pdata.elevatorDischargeLines, pdata.elevatorLevelDataLines, pdata.elevatorPriorityLines, pdata.elevatorLinkLines, pdata.elevatorTimingModels);
        this.d_kb.getElevatorModel().initTriSearchConnections(mesh.getTris());
        ArrayList<OccProfileSim.IShapeGen> occShapes = new ArrayList<OccProfileSim.IShapeGen>(pdata.occShapeLines.size());
        for (String occShapeLine : pdata.occShapeLines) {
            occShapes.add(this.parseOccShape(occShapeLine, pdata.distributions));
        }
        HashMap<Integer, String> aeTeamNameMap = new HashMap<Integer, String>();
        ArrayList<AssistedEvacTeam> assistedEvacuationData = new ArrayList<AssistedEvacTeam>();
        for (String string : pdata.aeGoalsLines) {
            AssistedEvacTeam assistedEvacTeam = this.parseAssistedEvacData(string);
            assistedEvacuationData.add(assistedEvacTeam);
            aeTeamNameMap.put(assistedEvacTeam.teamId, assistedEvacTeam.teamName);
        }
        this.d_kb.setAssistedEvacTeams(assistedEvacuationData);
        LinkedIdentityHashMap<AttractorSim, Integer> attrBehaviorAssignments = new LinkedIdentityHashMap<AttractorSim, Integer>();
        for (String string : pdata.attractorLines) {
            pdata.attractors.add(this.parseAttractor(string, this.d_kb.getNodes(), attrBehaviorAssignments, pdata.distributions, tags));
        }
        for (String string : pdata.occTargetLines) {
            OccTarget occTarget = this.parseOccTarget(string);
            pdata.occTargets.add(occTarget);
            this.d_kb.getOccTargets().add(occTarget);
        }
        this.d_kb.getOccTargets().initTargets();
        LinkedHashMap<Integer, OccProfileSim.CompRestrictions> linkedHashMap = new LinkedHashMap<Integer, OccProfileSim.CompRestrictions>();
        for (String string : pdata.compRestrictionsLines) {
            this.parseCompRestrictions(string, linkedHashMap, this.d_kb.getNodes());
        }
        LinkedHashMap<Integer, Predicate<AttractorSim>> linkedHashMap2 = new LinkedHashMap<Integer, Predicate<AttractorSim>>();
        for (String string : pdata.attrRestrictionLines) {
            this.parseAttrFilter(string, linkedHashMap2, pdata.attractors);
        }
        ParseProfileInfo parseProfileInfo = new ParseProfileInfo(pdata.functions, pdata.distributions, occShapes, aeTeamNameMap, linkedHashMap, linkedHashMap2, tags);
        for (String string : pdata.profLines) {
            pdata.profiles.add(this.parseProfile(string, parseProfileInfo));
        }
        for (String string : pdata.baseQueuesLines) {
            this.parseBaseQueues(string, pdata.distributions, pdata.profiles);
        }
        for (String string : pdata.metaQueues) {
            this.parseMetaQueues(string, pdata.distributions);
        }
        ArrayList<OccGroup> arrayList2 = new ArrayList<OccGroup>();
        for (String string : pdata.occGroupLines) {
            arrayList2.add((OccGroup)this.parseOccGroup(string, pdata.distributions, pdata.profiles, false));
        }
        this.d_kb.addOccupantGroups(arrayList2);
        ArrayList<OccGroupType> arrayList3 = new ArrayList<OccGroupType>();
        for (String string : pdata.occGroupTypeLines) {
            arrayList3.add((OccGroupType)this.parseOccGroup(string, pdata.distributions, pdata.profiles, true));
        }
        this.d_kb.setOccupantGroupTypes(arrayList3);
        ArrayList<Pair> arrayList4 = new ArrayList<Pair>();
        for (String string : pdata.behaviorLines) {
            Object entry = this.parseBehavior(string);
            arrayList4.add((Pair)entry);
            pdata.behaviors.add((BehaviorSim)((Pair)entry).v1);
        }
        ParseGoalInfo parseGoalInfo = new ParseGoalInfo(parseProfileInfo, assistedEvacuationData, pdata.counters, tags, arrayList2, arrayList3, pdata.occTargets, pdata.attractors, pdata.profiles, pdata.behaviors);
        for (Object entry : arrayList4) {
            this.finalizeBehavior((BehaviorSim)((Pair)entry).v1, parseGoalInfo, (String[])((Pair)entry).v2);
        }
        for (Map.Entry entry : attrBehaviorAssignments.entrySet()) {
            ((AttractorSim)entry.getKey()).behavior = pdata.behaviors.get((Integer)entry.getValue());
            this.d_kb.addAttractor((AttractorSim)entry.getKey());
        }
        for (String string : pdata.occSourcesLines) {
            OccSource occSource = this.parseOccSource(string, pdata.functions, pdata.profiles, pdata.behaviors, pdata.distributions);
            if (occSource == null) continue;
            this.d_kb.addOccSource(occSource);
        }
        Random random = new Random(0L);
        Random random2 = new Random(0L);
        OccAdder occAdder = new OccAdder(this.d_kb.getMesh());
        for (String line12 : pdata.occLines) {
            Occupant o = this.parseOccFromJson(this.d_kb, line12, occAdder, random, random2, pdata.profiles, pdata.behaviors, pdata.functions, occShapes, aeTeamNameMap, pdata.attractors, linkedHashMap, linkedHashMap2, tags);
            if (o != null) continue;
            System.err.println("Invalid occupant specified: " + line12);
        }
        occAdder.finish(this.d_kb);
        for (int i = 0; i < pdata.occGroupLines.size(); ++i) {
            this.finishParsingOccGroup(pdata.occGroupLines.get(i), (OccGroup)arrayList2.get(i));
        }
        tags.commitToKb(this.d_kb);
        this.d_kb.init();
        for (String evtLine : pdata.evtLines) {
            this.parseEvent(evtLine);
        }
    }

    public static JSONObject getJsonLine(String line, boolean hasIndex) throws IOException {
        int colix;
        if (hasIndex && (colix = line.indexOf(58)) != -1) {
            line = line.substring(colix + 1);
        }
        try {
            JSONParser parser = new JSONParser();
            return (JSONObject)parser.parse(line);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public static JSONObject getJsonLineNoThrow(String line, boolean hasIndex) {
        try {
            return SimpleParser.getJsonLine(line, hasIndex);
        }
        catch (IOException e) {
            TeciLogging.log(LOGGER, Level.SEVERE, (Throwable)e);
            return null;
        }
    }

    private void finalizeBehavior(BehaviorSim behavior, ParseGoalInfo pgi, String[] scriptTokens) throws IOException {
        ArrayList<IGoal> goals = new ArrayList<IGoal>();
        for (String strGoal : scriptTokens) {
            goals.add(this.parseGoal(strGoal, pgi, goals));
        }
        goals.trimToSize();
        behavior.initGoals(Collections.unmodifiableList(goals));
    }

    private void parseCompRestrictions(String line, Map<Integer, OccProfileSim.CompRestrictions> compRestrictionsMap, List<ANode> nodeList) throws IOException {
        int colix = line.indexOf(58);
        JSONParser parser = new JSONParser();
        int ix = Integer.parseInt(line.substring(0, colix));
        try {
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            JSONArray array = (JSONArray)json.get("components");
            Set<ANode> comps = this.parseUnorderedSet(array, this.d_kb.getNodes());
            boolean reject = "reject".equals(json.get("action"));
            boolean elevatorsFromBehavior = (Boolean)json.get("elevators-from-behavior");
            compRestrictionsMap.put(ix, new OccProfileSim.CompRestrictions(comps, reject, elevatorsFromBehavior));
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    private OccTarget parseOccTarget(String line) throws IOException {
        JSONObject jobj = SimpleParser.getJsonLine(line, true);
        int id = SimpleParser.parseValue(jobj.get("id"), Integer.class);
        String name = (String)jobj.get("name");
        Vector3d orient = JsonUtil.getVector3d(jobj, "orient", true);
        Point3d loc = JsonUtil.getPoint3d(jobj, "loc");
        double priority = SimpleParser.parseValue(jobj, "priority", 0.0, Double.class);
        Tri tri = this.d_kb.getMesh().getTri(loc);
        if (tri == null) {
            throw new RuntimeException(String.format("Could not find triangle for %s", SimpleParser.format(loc)));
        }
        return new OccTarget(id, name, new TriPoint(tri, loc), orient, priority);
    }

    private AttractorSim parseAttractor(String line, List<ANode> nodes, Map<AttractorSim, Integer> attrBehaviorAssignments, List<IDistributedVal<?>> distributions, TagGenerator tags) throws IOException {
        JSONObject jobj = SimpleParser.getJsonLine(line, true);
        return this.parseAttractor(jobj, attrBehaviorAssignments, nodes, distributions, tags);
    }

    private AttractorSim parseAttractor(JSONObject jobj, Map<AttractorSim, Integer> attrBehaviorAssignments, List<ANode> nodes, List<IDistributedVal<?>> distributions, TagGenerator tags) throws IOException {
        int id = JsonUtil.getInt(jobj, "id");
        long resultsId = JsonUtil.getLong(jobj, "resultsId");
        String name = (String)jobj.get("name");
        AttractorSim.PlaceType type = AttractorSim.PlaceType.valueOf((String)jobj.get("type"));
        int rank = JsonUtil.getInt(jobj, "rank");
        AttractorSim.Awareness awareness = AttractorSim.Awareness.valueOf((String)jobj.get("awareness"));
        int minAwarenessCount = JsonUtil.getNum(jobj, "minAwarenessCount", 1).intValue();
        double minAwarenessTime = JsonUtil.getNum(jobj, "minAwarenessTime", 0.0).doubleValue();
        int behaviorId = JsonUtil.getInt(jobj, "behavior");
        AttractorSim.InfluenceFrom influenceFrom = AttractorSim.InfluenceFrom.valueOf((String)jobj.get("influenceFrom"));
        double influence = JsonUtil.getDouble(jobj, "influence");
        boolean requiresCompletion = jobj.getOrDefault("requiresCompletion", false);
        boolean forceConsiderationIfUnaware = jobj.getOrDefault("forceConsiderationIfUnaware", true);
        TriPoint loc = null;
        if (type != AttractorSim.PlaceType.TEMPLATE && jobj.containsKey("location")) {
            Point3d p = JsonUtil.getPoint3d(jobj, "location");
            Tri tri = this.d_kb.getMesh().getTri(p);
            if (tri == null) {
                throw new IOException(String.format("Could not find triangle for %s", SimpleParser.format(p)));
            }
            loc = new TriPoint(tri, p);
        }
        boolean ignoreOccSusc = jobj.getOrDefault("ignoreOccSusc", false);
        IEventTime usageTime = this.parseEventTime((JSONObject)jobj.get("reactTime"), distributions);
        Set<ANode> rooms = Collections.emptySet();
        double influenceRadius = 0.0;
        switch (awareness) {
            case GLOBAL: {
                break;
            }
            case ROOM_ONLY: {
                break;
            }
            case ROOMS: {
                JSONArray jrooms = (JSONArray)jobj.get("rooms");
                rooms = new LinkedIdentityHashSet();
                for (int m = 0; m < jrooms.size(); ++m) {
                    int nodeIx = ((Number)jrooms.get(m)).intValue();
                    rooms.add(nodes.get(nodeIx));
                }
                break;
            }
            case LINE_OF_SIGHT: {
                influenceRadius = JsonUtil.getDouble(jobj, "radius");
            }
        }
        List<Pair<Double, Double>> influenceCurve = JsonUtil.getList(jobj.getOrDefault("influenceCurve", new JSONArray()), obj -> new Pair<Double, Double>(JsonUtil.getDouble((JSONObject)obj, "time"), JsonUtil.getDouble((JSONObject)obj, "influence")));
        Predicate occFilter = Predicates.alwaysTrue();
        JSONObject joccFilter = (JSONObject)jobj.get("occFilter");
        if (joccFilter != null) {
            Function<String, Tag> toTag = tags::getTag;
            occFilter = IOccFilter.InputFileInfo.findType((JSONObject)joccFilter).fromJson.get(joccFilter, toTag);
        }
        AttractorSim result = new AttractorSim(new AttractorSim.Props(resultsId, name, type, rank, null, requiresCompletion, awareness, minAwarenessCount, minAwarenessTime, forceConsiderationIfUnaware, influenceRadius, influence, influenceCurve, influenceFrom, ignoreOccSusc, rooms, usageTime, occFilter), loc);
        result.setId(id);
        attrBehaviorAssignments.put(result, behaviorId);
        return result;
    }

    private IEventTime parseEventTime(JSONObject jobj, List<IDistributedVal<?>> distributions) throws IOException {
        if (jobj == null) {
            return IEventTime.Auto.INSTANCE;
        }
        IEventTime.InputFileInfo info = IEventTime.InputFileInfo.findType(jobj);
        return info.fromJson.get(jobj, i -> (IDistributedVal)distributions.get(i));
    }

    private <T> void parseAttrFilter(String line, Map<Integer, Predicate<AttractorSim>> attrFilterMap, List<AttractorSim> attrList) throws IOException {
        int colix = line.indexOf(58);
        int ix = Integer.parseInt(line.substring(0, colix));
        try {
            String jsonStr = line.substring(colix + 1);
            Predicate<AttractorSim> filter = this.parseObjsFilter(jsonStr, attrList);
            attrFilterMap.put(ix, filter);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    private <T> Predicate<T> parseObjsFilter(String jsonString, List<T> objList) throws ParseException {
        String action;
        JSONParser parser = new JSONParser();
        JSONObject json = (JSONObject)parser.parse(jsonString);
        Supplier<Set> getObjSet = () -> {
            JSONArray jobjIds = (JSONArray)json.get("objects");
            LinkedIdentityHashSet attrs = new LinkedIdentityHashSet();
            for (int m = 0; m < jobjIds.size(); ++m) {
                Number val = (Number)jobjIds.get(m);
                attrs.add(objList.get(val.intValue()));
            }
            return attrs;
        };
        switch (action = (String)json.get("action")) {
            case "accept_all": {
                return Predicates.alwaysTrue();
            }
            case "reject_all": {
                return Predicates.alwaysFalse();
            }
            case "accept": {
                return Filters.accept(getObjSet.get());
            }
            case "reject": {
                return Filters.reject(getObjSet.get());
            }
        }
        assert (false);
        return Predicates.alwaysTrue();
    }

    private IDistributedVal<?> getDistributedVal(List<IDistributedVal<?>> distributions, JSONObject json, String key, boolean required) throws IOException {
        if (!json.containsKey(key)) {
            if (!required) {
                return null;
            }
            throw new IOException(String.format(Intl.intl("%s must be defined."), key));
        }
        int ix = JsonUtil.getInt(json, key);
        if (ix < 0 || ix >= distributions.size()) {
            throw new IOException(String.format(Intl.intl("%1$s must lie in the range, 0 to %2$d"), key, distributions.size() - 1));
        }
        return distributions.get(ix);
    }

    private OccSource parseOccSource(String line, List<IFunction1d> functions, List<OccProfileSim> profiles, List<BehaviorSim> behaviors, List<IDistributedVal<?>> distributions) throws IOException {
        try {
            IOccSourceFlowrate flowRate;
            JSONObject json = SimpleParser.getJsonLine(line, true);
            String name = (String)json.get("name");
            if (name == null) {
                name = "";
            }
            JSONObject boundsJson = (JSONObject)json.get("bounds");
            Point3d min = this.parsePoint3d(new TokenIterator(SimpleParser.getTokens((String)boundsJson.get("min"), "(), ", false)));
            Point3d max = this.parsePoint3d(new TokenIterator(SimpleParser.getTokens((String)boundsJson.get("max"), "(), ", false)));
            AABox bounds = new AABox(min, max);
            long sourceSeed = json.containsKey("seed") ? JsonUtil.getLong(json, "seed") : this.d_occSourceSeedGen.nextLong();
            if (json.containsKey("flowrate")) {
                long flowRateIxL = (Long)json.get("flowrate");
                int flowRateIx = (int)flowRateIxL;
                IFunction1d flowRateFunc = functions.get(flowRateIx);
                flowRate = new AUCOccSourceFlowrate(flowRateFunc);
            } else {
                assert (json.containsKey("occSourceFlowrate"));
                JSONObject jflowrate = (JSONObject)json.get("occSourceFlowrate");
                FlowrateParser[] parsers = new FlowrateParser[]{AUCOccSourceFlowrate::fromJson, RandomizedOccSourceFlowrate::fromJson, DistributedOccSourceFlowrate::fromJson};
                Exception[] caughtExc = new Exception[]{null};
                Optional<IOccSourceFlowrate> oflowRate = Stream.of(parsers).map(parser -> {
                    try {
                        return parser.parse(jflowrate, functions::get);
                    }
                    catch (Exception e) {
                        if (caughtExc[0] == null) {
                            caughtExc[0] = e;
                        }
                        return null;
                    }
                }).filter(fr -> fr != null).findFirst();
                if (!oflowRate.isPresent()) {
                    assert (caughtExc[0] != null);
                    throw new IOException(caughtExc[0]);
                }
                flowRate = oflowRate.get();
            }
            IUrn profileIndexUrn = (IUrn)this.getDistributedVal(distributions, json, "profiles", true);
            IUrn<OccProfileSim> profUrn = SimpleParser.toObjectUrn(profileIndexUrn, profiles);
            IUrn behaviorIndexUrn = (IUrn)this.getDistributedVal(distributions, json, "behaviors", true);
            IUrn<BehaviorSim> behaviorUrn = SimpleParser.toObjectUrn(behaviorIndexUrn, behaviors);
            boolean enforceFlowrate = (Boolean)json.get("enforceFlowrate");
            Object compIx = json.get("component");
            ANode component = null;
            if (compIx != null) {
                component = this.d_kb.getNodes().get((int)((Long)compIx).longValue());
            }
            ICurve initialOrient = (ICurve)this.getDistributedVal(distributions, json, "initialOrient", false);
            boolean emitAtMaxVel = json.getOrDefault("emitAtMaxVel", false);
            IUrn groupTemplateIndexUrn = (IUrn)this.getDistributedVal(distributions, json, "groupTemplates", true);
            IUrn<OccGroupType> groupTemplateUrn = SimpleParser.toObjectUrn(groupTemplateIndexUrn, this.d_kb.getOccupantGroupTypes());
            List<Point3d> spawnLocs = Collections.emptyList();
            if (json.containsKey("locations")) {
                spawnLocs = JsonUtil.getList((JSONArray)json.get("locations"), o -> JsonUtil.getPoint3d((JSONArray)o));
            }
            return new OccSource(this.d_kb, name, bounds, flowRate, profUrn, behaviorUrn, sourceSeed, enforceFlowrate, initialOrient, emitAtMaxVel, component, groupTemplateUrn, spawnLocs);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> IUrn<T> toObjectUrn(IUrn<Integer> urn, List<T> indexList) {
        Map<Integer, Double> weights = urn.getWeights();
        LinkedIdentityHashMap urnMap = new LinkedIdentityHashMap();
        weights.forEach((k, v) -> urnMap.put(indexList.get((int)k), v));
        return UrnUtil.newUrn(urnMap);
    }

    public Counter parseCounter(String line) {
        TokenIterator toks = new TokenIterator(SimpleParser.getTokens(line, " ,=", true));
        double initValue = toks.nextDouble();
        return new Counter(initValue);
    }

    private IOccGroup parseOccGroup(String line, List<IDistributedVal<?>> distributions, List<OccProfileSim> profiles, boolean isGroupType) {
        int colix = line.indexOf(58);
        int groupID = Integer.parseInt(line.substring(0, colix));
        JSONParser parser = new JSONParser();
        try {
            IOccGroup group;
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            double maxDistance = (Double)json.get("maxDistance");
            double slowdownTime = (Double)json.get("slowdownTime");
            boolean requiresLeader = (Boolean)json.get("requiresLeader");
            boolean respectSocialDist = json.getOrDefault("respectSocialDist", false);
            String name = "";
            if (json.containsKey("name")) {
                name = (String)json.get("name");
            }
            Color color = SimpleParser.parseJSONColor(json.get("color"));
            if (isGroupType) {
                boolean allowSmallerGroups = (Boolean)json.get("allowSmallerGroups");
                ICurve minNumberOfMembers = null;
                if (allowSmallerGroups) {
                    int minNumberOfMembersID = (int)((Long)json.get("minNumberOfMembers")).longValue();
                    minNumberOfMembers = (ICurve)distributions.get(minNumberOfMembersID);
                }
                int prefNumberOfMembersID = (int)((Long)json.get("prefNumberOfMembers")).longValue();
                ICurve prefNumberOfMembers = (ICurve)distributions.get(prefNumberOfMembersID);
                boolean useExactCalc = (Boolean)json.get("exactDistanceCalculation");
                double heightMultiplier = !useExactCalc ? (Double)json.get("heightMultiplier") : 0.0;
                Object leaderProfID = json.get("leaderProfile");
                OccProfileSim leaderProf = null;
                if (leaderProfID != null) {
                    leaderProf = profiles.get(((Long)leaderProfID).intValue());
                }
                boolean restrictRoom = (Boolean)json.get("restrictRoom");
                boolean specifyProfiles = (Boolean)json.get("specifyProfiles");
                LinkedIdentityHashMap<OccProfileSim, OccGroupType.GroupCreationData> profMap = null;
                if (specifyProfiles) {
                    profMap = new LinkedIdentityHashMap<OccProfileSim, OccGroupType.GroupCreationData>();
                    JSONArray profArray = (JSONArray)json.get("profiles");
                    for (Object o : profArray) {
                        JSONObject profJson = (JSONObject)o;
                        boolean allowSmallerGroupsProf = (Boolean)profJson.get("allowSmallerGroups");
                        ICurve minNumberOfMembersProf = allowSmallerGroupsProf ? (ICurve)distributions.get((int)((Long)profJson.get("minNumberOfMembers")).longValue()) : null;
                        ICurve prefNumberOfMembersProf = (ICurve)distributions.get((int)((Long)profJson.get("prefNumberOfMembers")).longValue());
                        OccProfileSim prof = profiles.get((int)((Long)profJson.get("profile")).longValue());
                        OccGroupType.GroupCreationData data = new OccGroupType.GroupCreationData(prefNumberOfMembersProf, allowSmallerGroupsProf, minNumberOfMembersProf);
                        profMap.put(prof, data);
                    }
                }
                boolean isNoGroupType = (Boolean)json.get("ungrouped");
                group = new OccGroupType(groupID, name, maxDistance, slowdownTime, requiresLeader, minNumberOfMembers, prefNumberOfMembers, allowSmallerGroups, useExactCalc, heightMultiplier, specifyProfiles, profMap, leaderProf, restrictRoom, color, isNoGroupType, respectSocialDist);
            } else {
                Color templateColor = SimpleParser.parseJSONColor(json.get("templateColor"));
                group = new OccGroup(groupID, name, maxDistance, slowdownTime, requiresLeader, respectSocialDist, color, templateColor);
            }
            return group;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void finishParsingOccGroup(String line, OccGroup occGroup) {
        try {
            Object leader;
            JSONObject json = SimpleParser.getJsonLine(line, true);
            JSONArray initMembersAr = (JSONArray)json.get("members");
            if (initMembersAr != null) {
                for (Object idObj : initMembersAr) {
                    if (!(idObj instanceof Long)) continue;
                    int id = (int)((Long)idObj).longValue();
                    Occupant occ = this.d_kb.getOccs().get(id);
                    occGroup.addOccOnInit(occ);
                }
            }
            if ((leader = json.get("leader")) != null) {
                int leaderId = (int)((Long)leader).longValue();
                occGroup.addLeaderOnInit(this.d_kb.getOccs().get(leaderId));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public AssistedEvacTeam parseAssistedEvacData(String line) {
        String[] tokens = SimpleParser.getTokens(line, " ,=", true);
        int colix = line.indexOf(58);
        int id = Integer.parseInt(line.substring(0, colix));
        ArrayList<Integer> teamGoals = new ArrayList<Integer>();
        String teamName = null;
        block8: for (int index = 0; index < tokens.length; ++index) {
            switch (tokens[index]) {
                case "goals": {
                    String[] goalsTokens = SimpleParser.getTokens(tokens[++index], "|", false);
                    if (goalsTokens[0].equals("NA")) continue block8;
                    for (int i = 0; i < goalsTokens.length; ++i) {
                        teamGoals.add(Integer.parseInt(goalsTokens[i]));
                    }
                    continue block8;
                }
                case "name": {
                    teamName = tokens[++index];
                    continue block8;
                }
                default: {
                    System.err.printf("warning: %s \"%s\" (ignored)\n", "unknown assisted evacuation parameter", tokens[index]);
                }
            }
        }
        return new AssistedEvacTeam(teamName, teamGoals, id);
    }

    public int parseVersion(String line) {
        return Integer.parseInt(line);
    }

    public Material parseMat(String line) {
        File inputDir = new File(this.d_absolutePath);
        Function<String, IImage> imgLoader = imgName -> {
            File file = FilenameManager.resolveFile(inputDir, imgName, false);
            return ImageManager.getImage(file.getAbsolutePath(), 3, 0);
        };
        if (this.d_version < 10) {
            IImage img;
            String[] tokens = SimpleParser.getTokens(line, true);
            String imgName2 = tokens[0];
            double width = Double.parseDouble(tokens[1]);
            double height = Double.parseDouble(tokens[2]);
            MatAttrs nattrs = new MatAttrs();
            nattrs = nattrs.applyRedirect(MatChannel.AMBIENT, MatChannel.DIFFUSE);
            if (imgName2 != null && (img = imgLoader.apply(imgName2)) != null) {
                Texture tex = Texture.repeated(img, "uvset");
                nattrs = nattrs.applyTexture(MatChannel.DIFFUSE, tex);
            }
            return new Material(nattrs, width, height);
        }
        try {
            JSONObject jobj = SimpleParser.getJsonLine(line, true);
            double width = JsonUtil.getDouble(jobj, "width");
            double height = JsonUtil.getDouble(jobj, "height");
            MatAttrs attrs = IMatAttrs.fromJson(jobj, imgLoader);
            return new Material(attrs, width, height);
        }
        catch (Throwable t) {
            TeciLogging.log(LOGGER, Level.SEVERE, t);
            return null;
        }
    }

    public IFunction1d parseFunction(String line) throws IOException {
        try {
            JSONObject json = SimpleParser.getJsonLine(line, true);
            String type = (String)json.get("type");
            if (type.equalsIgnoreCase("const")) {
                double val = (Double)json.get("val");
                return new ConstFunction1d(val);
            }
            if (type.equalsIgnoreCase("pw")) {
                JSONArray xj = (JSONArray)json.get("x");
                JSONArray yj = (JSONArray)json.get("y");
                boolean extrapolate = (Boolean)json.get("extrapolate");
                double[] x = new double[xj.size()];
                for (int i = 0; i < x.length; ++i) {
                    x[i] = (Double)xj.get(i);
                }
                double[] y = new double[yj.size()];
                for (int i = 0; i < y.length; ++i) {
                    y[i] = (Double)yj.get(i);
                }
                return new PiecewiseFunction1d(x, y, extrapolate);
            }
            if (type.equalsIgnoreCase("impulse")) {
                return ImpulseFunction1d.parse(json);
            }
            assert (false);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IDistributedVal<?> parseDistribution(TagGenerator tags, String line, boolean hasHeader) throws IOException {
        JSONObject json = SimpleParser.getJsonLine(line, hasHeader);
        Object urn = json.get("urn");
        return urn != null ? this.parseOrderedUrn(tags, line, hasHeader) : SimpleParser.parseCurve(line, hasHeader);
    }

    public static ICurve parseCurve(String line, boolean hasHeader) throws IOException {
        try {
            JSONObject json = SimpleParser.getJsonLine(line, hasHeader);
            String type = (String)json.get("type");
            if (type.equalsIgnoreCase("auto")) {
                return new AutoCurve(Unit.ONE);
            }
            if (type.equalsIgnoreCase("cc")) {
                UnitDouble val = Global.parseUnitDouble((CharSequence)json.get("val"), null, Locale.US);
                return new ConstantCurve(val);
            }
            if (type.equalsIgnoreCase("logNorm")) {
                UnitDouble mean = Global.parseUnitDouble((CharSequence)json.get("mean"), null, Locale.US);
                UnitDouble stDev = Global.parseUnitDouble((CharSequence)json.get("stDev"), null, Locale.US);
                UnitDouble min = Global.parseUnitDouble((CharSequence)json.get("min"), null, Locale.US);
                UnitDouble max = Global.parseUnitDouble((CharSequence)json.get("max"), null, Locale.US);
                return new LogNormCurve(min, max, mean, stDev);
            }
            if (type.equalsIgnoreCase("stdNorm")) {
                UnitDouble mean = Global.parseUnitDouble((CharSequence)json.get("mean"), null, Locale.US);
                UnitDouble stDev = Global.parseUnitDouble((CharSequence)json.get("stDev"), null, Locale.US);
                UnitDouble min = Global.parseUnitDouble((CharSequence)json.get("min"), null, Locale.US);
                UnitDouble max = Global.parseUnitDouble((CharSequence)json.get("max"), null, Locale.US);
                return new StdNormCurve(min, max, mean, stDev);
            }
            if (type.equalsIgnoreCase("unif")) {
                UnitDouble min = Global.parseUnitDouble((CharSequence)json.get("min"), null, Locale.US);
                UnitDouble max = Global.parseUnitDouble((CharSequence)json.get("max"), null, Locale.US);
                return new UniformCurve(min, max);
            }
            assert (false);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (java.text.ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String unescapeName(String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.isEmpty()) {
            return "";
        }
        String[] toks = SimpleParser.getTokens(name, "", false, true, false, false);
        assert (toks.length == 1);
        return toks[0];
    }

    public void parseNode(String line, TagGenerator tags) throws IOException {
        TokenIterator toks = new TokenIterator(SimpleParser.getTokens(line, " ,=", true, true, true, true));
        String name = this.unescapeName(toks.next());
        toks.next();
        int animationId = Integer.parseInt(toks.next());
        long resultsId = -1L;
        String annotatedName = name;
        if (this.d_version >= 11) {
            resultsId = Long.parseLong(toks.next());
            annotatedName = this.unescapeName(toks.next());
        }
        ANode n = new ANode(name, annotatedName);
        n.setAnimationId(animationId);
        n.setResultsID(resultsId);
        this.d_kb.addNode(n);
        while (toks.hasMore()) {
            String param = toks.next();
            switch (param.toLowerCase()) {
                case "tags": {
                    String tagStr = toks.next();
                    Set<Tag> ntags = SimpleParser.getTags(tagStr, tags, false);
                    if (ntags.isEmpty()) break;
                    n.setOccTags(new ArrayList<Tag>(ntags));
                    break;
                }
                case "count": {
                    int count = toks.nextInt();
                    n.setCapacity(new ANode.Count(count));
                    break;
                }
                case "dens": {
                    double density = toks.nextDouble();
                    n.setCapacity(new ANode.Density(density, n));
                    break;
                }
            }
        }
    }

    public void parseDoor(String line, List<IDistributedVal<?>> distributions) throws IOException {
        TokenIterator tokens = new TokenIterator(SimpleParser.getTokens(line, true));
        int ixNode = tokens.nextInt();
        ANode n = this.d_kb.getNodes().get(ixNode);
        double effWid = tokens.nextDouble();
        String strR1 = tokens.next();
        ANode r1 = null;
        if (!strR1.equals("-")) {
            int ixR1 = Integer.parseInt(strR1);
            r1 = this.d_kb.getNodes().get(ixR1);
        }
        String strR2 = tokens.next();
        ANode r2 = null;
        if (!strR2.equals("-")) {
            int ixR2 = Integer.parseInt(strR2);
            r2 = this.d_kb.getNodes().get(ixR2);
        }
        IDoorFlowrate flowrate = this.parseFlowrate(tokens);
        DoorDir onewayDir = this.parseDoorDir(tokens);
        String wt = tokens.next();
        IDistributedVal<UnitDouble> waitTime = wt.equals("-") ? null : distributions.get(Integer.parseInt(wt));
        n.createDoorQueueData(this.d_kb, this.getParam(), r1, r2, flowrate, effWid, waitTime);
        n.setDoorDir(onewayDir);
    }

    private IDoorFlowrate parseFlowrate(TokenIterator tokens) throws IOException {
        String frStr = tokens.next();
        if (frStr.equals("-")) {
            return null;
        }
        Double val = Double.parseDouble(frStr);
        return Double.isInfinite(val) ? IDoorFlowrate.UNLIMITED : new IDoorFlowrate.Fixed(val);
    }

    private DoorDir parseDoorDir(TokenIterator tokens) throws IOException {
        if (!tokens.hasMore()) {
            return null;
        }
        String dirStr = tokens.next();
        if (dirStr.equals("-")) {
            return null;
        }
        if (dirStr.equals("dir+")) {
            return DoorDir.POSITIVE;
        }
        if (dirStr.equals("dir-")) {
            return DoorDir.NEGATIVE;
        }
        throw new IOException(String.format("Unknown door direction: %s", dirStr));
    }

    public void parseStair(String line) {
        String[] tokens = SimpleParser.getTokens(line, true);
        int ixNode = Integer.parseInt(tokens[0]);
        ANode n = this.d_kb.getNodes().get(ixNode);
        double rise = Double.parseDouble(tokens[1]);
        double tread = Double.parseDouble(tokens[2]);
        n.createStairData(this.d_kb, rise, tread);
    }

    private static ICurve cc(double val, Unit u) {
        return new ConstantCurve(new UnitDouble(val, u));
    }

    public OccProfileSim.IShapeGen parseOccShape(String line, List<IDistributedVal<?>> distributions) {
        TokenIterator tokens = new TokenIterator(SimpleParser.getTokens(line, " ,=", true));
        String type = "";
        String name = "";
        ICurve shoulderWidth = null;
        Double geomWidth = null;
        ICurve height = null;
        Point3d[] points = new Point3d[]{};
        List<Point3d> attachments = Collections.emptyList();
        Set<String> animTags = Collections.emptySet();
        String model = null;
        boolean lateral = false;
        Supplier<Point3d> parsePoint = () -> {
            double x = tokens.nextDouble();
            double y = tokens.nextDouble();
            double z = tokens.nextDouble();
            return new Point3d(x, y, z);
        };
        Supplier<Point3d[]> parsePointList = () -> {
            int pcount = tokens.nextInt();
            Point3d[] p = new Point3d[pcount];
            for (int m = 0; m < pcount; ++m) {
                p[m] = (Point3d)parsePoint.get();
            }
            return p;
        };
        Point3d occAvatarOffset = GeomConstants.PNT3D_ORIGIN;
        Point3d origin = GeomConstants.PNT3D_ORIGIN;
        block46: while (tokens.hasMore()) {
            String tstr = tokens.next();
            block16 : switch (tstr.toLowerCase()) {
                case "name": {
                    name = tokens.next();
                    break;
                }
                case "type": {
                    switch (type = tokens.next().toLowerCase()) {
                        case "poly": {
                            points = parsePointList.get();
                        }
                    }
                    break;
                }
                case "diameter": {
                    shoulderWidth = SimpleParser.cc(tokens.nextDouble(), SI.METER);
                    break;
                }
                case "diameterdist": {
                    shoulderWidth = (ICurve)distributions.get(tokens.nextInt());
                    break;
                }
                case "height": {
                    height = SimpleParser.cc(tokens.nextDouble(), SI.METER);
                    break;
                }
                case "heightdist": {
                    height = (ICurve)distributions.get(tokens.nextInt());
                    break;
                }
                case "geomdiameter": {
                    geomWidth = tokens.nextDouble();
                    break;
                }
                case "attachedagentspositions": {
                    attachments = Arrays.asList(parsePointList.get());
                    break;
                }
                case "anim": {
                    String animtype = tokens.next();
                    switch (animtype.toLowerCase()) {
                        case "wheelchair": {
                            animTags = CommonAnimTags.DEFAULT_WHEELCHAIR.tags;
                            break block16;
                        }
                        case "bed": {
                            animTags = CommonAnimTags.DEFAULT_LAY.tags;
                        }
                    }
                    break;
                }
                case "animtags": {
                    int tagCount = tokens.nextInt();
                    animTags = new LinkedHashSet();
                    for (int m = 0; m < tagCount; ++m) {
                        animTags.add(tokens.next());
                    }
                    continue block46;
                }
                case "model": {
                    model = tokens.next();
                    if (!model.equals("<shape>")) break;
                    model = "";
                    break;
                }
                case "occavataroffset": {
                    occAvatarOffset = parsePoint.get();
                    break;
                }
                case "origin": {
                    origin = parsePoint.get();
                    break;
                }
                case "lateral": {
                    lateral = tokens.nextBoolean();
                }
            }
        }
        if (shoulderWidth != null) {
            return new OccProfileSim.CylShapeGen(shoulderWidth, geomWidth != null ? new UnitDouble(geomWidth, LENGTH_UNIT) : null, height);
        }
        if (!(height instanceof ConstantCurve)) {
            System.err.println("WARNING: Polygon height not specified as a constant - using average instead.");
        }
        double polyHeight = height.getAvg().get(LENGTH_UNIT);
        if (name.isEmpty()) {
            name = "Polygon";
        }
        VehicleBody vbody = new VehicleBody(name, origin, points, polyHeight, lateral, attachments, animTags, occAvatarOffset, model);
        return new OccProfileSim.PolyShapeGen(vbody);
    }

    private float getComfortDist(JSONObject json, Random rnd, long seed, OccProfileSim parentProfile, double occRadius) {
        Object ret = json.get("comfortDist");
        if (ret instanceof Number) {
            return ((Number)ret).floatValue();
        }
        if (ret instanceof String) {
            return Float.parseFloat((String)ret);
        }
        return (float)parentProfile.getComfortDistance(rnd, seed, new UnitDouble(occRadius, SI.METER)).get(SI.METER);
    }

    private static <T> T parseValue(Object ret, Class<T> targetClass) {
        if (ret != null && !targetClass.equals(ret.getClass())) {
            boolean retString = ret.getClass().equals(String.class);
            if (targetClass.equals(Double.class)) {
                return (T)(retString ? Double.valueOf(Double.parseDouble((String)ret)) : Double.valueOf(((Number)ret).doubleValue()));
            }
            if (targetClass.equals(Float.class)) {
                return (T)(retString ? Float.valueOf(Float.parseFloat((String)ret)) : Float.valueOf(((Number)ret).floatValue()));
            }
            if (targetClass.equals(Integer.class)) {
                return (T)(retString ? Integer.valueOf(Integer.parseInt((String)ret)) : Integer.valueOf(((Number)ret).intValue()));
            }
            if (targetClass.equals(Long.class)) {
                return (T)(retString ? Long.valueOf(Long.parseLong((String)ret)) : Long.valueOf(((Number)ret).longValue()));
            }
            if (targetClass.equals(Boolean.class)) {
                return (T)(retString ? Boolean.valueOf(Boolean.parseBoolean((String)ret)) : (Boolean)ret);
            }
            if (targetClass.equals(Point3f.class)) {
                StringTokenizer st = new StringTokenizer((String)ret, "(), ");
                return (T)new Point3f(Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()));
            }
            if (Enum.class.isAssignableFrom(targetClass) && ret instanceof String) {
                return Enum.valueOf(targetClass, (String)ret);
            }
            assert (false);
            return null;
        }
        return (T)ret;
    }

    private static <T> T parseValue(JSONObject obj, String key, T defVal, Class<T> targetClass) {
        if (!obj.containsKey(key)) {
            return defVal;
        }
        return SimpleParser.parseValue(obj.get(key), targetClass);
    }

    private <T> Set<T> parseUnorderedSet(JSONArray array, List<T> items) {
        IdentityHashSet restrictedComps = new IdentityHashSet();
        for (int i = 0; i < array.size(); ++i) {
            restrictedComps.add(items.get((int)((Long)array.get(i)).longValue()));
        }
        return restrictedComps;
    }

    private static <T> T getCustomOccProp(JSONObject json, String key, Class<T> targetClass, T defVal) {
        Object jsonVal = json.get(key);
        if (jsonVal == null) {
            return defVal;
        }
        return SimpleParser.parseValue(jsonVal, targetClass);
    }

    public Occupant parseOccFromJson(KB kb, String line, OccAdder adder, Random seedGen, Random priorityGen, List<OccProfileSim> profiles, List<BehaviorSim> behaviors, List<IFunction1d> functions, List<OccProfileSim.IShapeGen> occShapes, HashMap<Integer, String> aeTeamNameMap, List<AttractorSim> attractors, Map<Integer, OccProfileSim.CompRestrictions> compRestrictionsMap, Map<Integer, Predicate<AttractorSim>> attrFilterMap, TagGenerator tags) throws IOException {
        OccPropParser opp = new OccPropParser(kb, attractors);
        try {
            String orientString;
            JSONObject json = SimpleParser.getJsonLine(line, true);
            Random rnd = new Random();
            OccProfileSim parentProfile = profiles.get((int)((Long)json.get("profile")).longValue());
            Long rseed = (Long)json.get("rseed");
            if (rseed == null) {
                rseed = theUtil.randomSeed(rnd);
            }
            long frseed = rseed;
            Long orientSeed = (Long)json.get("orientSeed");
            if (orientSeed == null) {
                orientSeed = rseed;
            }
            String name = (String)json.get("name");
            int ixOccProf = (int)((Long)json.get("behavior")).longValue();
            BehaviorSim behavior = behaviors.get(ixOccProf);
            String ptString = (String)json.get("loc");
            StringTokenizer st = new StringTokenizer(ptString, " ");
            Point3d pt = new Point3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
            IFunction1d fundamental = KnownFuncs.SFPE_FUNDAMENTAL_DIAGRAM;
            IFunction1d stairFracUp = KnownFuncs.SFPE_STAIR_FUNCTION;
            IFunction1d stairFundUp = null;
            IFunction1d stairFracDown = KnownFuncs.SFPE_STAIR_FUNCTION;
            IFunction1d stairFundDown = null;
            IFunction1d rampFracUp = KnownFuncs.SFPE_RAMP_FUNCTION;
            IFunction1d rampFundUp = null;
            IFunction1d rampFracDown = KnownFuncs.SFPE_RAMP_FUNCTION;
            IFunction1d rampFundDown = null;
            Occupant occ = adder.add(name, rseed, orientSeed, parentProfile, behavior, pt, this.d_kb);
            if (occ == null) {
                return null;
            }
            String modelid = (String)opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_OCCMODEL.key, parentProfile, OccProfileSim.PROP_OCCMODEL, String.class);
            occ.avatar = modelid.equals("<null>") ? null : modelid;
            occ.maxVel = ((Float)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_MAXVEL.key, parentProfile, OccProfileSim.PROP_MAXVEL, Float.class, VEL_UNIT)).floatValue();
            occ.accelFactor = 1.0f / ((Float)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_ACCEL_TIME.key, parentProfile, OccProfileSim.PROP_ACCEL_TIME, Float.class, TIME_UNIT)).floatValue();
            Double occDiameter = SimpleParser.getCustomOccProp(json, INLINE_PROP_DIAMETER, Double.class, null);
            if (occDiameter != null) {
                Double geomDiam = SimpleParser.getCustomOccProp(json, INLINE_PROP_GEOM_DIAMETER, Double.class, occDiameter);
                Double height = SimpleParser.getCustomOccProp(json, INLINE_PROP_HEIGHT, Double.class, 1.8288);
                occ.bodyShape = new CylinderShape(pt, occDiameter * 0.5, geomDiam * 0.5, height, occ.orient, occ.id);
            } else {
                Object bodyShapeProp = opp.getOccProp(json, rnd, rseed, parentProfile, OccProfileSim.PROP_SHAPE, null);
                OccProfileSim.IShapeGen bodyShape = bodyShapeProp instanceof OccProfileSim.IShapeGen ? (OccProfileSim.IShapeGen)bodyShapeProp : occShapes.get(((Number)bodyShapeProp).intValue());
                occ.bodyShape = bodyShape.generateShape(occ, rnd, rseed, this.d_kb);
            }
            Object speedInSmokeParseProp = opp.getOccProp(json, rnd, rseed, parentProfile, OccProfileSim.PROP_SPEED_IN_SMOKE, null);
            if (speedInSmokeParseProp instanceof SpeedInSmokeSim) {
                occ.smokeSpeed = (SpeedInSmokeSim)speedInSmokeParseProp;
            } else {
                assert (speedInSmokeParseProp instanceof JSONObject);
                occ.smokeSpeed = SimpleParser.parseSpeedInSmokeJson(speedInSmokeParseProp, functions);
            }
            Point3f c = (Point3f)opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_COLOR.key, parentProfile, OccProfileSim.PROP_COLOR, Point3f.class);
            occ.visColor = this.finalizeColor(new Color3b(theUtil.toCCb(c.x), theUtil.toCCb(c.y), theUtil.toCCb(c.z)));
            occ.reacTime = ((Float)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_REAC_TIME.key, parentProfile, null, Float.class, TIME_UNIT)).floatValue();
            double priority = (Double)opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_PRIORITY_LEVEL.key, parentProfile, OccProfileSim.PROP_PRIORITY_LEVEL, Double.class);
            occ.minSqueezeFactor = ((Float)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_MIN_SQUEEZE_FACTOR_CONST.key, parentProfile, OccProfileSim.PROP_MIN_SQUEEZE_FACTOR_CONST, Float.class, Unit.ONE)).floatValue();
            occ.persistTime = ((Float)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_PERSIST_TIME.key, parentProfile, OccProfileSim.PROP_PERSIST_TIME, Float.class, TIME_UNIT)).floatValue();
            occ.collisionResponseTime = ((Float)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_COLLISION_RESPONSE_TIME.key, parentProfile, OccProfileSim.PROP_COLLISION_RESPONSE_TIME, Float.class, TIME_UNIT)).floatValue();
            occ.comfortDist = this.getComfortDist(json, rnd, rseed, parentProfile, occ.bodyShape.getOccRadius());
            Object socialDistFilter = opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_SOCIAL_DIST_FILTER.key, parentProfile, OccProfileSim.PROP_SOCIAL_DIST_FILTER, null);
            if (socialDistFilter instanceof Predicate) {
                occ.socialDistFilter = (Predicate)socialDistFilter;
            } else if (socialDistFilter instanceof JSONObject) {
                JSONObject jsocialDistFilter = (JSONObject)socialDistFilter;
                Function<String, Tag> toTag = tags::getTag;
                occ.socialDistFilter = IOccFilter.InputFileInfo.findType((JSONObject)jsocialDistFilter).fromJson.get(jsocialDistFilter, toTag);
            }
            occ.socialDist = ((Float)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_SOCIAL_DIST.key, parentProfile, OccProfileSim.PROP_SOCIAL_DIST, Float.class, LENGTH_UNIT)).floatValue();
            occ.slowFactor = ((Float)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_SLOW_FACTOR.key, parentProfile, OccProfileSim.PROP_SLOW_FACTOR, Float.class, Unit.ONE)).floatValue();
            occ.reqAssistedBy = (Boolean)opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_ASSIST.key, parentProfile, OccProfileSim.PROP_ASSIST, Boolean.class);
            occ.requiresAssistance = (Boolean)opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_REQUIRES_ASSISTANCE.key, parentProfile, OccProfileSim.PROP_REQUIRES_ASSISTANCE, Boolean.class);
            occ.obeyOnewayDoors = (Boolean)opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_OBEY_ONEWAY_DOORS.key, parentProfile, OccProfileSim.PROP_OBEY_ONEWAY_DOORS, Boolean.class);
            occ.movingTerrainPref = (EscalatorPreference)((Object)opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_ESCALATOR_PREF.key, parentProfile, OccProfileSim.PROP_ESCALATOR_PREF, EscalatorPreference.class));
            occ.localQueueTimeFactor = (Double)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_LOCAL_QUEUE_TIME_FACTOR.key, parentProfile, OccProfileSim.PROP_LOCAL_QUEUE_TIME_FACTOR, Double.class, Unit.ONE);
            occ.localTravelTimeFactor = (Double)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_LOCAL_TRAVEL_TIME_FACTOR.key, parentProfile, OccProfileSim.PROP_LOCAL_TRAVEL_TIME_FACTOR, Double.class, Unit.ONE);
            occ.tailTimeFactor = (Double)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_TAIL_TIME_FACTOR.key, parentProfile, OccProfileSim.PROP_TAIL_TIME_FACTOR, Double.class, Unit.ONE);
            occ.currDoorFactor = (Double)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_CURR_DOOR_PREF.key, parentProfile, OccProfileSim.PROP_CURR_DOOR_PREF, Double.class, Unit.ONE);
            occ.distTravelledFactor = (Double)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_CURRENT_ROOM_DIST_PENALTY.key, parentProfile, null, Double.class, LENGTH_UNIT);
            occ.boundaryLayer = ((Float)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_BOUNDARY_LAYER.key, parentProfile, OccProfileSim.PROP_BOUNDARY_LAYER, Float.class, LENGTH_UNIT)).floatValue();
            occ.outputTimeHistory = (Integer)opp.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_PRINT_EXTRA_OUTPUT.key, parentProfile, OccProfileSim.PROP_PRINT_EXTRA_OUTPUT, Integer.class, Unit.ONE);
            Object compRest = opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_RESTRICTED_COMPONENTS.key, parentProfile, OccProfileSim.PROP_RESTRICTED_COMPONENTS, null);
            if (compRest instanceof Number) {
                occ.compRestrictions = compRestrictionsMap.get(((Number)compRest).intValue());
            } else if (compRest instanceof OccProfileSim.CompRestrictions) {
                occ.compRestrictions = (OccProfileSim.CompRestrictions)compRest;
            }
            ToDoubleBiFunction<OccProfileSim.OccProp, Unit> getDistrUdoubleValue = (prop, unit) -> (Double)opp.getOccProp(json, rnd, frseed, (String)prop.key, parentProfile, (OccProfileSim.Prop<?>)prop, Double.class, (Unit)unit);
            occ.attractorSuscSeek = (float)getDistrUdoubleValue.applyAsDouble(OccProfileSim.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK, Unit.ONE);
            occ.attractorSuscIdle = (float)getDistrUdoubleValue.applyAsDouble(OccProfileSim.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE, Unit.ONE);
            Object attrFilter = opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_ATTRACTOR_RESTRICTIONS.key, parentProfile, OccProfileSim.PROP_ATTRACTOR_RESTRICTIONS, null);
            if (attrFilter instanceof Number) {
                occ.allowedAttractors = attrFilterMap.get(((Number)attrFilter).intValue());
            } else if (attrFilter instanceof Predicate) {
                occ.allowedAttractors = (Predicate)attrFilter;
            }
            double elevatorWaitTime = (Double)opp.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_ELEVATOR_WAIT_TIME.key, parentProfile, OccProfileSim.PROP_ELEVATOR_WAIT_TIME, Double.class);
            occ.elevatorWaitTime = new OccProfileSim.ElevatorWaitTime(elevatorWaitTime);
            fundamental = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_FUNDAMENTAL.key));
            if (fundamental == null) {
                fundamental = parentProfile.getProperty(OccProfileSim.PROP_FUNDAMENTAL);
            }
            if ((stairFracUp = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_STAIR_SPEED_UP.key))) == null) {
                stairFracUp = parentProfile.getProperty(OccProfileSim.PROP_STAIR_SPEED_UP);
            }
            if ((stairFundUp = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_STAIR_FUNDAMENTAL_UP.key))) == null) {
                stairFundUp = parentProfile.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_UP).apply(parentProfile);
            }
            if ((stairFracDown = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_STAIR_SPEED_DOWN.key))) == null) {
                stairFracDown = parentProfile.getProperty(OccProfileSim.PROP_STAIR_SPEED_DOWN);
            }
            if ((stairFundDown = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_STAIR_FUNDAMENTAL_DOWN.key))) == null) {
                stairFundDown = parentProfile.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_DOWN).apply(parentProfile);
            }
            if ((rampFracUp = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_RAMP_SPEED_UP.key))) == null) {
                rampFracUp = parentProfile.getProperty(OccProfileSim.PROP_RAMP_SPEED_UP);
            }
            if ((rampFundUp = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_RAMP_FUNDAMENTAL_UP.key))) == null) {
                rampFundUp = parentProfile.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_UP).apply(parentProfile);
            }
            if ((rampFracDown = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_RAMP_SPEED_DOWN.key))) == null) {
                rampFracDown = parentProfile.getProperty(OccProfileSim.PROP_RAMP_SPEED_DOWN);
            }
            if ((rampFundDown = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_RAMP_FUNDAMENTAL_DOWN.key))) == null) {
                rampFundDown = parentProfile.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_DOWN).apply(parentProfile);
            }
            if ((orientString = (String)json.get((String)OccProfileSim.PROP_INIT_ORIENT.key)) != null) {
                st = new StringTokenizer(orientString, " ");
                occ.orient = new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
            } else {
                double angleRad = ((UnitDouble)parentProfile.getDistVal(OccProfileSim.PROP_INIT_ORIENT, rnd, orientSeed)).getValue(SI.RADIAN);
                Vector3d orient = new Vector3d(1.0, 0.0, 0.0);
                Inter.rotateTuple2D(orient, (float)angleRad, new Point3d(0.0, 0.0, 0.0));
                occ.orient = orient;
            }
            if (stairFundUp == null) {
                stairFundUp = fundamental;
            }
            if (stairFundDown == null) {
                stairFundDown = fundamental;
            }
            if (rampFundUp == null) {
                rampFundUp = fundamental;
            }
            if (rampFundDown == null) {
                rampFundDown = fundamental;
            }
            occ.fundamental = fundamental;
            occ.stairSpeed = this.finalizeSlopeSpeed(new SlopeSpeed(stairFracUp, stairFundUp, stairFracDown, stairFundDown));
            occ.rampSpeed = this.finalizeSlopeSpeed(new SlopeSpeed(rampFracUp, rampFundUp, rampFracDown, rampFundDown));
            if (Double.isNaN(priority)) {
                priority = OccPriority.init(0, priorityGen.nextDouble());
            }
            occ.priority = priority;
            Function<Object, Object> tagsFromJson = obj -> {
                if (obj instanceof Set) {
                    return obj;
                }
                if (obj instanceof JSONArray) {
                    return this.setFromJsonArray(i -> new LinkedIdentityHashSet(i), (JSONArray)obj, t -> tags.getTag(t.toString()));
                }
                return Collections.emptySet();
            };
            Set occTags = (Set)opp.getOccProp(json.get(OccProfileSim.PROP_TAGS.key), rnd, (long)rseed, parentProfile, OccProfileSim.PROP_TAGS, tagsFromJson, Unit.ONE);
            tags.commitToKb(kb);
            kb.replaceClearableTags(occ, occTags);
            Function<OccProfileSim.Prop, Set> parseAnimTags = prop -> {
                Object ret = json.get(prop.key.toString());
                return (Set)opp.getOccProp(ret, rnd, frseed, parentProfile, (OccProfileSim.Prop)prop, jval -> {
                    if (jval instanceof Set) {
                        return (Set)jval;
                    }
                    if (jval instanceof JSONArray) {
                        return this.setFromJsonArray(i -> new LinkedHashSet(i), (JSONArray)jval, jcomp -> jcomp.toString());
                    }
                    return jval;
                }, Unit.ONE);
            };
            occ.animTagsIdling = parseAnimTags.apply(OccProfileSim.PROP_ANIMS_IDLE);
            occ.animTagsMoving = parseAnimTags.apply(OccProfileSim.PROP_ANIMS_MOVING);
            return occ;
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    private IFunction1d safeGetFunc(List<IFunction1d> functions, Object index) {
        if (index == null) {
            return null;
        }
        return functions.get((int)((Long)index).longValue());
    }

    private SlopeSpeed finalizeSlopeSpeed(SlopeSpeed speed) {
        return this.finalizePoolItem(this.d_slopeSpeedPool, speed);
    }

    private Color3b finalizeColor(Color3b color) {
        return this.finalizePoolItem(this.d_colorPool, color);
    }

    private <T> T finalizePoolItem(Map<T, T> pool, T item) {
        T eitem = pool.putIfAbsent(item, item);
        return eitem != null ? eitem : item;
    }

    private static byte parseColorComp(String val) {
        float fval = Float.parseFloat(val);
        return (byte)(fval * 255.0f);
    }

    public Point3d parseVert(String line) {
        String[] tokens = SimpleParser.getTokens(line, true);
        return new Point3d(Double.parseDouble(tokens[0]), Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2]));
    }

    public boolean parseMeshTri(MeshBuilder mb, String line) {
        String[] tokens = SimpleParser.getTokens(line, true);
        String strNode = tokens[0];
        String type = tokens[1];
        Tri.Terrain terrain = null;
        if (type.equalsIgnoreCase("open")) {
            terrain = Tri.Terrain.OPEN;
        } else if (type.equalsIgnoreCase("stair")) {
            terrain = Tri.Terrain.STAIR;
        } else if (type.equalsIgnoreCase("ramp")) {
            terrain = Tri.Terrain.RAMP;
        }
        int iv1 = Integer.parseInt(tokens[2]);
        int iv2 = Integer.parseInt(tokens[3]);
        int iv3 = Integer.parseInt(tokens[4]);
        int nodeIx = Integer.parseInt(strNode);
        ANode node = this.d_kb.getNodes().get(nodeIx);
        MeshBuilder.MTri mtri = mb.addTri(node, terrain, iv1, iv2, iv3, null);
        if (mtri != null) {
            this.d_triFileOrder.put(this.d_triFileOrder.size(), mtri);
            return true;
        }
        System.err.printf("[SimpleParser.parseMeshTri()] unable to add triangle %s%n", this.d_triFileOrder.size());
        return false;
    }

    private Point3d parsePoint3d(TokenIterator tokens) throws IOException {
        return new Point3d(tokens.nextDouble(), tokens.nextDouble(), tokens.nextDouble());
    }

    private Vector3d parseVector3d(TokenIterator tokens) throws IOException {
        return new Vector3d(tokens.nextDouble(), tokens.nextDouble(), tokens.nextDouble());
    }

    private Point2d parsePoint2d(TokenIterator tokens) throws IOException {
        return new Point2d(tokens.nextDouble(), tokens.nextDouble());
    }

    private Vector2d parseVector2d(TokenIterator tokens) throws IOException {
        return new Vector2d(tokens.nextDouble(), tokens.nextDouble());
    }

    private double[] parseDoubles(TokenIterator tokens, int count) throws IOException {
        double[] result = new double[count];
        for (int m = 0; m < count; ++m) {
            result[m] = tokens.nextDouble();
        }
        return result;
    }

    private static Point3d parsePoint3d(String str) {
        return SimpleParser.parsePoint3d(str, "() ,");
    }

    private static Point3d parsePoint3d(String str, String delimiters) {
        List<String> tokens = CSVLineParser.parse(str, delimiters, "");
        return new Point3d(Double.parseDouble(tokens.get(0)), Double.parseDouble(tokens.get(1)), Double.parseDouble(tokens.get(2)));
    }

    private static Vector3d parseVector3d(String str, String delimiters) {
        List<String> tokens = CSVLineParser.parse(str, delimiters, "");
        return new Vector3d(Double.parseDouble(tokens.get(0)), Double.parseDouble(tokens.get(1)), Double.parseDouble(tokens.get(2)));
    }

    private static void throwexc(String format, Object ... args) throws IOException {
        throw new IOException(String.format(format, args));
    }

    private Collection<ANode> parseNodeList(String str) {
        if (str.equalsIgnoreCase("nearest") || str.equalsIgnoreCase("any")) {
            return null;
        }
        List<String> tokens = CSVLineParser.parse(str, "() ,", "");
        ArrayDeque<ANode> allowedExits = new ArrayDeque<ANode>();
        for (String node : tokens) {
            int ixGoal = Integer.parseInt(node);
            ANode exit = this.d_kb.getNodes().get(ixGoal);
            allowedExits.add(exit);
        }
        return Collections.unmodifiableCollection(allowedExits);
    }

    private static String format(Point3d p) {
        return String.format("(%.2f, %.2f, %.2f)", p.x, p.y, p.z);
    }

    private static Set<Tag> getTags(String tagStr, TagGenerator tagGen, boolean predefAllowed) throws IOException {
        if (tagStr.startsWith("(") && tagStr.endsWith(")")) {
            tagStr = tagStr.substring(1, tagStr.length() - 1);
        }
        TokenIterator tagToks = new TokenIterator(CSVLineParser.parse(new ArrayList<String>(), tagStr, " ,", "\"\"()", null, Character.valueOf('\\'), 0));
        LinkedHashSet tags = new LinkedHashSet();
        while (tagToks.hasMore()) {
            String stag = tagToks.next();
            Tag tag = tagGen.getTag(stag);
            if (tag.isPredefined() && !predefAllowed) {
                SimpleParser.throwexc("May not used pre-defined tag: %s", tag.name);
            }
            tags.add(tag);
        }
        return tags.isEmpty() ? Collections.emptySet() : tags;
    }

    private IGoal parseGoal(String goalStr, ParseGoalInfo pgi, List<IGoal> currGoals) throws IOException {
        TokenIterator toks = new TokenIterator(CSVLineParser.parse(new ArrayList<String>(), goalStr, " ,", "()\"\"", null, Character.valueOf('\\'), 3));
        Supplier<WaitMode> parseWaitMode = () -> {
            String tok;
            if (toks.hasMore() && (tok = toks.curr()).equalsIgnoreCase("mode")) {
                toks.next();
                String modeStr = toks.next().toUpperCase();
                return WaitMode.valueOf(modeStr);
            }
            return WaitMode.AVOID;
        };
        String tok = toks.next();
        switch (tok.toUpperCase()) {
            case "GOTO": {
                tok = toks.next();
                switch (tok.toUpperCase()) {
                    case "POINT": {
                        Point3d pt = SimpleParser.parsePoint3d(toks.next());
                        double r = toks.nextDouble();
                        Tri tri = this.d_kb.getMesh().getTri(pt);
                        if (tri == null) {
                            SimpleParser.throwexc(Intl.intl("GOTO POINT, %s, is not located on navigation mesh."), SimpleParser.format(pt));
                        }
                        return new PointGoal(new TriPoint(tri, pt), r);
                    }
                    case "OCCUPANT": {
                        int occId = toks.nextInt();
                        double r = toks.nextDouble();
                        return new DynamicTargetGoal(new ITargetPtSupplier.OccSupplier(occId), DynamicTargetGoal.Tracking.DYNAMIC_ONCE, r, DynamicTargetGoal.TargetNotFound.WAIT, DynamicTargetGoal.TargetUnreachable.WAIT);
                    }
                    case "EXIT": {
                        Collection<ANode> nodes = this.parseNodeList(toks);
                        return new ExitGoal(nodes);
                    }
                    case "ROOM": {
                        Collection<ANode> rooms = this.parseNodeList(toks);
                        return new RoomGoal(rooms);
                    }
                    case "ELEVATOR": {
                        IGoal elevGoal = ElevatorParserTxt.parseElevatorGoal(this.d_kb.getElevatorModel(), toks.tokens);
                        return elevGoal;
                    }
                    case "QUEUE": {
                        int qIx = Integer.parseInt(toks.next());
                        QMetaQueue q = qIx >= this.d_kb.getBaseQueueSize() ? this.d_kb.getMetaQueues().get(qIx - this.d_kb.getBaseQueueSize()) : (QMetaQueue)this.d_kb.getBaseQueues().get(qIx);
                        QueueGoal sg = new QueueGoal(q);
                        return sg;
                    }
                    case "OCCTARGETS": {
                        OccTargetGoal.DistancePref distPref = OccTargetGoal.DistancePref.valueOf(toks.next());
                        OccTargetGoal.PriorityPref priorityPref = OccTargetGoal.PriorityPref.valueOf(toks.next());
                        LinkedIdentityHashSet<OccTarget> locs = new LinkedIdentityHashSet();
                        while (toks.hasMore()) {
                            locs.add(pgi.occTargets.get(toks.nextInt()));
                        }
                        if (locs.isEmpty()) {
                            locs = Collections.emptySet();
                        }
                        return new OccTargetGoal(locs, distPref, priorityPref);
                    }
                    case "DYNAMIC_TARGET": {
                        JSONObject jobj = SimpleParser.nextTokAsJsonObj(toks);
                        return DynamicTargetGoal.fromJson(this.d_kb, jobj, pgi.tags::getTag);
                    }
                }
                Collection<ANode> nodes = this.parseNodeList(tok);
                return new ExitGoal(nodes);
            }
            case "WAIT": {
                WaitMode mode = parseWaitMode.get();
                tok = toks.curr();
                if (tok.equalsIgnoreCase("POINT")) {
                    toks.next();
                    toks.next();
                }
                if (tok.equalsIgnoreCase("CURVE")) {
                    toks.next();
                    return new WaitGoal(mode, (IDistributedVal)pgi.distributions.get(toks.nextInt()));
                }
                if (toks.getRemaining() >= 2) {
                    toks.next();
                }
                double t = toks.nextDouble();
                return new WaitGoal(mode, t);
            }
            case "WAIT_UNTIL": {
                String type = toks.next();
                WaitMode mode = parseWaitMode.get();
                if (type.equalsIgnoreCase(IEventTime.InputFileInfo.SIMPLE.key)) {
                    IDistributedVal waitCurve = (IDistributedVal)pgi.distributions.get(toks.nextInt());
                    return new WaitUntilGoal(mode, new IEventTime.SimpleEventTime(waitCurve));
                }
                if (type.equalsIgnoreCase(IEventTime.InputFileInfo.CYCLE.key)) {
                    IDistributedVal firstWait = (IDistributedVal)pgi.distributions.get(toks.nextInt());
                    IDistributedVal interval = (IDistributedVal)pgi.distributions.get(toks.nextInt());
                    return new WaitUntilGoal(mode, new IEventTime.CycledEventTime(firstWait, interval));
                }
                if (type.equalsIgnoreCase(IEventTime.InputFileInfo.LIST.key)) {
                    ArrayList<ICurve> curves = new ArrayList<ICurve>();
                    String next = toks.next();
                    Integer nextInt = Integer.parseInt(next);
                    while (nextInt != null || toks.hasMore()) {
                        int ixCurve = nextInt != null ? nextInt.intValue() : toks.nextInt();
                        nextInt = null;
                        ICurve curve = (ICurve)pgi.distributions.get(ixCurve);
                        curves.add(curve);
                    }
                    return new WaitUntilGoal(mode, new IEventTime.ListedEventTime(curves));
                }
            }
            case "WAIT_INTERVAL": {
                double t = toks.nextDouble();
                return new WaitIntervalGoal(t);
            }
            case "WAIT_UNTIL_INSIDE": {
                ArrayList<ANode> rooms = new ArrayList<ANode>();
                while (toks.hasMore()) {
                    int ixNode = toks.nextInt();
                    ANode room = this.d_kb.getNodes().get(ixNode);
                    rooms.add(room);
                }
                return new WaitUntilInsideGoal(rooms);
            }
            case "TAG": {
                String tagStr = toks.next();
                Set<Tag> tags = SimpleParser.getTags(tagStr, pgi.tags, true);
                return new ChangeTagGoal(ChangeTagGoal.Op.TAG, tags);
            }
            case "UNTAG": {
                String tagStr = toks.next();
                Set<Tag> tags = SimpleParser.getTags(tagStr, pgi.tags, true);
                return new ChangeTagGoal(ChangeTagGoal.Op.UNTAG, tags);
            }
            case "SET_TAG": {
                String tagStr = toks.next();
                Set<Tag> tags = SimpleParser.getTags(tagStr, pgi.tags, true);
                return new SetTagGoal(tags);
            }
            case "WAIT_UNTIL_ALL_TAGGED": {
                WaitMode mode = parseWaitMode.get();
                String tagStr = toks.next();
                Set<Tag> tags = SimpleParser.getTags(tagStr, pgi.tags, true);
                if (tags.isEmpty()) {
                    throw new IOException("No tags specified");
                }
                Predicate<Tag> tagFilter = Filters.accept(tags);
                return new WaitUntilTaggedGoal(mode, Predicates.alwaysTrue(), Predicates.alwaysTrue(), tagFilter);
            }
            case "WAIT_UNTIL_END": {
                WaitMode mode = parseWaitMode.get();
                return new WaitUntilEndGoal(mode);
            }
            case "WAIT_COUNTER": {
                WaitMode mode = parseWaitMode.get();
                Counter counter = pgi.counters.get(toks.nextInt());
                String op = toks.next();
                double rval = toks.nextDouble();
                ComparePredicate condition = new ComparePredicate(switch (op) {
                    case "<" -> ComparePredicate.Type.LESS;
                    case "<=" -> ComparePredicate.Type.LEQUAL;
                    case ">" -> ComparePredicate.Type.GREATER;
                    case ">=" -> ComparePredicate.Type.GEQUAL;
                    case "==" -> ComparePredicate.Type.EQUAL;
                    default -> throw new IOException(String.format("Unknown counter condition: %s", op));
                }, BigDecimal.valueOf(rval));
                return new WaitForCounterGoal(mode, counter, condition);
            }
            case "CHANGE_COUNTER": {
                Counter counter = pgi.counters.get(toks.nextInt());
                String op = toks.next();
                double rval = toks.nextDouble();
                return new ChangeCounterGoal(counter, new BigDecimalOp(switch (op.toLowerCase()) {
                    case "+", "add" -> BigDecimalOp.Type.ADD;
                    case "-", "sub", "subtract" -> BigDecimalOp.Type.SUBTRACT;
                    case "*", "mul", "multiply" -> BigDecimalOp.Type.MULTIPLY;
                    case "/", "div", "divide" -> BigDecimalOp.Type.DIVIDE;
                    default -> throw new IOException(String.format("Unknown counter op: %s", op));
                }, BigDecimal.valueOf(rval)));
            }
            case "SET_PROP": {
                String name = toks.next();
                IPropertySet.Prop<?> prop = OccProfileSim.PROP_TYPES_MAP.get(name);
                if (prop == null) {
                    throw new IOException(String.format("Unknown profile property: %s", name));
                }
                if (!(prop instanceof OccProfileSim.IOccProp) || !((OccProfileSim.IOccProp)((Object)prop)).canApply()) {
                    SimpleParser.throwexc("Profile property cannot be changed: %s", name);
                }
                JSONObject jobj = SimpleParser.nextTokAsJsonObj(toks);
                Object jsonVal = jobj.get("val");
                Object val = this.parseProfileProp(prop, jsonVal, pgi);
                return new SetOccPropGoal<Object>((OccProfileSim.IOccProp)((Object)prop), val);
            }
            case "SET_PROP_TO_PROFILE": {
                String name = toks.next();
                IPropertySet.Prop<?> prop = OccProfileSim.PROP_TYPES_MAP.get(name);
                if (prop == null) {
                    throw new IOException(String.format("Unknown profile property: %s", name));
                }
                if (!(prop instanceof OccProfileSim.IOccProp) || !((OccProfileSim.IOccProp)((Object)prop)).canApply()) {
                    SimpleParser.throwexc("Profile property cannot be changed: %s", name);
                }
                return new SetOccPropToProfileGoal((OccProfileSim.IOccProp)((Object)prop));
            }
            case "DETACH_ASSISTANTS": {
                Collection prevTeams = Util.reverseStream(currGoals).filter(g -> g instanceof WaitForAssistanceGoal).map(g -> ((WaitForAssistanceGoal)g).teams).findFirst().orElse(Collections.emptySet());
                if (prevTeams.isEmpty()) {
                    return DetachGoal.DETACH_ALL;
                }
                return new DetachGoal(prevTeams);
            }
            case "ASSIST": {
                int teamId = toks.nextInt();
                AssistedEvacTeam team = pgi.teams.get(teamId);
                return new AssistOccupantsGoal(team);
            }
            case "GET_ASSISTANCE": {
                WaitMode waitMode = parseWaitMode.get();
                ArrayList<AssistedEvacTeam> teams = new ArrayList<AssistedEvacTeam>();
                while (toks.hasMore()) {
                    teams.add(pgi.teams.get(toks.nextInt()));
                }
                return new WaitForAssistanceGoal(waitMode, theUtil.toArray(teams, AssistedEvacTeam.class));
            }
            case "FILL_ROOM": {
                return FillRoomGoal.ALWAYS;
            }
            case "FILL_ROOM_IF_NECESSARY": {
                return FillRoomGoal.ONLY_IF_NECESSARY;
            }
            case "JOIN_GROUP": {
                int groupId = toks.nextInt();
                OccGroup group = pgi.groups.get(groupId);
                return new JoinOccGroupGoal(group);
            }
            case "JOIN_GROUP_TYPE": {
                int groupTypeId = toks.nextInt();
                OccGroupType groupType = pgi.groupTypes.get(groupTypeId);
                return new JoinOccGroupGoal(groupType);
            }
            case "CHANGE_BEHAVIOR": {
                int urnId = toks.nextInt();
                ChangeBehaviorGoal changeBehaviorGoal = new ChangeBehaviorGoal(SimpleParser.toObjectUrn((IUrn)pgi.distributions.get(urnId), pgi.behaviors));
                return changeBehaviorGoal;
            }
            case "CHANGE_PROFILE": {
                int urnId = toks.nextInt();
                ChangeProfileGoal changeProfileGoal = new ChangeProfileGoal(ChangeProfileGoal.UI_PROP_FILTER, SimpleParser.toObjectUrn((IUrn)pgi.distributions.get(urnId), pgi.profiles));
                return changeProfileGoal;
            }
            case "CREATE_ATTRACTOR": {
                CreateAttractorGoal.LocationMode locationMode = CreateAttractorGoal.LocationMode.valueOf(toks.next());
                TriPoint fixedLocation = null;
                if (locationMode == CreateAttractorGoal.LocationMode.FIXED_LOCATION) {
                    Point3d location = SimpleParser.parsePoint3d(toks.next());
                    Tri tri = this.d_kb.getMesh().getTri(location);
                    if (tri == null) {
                        SimpleParser.throwexc(Intl.intl("GOTO POINT, %s, is not located on navigation mesh."), SimpleParser.format(location));
                    }
                    fixedLocation = new TriPoint(tri, location);
                }
                ArrayList<AttractorSim> attractors = new ArrayList<AttractorSim>();
                while (toks.hasMore()) {
                    attractors.add(pgi.attractors.get(toks.nextInt()));
                }
                return new CreateAttractorGoal(attractors, locationMode, fixedLocation);
            }
            case "DESTROY_ATTRACTOR": {
                ArrayList<AttractorSim> attractors = new ArrayList<AttractorSim>();
                while (toks.hasMore()) {
                    attractors.add(pgi.attractors.get(toks.nextInt()));
                }
                return new DestroyAttractorGoal(attractors);
            }
            case "LOOK_AT": {
                JSONObject jobj = SimpleParser.nextTokAsJsonObj(toks);
                return LookAtGoal.fromJson(jobj, pgi.tags::getTag);
            }
            case "LOOK_AHEAD": {
                return new LookAheadGoal();
            }
            case "REMOVE_SELF": {
                return RemoveSelfGoal.INSTANCE;
            }
            case "ABANDON_OCC_LOCS": {
                String whichStr = toks.next();
                AbandonOccTargetsGoal.Which which = AbandonOccTargetsGoal.Which.valueOf(whichStr);
                return new AbandonOccTargetsGoal(which);
            }
        }
        throw new IOException(String.format("Unknown goal: %s", tok));
    }

    private static JSONObject nextTokAsJsonObj(TokenIterator toks) throws IOException {
        String sval = toks.next();
        if (sval.startsWith("\"") && sval.endsWith("\"")) {
            sval = sval.substring(1, sval.length() - 1);
        }
        JSONParser jsonParser = new JSONParser();
        try {
            return (JSONObject)jsonParser.parse(sval);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    private static <T, CollT extends Collection<T>> CollT fromJsonArray(JSONArray arr, Class<CollT> resultType, Function<Object, T> fromJson) throws IOException {
        try {
            Collection result = (Collection)resultType.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Object obj : arr) {
                result.add(fromJson.apply(obj));
            }
            return (CollT)result;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private Collection<ANode> parseNodeList(TokenIterator toks) {
        String next = toks.next();
        if (next.equalsIgnoreCase("nearest") || next.equalsIgnoreCase("any")) {
            return null;
        }
        Integer nextInt = Integer.parseInt(next);
        ArrayList<ANode> nodes = new ArrayList<ANode>();
        while (nextInt != null || toks.hasMore()) {
            int ixNode = nextInt != null ? nextInt.intValue() : toks.nextInt();
            nextInt = null;
            ANode node = this.d_kb.getNodes().get(ixNode);
            nodes.add(node);
        }
        return nodes;
    }

    public Pair<BehaviorSim, String[]> parseBehavior(String line) throws IOException {
        try {
            String[] tokens = SimpleParser.getTokens(line, "", true, true, true);
            JSONParser jsonp = new JSONParser();
            JSONObject json = (JSONObject)jsonp.parse(tokens[0]);
            String name = (String)json.get("name");
            String script = (String)json.get("script");
            Color color = SimpleParser.parseJSONColor(json.get("color"));
            String[] scriptTokens = SimpleParser.getTokens(script, ";", false, true, true);
            return new Pair<BehaviorSim, String[]>(new BehaviorSim(name, color, Collections.emptyList()), scriptTokens);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Tag parseTag(String line) throws IOException {
        JSONObject json = SimpleParser.getJsonLine(line, true);
        Object options = Tag.NO_OPTIONS;
        for (Tag.Options option : Tag.Options.values()) {
            boolean present = json.getOrDefault(option.name().toLowerCase(), false);
            if (!present) continue;
            if (options == Tag.NO_OPTIONS) {
                options = ((EnumSet)options).clone();
            }
            ((AbstractCollection)options).add((Tag.Options)option);
        }
        Tag tag = new Tag((String)json.get("name"), (String)json.get("desc"), (EnumSet<Tag.Options>)options);
        return tag;
    }

    public OccProfileSim parseProfile(String line, ParseProfileInfo ppi) throws IOException {
        JSONObject json = SimpleParser.getJsonLine(line, true);
        OccProfileSim occProfile = new OccProfileSim();
        Map<Object, IPropertySet.Prop<?>> allProps = OccProfileSim.PROP_TYPES_MAP;
        for (Map.Entry<Object, IPropertySet.Prop<?>> entry : allProps.entrySet()) {
            Object prop = json.get(entry.getKey());
            if (prop == null) continue;
            Object val = this.parseProfileProp(entry.getValue(), prop, ppi);
            occProfile.setProperty((Object)entry.getValue(), val);
        }
        return occProfile;
    }

    private static Point3f parseJSONColorP3f(Object jsonVal) {
        if (jsonVal instanceof String) {
            StringTokenizer st = new StringTokenizer((String)jsonVal, "(), ");
            return new Point3f(Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()));
        }
        if (jsonVal instanceof JSONArray) {
            JSONArray arr = (JSONArray)jsonVal;
            Double r = (Double)arr.get(0);
            Double g = (Double)arr.get(1);
            Double b = (Double)arr.get(2);
            return new Point3f(r.floatValue(), g.floatValue(), b.floatValue());
        }
        assert (jsonVal == null);
        return null;
    }

    private static Color parseJSONColor(Object jsonVal) {
        if (jsonVal == null) {
            return null;
        }
        if (jsonVal instanceof String) {
            StringTokenizer st = new StringTokenizer((String)jsonVal, " ");
            return new Color(Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()));
        }
        if (jsonVal instanceof JSONArray) {
            JSONArray color = (JSONArray)jsonVal;
            Double r = (Double)color.get(0);
            Double g = (Double)color.get(1);
            Double b = (Double)color.get(2);
            Double a = (Double)color.get(3);
            return new Color(r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue());
        }
        assert (false);
        return null;
    }

    private Object parseProfileProp(IPropertySet.Prop<?> prop, Object jsonVal, ParseProfileInfo ppi) {
        if (prop == OccProfileSim.PROP_COLOR) {
            return SimpleParser.parseJSONColorP3f(jsonVal);
        }
        if (prop == OccProfileSim.PROP_TAGS) {
            long propL = (Long)jsonVal;
            if (this.d_version >= 16) {
                return (IUrn)ppi.distributions.get((int)propL);
            }
            IUrn strUrn = (IUrn)ppi.distributions.get((int)propL);
            LinkedIdentityHashMap<Set<Object>, Double> tagWeights = new LinkedIdentityHashMap<Set<Object>, Double>();
            for (Map.Entry entry : strUrn.getWeights().entrySet()) {
                Set<Object> tags = new LinkedIdentityHashSet();
                for (String str : ((String)entry.getKey()).split(" ")) {
                    if ((str = str.trim()).isEmpty()) continue;
                    tags.add(ppi.tags.getTag(str));
                }
                if (tags.isEmpty()) {
                    tags = Collections.emptySet();
                } else if (tags.size() == 1) {
                    tags = Collections.singleton((Tag)tags.iterator().next());
                }
                tagWeights.put(tags, entry.getValue());
            }
            if (tagWeights.isEmpty()) {
                return new Urn<Object>(new Object[0]);
            }
            if (tagWeights.size() == 1) {
                return new Urn<Set>((Collection<Set>)Collections.singleton((Set)tagWeights.keySet().iterator().next()));
            }
            return new InfiniteUrn(tagWeights);
        }
        if (jsonVal instanceof String && prop instanceof OccProfileSim.NullableProp && "null".equals(jsonVal)) {
            return ((OccProfileSim.NullableProp)prop).nullValue;
        }
        if (jsonVal instanceof String) {
            return jsonVal;
        }
        if (jsonVal instanceof Double) {
            return jsonVal;
        }
        if (jsonVal instanceof Boolean) {
            return jsonVal;
        }
        if (prop instanceof IFunction1d || prop instanceof OccProfileSim.Function1dProp) {
            long propL = (Long)jsonVal;
            return ppi.functions.get((int)propL);
        }
        if (prop instanceof OccProfileSim.ProfileFunctionProp) {
            long propL = (Long)jsonVal;
            return new OccProfileSim.ConstProfileFunction(ppi.functions.get((int)propL));
        }
        if (prop instanceof OccProfileSim.Prop && ((OccProfileSim.Prop)prop).isAssignableTo(IDistributedVal.class)) {
            long propL = (Long)jsonVal;
            return ppi.distributions.get((int)propL);
        }
        if (prop instanceof OccProfileSim.UnitDoubleOccProp) {
            double propD = (Double)jsonVal;
            return new UnitDouble(propD, ((OccProfileSim.UnitDoubleOccProp)prop).defaultUnit);
        }
        if (prop instanceof OccProfileSim.Prop && ((OccProfileSim.Prop)prop).isAssignableTo(OccProfileSim.IShapeGen.class)) {
            if (jsonVal != null) {
                long propL = (Long)jsonVal;
                return ppi.occShapes.get((int)propL);
            }
        } else if (prop.equals(OccProfileSim.PROP_SPACING)) {
            try {
                OccProfileSim.Spacing spacing = SimpleParser.parseSpacingCurve(jsonVal.toString());
                return spacing;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (prop.equals(OccProfileSim.PROP_SPEED_IN_SMOKE)) {
                return SimpleParser.parseSpeedInSmokeJson(jsonVal, ppi.functions);
            }
            if (prop.equals(OccProfileSim.PROP_RESTRICTED_COMPONENTS)) {
                return ppi.compRestrictionsMap.get((int)((Long)jsonVal).longValue());
            }
            if (prop.equals(OccProfileSim.PROP_ATTRACTOR_RESTRICTIONS)) {
                return ppi.attrFiltersMap.get((int)((Long)jsonVal).longValue());
            }
            if (prop.equals(OccProfileSim.PROP_SOCIAL_DIST_FILTER)) {
                try {
                    JSONObject jobj = (JSONObject)jsonVal;
                    Function<String, Tag> toTag = ppi.tags::getTag;
                    return IOccFilter.InputFileInfo.findType((JSONObject)jobj).fromJson.get(jobj, toTag);
                }
                catch (IOException e) {
                    TeciLogging.log(LOGGER, Level.SEVERE, (Throwable)e);
                }
            }
        }
        return prop.defVal;
    }

    private static OccProfileSim.Spacing parseSpacingCurve(String line) throws IOException {
        try {
            JSONObject json = SimpleParser.getJsonLine(line, false);
            OccProfileSim.SpacingType spacingType = OccProfileSim.SpacingType.valueOf((String)json.get("type"));
            String curveString = json.get("val").toString();
            ICurve curve = SimpleParser.parseCurve(curveString, false);
            return new OccProfileSim.Spacing(spacingType, curve);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SpeedInSmokeSim parseSpeedInSmokeJson(Object jsonVal, List<IFunction1d> functions) {
        if (jsonVal instanceof JSONObject) {
            JSONObject json = (JSONObject)jsonVal;
            SpeedInSmoke.Mode mode = json.containsKey("mode") ? SpeedInSmoke.Mode.valueOf((String)json.get("mode")) : SpeedInSmokeSim.DEFAULT.mode;
            UnitDouble customFuncVisThreshold = json.containsKey("customFuncVisThreshold") ? new UnitDouble((Double)json.get("customFuncVisThreshold"), SI.METER) : SpeedInSmokeSim.DEFAULT.customFuncVisThreshold;
            SpeedInSmoke.FuncType customFuncVisType = json.containsKey("customFuncVisType") ? SpeedInSmoke.FuncType.valueOf((String)json.get("customFuncVisType")) : SpeedInSmokeSim.DEFAULT.customFuncVisType;
            IFunction1d customFuncVis = json.containsKey("customFuncVis") ? functions.get(((Long)json.get("customFuncVis")).intValue()) : SpeedInSmokeSim.DEFAULT.customFuncVis;
            return new SpeedInSmokeSim(mode, customFuncVisThreshold, customFuncVisType, customFuncVis);
        }
        throw new IllegalArgumentException(jsonVal.getClass().getName());
    }

    private IUrn<?> parseOrderedUrn(TagGenerator tags, String line, boolean hasHeader) throws IOException {
        JSONObject json = SimpleParser.getJsonLine(line, hasHeader);
        JSONArray array = (JSONArray)json.get("urn");
        String type = (String)json.get("type");
        String subType = (String)json.get("subType");
        return this.parseOrderedUrn(tags, array, type, subType);
    }

    private IUrn<?> parseOrderedUrn(TagGenerator tags, JSONArray jsonArray, String type, String subType) throws IOException {
        if (this.d_version < 16) {
            return SimpleParser.parseOrderedUrnPre0016(jsonArray, type);
        }
        if (jsonArray.size() == 0) {
            return null;
        }
        switch (type) {
            case "int": {
                return SimpleParser.toOrderedUrn(jsonArray, jval -> JsonUtil.asNum(jval).intValue());
            }
            case "bool": {
                return SimpleParser.toOrderedUrn(jsonArray, jval -> (Boolean)jval);
            }
            case "string": {
                return SimpleParser.toOrderedUrn(jsonArray, jval -> jval.toString());
            }
            case "ud": {
                try {
                    return SimpleParser.toOrderedUrn(jsonArray, jval -> {
                        try {
                            return Global.parseUnitDouble(jval.toString(), null, Locale.US);
                        }
                        catch (java.text.ParseException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (RuntimeException e) {
                    if (e.getCause() != null) {
                        throw new IOException(e.getCause());
                    }
                    throw new IOException(e);
                }
            }
            case "enum": {
                assert (subType != null);
                if (subType == null) {
                    throw new IOException(String.format(Intl.intl("%s requires a subType"), type));
                }
                try {
                    Class<?> clazz = Class.forName(subType);
                    if (!clazz.isEnum()) {
                        throw new IOException(String.format(Intl.intl("%s is not an enum class."), subType));
                    }
                    return SimpleParser.toOrderedUrn(jsonArray, jval -> Enum.valueOf(clazz, jval.toString()));
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
            case "set": {
                if (subType == null) {
                    assert (jsonArray.size() == 1);
                    LinkedHashMap setMap = new LinkedHashMap();
                    setMap.put(Collections.emptySet(), 1.0);
                    return UrnUtil.newUrn(setMap);
                }
                switch (subType) {
                    case "string": {
                        return SimpleParser.toOrderedUrn(jsonArray, jval -> this.setFromJsonArray(n -> new LinkedHashSet(n), (JSONArray)jval, v -> v.toString()));
                    }
                    case "tag": {
                        return SimpleParser.toOrderedUrn(jsonArray, jval -> this.setFromJsonArray(n -> new LinkedIdentityHashSet(n), (JSONArray)jval, v -> tags.getTag(v.toString())));
                    }
                }
                assert (false);
                throw new IOException(String.format("Unknown Urn sub-type: %s", subType));
            }
        }
        assert (false);
        throw new IOException(String.format(Intl.intl("Unknown urn type: %s"), type));
    }

    private static <T> IUrn<T> toOrderedUrn(JSONArray jarray, Function<Object, T> toNativeKey) {
        LinkedHashMap<Object, Double> map = new LinkedHashMap<Object, Double>(jarray.size());
        for (int i = 0; i < jarray.size(); ++i) {
            JSONObject jentry = (JSONObject)jarray.get(i);
            Object jval = jentry.get("val");
            Object key = jval == null ? null : (Object)toNativeKey.apply(jval);
            Double val = JsonUtil.getDouble(jentry, "weight");
            map.put(key, val);
        }
        return UrnUtil.newUrn(map);
    }

    private <T> Set<T> setFromJsonArray(IntFunction<Set<T>> newSet, JSONArray array, Function<Object, T> toNative) {
        if (array.isEmpty()) {
            return Collections.emptySet();
        }
        if (array.size() == 1) {
            return Collections.singleton(toNative.apply(array.get(0)));
        }
        Set result = newSet.apply(array.size());
        for (int m = 0; m < array.size(); ++m) {
            result.add(toNative.apply(array.get(m)));
        }
        return this.d_setPool.computeIfAbsent(result, r -> result);
    }

    private static IUrn<?> parseOrderedUrnPre0016(JSONArray jsonArray, String type) {
        if (jsonArray.size() == 0) {
            return null;
        }
        BiConsumer<JSONArray, Map> fillMap = (array, map) -> {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = (JSONObject)array.get(i);
                assert (obj.keySet().size() == 1);
                String key = (String)obj.keySet().iterator().next();
                Double val = (Double)obj.get(key);
                map.put(key, val);
            }
        };
        BiConsumer<JSONArray, Map> fillIntMap = (array, map) -> {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = (JSONObject)array.get(i);
                assert (obj.keySet().size() == 1);
                String key = (String)obj.keySet().iterator().next();
                Integer ikey = Integer.parseInt(key);
                Double val = (Double)obj.get(key);
                map.put(ikey, val);
            }
        };
        BiConsumer<JSONArray, Map> fillBoolMap = (array, map) -> {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = (JSONObject)array.get(i);
                assert (obj.keySet().size() == 1);
                String key = (String)obj.keySet().iterator().next();
                Boolean bkey = Boolean.parseBoolean(key);
                Double val = (Double)obj.get(key);
                map.put(bkey, val);
            }
        };
        BiConsumer<JSONArray, Map> fillUdMap = (array, map) -> {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = (JSONObject)array.get(i);
                assert (obj.keySet().size() == 1);
                String key = (String)obj.keySet().iterator().next();
                try {
                    UnitDouble udkey = Global.parseUnitDouble(key, null, Locale.US);
                    Double val = (Double)obj.get(key);
                    map.put(udkey, val);
                    continue;
                }
                catch (java.text.ParseException e) {
                    e.printStackTrace();
                }
            }
        };
        LinkedHashMap map2 = null;
        if (type.equals("int")) {
            LinkedHashMap intMap = new LinkedHashMap();
            fillIntMap.accept(jsonArray, intMap);
            map2 = intMap;
        } else if (type.equals("bool")) {
            LinkedHashMap boolMap = new LinkedHashMap();
            fillBoolMap.accept(jsonArray, boolMap);
            map2 = boolMap;
        } else if (type.equals("ud")) {
            LinkedHashMap udMap = new LinkedHashMap();
            fillUdMap.accept(jsonArray, udMap);
            map2 = udMap;
        } else if (type.equals("string")) {
            LinkedHashMap strMap = new LinkedHashMap();
            fillMap.accept(jsonArray, strMap);
            map2 = strMap;
        } else assert (false);
        return UrnUtil.newUrn(map2);
    }

    public void parseBaseQueues(String line, List<IDistributedVal<?>> distributions, List<OccProfileSim> allProfiles) throws IOException {
        SimpleParser.parseBaseQueues(this.d_kb, line, distributions, allProfiles);
    }

    public static QBaseQueue parseBaseQueues(KB kb, String line, List<IDistributedVal<?>> distributions, List<OccProfileSim> allProfiles) throws IOException {
        int colix = line.indexOf(123);
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(line.substring(colix));
            JSONObject json = (JSONObject)obj;
            String name = json.getOrDefault("name", Intl.intl("Queue")).toString();
            Color color = SimpleParser.parseJSONColor(json.get("color"));
            ArrayList<String> qProfs = new ArrayList<String>();
            JSONArray qProfsJSON = (JSONArray)json.get("restrictedProfs");
            if (qProfsJSON == null) {
                for (OccProfileSim p : allProfiles) {
                    qProfs.add(p.getName());
                }
            } else {
                for (OccProfileSim s : qProfsJSON) {
                    qProfs.add(((Object)s).toString());
                }
            }
            String sortType = json.get("sorting").toString();
            QMetaQueue.QBalancingType bType = QMetaQueue.QBalancingType.getTypeForString(sortType);
            String sIx = json.get("sortindex").toString();
            IUrn sUrn = sIx.equals("null") ? null : (sortType == "dist" ? (IUrn)distributions.get(Integer.parseInt(sIx)) : null);
            ArrayList<QServicePoint> services = new ArrayList<QServicePoint>();
            JSONArray serviceObjects = (JSONArray)json.get("services");
            for (Object service : serviceObjects) {
                JSONObject jService = (JSONObject)service;
                String servName = (String)jService.get("name");
                Point3d serviceP3d = SimpleParser.parsePoint3d(jService.get("point").toString());
                TriPoint serviceTP = new TriPoint(kb.getMesh().getTri(serviceP3d), serviceP3d);
                int timeNum = Integer.parseInt(jService.get("distindex").toString());
                QServicePoint qServicePoint = new QServicePoint(servName, serviceTP, distributions.get(timeNum));
                services.add(qServicePoint);
            }
            ArrayList<QPath> queues = new ArrayList<QPath>();
            JSONArray queueObjects = (JSONArray)json.get("paths");
            for (Object queueObj : queueObjects) {
                JSONObject jQueue = (JSONObject)queueObj;
                String pathName = (String)jQueue.get("name");
                ArrayList<String> pointNames = new ArrayList<String>();
                for (Object nodeName : (JSONArray)jQueue.get("pointNames")) {
                    pointNames.add((String)nodeName);
                }
                boolean followPath = (Boolean)jQueue.get("followpath");
                ArrayList<TriPoint> qPoints = new ArrayList<TriPoint>();
                for (Object point : (JSONArray)jQueue.get("points")) {
                    Iterator p = SimpleParser.parsePoint3d(point.toString());
                    Tri tri = kb.getMesh().getTri((Point3d)((Object)p));
                    if (tri == null) {
                        throw new IOException(String.format(Intl.intl("Queue %s does not lie completely on the navigation mesh."), name));
                    }
                    qPoints.add(new TriPoint(tri, (Point3d)((Object)p)));
                }
                ArrayList<String> pathProfs = new ArrayList<String>();
                JSONArray pathProfsJSON = (JSONArray)jQueue.get("restrictedProfs");
                if (pathProfsJSON == null) {
                    for (OccProfileSim p : allProfiles) {
                        pathProfs.add(p.getName());
                    }
                } else {
                    for (Object s : pathProfsJSON) {
                        pathProfs.add(s.toString());
                    }
                }
                QPath occQ = new QPath(pathName, kb, qPoints, pointNames);
                occQ.setForceFollowPath(followPath);
                occQ.setRestrictedProfiles(pathProfs);
                queues.add(occQ);
            }
            QBaseQueue newUnit = new QBaseQueue(name, color, qProfs, services, queues, null, bType, sUrn);
            if (json.containsKey("resultsid")) {
                newUnit.setResultsID(Long.parseLong(json.get("resultsid").toString()));
            }
            kb.addBaseQueue(newUnit);
            return newUnit;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void parseMetaQueues(String line, List<IDistributedVal<?>> distributions) {
        SimpleParser.parseMetaQueues(this.d_kb, line, distributions);
    }

    public static QMetaQueue parseMetaQueues(KB kb, String line, List<IDistributedVal<?>> distributions) {
        int colix = line.indexOf(123);
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(line.substring(colix));
            JSONObject json = (JSONObject)obj;
            QMetaQueue.QBalancingType bType = QMetaQueue.QBalancingType.getTypeForString(json.get("sorting").toString());
            QMetaQueue newMeta = new QMetaQueue(bType, null);
            JSONArray childIndices = (JSONArray)json.get("children");
            int subNum = kb.getBaseQueues().size();
            for (Object child : childIndices) {
                int ix = Integer.parseInt(child.toString());
                if (ix >= subNum) {
                    newMeta.addChild(kb.getMetaQueues().get(ix - subNum));
                    kb.getMetaQueues().get(ix - subNum).setParent(newMeta);
                    continue;
                }
                newMeta.addChild(kb.getBaseQueues().get(ix));
                kb.getBaseQueues().get(ix).setParent(newMeta);
            }
            kb.addMetaQueue(newMeta);
            return newMeta;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int[] parseIndexes(TokenIterator tokens, int count) {
        count = Math.min(tokens.getRemaining(), count);
        int[] ixes = new int[count];
        for (int m = 0; m < count; ++m) {
            ixes[m] = tokens.nextInt();
        }
        return ixes;
    }

    public void parseBlockage(String line, List<Material> mats) throws IOException {
        Blockage.DisplayType type;
        TokenIterator tokens = new TokenIterator(SimpleParser.getTokens(line, true));
        String blkgName = tokens.next();
        long resultsId = -1L;
        if (this.d_version >= 14) {
            resultsId = tokens.nextLong();
        }
        int matIx = -1;
        long cadGeomId = -1L;
        Color4f color = DEFAULT_BLKG_COLOR;
        if (this.d_version < 13) {
            type = Blockage.DisplayType.SIMPLE;
            if (this.d_version >= 4) {
                matIx = tokens.nextInt();
            }
        } else {
            String stype = tokens.next();
            type = Stream.of(Blockage.DisplayType.values()).filter(dt -> dt.name.equalsIgnoreCase(stype)).findFirst().orElse(Blockage.DisplayType.NONE);
            switch (type) {
                case NONE: {
                    break;
                }
                case SIMPLE: {
                    matIx = tokens.nextInt();
                    color = new Color4f(tokens.nextFloat(), tokens.nextFloat(), tokens.nextFloat(), tokens.nextFloat());
                    break;
                }
                case CAD_GEOM: {
                    cadGeomId = tokens.nextLong();
                }
            }
        }
        int[] triIds = SimpleParser.parseIndexes(tokens, Integer.MAX_VALUE);
        this.getTris(triIds);
        Material mat = matIx == -1 ? null : mats.get(matIx);
        int blkgId = this.getKB().getBlockages().size();
        Blockage blkg = new Blockage(blkgId, blkgName, resultsId, triIds, type, mat, color, cadGeomId);
        this.getKB().addBlockage(blkg);
    }

    public void parseAnimatedGeom(String line) throws IOException {
        JSONObject jobj = SimpleParser.getJsonLine(line, true);
        String name = jobj.getOrDefault("name", "");
        String annotatedName = jobj.getOrDefault("annotatedName", name);
        long id = JsonUtil.getLong(jobj, "id");
        this.getKB().addAnimatedGeom(new AnimatedGeom(name, annotatedName, id));
    }

    public void parseCamera(String line) throws IOException {
        TokenIterator tokens = new TokenIterator(SimpleParser.getTokens(line, " ,()", true));
        Camera camera = new Camera(this.getKB().getCameras().size());
        camera.set(Camera.PROP_NAME, tokens.next());
        Camera.Type type = tokens.next().equals("2D") ? Camera.Type.ORTHO : Camera.Type.PERSPECTIVE;
        camera.set(Camera.PROP_TYPE, type);
        camera.set(Camera.PROP_FOV, tokens.nextDouble());
        camera.set(Camera.PROP_LOC, this.parsePoint3d(tokens));
        camera.set(Camera.PROP_REF, this.parsePoint3d(tokens));
        camera.set(Camera.PROP_UP, this.parseVector3d(tokens));
        camera.set(Camera.PROP_ZOOM, tokens.nextDouble());
        camera.set(Camera.PROP_ZOOM_LOC, this.parsePoint2d(tokens));
        boolean controllable = tokens.nextInt() != 0;
        camera.set(Camera.PROP_SECURITY, controllable);
        if (controllable) {
            camera.set(Camera.PROP_PTZ_ORIENT, this.parseVector3d(tokens));
            camera.set(Camera.PROP_PAN_INFO, SimpleParser.parsePTZSpec(tokens));
            camera.set(Camera.PROP_TILT_INFO, SimpleParser.parsePTZSpec(tokens));
            camera.set(Camera.PROP_ZOOM_INFO, SimpleParser.parsePTZSpec(tokens));
        }
        this.getKB().addCamera(camera);
    }

    private static Camera.PTZSpec parsePTZSpec(TokenIterator tokens) {
        return new Camera.PTZSpec(tokens.nextDouble(), tokens.nextDouble(), tokens.nextDouble());
    }

    public void parseMeta(String line) {
        this.getKB().addMetaData(line);
    }

    public void parseEvent(String line) throws IOException {
        BitSet quotedVals = new BitSet();
        List<String> tokList = CSVLineParser.parse(line, " ,", "\"", quotedVals);
        TokenIterator tokens = new TokenIterator(tokList);
        double t = tokens.nextDouble();
        String cmd = tokens.next();
        if (cmd.equalsIgnoreCase(CMD_ADD_BLOCKAGE)) {
            String blkgId = tokens.next();
            List<Blockage> blockages = this.findBlockages(blkgId, quotedVals.get(2));
            for (Blockage blockage : blockages) {
                this.d_kb.addEvent(t, new EngineOp.AddBlockage(blockage));
            }
        } else if (cmd.equalsIgnoreCase(CMD_REMOVE_BLOCKAGE)) {
            String blkgId = tokens.next();
            List<Blockage> blockages = this.findBlockages(blkgId, quotedVals.get(2));
            for (Blockage blockage : blockages) {
                this.d_kb.addEvent(t, new EngineOp.RemoveBlockage(blockage));
            }
        } else if (cmd.equalsIgnoreCase(CMD_SET_BLOCKAGE_SPEED_MOD)) {
            String blkgId = tokens.next();
            List<Blockage> blockages = this.findBlockages(blkgId, quotedVals.get(2));
            SpeedModifier.Type type = SpeedModifier.Type.valueOf(tokens.next().toUpperCase());
            double value = tokens.nextDouble();
            for (Blockage blockage : blockages) {
                this.d_kb.addEvent(t, new EngineOp.SetBlockageSpeedModifier(blockage, new SpeedModifier(type, value)));
            }
        } else if (cmd.equalsIgnoreCase(CMD_OPEN_DOOR)) {
            int doorNodeIx = tokens.nextInt();
            ANode node = this.d_kb.getNodes().get(doorNodeIx);
            this.d_kb.addEvent(t, EngineOp.SetDoorState.openDoor(node));
        } else if (cmd.equalsIgnoreCase(CMD_CLOSE_DOOR)) {
            int doorNodeIx = tokens.nextInt();
            double reopenTime = tokens.nextDouble();
            ANode node = this.d_kb.getNodes().get(doorNodeIx);
            ITimeEstimate tEst = reopenTime != -1.0 ? new ITimeEstimate.Specific(reopenTime) : ITimeEstimate.FOREVER;
            this.d_kb.addEvent(t, EngineOp.SetDoorState.closeDoor(node, tEst));
        } else if (cmd.equalsIgnoreCase(CMD_CHANGE_DOOR_DIR)) {
            Vector2d dir = this.parseVector2d(tokens);
            int doorNodeIx = tokens.nextInt();
            ANode node = this.d_kb.getNodes().get(doorNodeIx);
            this.d_kb.addEvent(t, EngineOp.SetDoorState.openAndSetDirection(node, dir));
        } else if (cmd.equalsIgnoreCase(CMD_SET_SPEED_MOD)) {
            String typeName = tokens.next();
            double value = tokens.nextDouble();
            SpeedModifier.Type type = SpeedModifier.Type.valueOf(typeName.toUpperCase());
            SpeedModifier mod = new SpeedModifier(type, value);
            if (this.d_version < 12) {
                int[] tixes = SimpleParser.parseIndexes(tokens, Integer.MAX_VALUE);
                List<Tri> tris = this.getTris(tixes);
                LinkedIdentityHashSet nodes = new LinkedIdentityHashSet();
                tris.stream().forEach(tri -> nodes.add(tri.node));
                for (ANode node : nodes) {
                    this.d_kb.addEvent(t, new EngineOp.SetSpeedModifier(node, mod));
                }
            } else {
                int nodeIx = tokens.nextInt();
                ANode node = this.d_kb.getNodes().get(nodeIx);
                this.d_kb.addEvent(t, new EngineOp.SetSpeedModifier(node, mod));
            }
        } else if (cmd.equalsIgnoreCase(CMD_SET_ATTRACTOR_INFLUENCE)) {
            int attrIx = tokens.nextInt();
            double influence = tokens.nextDouble();
            AttractorSim attr = this.d_kb.getRootAttractors().get(attrIx);
            this.d_kb.addEvent(t, new EngineOp.SetAttractorInfluence(attr, influence));
        } else {
            throw new IllegalArgumentException("Unknown Command: " + cmd);
        }
    }

    public void parseJSON(String line) throws IOException {
        SimpleParser.parseJSON(this.d_kb, line);
    }

    public static void parseJSON(KB kb, String line) throws IOException {
        Object smvLinkObj;
        Object customScripts;
        JSONObject lineData = (JSONObject)JSONValue.parse(line);
        Object densRegions = lineData.get("density-regions");
        if (densRegions != null) {
            JSONArray regions = (JSONArray)densRegions;
            for (Object regionObj : regions) {
                JSONObject region = (JSONObject)regionObj;
                String name = (String)region.get("name");
                String minStr = (String)region.get("min");
                String maxStr = (String)region.get("max");
                Point3d min = SimpleParser.parsePoint3d(minStr);
                Point3d max = SimpleParser.parsePoint3d(maxStr);
                kb.addDensityRegion(new MeasurementRegion(name, new AABox(min, max)));
            }
        }
        if ((customScripts = lineData.get("custom-scripts")) != null) {
            JSONArray scripts = (JSONArray)customScripts;
            for (Object scriptObj : scripts) {
                JSONObject scriptJson = (JSONObject)scriptObj;
                String srcEncoded = (String)scriptJson.get("src_base64");
                byte[] decodedString = Base64.getDecoder().decode(srcEncoded);
                kb.addScript(new String(decodedString));
            }
        }
        if ((smvLinkObj = lineData.get("smv_pl3d")) != null) {
            String smvFn = (String)smvLinkObj;
            File smvFile = new File(smvFn);
            DataFinderSmvPlot3d smvDataFinder = new DataFinderSmvPlot3d(smvFile);
            DataInquisitor inquisitor = new DataInquisitor(smvDataFinder);
            KbLink smvLink = new KbLink(inquisitor);
            DataFinder.Quantity[] knownQuantities = inquisitor.getQuantities();
            JSONArray sensors = (JSONArray)lineData.get("sensors");
            for (Object sensorObj : sensors) {
                JSONObject sensor = (JSONObject)sensorObj;
                String pl3dQuantity = (String)sensor.get("pl3d_quantity");
                String label = (String)sensor.get("label");
                DataFinder.Quantity q = null;
                for (DataFinder.Quantity knownQuantity : knownQuantities) {
                    if (!knownQuantity.fdsName.equals(pl3dQuantity) && !knownQuantity.friendlyName.equals(pl3dQuantity)) continue;
                    q = knownQuantity;
                    break;
                }
                if (q == null) {
                    throw new IllegalArgumentException("Unknown Quantity: " + pl3dQuantity);
                }
                smvLink.addSensor(new KbLink.SensorInfo(q, label));
            }
            kb.setFdsOutputData(smvLink);
        }
    }

    private List<Blockage> findBlockages(String blkgId, boolean quoted) {
        if (quoted) {
            return this.d_kb.getBlockages(blkgId);
        }
        try {
            int id = Integer.parseInt(blkgId);
            if (id >= this.d_kb.getBlockages().size()) {
                throw new NumberFormatException();
            }
            return Arrays.asList(this.d_kb.getBlockages().get(id));
        }
        catch (NumberFormatException e) {
            return this.d_kb.getBlockages(blkgId);
        }
    }

    private List<Tri> getTris(int[] triids) throws IOException {
        Tri[] mtris = this.d_kb.getMesh().getTris();
        ArrayList<Tri> tris = new ArrayList<Tri>(triids.length);
        for (int triid : triids) {
            if (triid >= mtris.length || triid < 0) {
                String msg = String.format(Intl.intl("Invalid tri index: %d"), triid);
                throw new IOException(msg);
            }
            tris.add(mtris[triid]);
        }
        return tris;
    }

    public void parseEdge(MeshBuilder mb, String line) {
        String[] tokens = SimpleParser.getTokens(line, true);
        if (tokens[0].equalsIgnoreCase("door")) {
            ANode node = this.d_kb.getNodes().get(Integer.parseInt(tokens[1]));
            int ixVert1 = Integer.parseInt(tokens[2]);
            int ixVert2 = Integer.parseInt(tokens[3]);
            mb.addDoorEdge(node, ixVert1, ixVert2);
        } else if (tokens[0].equalsIgnoreCase("exit_door")) {
            ANode node = this.d_kb.getNodes().get(Integer.parseInt(tokens[1]));
            int ixVert1 = Integer.parseInt(tokens[2]);
            int ixVert2 = Integer.parseInt(tokens[3]);
            mb.addExitDoorEdge(node, ixVert1, ixVert2);
        } else if (tokens[0].equalsIgnoreCase("boundary")) {
            int ixVert1 = Integer.parseInt(tokens[1]);
            int ixVert2 = Integer.parseInt(tokens[2]);
            mb.addBoundaryEdge(ixVert1, ixVert2);
        } else {
            throw new RuntimeException("unknown edge type: " + tokens[0]);
        }
    }

    public void parseParam(String line) {
        String[] tokens = SimpleParser.getTokens(line, false);
        this.d_param.set(tokens[0], tokens[1], this.d_absolutePath);
    }

    public static String[] getTokens(String str, String delims, boolean hasIndex) {
        return SimpleParser.getTokens(str, delims, hasIndex, true, false);
    }

    public static String[] getTokens(String str, String delims, boolean hasIndex, boolean allowEscapeChar, boolean keepAll) {
        return SimpleParser.getTokens(str, delims, hasIndex, allowEscapeChar, keepAll, false);
    }

    public static String[] getTokens(String str, String delims, boolean hasIndex, boolean allowEscapeChar, boolean keepAll, boolean grouping) {
        if (hasIndex) {
            int colix = str.indexOf(58);
            str = str.substring(colix + 1);
        }
        Character escapeChar = allowEscapeChar ? Character.valueOf('\\') : null;
        int options = 0;
        if (keepAll) {
            options |= 3;
        }
        String quote = grouping ? "\"\"()" : "\"";
        List<String> tokList = CSVLineParser.parse(new ArrayList<String>(), str, delims, quote, null, escapeChar, options);
        String[] toks = new String[tokList.size()];
        return tokList.toArray(toks);
    }

    public static String[] getTokens(String str, boolean hasIndex) {
        return SimpleParser.getTokens(str, " ,", hasIndex);
    }

    private String[] removeEmpty(String[] strArr) {
        ArrayList<String> nonEmpty = new ArrayList<String>();
        for (String s : strArr) {
            if (s.length() <= 0) continue;
            nonEmpty.add(s);
        }
        return nonEmpty.toArray(new String[nonEmpty.size()]);
    }

    private static enum State {
        UNKNOWN(""),
        VERSION("version"),
        PARAM("param"),
        MATERIALS("materials"),
        NODES("nodes"),
        DOORS("doors"),
        STAIRS("stairs"),
        OCCS("occupants"),
        VERTS("verts"),
        NAVMESH("navmesh"),
        GEOMMESH("geommesh"),
        PROFILES("profiles"),
        BEHAVIORS("behaviors"),
        TAGS("tags"),
        EDGES("edges"),
        FLOORS("floors"),
        ELEVATORS("elevators"),
        ELEVATOR_DISCHARGE("elevator-discharge"),
        ELEVATOR_LEVEL_DATA("elevator-level-data"),
        ELEVATOR_LINKS("elevator-links"),
        ELEVATOR_PRIORITY("elevator-priority"),
        ELEVATOR_TIMING_MODELS("elevator-timing-models"),
        QUEUE_BASE("basequeues"),
        QUEUE_META("metaqueues"),
        BLOCKAGES("blockages"),
        CAMERAS("cameras"),
        EVENTS("events"),
        JSON("json"),
        META("meta"),
        DISTRIBUTIONS("distributions"),
        FUNCTIONS("functions"),
        ASSISTED_EVAC_TEAMS("assisted-evac-teams"),
        OCCSHAPES("occshapes"),
        OCC_SOURCES("occupant-sources"),
        COUNTERS("counters"),
        GROUPS("groups"),
        GROUP_TEMPLATES("group-templates"),
        COMPONENT_RESTRICTIONS("component-restrictions"),
        ATTRACTORS("attractors"),
        ATTRACTOR_RESTRICTIONS("attractor-filters"),
        OCCTARGETS("occupant-targets"),
        ANIMATEDGEOMS("animated-geom");

        public final String token;

        private State(String token) {
            this.token = token;
        }
    }

    protected static class ParseData {
        final ArrayList<Point3d> pList = new ArrayList();
        MeshBuilder navmb = null;
        MeshBuilder geommb = null;
        final List<BehaviorSim> behaviors = new ArrayList<BehaviorSim>();
        final List<OccProfileSim> profiles = new ArrayList<OccProfileSim>();
        final List<Material> mats = new ArrayList<Material>();
        final List<IDistributedVal<?>> distributions = new ArrayList();
        final List<IFunction1d> functions = new ArrayList<IFunction1d>();
        final List<Counter> counters = new ArrayList<Counter>();
        final List<AttractorSim> attractors = new ArrayList<AttractorSim>();
        final List<OccTarget> occTargets = new ArrayList<OccTarget>();
        final TagGenerator tags;
        final List<String> nodeLines = new ArrayList<String>();
        final List<String> navTriLines = new ArrayList<String>();
        final List<String> geomTriLines = new ArrayList<String>();
        final List<String> stairLines = new ArrayList<String>();
        final List<String> edgeLines = new ArrayList<String>();
        final List<String> doorLines = new ArrayList<String>();
        final List<String> occLines = new ArrayList<String>();
        final List<String> behaviorLines = new ArrayList<String>();
        final List<String> profLines = new ArrayList<String>();
        final List<String> evtLines = new ArrayList<String>();
        final List<String> aeGoalsLines = new ArrayList<String>();
        final List<String> occShapeLines = new ArrayList<String>();
        final List<String> occSourcesLines = new ArrayList<String>();
        final List<String> tagLines = new ArrayList<String>();
        final List<String> blockagesLines = new ArrayList<String>();
        final List<String> occGroupLines = new ArrayList<String>();
        final List<String> occGroupTypeLines = new ArrayList<String>();
        final List<String> elevatorLines = new ArrayList<String>();
        final List<String> elevatorDischargeLines = new ArrayList<String>();
        final List<String> elevatorLevelDataLines = new ArrayList<String>();
        final List<String> elevatorLinkLines = new ArrayList<String>();
        final List<String> elevatorPriorityLines = new ArrayList<String>();
        final List<String> elevatorTimingModels = new ArrayList<String>();
        final List<String> baseQueuesLines = new ArrayList<String>();
        final List<String> metaQueues = new ArrayList<String>();
        final List<String> compRestrictionsLines = new ArrayList<String>();
        final List<String> attractorLines = new ArrayList<String>();
        final List<String> attrRestrictionLines = new ArrayList<String>();
        final List<String> occTargetLines = new ArrayList<String>();
        final List<String> animatedGeomLines = new ArrayList<String>();

        public ParseData(KB kb) {
            this.tags = new TagGenerator(kb);
        }
    }

    private static class TagGenerator {
        public final Map<String, Tag> tags = new LinkedHashMap<String, Tag>();
        private final Set<Tag> d_committedToKb = new IdentityHashSet<Tag>();
        private static final Function<String, Tag> s_newTag = name -> new Tag((String)name, (String)name, EnumSet.of(Tag.Options.CLEARABLE));

        public TagGenerator(KB kb) {
            for (PredefTag ptag : PredefTag.values()) {
                Tag tag = kb.getPredefTag(ptag);
                this.add(tag);
            }
        }

        public void add(Tag tag) {
            this.tags.put(tag.name, tag);
        }

        public Tag getTag(String name) {
            return this.tags.computeIfAbsent(name, s_newTag);
        }

        public void commitToKb(KB kb) {
            Collection newTags = this.tags.values().stream().filter(Predicates.and(t -> !t.isPredefined(), Filters.reject(this.d_committedToKb))).collect(Collectors.toList());
            kb.addTags(newTags);
            this.d_committedToKb.addAll(newTags);
        }
    }

    private static class ParseProfileInfo {
        public final List<IFunction1d> functions;
        public final List<IDistributedVal<?>> distributions;
        public final List<OccProfileSim.IShapeGen> occShapes;
        public final HashMap<Integer, String> aeTeamNameMap;
        public final Map<Integer, OccProfileSim.CompRestrictions> compRestrictionsMap;
        public final Map<Integer, Predicate<AttractorSim>> attrFiltersMap;
        public final TagGenerator tags;

        public ParseProfileInfo(List<IFunction1d> functions, List<IDistributedVal<?>> distributions, List<OccProfileSim.IShapeGen> occShapes, HashMap<Integer, String> aeTeamNameMap, Map<Integer, OccProfileSim.CompRestrictions> compRestrictionsMap, Map<Integer, Predicate<AttractorSim>> attrFiltersMap, TagGenerator tags) {
            this.functions = functions;
            this.distributions = distributions;
            this.occShapes = occShapes;
            this.aeTeamNameMap = aeTeamNameMap;
            this.compRestrictionsMap = compRestrictionsMap;
            this.attrFiltersMap = attrFiltersMap;
            this.tags = tags;
        }
    }

    private static class ParseGoalInfo
    extends ParseProfileInfo {
        public final List<AssistedEvacTeam> teams;
        public final List<Counter> counters;
        public final TagGenerator tags;
        public final List<OccGroup> groups;
        public final List<OccGroupType> groupTypes;
        public final List<OccTarget> occTargets;
        public final List<AttractorSim> attractors;
        public final List<OccProfileSim> profiles;
        public final List<BehaviorSim> behaviors;

        public ParseGoalInfo(ParseProfileInfo ppi, List<AssistedEvacTeam> teams, List<Counter> counters, TagGenerator tags, List<OccGroup> groups, List<OccGroupType> groupTypes, List<OccTarget> occTargets, List<AttractorSim> attractors, List<OccProfileSim> profiles, List<BehaviorSim> behaviors) {
            super(ppi.functions, ppi.distributions, ppi.occShapes, ppi.aeTeamNameMap, ppi.compRestrictionsMap, ppi.attrFiltersMap, tags);
            this.counters = counters;
            this.teams = teams;
            this.tags = tags;
            this.groups = groups;
            this.groupTypes = groupTypes;
            this.occTargets = occTargets;
            this.attractors = attractors;
            this.profiles = profiles;
            this.behaviors = behaviors;
        }
    }

    private static class TokenIterator {
        public final List<String> tokens;
        public int tix;

        public TokenIterator(String[] tokens) {
            this(Arrays.asList(tokens), 0);
        }

        public TokenIterator(String[] tokens, int tix) {
            this(Arrays.asList(tokens), tix);
        }

        public TokenIterator(List<String> tokens) {
            this(tokens, 0);
        }

        public TokenIterator(List<String> tokens, int tix) {
            this.tokens = tokens;
            this.tix = tix;
        }

        public String curr() {
            return this.tokens.get(this.tix);
        }

        public String next() {
            return this.tokens.get(this.tix++);
        }

        public int nextInt() {
            return Integer.parseInt(this.next());
        }

        public double nextDouble() {
            return Double.parseDouble(this.next());
        }

        public float nextFloat() {
            return Float.parseFloat(this.next());
        }

        public long nextLong() {
            return Long.parseLong(this.next());
        }

        public boolean nextBoolean() {
            return Boolean.parseBoolean(this.next());
        }

        public boolean hasMore() {
            return this.tix < this.tokens.size();
        }

        public int getRemaining() {
            return this.tokens.size() - this.tix;
        }

        public void rewind(int count) {
            this.tix -= count;
        }
    }

    private static interface FlowrateParser {
        public IOccSourceFlowrate parse(JSONObject var1, IntFunction<IFunction1d> var2) throws Exception;
    }

    private static class OccPropParser {
        public OccPropParser(KB kb, List<AttractorSim> attractors) {
        }

        private Object getOccProp(JSONObject json, Random rnd, long seed, String name, OccProfileSim parentProfile, OccProfileSim.Prop<?> prop, Class<?> targetClass) {
            return this.getOccProp(json, rnd, seed, name, parentProfile, prop, targetClass, null);
        }

        private Object getOccProp(JSONObject json, Random rnd, long seed, OccProfileSim parentProfile, OccProfileSim.Prop<?> prop, Class<?> targetClass) {
            return this.getOccProp(json, rnd, seed, prop.key.toString(), parentProfile, prop, targetClass);
        }

        private Object getOccProp(JSONObject json, Random rnd, long seed, String name, OccProfileSim parentProfile, OccProfileSim.Prop<?> prop, Class<?> targetClass, Unit unit) {
            Object ret = json.get(name);
            return this.getOccProp(ret, rnd, seed, parentProfile, prop, targetClass != null ? jsonVal -> SimpleParser.parseValue(jsonVal, targetClass) : null, unit);
        }

        private Object getOccProp(Object ret, Random rnd, long seed, OccProfileSim parentProfile, OccProfileSim.Prop prop, Function<Object, Object> finalizeValue, Unit unit) {
            Object v;
            if (ret == null && prop != null) {
                Object profileProp = prop.isDistributed() ? parentProfile.getDistVal(prop, rnd, seed) : parentProfile.getProperty(prop);
                if (prop == OccProfileSim.PROP_PRINT_EXTRA_OUTPUT) {
                    profileProp = (Boolean)profileProp != false ? 1 : 0;
                } else if (profileProp instanceof OccProfileSim.Spacing) {
                    profileProp = parentProfile.getSpacingVal(rnd, seed);
                }
                if (profileProp instanceof UnitDouble) {
                    profileProp = unit != null ? ((UnitDouble)profileProp).getValue(unit) : ((UnitDouble)profileProp).getValueNoUnit();
                }
                ret = profileProp;
            }
            if (finalizeValue != null && (v = finalizeValue.apply(ret)) != null) {
                return v;
            }
            return ret;
        }
    }
}

